/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.quote.report;

import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfBorderArray;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class PaypalStamper {
    public static void main(String[] args) throws Exception {
        PaypalStamper s = new PaypalStamper();
        s.addLink(new File("Facture_2018-11-00422.pdf"), new File("paypal.pdf"), 33, 72, "https://www.openconerto.org");
    }

    public void addLink(File inFile, File outFile, int x, int y, String hyperlink) throws Exception {
        if (hyperlink == null) {
            throw new IllegalArgumentException("null link");
        }
        PdfReader reader = new PdfReader((InputStream)new FileInputStream(inFile));
        PdfStamper stamper = new PdfStamper(reader, (OutputStream)new FileOutputStream(outFile));
        int page = reader.getNumberOfPages();
        Image img = Image.getInstance((URL)this.getClass().getResource("payer-avec-paypal.png"));
        float w = img.getScaledWidth() / 3.0f;
        float h = img.getScaledHeight() / 3.0f;
        stamper.getOverContent(page).addImage(img, w, 0.0f, 0.0f, h, (float)x, (float)y);
        Rectangle linkLocation = new Rectangle((float)x, (float)y, (float)x + w, (float)y + h);
        PdfAnnotation link = PdfAnnotation.createLink((PdfWriter)stamper.getWriter(), (Rectangle)linkLocation, (PdfName)PdfAnnotation.HIGHLIGHT_OUTLINE, (PdfAction)new PdfAction(hyperlink));
        link.setBorder(new PdfBorderArray(0.0f, 0.0f, 0.0f));
        stamper.addAnnotation(link, page);
        stamper.close();
        reader.close();
    }
}

