/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.erp.core.sales.product.model.ProductComponent;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;

public class ProductHelper {
    private DBRoot root;

    public ProductHelper(DBRoot root) {
        this.root = root;
    }

    public BigDecimal getEnumPrice(SQLRowAccessor r, PriceField field) {
        PriceField[] values = (PriceField[])field.getClass().getEnumConstants();
        BigDecimal result = r.getBigDecimal(values[0].toString());
        if (result == null) {
            return null;
        }
        int i = 1;
        while (i < values.length) {
            BigDecimal m0 = r.getBigDecimal(values[i].toString());
            if (m0 != null && m0.floatValue() > 0.0f) {
                result = result.divide(m0, 2, RoundingMode.HALF_UP);
            }
            if (values[i] == field) break;
            ++i;
        }
        return result;
    }

    public void fillProductComponent(List<? extends SQLRowAccessor> itemsTableElement, List<ProductComponent> productComponents, int qte, int index, int level) {
        if (level > 0) {
            int i = index;
            while (i < itemsTableElement.size()) {
                SQLRowAccessor r = itemsTableElement.get(i);
                if (!r.getTable().contains("NIVEAU") || r.getInt("NIVEAU") >= level) {
                    SQLRowAccessor rNext;
                    if (r.getTable().contains("NIVEAU") && i + 1 < itemsTableElement.size() && (rNext = itemsTableElement.get(i + 1)).getInt("NIVEAU") > r.getInt("NIVEAU")) {
                        this.fillProductComponent(itemsTableElement, productComponents, qte * r.getInt("QTE"), i + 1, rNext.getInt("NIVEAU"));
                    } else if (!(r.getTable().contains("NIVEAU") && r.getInt("NIVEAU") != level || r.getForeign("ID_ARTICLE") == null || r.isForeignEmpty("ID_ARTICLE"))) {
                        productComponents.add(ProductComponent.createFrom(r, qte, r));
                    }
                } else if (r.getInt("NIVEAU") < level) break;
                ++i;
            }
        }
    }

    public BigDecimal getUnitCostForQuantity(SQLRowAccessor rArticle, int qty) {
        Collection<? extends SQLRowAccessor> l = rArticle.getReferentRows(rArticle.getTable().getTable("ARTICLE_PRIX_REVIENT"));
        BigDecimal result = null;
        for (SQLRowAccessor sQLRowAccessor : l) {
            if (sQLRowAccessor.getLong("QTE") > (long)qty) break;
            result = sQLRowAccessor.getBigDecimal("PRIX");
        }
        if (result == null) {
            result = BigDecimal.ZERO;
        }
        return result;
    }

    public List<String> getRequiredProperties(int categoryId) {
        SQLTable table = this.root.getTable("FAMILLE_CARACTERISTIQUE");
        SQLSelect sel = new SQLSelect();
        sel.addSelect(table.getField("NOM"));
        sel.setWhere(table.getField("ID_FAMILLE_ARTICLE"), "=", categoryId);
        SQLDataSource src = this.root.getDBSystemRoot().getDataSource();
        return src.executeCol(sel.asString());
    }

    public int getMinQuantityForCostCalculation(int productId) {
        SQLTable costTable = this.root.getTable("ARTICLE_PRIX_REVIENT");
        SQLSelect sel = new SQLSelect();
        sel.addSelect(costTable.getKey());
        sel.addSelect(costTable.getField("ID_ARTICLE"));
        sel.addSelect(costTable.getField("QTE"));
        sel.setWhere(new Where((FieldRef)costTable.getField("ID_ARTICLE"), "=", productId));
        SQLDataSource src = this.root.getDBSystemRoot().getDataSource();
        List l = (List)src.execute(sel.asString(), SQLRowListRSH.createFromSelect(sel));
        if (l.isEmpty()) {
            return -1;
        }
        int min = Integer.MAX_VALUE;
        for (SQLRow sqlRow : l) {
            int n = sqlRow.getInt("QTE");
            if (n >= min) continue;
            min = n;
        }
        return min;
    }

    public Map<Long, BigDecimal> getUnitCost(Map<Long, Integer> productQties, TypePrice type) {
        HashMap<Long, BigDecimal> result = new HashMap<Long, BigDecimal>();
        String fieldPrice = type == TypePrice.ARTICLE_TARIF_FOURNISSEUR || type == TypePrice.ARTICLE_TARIF_FOURNISSEUR_DDP ? "PRIX_ACHAT_DEVISE_F" : "PRIX";
        String fieldDate = type == TypePrice.ARTICLE_TARIF_FOURNISSEUR || type == TypePrice.ARTICLE_TARIF_FOURNISSEUR_DDP ? "DATE_PRIX" : "DATE";
        SQLTable costTable = this.root.getTable(type == TypePrice.ARTICLE_TARIF_FOURNISSEUR_DDP ? "ARTICLE_TARIF_FOURNISSEUR" : type.name());
        SQLSelect sel = new SQLSelect();
        sel.addSelect(costTable.getKey());
        sel.addSelect(costTable.getField("ID_ARTICLE"));
        sel.addSelect(costTable.getField("QTE"));
        sel.addSelect(costTable.getField(fieldPrice));
        if (type == TypePrice.ARTICLE_TARIF_FOURNISSEUR_DDP) {
            SupplierPriceField[] supplierPriceFieldArray = SupplierPriceField.values();
            int n = supplierPriceFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                SupplierPriceField f = supplierPriceFieldArray[n2];
                sel.addSelect(costTable.getField(f.name()));
                ++n2;
            }
        }
        sel.addSelect(costTable.getField(fieldDate));
        sel.setWhere(new Where((FieldRef)costTable.getField("ID_ARTICLE"), true, productQties.keySet()));
        sel.addFieldOrder(costTable.getField("QTE"));
        sel.addFieldOrder(costTable.getField(fieldDate));
        SQLDataSource src = this.root.getDBSystemRoot().getDataSource();
        List l = (List)src.execute(sel.asString(), SQLRowListRSH.createFromSelect(sel));
        for (SQLRow sqlRow : l) {
            System.out.println(String.valueOf(sqlRow.getID()) + ":" + sqlRow.getAllValues());
        }
        int size = l.size();
        if (size == 0 && type == TypePrice.ARTICLE_PRIX_REVIENT) {
            return this.getUnitCost(productQties, TypePrice.ARTICLE_TARIF_FOURNISSEUR_DDP);
        }
        for (Long id : productQties.keySet()) {
            BigDecimal cost = BigDecimal.ZERO;
            int qty = productQties.get(id);
            int i = 0;
            while (i < size) {
                SQLRow row = (SQLRow)l.get(i);
                if (row.getInt("ID_ARTICLE") == id.intValue()) {
                    if (row.getLong("QTE") > (long)qty) {
                        if (cost != null) break;
                        if (type == TypePrice.ARTICLE_TARIF_FOURNISSEUR_DDP) {
                            cost = this.getEnumPrice(row, SupplierPriceField.COEF_TRANSPORT_SIEGE);
                            break;
                        }
                        cost = row.getBigDecimal(fieldPrice);
                        break;
                    }
                    cost = type == TypePrice.ARTICLE_TARIF_FOURNISSEUR_DDP ? this.getEnumPrice(row, SupplierPriceField.COEF_TRANSPORT_SIEGE) : row.getBigDecimal(fieldPrice);
                }
                ++i;
            }
            if (cost == null) {
                cost = BigDecimal.ZERO;
            }
            result.put(id, cost);
        }
        return result;
    }

    public List<ProductComponent> getChildWithQtyFrom(List<ProductComponent> items) {
        return this.getChildWithQtyFrom(items, new HashSet<Integer>());
    }

    private List<ProductComponent> getChildWithQtyFrom(List<ProductComponent> items, Set<Integer> ancestorsOrigin) {
        if (this.root.contains("ARTICLE_ELEMENT")) {
            int originalAncestorsSize = ancestorsOrigin.size();
            HashSet<Integer> ancestors = new HashSet<Integer>(ancestorsOrigin);
            ArrayList<ProductComponent> result = new ArrayList<ProductComponent>();
            final ArrayList<Integer> parentsArticleIDs = new ArrayList<Integer>();
            ListMap<Integer, ProductComponent> productCompByID = new ListMap<Integer, ProductComponent>();
            for (ProductComponent p : items) {
                productCompByID.add(p.getProduct().getID(), p);
                int idSource = p.getProduct().getID();
                parentsArticleIDs.add(idSource);
            }
            final SQLTable costTable = this.root.getTable("ARTICLE_ELEMENT");
            SQLRowValues rowVals = new SQLRowValues(costTable);
            SQLRowValues artRowValues = rowVals.putRowValues("ID_ARTICLE").putNulls("ID", "GESTION_STOCK", "CODE", "NOM", "ID_DEPOT_STOCK", "ID_UNITE_VENTE", "ID_FOURNISSEUR");
            SQLRowValues stockRowVals = new SQLRowValues(this.root.getTable("STOCK"));
            stockRowVals.putNulls("QTE_TH", "QTE_RECEPT_ATTENTE", "QTE_REEL", "QTE_LIV_ATTENTE", "ID_DEPOT_STOCK");
            stockRowVals.put("ID_ARTICLE", (Object)artRowValues);
            rowVals.putRowValues("ID_ARTICLE_PARENT").put("ID", null);
            rowVals.put("QTE", null);
            rowVals.put("QTE_UNITAIRE", null);
            SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowVals);
            fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect input) {
                    input.setWhere(new Where(costTable.getField("ID_ARTICLE_PARENT"), parentsArticleIDs));
                    return input;
                }
            });
            List<SQLRowValues> childs = fetcher.fetch();
            if (childs.size() > 0) {
                for (SQLRowValues childRowValues : childs) {
                    SQLRowAccessor foreignArticleParent = childRowValues.getForeign("ID_ARTICLE_PARENT");
                    if (childRowValues.getObject("ID_ARTICLE") == null || childRowValues.isForeignEmpty("ID_ARTICLE")) continue;
                    List source = (List)productCompByID.get(foreignArticleParent.getID());
                    if (ancestorsOrigin.contains(foreignArticleParent.getID())) continue;
                    ancestors.add(foreignArticleParent.getID());
                    for (ProductComponent productParent : source) {
                        SQLRowAccessor foreignArticle = childRowValues.getForeign("ID_ARTICLE");
                        int childQ = childRowValues.getInt("QTE");
                        BigDecimal childqD = childRowValues.getBigDecimal("QTE_UNITAIRE");
                        ProductComponent childComponent = ProductComponent.createFromRowArticle(foreignArticle, childqD.multiply(new BigDecimal(childQ)), productParent.getSource());
                        childComponent.setQty(childComponent.getQty().multiply(productParent.getQty(), DecimalUtils.HIGH_PRECISION));
                        result.add(childComponent);
                    }
                }
                List<ProductComponent> bomFromChilds = this.getChildWithQtyFrom(new ArrayList<ProductComponent>(result), ancestors);
                for (ProductComponent s : bomFromChilds) {
                    result.add(s);
                }
            }
            if (originalAncestorsSize == 0) {
                for (ProductComponent p : items) {
                    result.add(p);
                }
            }
            for (Integer anc : ancestors) {
                if (!productCompByID.containsKey(anc)) continue;
                result.removeAll((Collection)productCompByID.get(anc));
            }
            return result;
        }
        return items;
    }

    public Map<Long, Integer> getBOM(Long productId) {
        HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        SQLTable costTable = this.root.getTable("ARTICLE_ELEMENT");
        SQLSelect sel = new SQLSelect();
        sel.addSelect(costTable.getField("ID_ARTICLE"));
        sel.addSelect(costTable.getField("QTE"));
        sel.setWhere(new Where((FieldRef)costTable.getField("ID_ARTICLE_PARENT"), "=", (Object)productId));
        sel.addFieldOrder(costTable.getField("QTE"));
        SQLDataSource src = this.root.getDBSystemRoot().getDataSource();
        List l = (List)src.execute(sel.asString(), SQLRowListRSH.createFromSelect(sel));
        int size = l.size();
        int i = 0;
        while (i < size) {
            SQLRow row = (SQLRow)l.get(i);
            long id = row.getLong("ID_ARTICLE");
            Integer qte = (Integer)result.get(id);
            qte = qte == null ? Integer.valueOf(row.getInt("QTE")) : Integer.valueOf(qte + row.getInt("QTE"));
            result.put(id, qte);
            ++i;
        }
        return result;
    }

    public BigDecimal getBomPriceForQuantity(int qty, Collection<? extends SQLRowAccessor> rowValuesProductItems, TypePrice type) {
        HashMap<Long, Integer> productQties = new HashMap<Long, Integer>();
        int count = rowValuesProductItems.size();
        for (SQLRowAccessor sQLRowAccessor : rowValuesProductItems) {
            if (sQLRowAccessor.getObject("ID_ARTICLE") == null) continue;
            System.out.println("id:" + sQLRowAccessor.getObject("ID_ARTICLE"));
            int n = sQLRowAccessor.getForeignID("ID_ARTICLE");
            int qte = sQLRowAccessor.getInt("QTE") * qty;
            Integer qteForId = (Integer)productQties.get(n);
            if (qteForId == null) {
                productQties.put(Long.valueOf(n), qte);
                continue;
            }
            productQties.put(Long.valueOf(n), qte + qteForId);
        }
        Map<Long, BigDecimal> map = this.getUnitCost(productQties, type);
        BigDecimal cost = null;
        for (SQLRowAccessor sQLRowAccessor : rowValuesProductItems) {
            if (sQLRowAccessor.getObject("ID_ARTICLE") == null) continue;
            int id = sQLRowAccessor.getForeignID("ID_ARTICLE");
            int qte = sQLRowAccessor.getInt("QTE");
            BigDecimal unitCost = map.get(id);
            BigDecimal lineCost = unitCost.multiply(BigDecimal.valueOf(qte)).multiply(sQLRowAccessor.getBigDecimal("QTE_UNITAIRE"));
            if (cost == null) {
                cost = BigDecimal.ZERO;
            }
            cost = cost.add(lineCost);
        }
        return cost;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<BigDecimal, BigDecimal> getStandardBomPrices(Collection<? extends SQLRowAccessor> rowValuesProductItems) {
        void var3_6;
        HashMap<Long, Integer> productQties = new HashMap<Long, Integer>();
        for (SQLRowAccessor sQLRowAccessor : rowValuesProductItems) {
            if (sQLRowAccessor.getObject("ID_ARTICLE") == null) continue;
            System.out.println("id:" + sQLRowAccessor.getObject("ID_ARTICLE"));
            int n = sQLRowAccessor.getForeignID("ID_ARTICLE");
            int qte = sQLRowAccessor.getInt("QTE");
            Integer qteForId = (Integer)productQties.get(n);
            if (qteForId == null) {
                productQties.put(Long.valueOf(n), qte);
                continue;
            }
            productQties.put(Long.valueOf(n), qte + qteForId);
        }
        Object var3_5 = null;
        BigDecimal costPA = null;
        for (SQLRowAccessor sQLRowAccessor : rowValuesProductItems) {
            void var3_8;
            if (sQLRowAccessor.getObject("ID_ARTICLE") == null) continue;
            SQLRowAccessor rowChild = sQLRowAccessor.getForeign("ID_ARTICLE");
            int qte = sQLRowAccessor.getInt("QTE");
            BigDecimal unitCostPV = rowChild.getBigDecimal("PV_HT");
            BigDecimal unitCostPA = rowChild.getBigDecimal("PA_HT");
            BigDecimal lineCostPV = unitCostPV.multiply(BigDecimal.valueOf(qte)).multiply(sQLRowAccessor.getBigDecimal("QTE_UNITAIRE"));
            if (var3_6 == null) {
                BigDecimal bigDecimal = BigDecimal.ZERO;
            }
            BigDecimal bigDecimal = var3_8.add(lineCostPV);
            BigDecimal lineCostPA = unitCostPA.multiply(BigDecimal.valueOf(qte)).multiply(sQLRowAccessor.getBigDecimal("QTE_UNITAIRE"));
            if (costPA == null) {
                costPA = BigDecimal.ZERO;
            }
            costPA = costPA.add(lineCostPA);
        }
        return Tuple2.create(costPA, var3_6);
    }

    public BigDecimal getUnitCost(int id, int qty, TypePrice type) {
        HashMap<Long, Integer> productQties = new HashMap<Long, Integer>();
        productQties.put(Long.valueOf(id), qty);
        Map<Long, BigDecimal> unitCost = this.getUnitCost(productQties, type);
        System.out.println(">" + unitCost);
        return unitCost.get(id);
    }

    public Date getUnitCostDate(int id, int qty, TypePrice type) {
        HashMap<Long, Integer> productQties = new HashMap<Long, Integer>();
        productQties.put(Long.valueOf(id), qty);
        Map<Long, Date> unitCost = this.getUnitCostDate(productQties, type);
        System.out.println(">" + unitCost);
        return unitCost.get(id);
    }

    private Map<Long, Date> getUnitCostDate(Map<Long, Integer> productQties, TypePrice type) {
        HashMap<Long, Date> result = new HashMap<Long, Date>();
        String fieldPrice = type == TypePrice.ARTICLE_TARIF_FOURNISSEUR ? "PRIX_ACHAT_DEVISE_F" : "PRIX";
        String fieldDate = type == TypePrice.ARTICLE_TARIF_FOURNISSEUR ? "DATE_PRIX" : "DATE";
        SQLTable costTable = this.root.getTable(type.name());
        SQLSelect sel = new SQLSelect();
        sel.addSelect(costTable.getKey());
        sel.addSelect(costTable.getField("ID_ARTICLE"));
        sel.addSelect(costTable.getField("QTE"));
        sel.addSelect(costTable.getField(fieldPrice));
        sel.addSelect(costTable.getField(fieldDate));
        sel.setWhere(new Where((FieldRef)costTable.getField("ID_ARTICLE"), true, productQties.keySet()));
        sel.addFieldOrder(costTable.getField("QTE"));
        sel.addFieldOrder(costTable.getField(fieldDate));
        SQLDataSource src = this.root.getDBSystemRoot().getDataSource();
        List l = (List)src.execute(sel.asString(), SQLRowListRSH.createFromSelect(sel));
        for (SQLRow sqlRow : l) {
            System.out.println(String.valueOf(sqlRow.getID()) + ":" + sqlRow.getAllValues());
        }
        int size = l.size();
        for (Long id : productQties.keySet()) {
            Calendar cost = null;
            int qty = productQties.get(id);
            int i = 0;
            while (i < size) {
                SQLRow row = (SQLRow)l.get(i);
                if (row.getInt("ID_ARTICLE") == id.intValue()) {
                    if (row.getLong("QTE") > (long)qty) {
                        if (cost != null) break;
                        cost = row.getDate("DATE");
                        break;
                    }
                    cost = row.getDate("DATE");
                }
                ++i;
            }
            if (cost != null) {
                result.put(id, cost.getTime());
                continue;
            }
            result.put(id, new Date());
        }
        return result;
    }

    public static interface PriceField {
    }

    public static enum SupplierPriceField implements PriceField
    {
        PRIX_ACHAT,
        COEF_TRANSPORT_PORT,
        COEF_TAXE_D,
        COEF_TRANSPORT_SIEGE,
        COEF_FRAIS_MOULE,
        COEF_FRAIS_INDIRECTS,
        COEF_PRIX_MINI;

    }

    public static enum TypePrice {
        ARTICLE_PRIX_REVIENT,
        ARTICLE_PRIX_MIN_VENTE,
        ARTICLE_PRIX_PUBLIC,
        ARTICLE_TARIF_FOURNISSEUR,
        ARTICLE_TARIF_FOURNISSEUR_DDP;

    }
}

