/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class POSGlassPane
extends JPanel
implements MouseListener,
MouseMotionListener,
FocusListener {
    JMenuBar menuBar;
    boolean inDrag = false;
    boolean needToRedispatch = false;

    POSGlassPane(JPanel p, int x, int y) {
        this.setLayout(null);
        p.setSize(p.getPreferredSize());
        p.setLocation(x, y);
        this.add(p);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addFocusListener(this);
    }

    @Override
    public void setVisible(boolean v) {
        if (v) {
            this.requestFocus();
        }
        super.setVisible(v);
    }

    @Override
    public void focusLost(FocusEvent fe) {
        if (this.isVisible()) {
            this.requestFocus();
        }
    }

    @Override
    public void focusGained(FocusEvent fe) {
    }

    public void setNeedToRedispatch(boolean need) {
        this.needToRedispatch = need;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.needToRedispatch) {
            this.redispatchMouseEvent(e);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.needToRedispatch) {
            this.redispatchMouseEvent(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.needToRedispatch) {
            this.redispatchMouseEvent(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.needToRedispatch) {
            this.redispatchMouseEvent(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.needToRedispatch) {
            this.redispatchMouseEvent(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.needToRedispatch) {
            this.redispatchMouseEvent(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.needToRedispatch) {
            this.redispatchMouseEvent(e);
            this.inDrag = false;
        }
    }

    private void redispatchMouseEvent(MouseEvent e) {
        boolean inButton = false;
        boolean inMenuBar = false;
        Point glassPanePoint = e.getPoint();
        Component component = null;
        JMenuBar container = null;
        Point containerPoint = SwingUtilities.convertPoint(this, glassPanePoint, null);
        int eventID = e.getID();
        if (containerPoint.y < 0) {
            inMenuBar = true;
            container = this.menuBar;
            containerPoint = SwingUtilities.convertPoint(this, glassPanePoint, this.menuBar);
            this.testForDrag(eventID);
        }
        if ((component = SwingUtilities.getDeepestComponentAt(container, containerPoint.x, containerPoint.y)) == null) {
            return;
        }
        inButton = true;
        this.testForDrag(eventID);
        if (inMenuBar || inButton || this.inDrag) {
            Point componentPoint = SwingUtilities.convertPoint(this, glassPanePoint, component);
            component.dispatchEvent(new MouseEvent(component, eventID, e.getWhen(), e.getModifiers(), componentPoint.x, componentPoint.y, e.getClickCount(), e.isPopupTrigger()));
        }
    }

    private void testForDrag(int eventID) {
        if (eventID == 501) {
            this.inDrag = true;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle clip = g.getClipBounds();
        AlphaComposite alpha = AlphaComposite.SrcOver.derive(0.65f);
        Composite composite = g2.getComposite();
        g2.setComposite(alpha);
        g2.setColor(Color.BLACK);
        g2.fillRect(clip.x, clip.y, clip.width, clip.height);
        g2.setComposite(composite);
    }
}

