/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.model;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import net.jcip.annotations.Immutable;
import org.openconcerto.erp.core.sales.pos.POSConfiguration;
import org.openconcerto.erp.core.sales.pos.model.ReceiptCode;
import org.openconcerto.erp.core.sales.pos.model.RegisterDB;
import org.openconcerto.erp.core.sales.pos.model.RegisterState;
import org.openconcerto.erp.utils.TM;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.ui.SwingThreadUtils;
import org.openconcerto.utils.CollectionUtils;

@Immutable
public final class DBState {
    private final RegisterDB registerDB;
    private final SQLRowValues registerVals;
    private final SQLRowValues lastReceiptVals;
    private final RegisterState registerState;
    private final List<SQLRowValues> lastEntries;
    private static final Map<String, ?> NULL_VALUES = CollectionUtils.createMap("HOST_NAME", null, "HOST_USER", null);

    private static final RegisterState.Status getStatus(SQLRowAccessor entry) {
        RegisterState.Status res = RegisterState.Status.valueOf(entry.getString("EVT"));
        if (res != RegisterState.Status.OPEN && res != RegisterState.Status.CLOSED) {
            throw new IllegalStateException("Invalid status : " + (Object)((Object)res));
        }
        return res;
    }

    protected DBState(RegisterDB registerDB, SQLRowValues registerR) {
        this.registerDB = registerDB;
        this.registerVals = registerR.toImmutable();
        if (this.getPosID() != registerDB.getPosID()) {
            throw new IllegalArgumentException("Not same register");
        }
        this.lastReceiptVals = (SQLRowValues)CollectionUtils.getSole(this.registerVals.getReferentRows(this.registerDB.getReceiptElement().getTable().getField("ID_CAISSE")));
        this.lastEntries = Collections.unmodifiableList(new ArrayList(this.registerVals.getReferentRows(this.registerDB.getLogElement().getTable().getField("ID_CAISSE"))));
        SQLRowValues lastEntry = this.getLastEntry();
        if (lastEntry == null) {
            this.registerState = new RegisterState(RegisterState.Status.CLOSED, null);
        } else {
            if (lastEntry.getForeignID("ID_CAISSE") != this.getPosID()) {
                throw new IllegalStateException("Incoherent register IDs");
            }
            RegisterState.Status status = DBState.getStatus(lastEntry);
            this.registerState = new RegisterState(status, lastEntry.getDate("DATE").getTime());
        }
    }

    public final int getPosID() {
        return this.registerVals.getID();
    }

    public final RegisterState getRegisterState() {
        return this.registerState;
    }

    public SQLRowValues getRegisterRow() {
        return this.registerVals;
    }

    public final SQLRowValues getLastClosure() {
        return this.registerVals.followPath(this.registerDB.getRegisterToLastClosureEntry().minusLast());
    }

    public final SQLRowValues getLastClosureEntry() {
        return this.registerVals.followPath(this.registerDB.getRegisterToLastClosureEntry());
    }

    public final SQLRowValues getLastOpeningEntry() {
        List<SQLRowValues> entries = this.getLastEntries();
        if (entries.isEmpty()) {
            assert (!this.getRegisterState().hasDate());
            return null;
        }
        if (DBState.getStatus(entries.get(0)).equals((Object)RegisterState.Status.OPEN)) {
            return entries.get(0);
        }
        if (entries.size() > 1 && DBState.getStatus(entries.get(1)).equals((Object)RegisterState.Status.OPEN)) {
            return entries.get(1);
        }
        throw new IllegalStateException("Two consecutive non-open entries : " + entries);
    }

    public final SQLRowValues getLastEntry() {
        return CollectionUtils.getFirst(this.getLastEntries());
    }

    public final List<SQLRowValues> getLastEntries() {
        return this.lastEntries;
    }

    public final SQLRowValues getLastReceiptRow() {
        return this.lastReceiptVals;
    }

    public final ReceiptCode getLastReceiptCode() throws ParseException {
        SQLRowValues lastReceiptRow = this.getLastReceiptRow();
        return lastReceiptRow == null ? null : new ReceiptCode(lastReceiptRow.getString("NUMERO"));
    }

    public final SQLRowValues fillHostValues(SQLRowValues logVals) {
        logVals.put("HOST_NAME", PropsConfiguration.getHostname());
        logVals.put("HOST_USER", System.getProperty("user.name"));
        return logVals;
    }

    public final boolean checkIfMoved(final TM erpTM) throws InterruptedException, ExecutionException {
        SQLRowValues lastEntry = this.getLastEntry();
        if (lastEntry == null) {
            return false;
        }
        Map<String, Object> currentValues = this.fillHostValues(new SQLRowValues(lastEntry.getTable())).getAbsolutelyAll();
        Map<String, Object> dbValues = lastEntry.getValues(currentValues.keySet());
        if (dbValues.equals(currentValues) || NULL_VALUES.equals(dbValues)) {
            return false;
        }
        final String message = erpTM.translate("register.moved", new Object[]{this.getPosID()});
        final String[] options = new String[]{erpTM.translate("register.moved.ignore", new Object[0]), erpTM.translate("register.moved.quit", new Object[0])};
        FutureTask<Boolean> askUserCallable = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                int ans = JOptionPane.showOptionDialog(null, message, erpTM.translate("register.moved.title", new Object[0]), -1, 3, null, options, options[1]);
                if (ans != 0) {
                    return true;
                }
                return false;
            }
        });
        SwingThreadUtils.invoke(askUserCallable);
        boolean quit = askUserCallable.get();
        if (!quit) {
            POSConfiguration.getLogger().log(Level.WARNING, "User choose to ignore changed host,\nDB values : {0}\ncurrent values : {1}", new Object[]{dbValues, currentValues});
        }
        return quit;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " for register " + this.getPosID() + " in state " + this.getRegisterState();
    }
}

