/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.report;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.jopendocument.model.OpenDocument;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.sales.quote.report.PaypalStamper;
import org.openconcerto.erp.core.supplychain.purchase.importer.FacturXExporter;
import org.openconcerto.erp.generationDoc.AbstractSheetXMLWithDate;
import org.openconcerto.erp.generationDoc.PDFAttachment;
import org.openconcerto.erp.generationDoc.SheetUtils;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.utils.ExceptionHandler;

public class VenteFactureXmlSheet
extends AbstractSheetXMLWithDate {
    public static final String TEMPLATE_ID = "VenteFacture";
    public static final String TEMPLATE_SITUATION_SUFFIX = "Situation";
    public static final String TEMPLATE_PROPERTY_NAME = "LocationFacture";

    @Override
    public String getReference() {
        return this.getSQLRow().getString("NOM");
    }

    @Override
    public String getName() {
        String startName = this.getSQLRow().getBoolean("COMPLEMENT") != false ? "FactureComplement_" : (this.getSQLRow().getBoolean("ACOMPTE") != false ? "FactureAcompte_" : "Facture_");
        return String.valueOf(startName) + this.getSQLRow().getString("NUMERO");
    }

    @Override
    public SQLRow getRowLanguage() {
        SQLRow rowClient = this.getSQLRow().getForeignRow("ID_CLIENT");
        if (rowClient.getTable().contains("ID_LANGUE")) {
            if (!rowClient.isForeignEmpty("ID_LANGUE")) {
                return rowClient.getForeign("ID_LANGUE");
            }
            return null;
        }
        return super.getRowLanguage();
    }

    public VenteFactureXmlSheet(SQLRow row) {
        super(row);
        this.elt = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
        this.printer = PrinterNXProps.getInstance().getStringProperty("FacturePrinter");
        this.getDefaultTemplateId();
    }

    @Override
    public String getType() {
        SQLRow row = this.getSQLRow();
        String type = row.getBoolean("COMPLEMENT") != false ? "Complement" : (row.getBoolean("ACOMPTE") != false ? "Acompte" : (row.getBoolean("PARTIAL") != false || row.getBoolean("SOLDE") != false ? TEMPLATE_SITUATION_SUFFIX : null));
        return type;
    }

    @Override
    public String getDefaultTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    public void createPDF(File generatedFile, File pdfFile, OpenDocument doc, String storagePath) {
        block20: {
            if (pdfFile == null) {
                throw new IllegalArgumentException("null PDF file");
            }
            try {
                ArrayList<PDFAttachment> attachments = new ArrayList<PDFAttachment>(1);
                FacturXExporter ex = new FacturXExporter();
                SQLRow rowSociete = ComptaPropsConfiguration.getInstanceCompta().getRowSociete();
                String xml = ex.createXMLFrom(this.getSQLRow().getTable().getDBRoot(), this.getSQLRow().getID(), rowSociete);
                attachments.add(new PDFAttachment("factur-x.xml", "factur-x.xml", xml.getBytes(StandardCharsets.UTF_8), "text/xml"));
                SQLPreferences prefs = SQLPreferences.getMemCached(this.getElement().getTable().getDBRoot());
                if (prefs.getBoolean("paypal.invoice", false)) {
                    try {
                        File inFile = File.createTempFile("oc_", pdfFile.getName());
                        SheetUtils.convert2PDF(doc, inFile, attachments);
                        PaypalStamper s = new PaypalStamper();
                        int x = prefs.getInt("paypal.invoice.x", 0);
                        int y = prefs.getInt("paypal.invoice.y", 0);
                        String ref = this.getSQLRow().getString("NUMERO");
                        long cents = this.getSQLRow().getLong("NET_A_PAYER");
                        String amount = String.valueOf(cents / 100L) + "." + cents % 100L;
                        String currency = "EUR";
                        URL url = new URL("https://cloud.openconcerto.org/payment");
                        URLConnection con = url.openConnection();
                        HttpURLConnection http = (HttpURLConnection)con;
                        http.setRequestMethod("POST");
                        http.setDoOutput(true);
                        http.setDefaultUseCaches(false);
                        String hyperlink = null;
                        HashMap<String, String> arguments = new HashMap<String, String>();
                        arguments.put("pI", prefs.get("paypal.clientid", ""));
                        arguments.put("pS", prefs.get("paypal.secret", ""));
                        arguments.put("ref", ref);
                        arguments.put("amount", amount);
                        arguments.put("currency", currency);
                        arguments.put("type", "paypal");
                        StringJoiner sj = new StringJoiner("&");
                        for (Map.Entry entry : arguments.entrySet()) {
                            sj.add(String.valueOf(URLEncoder.encode((String)entry.getKey(), "UTF-8")) + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8"));
                        }
                        String postData = sj.toString();
                        byte[] out = postData.getBytes(StandardCharsets.UTF_8);
                        int length = out.length;
                        http.setFixedLengthStreamingMode(length);
                        http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                        http.connect();
                        Throwable throwable = null;
                        Object var29_31 = null;
                        try (OutputStream os = http.getOutputStream();){
                            os.write(out);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        if (http.getResponseCode() != 401) {
                            int numCharsRead;
                            InputStream is = http.getInputStream();
                            InputStreamReader isr = new InputStreamReader(is);
                            char[] charArray = new char[1024];
                            StringBuilder sb = new StringBuilder();
                            while ((numCharsRead = isr.read(charArray)) > 0) {
                                sb.append(charArray, 0, numCharsRead);
                            }
                            hyperlink = sb.toString();
                        }
                        s.addLink(inFile, pdfFile, x, y, hyperlink);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        SheetUtils.convert2PDF(doc, pdfFile, attachments);
                    }
                    break block20;
                }
                SheetUtils.convert2PDF(doc, pdfFile, attachments);
            }
            catch (Throwable e) {
                ExceptionHandler.handle("Impossible de cr\u00e9er le PDF " + pdfFile.getAbsolutePath(), e);
            }
        }
        if (!pdfFile.canRead()) {
            ExceptionHandler.handle("Le fichier PDF " + pdfFile.getAbsolutePath() + " ne peut \u00eatre lu.");
        }
        this.storeWithStorageEngines(generatedFile, pdfFile, storagePath);
    }
}

