/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.element;

import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.finance.payment.component.EncaisserMontantSQLComponent;
import org.openconcerto.erp.core.sales.invoice.component.SaisieVenteFactureSQLComponent;
import org.openconcerto.erp.generationEcritures.GenerationReglementVenteNG;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.erp.preferences.GestionCommercialeGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.StringUtils;

public class EncaisserMontantSQLElement
extends ComptaSQLConfElement {
    public EncaisserMontantSQLElement() {
        super("ENCAISSER_MONTANT", "un encaissement de montant", "encaissements de montant");
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        if (prefs.getBoolean(GestionCommercialeGlobalPreferencePanel.ACOMPTE_DEVIS, false)) {
            RowAction.PredicateRowAction actionClient = new RowAction.PredicateRowAction(new AbstractAction("Annuler l'acompte"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SQLRow selRow = IListe.get(e).getSelectedRow().asRow();
                    if (selRow.getBoolean("ACOMPTE").booleanValue()) {
                        if (!selRow.isForeignEmpty("ID_DEVIS")) {
                            int idDevis = selRow.getForeignID("ID_DEVIS");
                            try {
                                EncaisserMontantSQLElement.this.archive(selRow.getID());
                                String up = "UPDATE " + EncaisserMontantSQLElement.this.getTable().getTable("DEVIS").getSQLName().quote() + " set \"T_ACOMPTE\"=(SELECT COALESCE(SUM(\"MONTANT\"),0) from " + EncaisserMontantSQLElement.this.getTable().getSQLName().quote() + " where \"ID_DEVIS\"=" + idDevis + " AND \"ARCHIVE\"=0) where \"ID_DEVIS\"=" + idDevis;
                                EncaisserMontantSQLElement.this.getTable().getDBSystemRoot().getDataSource().execute(up);
                            }
                            catch (SQLException e1) {
                                e1.printStackTrace();
                                ExceptionHandler.handle("Erreur lors de l'annulation de l'acompte!", e1);
                            }
                        } else if (!selRow.isForeignEmpty("ID_COMMANDE_CLIENT")) {
                            int idDevis = selRow.getForeignID("ID_COMMANDE_CLIENT");
                            try {
                                EncaisserMontantSQLElement.this.archive(selRow.getID());
                                String up = "UPDATE " + EncaisserMontantSQLElement.this.getTable().getTable("COMMANDE_CLIENT").getSQLName().quote() + " set \"T_ACOMPTE\"=(SELECT COALESCE(SUM(\"MONTANT\"),0) from " + EncaisserMontantSQLElement.this.getTable().getSQLName().quote() + " where \"ID_COMMANDE_CLIENT\"=" + idDevis + " AND \"ARCHIVE\"=0) where \"ID\"=" + idDevis;
                                EncaisserMontantSQLElement.this.getTable().getDBSystemRoot().getDataSource().execute(up);
                            }
                            catch (SQLException e1) {
                                e1.printStackTrace();
                                ExceptionHandler.handle("Erreur lors de l'annulation de l'acompte!", e1);
                            }
                        }
                    }
                }
            }, false);
            actionClient.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
            this.getRowActions().add(actionClient);
        }
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("NOM");
        l.add("ID_CLIENT");
        l.add("ID_MODE_REGLEMENT");
        l.add("MONTANT");
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        if (prefs.getBoolean(GestionCommercialeGlobalPreferencePanel.ACOMPTE_DEVIS, false)) {
            l.add("ACOMPTE");
        }
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("MONTANT");
        return l;
    }

    @Override
    public Set<String> getReadOnlyFields() {
        HashSet<String> s = new HashSet<String>();
        s.add("ACOMPTE");
        s.add("ID_CLIENT");
        return s;
    }

    @Override
    protected synchronized void _initTableSource(SQLTableModelSource table) {
        super._initTableSource(table);
        BaseSQLTableModelColumn racCol = new BaseSQLTableModelColumn("Report \u00e9ch\u00e9ance", Boolean.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                return r.getForeign("ID_MODE_REGLEMENT").getBoolean("COMPTANT") == false;
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = new Path(EncaisserMontantSQLElement.this.getTable());
                Path p2 = (Path)p.add(p.getLast().getField("ID_MODE_REGLEMENT"));
                return CollectionUtils.createSet(new FieldPath(p2, "COMPTANT"));
            }
        };
        table.getColumns().add(racCol);
    }

    @Override
    public SQLComponent createComponent() {
        return new EncaisserMontantSQLComponent(this);
    }

    @Override
    protected void archive(TreesOfSQLRows trees, boolean cutLinks) throws SQLException {
        for (SQLRow row : trees.getRows()) {
            for (SQLRow rowEncaisseItems : row.getReferentRows(row.getTable().getTable("ENCAISSER_MONTANT_ELEMENT").getField("ID_ENCAISSER_MONTANT"))) {
                SQLRow rowEch = rowEncaisseItems.getForeignRow("ID_ECHEANCE_CLIENT");
                if (rowEch.getID() > 1) {
                    SQLRowValues rowVals = rowEch.createEmptyUpdateRow();
                    rowVals.put("REGLE", Boolean.FALSE);
                    if (rowEch.getBoolean("REGLE").booleanValue()) {
                        rowVals.put("MONTANT", rowEncaisseItems.getLong("MONTANT_REGLE"));
                    } else {
                        rowVals.put("MONTANT", rowEch.getLong("MONTANT") + rowEncaisseItems.getLong("MONTANT_REGLE"));
                    }
                    rowVals.update();
                }
                Configuration.getInstance().getDirectory().getElement(rowEncaisseItems.getTable()).archive(rowEncaisseItems);
            }
            if (row.getBoolean("ACOMPTE").booleanValue()) {
                String up;
                if (!row.isForeignEmpty("ID_DEVIS")) {
                    int idDevis = row.getForeignID("ID_DEVIS");
                    try {
                        this.archive(row.getID());
                        up = "UPDATE " + this.getTable().getTable("DEVIS").getSQLName().quote() + " set \"T_ACOMPTE\"=(SELECT COALESCE(SUM(\"MONTANT\"),0) from " + this.getTable().getSQLName().quote() + " where \"ID_DEVIS\"=" + idDevis + " AND \"ARCHIVE\"=0) where \"ID_DEVIS\"=" + idDevis;
                        this.getTable().getDBSystemRoot().getDataSource().execute(up);
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                        ExceptionHandler.handle("Erreur lors de l'annulation de l'acompte!", e1);
                    }
                } else if (!row.isForeignEmpty("ID_COMMANDE_CLIENT")) {
                    int idDevis = row.getForeignID("ID_COMMANDE_CLIENT");
                    try {
                        this.archive(row.getID());
                        up = "UPDATE " + this.getTable().getTable("COMMANDE_CLIENT").getSQLName().quote() + " set \"T_ACOMPTE\"=(SELECT COALESCE(SUM(\"MONTANT\"),0) from " + this.getTable().getSQLName().quote() + " where \"ID_COMMANDE_CLIENT\"=" + idDevis + " AND \"ARCHIVE\"=0) where \"ID\"=" + idDevis;
                        this.getTable().getDBSystemRoot().getDataSource().execute(up);
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                        ExceptionHandler.handle("Erreur lors de l'annulation de l'acompte!", e1);
                    }
                }
            }
            SQLSelect sel = new SQLSelect(this.getTable().getBase());
            SQLTable tableMvt = this.getTable().getTable("MOUVEMENT");
            EcritureSQLElement eltEcr = (EcritureSQLElement)Configuration.getInstance().getDirectory().getElement(tableMvt.getTable("ECRITURE"));
            sel.addSelectStar(tableMvt);
            Where w = new Where((FieldRef)tableMvt.getField("SOURCE"), "=", (Object)this.getTable().getName());
            w = w.and(new Where((FieldRef)tableMvt.getField("IDSOURCE"), "=", row.getID()));
            sel.setWhere(w);
            List list = (List)this.getTable().getBase().getDataSource().execute(sel.asString(), SQLRowListRSH.createFromSelect(sel, tableMvt));
            for (SQLRow sqlRow : list) {
                eltEcr.archiveMouvementProfondeur(sqlRow.getID(), true);
            }
        }
        super.archive(trees, cutLinks);
    }

    public void regleFacture(SQLRow rowAfter, SQLRowValues rowBefore, boolean update) throws Exception {
        if (update && rowBefore == null) {
            throw new IllegalArgumentException();
        }
        if (update) {
            for (SQLRowAccessor sQLRowAccessor : rowBefore.getReferentRows(this.getTable().getTable("ENCAISSER_MONTANT_ELEMENT"))) {
                SQLRowAccessor rowEch = sQLRowAccessor.getForeign("ID_ECHEANCE_CLIENT");
                if (rowEch.getID() <= 1) continue;
                SQLRowValues rowVals = rowEch.createEmptyUpdateRow();
                rowVals.put("REGLE", Boolean.FALSE);
                if (rowEch.getBoolean("REGLE").booleanValue()) {
                    rowVals.put("MONTANT", sQLRowAccessor.getLong("MONTANT_REGLE"));
                } else {
                    rowVals.put("MONTANT", rowEch.getLong("MONTANT") + sQLRowAccessor.getLong("MONTANT_REGLE"));
                }
                rowVals.update();
            }
            SQLSelect sQLSelect = new SQLSelect(this.getTable().getBase());
            SQLTable tableMvt = this.getTable().getTable("MOUVEMENT");
            EcritureSQLElement eltEcr = (EcritureSQLElement)Configuration.getInstance().getDirectory().getElement(tableMvt.getTable("ECRITURE"));
            sQLSelect.addSelectStar(tableMvt);
            Where w = new Where((FieldRef)tableMvt.getField("SOURCE"), "=", (Object)this.getTable().getName());
            w = w.and(new Where((FieldRef)tableMvt.getField("IDSOURCE"), "=", rowBefore.getID()));
            sQLSelect.setWhere(w);
            List list = (List)this.getTable().getBase().getDataSource().execute(sQLSelect.asString(), SQLRowListRSH.createFromSelect(sQLSelect, tableMvt));
            for (SQLRow sqlRow : list) {
                eltEcr.archiveMouvementProfondeur(sqlRow.getID(), false);
            }
            SQLRowAccessor nonEmptyForeignMvt = rowBefore.getNonEmptyForeign("ID_MOUVEMENT");
            if (nonEmptyForeignMvt != null && nonEmptyForeignMvt.getString("SOURCE").equals("ECHEANCE_CLIENT")) {
                eltEcr.archiveMouvementProfondeur(nonEmptyForeignMvt.getID(), true);
            }
        }
        System.out.println("G\u00e9n\u00e9ration des ecritures du reglement");
        String string = rowAfter.getString("NOM");
        SQLRow rowModeRegl = rowAfter.getForeignRow("ID_MODE_REGLEMENT");
        SQLRow rowTypeRegl = rowModeRegl.getForeignRow("ID_TYPE_REGLEMENT");
        SQLRow clientRow = rowAfter.getForeignRow("ID_CLIENT");
        String label = "R\u00e8glement vente " + (string == null ? "" : string) + " (" + rowTypeRegl.getString("NOM") + ") " + StringUtils.limitLength(clientRow.getString("NOM"), 20);
        long montant = rowAfter.getLong("MONTANT");
        PrixTTC ttc = new PrixTTC(montant);
        Collection l = rowAfter.getReferentRows(rowAfter.getTable().getTable("ENCAISSER_MONTANT_ELEMENT"));
        if (l.isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, "Un probl\u00e8me a \u00e9t\u00e9 rencontr\u00e9 lors de l'encaissement! \n Les \u00e9critures comptables non pu \u00eatre g\u00e9n\u00e9rer!");
                }
            });
            System.err.println("Liste des \u00e9ch\u00e9ances vides pour l'encaissement ID " + rowAfter.getID());
            Thread.dumpStack();
            return;
        }
        new GenerationReglementVenteNG(label, clientRow, ttc, rowAfter.getDate("DATE").getTime(), rowModeRegl, rowAfter, ((SQLRow)l.get(0)).getForeignRow("ID_MOUVEMENT_ECHEANCE"), false, false, rowAfter.getString("TIERS"), rowAfter.getForeign("ID_COMPTE_PCE_TIERS"));
        boolean supplement = false;
        if (!rowAfter.getBoolean("ACOMPTE").booleanValue()) {
            for (SQLRow sqlRow : l) {
                SQLRow rowEch = sqlRow.getForeignRow("ID_ECHEANCE_CLIENT");
                SQLRowValues rowValsEch = rowEch.createEmptyUpdateRow();
                if (sqlRow.getLong("MONTANT_REGLE") >= sqlRow.getLong("MONTANT_A_REGLER")) {
                    rowValsEch.put("REGLE", Boolean.TRUE);
                    if (sqlRow.getLong("MONTANT_REGLE") > sqlRow.getLong("MONTANT_A_REGLER")) {
                        supplement = true;
                    }
                }
                rowValsEch.put("MONTANT", rowEch.getLong("MONTANT") - sqlRow.getLong("MONTANT_REGLE"));
                rowValsEch.update();
            }
        }
        if (supplement) {
            final SQLElement elt = this.getDirectory().getElement("SAISIE_VENTE_FACTURE");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditFrame f = new EditFrame(elt, EditFrame.CREATION);
                    SaisieVenteFactureSQLComponent comp = (SaisieVenteFactureSQLComponent)f.getSQLComponent();
                    comp.setComplement(true);
                    f.setVisible(true);
                }
            });
        }
    }

    @Override
    protected String createCodeSuffix() {
        return ".category";
    }
}

