/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.element;

import com.ibm.icu.math.BigDecimal;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class FraisDocumentSQLElement
extends ComptaSQLConfElement {
    public FraisDocumentSQLElement() {
        super("FRAIS_DOCUMENT");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add("CODE");
        list.add("NOM");
        list.add("MONTANT_HT");
        list.add("ID_TAXE");
        list.add("MONTANT_TTC");
        return list;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add("CODE");
        list.add("NOM");
        list.add("MONTANT_TTC");
        return list;
    }

    @Override
    public Set<String> getReadOnlyFields() {
        HashSet<String> s = new HashSet<String>();
        s.add("MONTANT_TTC");
        return s;
    }

    @Override
    public ListMap<String, String> getShowAs() {
        return ListMap.singleton(null, new String[]{"CODE", "NOM"});
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                JLabel labelCode = new JLabel(this.getLabelFor("CODE"));
                c.weightx = 0.0;
                this.add((Component)labelCode, c);
                ++c.gridx;
                c.weightx = 1.0;
                JTextField textCode = new JTextField();
                this.add((Component)textCode, c);
                ++c.gridx;
                c.weightx = 0.0;
                JLabel labelNom = new JLabel(this.getLabelFor("NOM"));
                this.add((Component)labelNom, c);
                ++c.gridx;
                c.weightx = 1.0;
                JTextField textNom = new JTextField();
                this.add((Component)textNom, c);
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                JLabel labelTaux = new JLabel(this.getLabelFor("MONTANT_HT"));
                this.add((Component)labelTaux, c);
                ++c.gridx;
                c.weightx = 1.0;
                final DeviseField textTaux = new DeviseField();
                this.add((Component)textTaux, c);
                ++c.gridx;
                c.weightx = 0.0;
                JLabel labelTaxe = new JLabel(this.getLabelFor("ID_TAXE"));
                this.add((Component)labelTaxe, c);
                ++c.gridx;
                c.weightx = 1.0;
                final SQLRequestComboBox boxTaxe = new SQLRequestComboBox();
                this.add((Component)boxTaxe, c);
                ++c.gridx;
                c.weightx = 0.0;
                JLabel labelTTC = new JLabel(this.getLabelFor("MONTANT_TTC"));
                this.add((Component)labelTTC, c);
                ++c.gridx;
                c.weightx = 1.0;
                final DeviseField textTTC = new DeviseField();
                textTTC.setEditable(false);
                this.add((Component)textTTC, c);
                this.addRequiredSQLObject(boxTaxe, "ID_TAXE");
                boxTaxe.addModelListener("wantedID", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        textTTC.setValue(this.getMontantTTC(textTaux, boxTaxe));
                    }
                });
                textTaux.getDocument().addDocumentListener(new SimpleDocumentListener(){

                    @Override
                    public void update(DocumentEvent e) {
                        textTTC.setValue(this.getMontantTTC(textTaux, boxTaxe));
                    }
                });
                this.addRequiredSQLObject(textTTC, "MONTANT_TTC");
                this.addRequiredSQLObject(textTaux, "MONTANT_HT");
                this.addRequiredSQLObject(textNom, "NOM");
                this.addRequiredSQLObject(textCode, "CODE");
            }

            public long getMontantTTC(DeviseField fieldHT, SQLRequestComboBox boxTVA) {
                Float t;
                long l = 0L;
                long p = GestionDevise.parseLongCurrency(fieldHT.getText().trim());
                if (!boxTVA.isEmpty() && (t = TaxeCache.getCache().getTauxFromId(boxTVA.getWantedID())) != null) {
                    l = new BigDecimal(p).multiply(new BigDecimal(t.floatValue()).movePointLeft(2).add(BigDecimal.ONE)).setScale(0, 4).longValue();
                }
                return l;
            }
        };
    }
}

