/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.openconcerto.sql.preferences.UserProps;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class ReminderDialog {
    public static void showMessage(String title, String text, final String propertyId) {
        assert (SwingUtilities.isEventDispatchThread());
        boolean hideMessage = UserProps.getInstance().getBooleanValue("hide." + propertyId, false);
        if (!hideMessage) {
            final JDialog d = new JDialog();
            d.setTitle(title);
            String[] parts = text.split("\n");
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            DefaultGridBagConstraints c = new DefaultGridBagConstraints();
            c.fill = 0;
            c.gridwidth = 2;
            int i = 0;
            while (i < parts.length) {
                panel.add((Component)new JLabel(parts[i]), c);
                ++c.gridy;
                ++i;
            }
            c.gridwidth = 1;
            c.gridx = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.anchor = 16;
            final JCheckBox checkbox = new JCheckBox("ne plus afficher cette information");
            panel.add((Component)checkbox, c);
            ++c.gridx;
            c.anchor = 14;
            JButton buttonOk = new JButton("OK");
            panel.add((Component)buttonOk, c);
            d.setContentPane(panel);
            d.pack();
            d.setLocationRelativeTo(null);
            d.setResizable(false);
            d.setDefaultCloseOperation(2);
            d.setVisible(true);
            buttonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final boolean selected = checkbox.isSelected();
                    SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                        @Override
                        protected Object doInBackground() throws Exception {
                            if (selected) {
                                UserProps.getInstance().setProperty("hide." + propertyId, "true");
                                UserProps.getInstance().store();
                            }
                            return null;
                        }
                    };
                    worker.execute();
                    d.dispose();
                }
            });
        }
    }
}

