/*
 * Decompiled with CFR 0.152.
 */
package ds.desktop.notify;

import ds.desktop.notify.DesktopNotifyDriver;
import ds.desktop.notify.NotifyTheme;
import java.awt.AlphaComposite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;

public class DesktopNotify {
    public static final int DEFAULT = 0;
    public static final int INFORMATION = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 3;
    public static final int HELP = 4;
    public static final int TIP = 5;
    public static final int INPUT_REQUEST = 6;
    public static final int SUCCESS = 7;
    public static final int FAIL = 8;
    private static NotifyTheme defTheme = NotifyTheme.Dark;
    String title;
    String message;
    Image icon;
    int type;
    NotifyTheme theme;
    String[] tlts = new String[0];
    String[] msgs = new String[0];
    int w = 0;
    int h = 0;
    boolean visible = false;
    int highl = 0;
    long popupStart = 0L;
    long timeOut = 8000L;
    ActionListener action;

    public static void setDefaultTheme(NotifyTheme theme) {
        defTheme = theme;
    }

    public static NotifyTheme getDefaultTheme() {
        return defTheme;
    }

    public static void showDesktopMessage(String title, String message) {
        DesktopNotify.showDesktopMessage(title, message, 0, null, null, 0L);
    }

    public static void showDesktopMessage(String title, String message, int type) {
        DesktopNotify.showDesktopMessage(title, message, type, null, null, 0L);
    }

    public static void showDesktopMessage(String title, String message, int type, ActionListener action) {
        DesktopNotify.showDesktopMessage(title, message, type, null, action, 0L);
    }

    public static void showDesktopMessage(String title, String message, int type, Image icon, ActionListener action) {
        DesktopNotify.showDesktopMessage(title, message, type, icon, action, 0L);
    }

    public static void showDesktopMessage(String title, String message, int type, long maxTimeMillis) {
        DesktopNotify.showDesktopMessage(title, message, type, null, null, maxTimeMillis);
    }

    public static void showDesktopMessage(String title, String message, int type, long maxTimeMillis, ActionListener action) {
        DesktopNotify.showDesktopMessage(title, message, type, null, action, maxTimeMillis);
    }

    public static void showDesktopMessage(String title, String message, int type, Image icon) {
        DesktopNotify.showDesktopMessage(title, message, type, icon, null, 0L);
    }

    public static void showDesktopMessage(String title, String message, int type, Image icon, ActionListener action, long maxTimeMillis) {
        DesktopNotify pane = new DesktopNotify(title, message, type, icon);
        pane.setTimeout(maxTimeMillis);
        pane.setAction(action);
        pane.show();
    }

    protected DesktopNotify(String title, String message, int type, Image icon) {
        this.title = title == null ? "" : title;
        this.message = message == null ? "" : message;
        this.type = type;
        this.icon = icon;
        this.theme = defTheme;
    }

    public NotifyTheme getTheme() {
        return this.theme;
    }

    public void setTheme(NotifyTheme theme) {
        if (theme != null) {
            this.theme = theme;
        }
    }

    public ActionListener getAction() {
        return this.action;
    }

    public void setAction(ActionListener action) {
        this.action = action;
    }

    public void setTimeout(long millis) {
        this.timeOut = millis < 0L ? 0L : millis;
    }

    protected long expTime() {
        return this.timeOut == 0L ? Long.MAX_VALUE : this.popupStart + this.timeOut;
    }

    public void show() {
        DesktopNotifyDriver.postPane(this);
    }

    protected void setWidth(int w) {
        this.w = w;
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void render(int x, int y, boolean hover, Graphics2D rd, long l) {
        long i = l - this.popupStart;
        if (i > 500L) {
            i = this.expTime() - l;
        }
        if (i < 0L) {
            i = 0L;
        }
        if (i > 500L) {
            i = -1L;
        }
        rd.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        AffineTransform trans = rd.getTransform();
        rd.translate(x, y);
        if (i != -1L) {
            double d = (double)i / 500.0;
            rd.translate((double)(this.w / 2) - (double)(this.w / 2) * d, (double)(this.h / 2) - (double)(this.h / 2) * d);
            rd.scale(d, d);
            rd.setComposite(AlphaComposite.getInstance(3, (float)d));
        }
        rd.setPaint(new GradientPaint(0.0f, this.title.isEmpty() ? 0 : 25, this.theme.bgGrad[0], 0.0f, this.h, this.theme.bgGrad[this.highl + 1], false));
        if (hover && this.highl < 20) {
            ++this.highl;
        }
        if (!hover && this.highl > 0) {
            --this.highl;
        }
        rd.fillRect(0, 0, this.w, this.h);
        rd.setPaint(null);
        rd.setColor(this.theme.borderColor);
        rd.drawRect(0, 0, this.w - 1, this.h - 1);
        if (i == -1L) {
            int j;
            int titleH = this.getLineHeight(this.theme.titleFont);
            int textH = this.getLineHeight(this.theme.contentFont);
            if (!this.title.isEmpty()) {
                rd.setColor(this.theme.titleColor);
                rd.setFont(this.theme.titleFont);
                for (j = 0; j < this.tlts.length; ++j) {
                    rd.drawString(this.tlts[j], 5 + (this.icon == null && this.type == 0 ? 0 : 38), 20 + titleH * j);
                }
            }
            if (!this.message.isEmpty()) {
                rd.setColor(this.theme.contentColor);
                rd.setFont(this.theme.contentFont);
                for (j = 0; j < this.msgs.length; ++j) {
                    rd.drawString(this.msgs[j], 6 + (this.icon == null && this.type == 0 ? 0 : 38), 20 + titleH * this.tlts.length + textH * j);
                }
            }
        }
        if (this.icon != null) {
            rd.drawImage(this.icon, 6, this.h / 2 - 15, 32, 32, null);
        } else if (this.type != 0) {
            rd.drawImage(this.theme.iconSet[this.type - 1], 6, this.h / 2 - 15, 32, 32, null);
        }
        rd.setTransform(trans);
        rd.setComposite(AlphaComposite.getInstance(3));
    }

    private int getLineHeight(Font font) {
        FontMetrics ftm = DesktopNotifyDriver.getFontMetrics(font);
        return ftm.getHeight() - ftm.getLeading();
    }

    protected void sortMessage() {
        if (!this.title.isEmpty()) {
            this.tlts = this.splitLines(this.title, this.theme.titleFont);
        }
        if (!this.message.isEmpty()) {
            this.msgs = this.splitLines(this.message, this.theme.contentFont);
        }
        this.h = 15 + this.getLineHeight(this.theme.titleFont) * this.tlts.length + this.getLineHeight(this.theme.contentFont) * this.msgs.length;
    }

    private String[] splitLines(String in, Font font) {
        ArrayList<String> list = new ArrayList<String>();
        String[] strs = in.split("\n");
        StringBuilder builder = new StringBuilder();
        FontMetrics ftm = DesktopNotifyDriver.getFontMetrics(font);
        for (String str : strs) {
            String[] words;
            for (String word : words = str.split(" ")) {
                if (ftm.stringWidth(builder.toString()) + ftm.stringWidth(word) < this.w - 12 - (this.icon == null && this.type == 0 ? 0 : 38)) {
                    builder.append(word).append(" ");
                    continue;
                }
                list.add(builder.toString());
                builder = new StringBuilder().append(word).append(" ");
            }
            list.add(builder.toString());
            builder.setLength(0);
        }
        String[] out = new String[list.size()];
        out = list.toArray(out);
        return out;
    }
}

