/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.xml;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openconcerto.utils.Tuple2;

public class XMLUtils {
    public static final String escapeAttribute(String value) {
        int len = value.length();
        int idx = 0;
        while (idx < len) {
            char ch = value.charAt(idx);
            if (ch == '<' || ch == '>' || ch == '&' || ch == '\r' || ch == '\n' || ch == '\"' || ch == '\t') break;
            ++idx;
        }
        if (idx == len) {
            return value;
        }
        StringBuilder sb = new StringBuilder(len + 5);
        sb.append(value, 0, idx);
        while (idx < len) {
            char ch = value.charAt(idx++);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\r': {
                    sb.append("&#xD;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '\t': {
                    sb.append("&#x9;");
                    break;
                }
                case '\n': {
                    sb.append("&#xA;");
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static final String escapeText(String value) {
        int right = value.length();
        int idx = 0;
        while (idx < right) {
            char ch = value.charAt(idx);
            if (ch == '<' || ch == '>' || ch == '&' || ch == '\r' || ch == '\n') break;
            ++idx;
        }
        if (idx == right) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        if (idx > 0) {
            sb.append(value, 0, idx);
        }
        while (idx < right) {
            char ch = value.charAt(idx++);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\r': {
                    sb.append("&#xD;");
                    break;
                }
                case '\n': {
                    sb.append('\n');
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static Tuple2.List2<String> splitQualifiedName(String qName) throws IllegalArgumentException {
        int indexOfColon = qName.indexOf(58);
        if (indexOfColon < 0) {
            return new Tuple2.List2<String>((String)null, qName);
        }
        if (indexOfColon == 0) {
            throw new IllegalArgumentException("Starts with colon : '" + qName + "'");
        }
        int l = qName.length();
        assert (indexOfColon < l);
        if (indexOfColon == l - 1) {
            throw new IllegalArgumentException("Ends with colon : '" + qName + "'");
        }
        int secondColon = qName.indexOf(58, indexOfColon + 1);
        if (secondColon >= 0) {
            throw new IllegalArgumentException("Two colons : '" + qName + "'");
        }
        return new Tuple2.List2<String>(qName.substring(0, indexOfColon), qName.substring(indexOfColon + 1));
    }

    public static final void skipToEndElement(XMLStreamReader reader) throws XMLStreamException {
        if (!reader.isStartElement()) {
            throw new IllegalStateException("Not at a start of an element : " + reader.getEventType() + ", " + reader.getLocation());
        }
        String name = reader.getLocalName();
        int depth = 1;
        while (depth != 0 || !reader.isEndElement() || !reader.getLocalName().equals(name)) {
            int eventType = reader.next();
            if (eventType == 1) {
                ++depth;
                continue;
            }
            if (eventType != 2) continue;
            --depth;
        }
    }
}

