/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.openconcerto.utils.CollectionMap2;

public interface CollectionMap2Itf<K, C extends Collection<V>, V>
extends Map<K, C> {
    public CollectionMap2.Mode getMode();

    public boolean isEmptyCollSameAsNoColl();

    public C getNonNull(K var1);

    public C get(Object var1, boolean var2, boolean var3);

    public C getCollection(Object var1);

    public boolean containsInCollection(K var1, V var2) throws NullPointerException;

    public Collection<V> allValues();

    public C putCollection(K var1, Collection<? extends V> var2);

    public boolean add(K var1, V var2);

    public boolean addAll(K var1, Collection<? extends V> var2);

    public void merge(Map<? extends K, ? extends Collection<? extends V>> var1);

    public void mergeScalarMap(Map<? extends K, ? extends V> var1);

    public boolean removeOne(K var1, V var2);

    public boolean removeAllInstancesOfItem(K var1, V var2);

    public boolean removeAll(K var1, Collection<? extends V> var2);

    public boolean removeAll(Map<? extends K, ? extends Collection<? extends V>> var1);

    public boolean removeAllScalar(Map<? extends K, ? extends V> var1);

    public Set<K> removeAllEmptyCollections();

    public Set<K> removeAllNullCollections();

    default public void replaceAllNonNullValues(Function<? super C, ? extends C> function) {
        this.replaceAll((k, v) -> v == null ? null : (Collection)function.apply((Object)v));
    }

    default public Map<K, C> convertToUnmodifiableMap(Function<? super C, ? extends C> toUnmodifiable) {
        this.replaceAllNonNullValues(Objects.requireNonNull(toUnmodifiable));
        return Collections.unmodifiableMap(this);
    }

    public static interface ListMapItf<K, V>
    extends CollectionMap2Itf<K, List<V>, V> {
        default public Map<K, List<V>> convertToUnmodifiableMap() {
            return this.convertToUnmodifiableMap(Collections::unmodifiableList);
        }
    }

    public static interface SetMapItf<K, V>
    extends CollectionMap2Itf<K, Set<V>, V> {
        default public Map<K, Set<V>> convertToUnmodifiableMap() {
            return this.convertToUnmodifiableMap(Collections::unmodifiableSet);
        }
    }
}

