/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.login;

import org.openconcerto.ui.login.AbstractProperties;
import org.openconcerto.utils.FileUtils;

public class LoginProperties
extends AbstractProperties {
    private static final String PASSWORD = "password";
    private static final String LAST_LOGIN = "login";
    private static final String LAST_COMPANY_ID = "company_id";
    private static final String LAST_COMPANY_NAME = "company_name";
    private String serverUrl;

    public LoginProperties(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getLastLoginName() {
        return this.getStringProperty(LAST_LOGIN);
    }

    public void setLastLoginName(String login) {
        this.setProperty(LAST_LOGIN, login);
    }

    public String getEncryptedStoredPassword() {
        return this.getProperty(PASSWORD);
    }

    public void setEncryptedStoredPassword(String password) {
        this.setProperty(PASSWORD, password);
    }

    public int getLastCompanyId() {
        return this.getIntProperty(LAST_COMPANY_ID, -1);
    }

    public void setLastCompanyId(long id) {
        this.setProperty(LAST_COMPANY_ID, String.valueOf(id));
    }

    public String getLastCompanyName() {
        return this.getProperty(LAST_COMPANY_NAME);
    }

    public void setLastCompanyName(String name) {
        this.setProperty(LAST_COMPANY_NAME, name);
    }

    @Override
    protected String getPropsFileName() {
        if (this.serverUrl == null) {
            throw new IllegalStateException("null server url");
        }
        String string = String.valueOf(System.getProperty("user.home")) + "/.openconcerto/" + FileUtils.FILENAME_ESCAPER.escape(this.serverUrl) + "/";
        return String.valueOf(string) + "login.properties";
    }
}

