/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.InvalidClassException;
import org.openconcerto.ui.light.LightUIButton;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.RowSelectionSpec;

public class LightUIButtonWithSelectionContext
extends LightUIButton {
    private RowSelectionSpec tableSelection;

    public LightUIButtonWithSelectionContext(JSONObject json) {
        super(json);
    }

    public LightUIButtonWithSelectionContext(String id, RowSelectionSpec tableSelection) {
        super(id, 24);
        this.tableSelection = tableSelection;
    }

    public LightUIButtonWithSelectionContext(LightUIButtonWithSelectionContext button) {
        super(button);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.tableSelection = null;
    }

    public RowSelectionSpec getTableSelection() {
        return this.tableSelection;
    }

    @Override
    protected void copy(LightUIElement element) {
        super.copy(element);
        if (!(element instanceof LightUIButtonWithSelectionContext)) {
            throw new InvalidClassException(LightUIButtonWithSelectionContext.class.getName(), element.getClassName(), element.getId());
        }
        LightUIButtonWithSelectionContext button = (LightUIButtonWithSelectionContext)element;
        this.tableSelection = button.tableSelection;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.tableSelection = new RowSelectionSpec();
        JSONObject o = (JSONObject)json.get("table-selection");
        this.tableSelection.fromJSON(o);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        json.put("table-selection", this.tableSelection.toJSON());
        return json;
    }
}

