/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.TableColumn;

public class TableColumnResizer
extends MouseInputAdapter {
    public static Cursor resizeCursor = Cursor.getPredefinedCursor(11);
    private int mouseXOffset;
    private Cursor otherCursor = resizeCursor;
    private JTable table;

    public TableColumnResizer(JTable table) {
        this.table = table;
        table.addMouseListener(this);
        table.addMouseMotionListener(this);
    }

    private boolean canResize(TableColumn column) {
        return column != null && this.table.getTableHeader().getResizingAllowed() && column.getResizable();
    }

    private TableColumn getResizingColumn(Point p) {
        return this.getResizingColumn(p, this.table.columnAtPoint(p));
    }

    private TableColumn getResizingColumn(Point p, int column) {
        int columnIndex;
        if (column == -1) {
            return null;
        }
        int row = this.table.rowAtPoint(p);
        if (row == -1) {
            return null;
        }
        Rectangle r = this.table.getCellRect(row, column, true);
        r.grow(-3, 0);
        if (r.contains(p)) {
            return null;
        }
        int midPoint = r.x + r.width / 2;
        if (this.table.getTableHeader().getComponentOrientation().isLeftToRight()) {
            columnIndex = p.x < midPoint ? column - 1 : column;
        } else {
            int n = columnIndex = p.x < midPoint ? column : column - 1;
        }
        if (columnIndex == -1) {
            return null;
        }
        return this.table.getTableHeader().getColumnModel().getColumn(columnIndex);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.table.getTableHeader().setDraggedColumn(null);
        this.table.getTableHeader().setResizingColumn(null);
        this.table.getTableHeader().setDraggedDistance(0);
        Point p = e.getPoint();
        int index = this.table.columnAtPoint(p);
        if (index == -1) {
            return;
        }
        TableColumn resizingColumn = this.getResizingColumn(p, index);
        if (!this.canResize(resizingColumn)) {
            return;
        }
        this.table.getTableHeader().setResizingColumn(resizingColumn);
        this.mouseXOffset = this.table.getTableHeader().getComponentOrientation().isLeftToRight() ? p.x - resizingColumn.getWidth() : p.x + resizingColumn.getWidth();
    }

    private void swapCursor() {
        Cursor tmp = this.table.getCursor();
        this.table.setCursor(this.otherCursor);
        this.otherCursor = tmp;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.canResize(this.getResizingColumn(e.getPoint())) != (this.table.getCursor() == resizeCursor)) {
            this.swapCursor();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int mouseX = e.getX();
        TableColumn resizingColumn = this.table.getTableHeader().getResizingColumn();
        boolean headerLeftToRight = this.table.getTableHeader().getComponentOrientation().isLeftToRight();
        if (resizingColumn != null) {
            Container container;
            int oldWidth = resizingColumn.getWidth();
            int newWidth = headerLeftToRight ? mouseX - this.mouseXOffset : this.mouseXOffset - mouseX;
            resizingColumn.setWidth(newWidth);
            if (this.table.getTableHeader().getParent() == null || (container = this.table.getTableHeader().getParent().getParent()) == null || !(container instanceof JScrollPane)) {
                return;
            }
            if (!container.getComponentOrientation().isLeftToRight() && !headerLeftToRight && this.table != null) {
                JViewport viewport = ((JScrollPane)container).getViewport();
                int viewportWidth = viewport.getWidth();
                int diff = newWidth - oldWidth;
                int newHeaderWidth = this.table.getWidth() + diff;
                Dimension tableSize = this.table.getSize();
                tableSize.width += diff;
                this.table.setSize(tableSize);
                if (newHeaderWidth >= viewportWidth && this.table.getAutoResizeMode() == 0) {
                    Point p = viewport.getViewPosition();
                    p.x = Math.max(0, Math.min(newHeaderWidth - viewportWidth, p.x + diff));
                    viewport.setViewPosition(p);
                    this.mouseXOffset += diff;
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.table.getTableHeader().setResizingColumn(null);
        this.table.getTableHeader().setDraggedColumn(null);
    }
}

