/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;

public final class ContainerUtils {
    private ContainerUtils() {
    }

    public static final Component getNearestChild(Container cont, Point p) {
        Component res = null;
        double distance = 2.147483647E9;
        Rectangle rv = new Rectangle();
        Component[] componentArray = cont.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            double d = ContainerUtils.getDistance(p, comp.getBounds(rv));
            if (d < distance) {
                distance = d;
                res = comp;
            }
            ++n2;
        }
        return res;
    }

    public static double getDistance(Point p, Rectangle bounds) {
        if (bounds.contains(p)) {
            return 0.0;
        }
        int x = ContainerUtils.getNearest(p.x, bounds.x, bounds.x + bounds.width);
        int y = ContainerUtils.getNearest(p.y, bounds.y, bounds.y + bounds.height);
        int diffX = Math.abs(p.x - x);
        int diffY = Math.abs(p.y - y);
        return Math.sqrt(diffX * diffX + diffY * diffY);
    }

    private static int getNearest(int p, int start, int end) {
        if (p < start) {
            return start;
        }
        if (p > end) {
            return end;
        }
        return p;
    }

    public static double getDistance(Container cont, Point p, Component comp, Rectangle bounds) {
        return ContainerUtils.getDistance(p, ContainerUtils.getBoundsInAncestor(cont, comp, bounds));
    }

    public static Rectangle getBoundsInAncestor(Container ancestor, Component comp, Rectangle bounds) {
        bounds = comp.getBounds(bounds);
        Container parent = comp.getParent();
        while (parent != null && parent != ancestor) {
            bounds.translate(parent.getX(), parent.getY());
            parent = parent.getParent();
        }
        return bounds;
    }
}

