/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.task;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.User;

public class UserTaskRight {
    private int idUser;
    private int idToUser;
    private boolean canRead;
    private boolean canModify;
    private boolean canAdd;
    private boolean canValidate;

    public UserTaskRight(int idUser, int idToUser, boolean canRead, boolean canModify, boolean canAdd, boolean canValidate) {
        this.idUser = idUser;
        this.idToUser = idToUser;
        this.canRead = canRead;
        this.canModify = canModify;
        this.canAdd = canAdd;
        this.canValidate = canValidate;
    }

    public boolean canModify() {
        return this.canModify;
    }

    public boolean canRead() {
        return this.canRead;
    }

    public boolean canValidate() {
        return this.canValidate;
    }

    public boolean canAdd() {
        return this.canAdd;
    }

    public int getIdToUser() {
        return this.idToUser;
    }

    public int getIdUser() {
        return this.idUser;
    }

    public static List<UserTaskRight> getUserTaskRight(User selectedUser) {
        DBSystemRoot systemRoot = Configuration.getInstance().getSystemRoot();
        SQLTable rightsT = systemRoot.findTable("TACHE_RIGHTS", true);
        SQLField userF = rightsT.getField("ID_USER_COMMON");
        SQLSelect sel = new SQLSelect(systemRoot, false);
        sel.addSelectStar(rightsT);
        sel.setWhere(new Where((FieldRef)userF, "=", selectedUser.getId()));
        List l = (List)systemRoot.getDataSource().execute(sel.toString(), new UTR_RSH(selectedUser, userF));
        return l;
    }

    public String toString() {
        return "UserTaskRight:" + this.idUser + " to user:" + this.idToUser + "Read:" + this.canRead + " Modify:" + this.canModify + " Add:" + this.canAdd + " Validate:" + this.canValidate;
    }

    private static final class UTR_RSH
    implements ResultSetHandler {
        private final User selectedUser;
        private final SQLField userFF;
        private final int userTUndef;

        private UTR_RSH(User selectedUser, SQLField userFF) {
            this.selectedUser = selectedUser;
            this.userFF = userFF;
            this.userTUndef = userFF.getForeignTable().getUndefinedID();
        }

        @Override
        public Object handle(ResultSet rs) throws SQLException {
            Vector<UserTaskRight> list = new Vector<UserTaskRight>();
            list.add(new UserTaskRight(this.selectedUser.getId(), this.selectedUser.getId(), true, true, true, true));
            while (rs.next()) {
                int idUser = rs.getInt(this.userFF.getName());
                assert (idUser == this.selectedUser.getId());
                int idToUser = rs.getInt("ID_USER_COMMON_TO");
                boolean canRead = rs.getBoolean("READ");
                boolean canModify = rs.getBoolean("MODIFY");
                boolean canWrite = rs.getBoolean("ADD");
                boolean canValidate = rs.getBoolean("VALIDATE");
                if (idToUser == this.userTUndef || idToUser == idUser) continue;
                list.add(new UserTaskRight(idUser, idToUser, canRead, canModify, canWrite, canValidate));
            }
            return list;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.selectedUser.hashCode();
            result = 31 * result + this.userFF.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UTR_RSH other = (UTR_RSH)obj;
            return this.selectedUser.equals(other.selectedUser) && this.userFF.equals(other.userFF);
        }
    }
}

