/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.ConnectivityInspector;
import org.jgrapht.ext.IntegerNameProvider;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;

@ThreadSafe
public abstract class BaseGraph {
    private static final Comparator<SQLTable> TABLE_COMP = new Comparator<SQLTable>(){

        @Override
        public int compare(SQLTable o1, SQLTable o2) {
            return o1.getSQLName().quote().compareTo(o2.getSQLName().quote());
        }
    };
    private static final Comparator<Link> LINK_COMP = new Comparator<Link>(){

        @Override
        public int compare(Link o1, Link o2) {
            int srcRes = TABLE_COMP.compare((SQLTable)o1.getSource(), (SQLTable)o2.getSource());
            if (srcRes != 0) {
                return srcRes;
            }
            int destRes = TABLE_COMP.compare((SQLTable)o1.getTarget(), (SQLTable)o2.getTarget());
            if (destRes != 0) {
                return destRes;
            }
            return o1.getCols().toString().compareTo(o2.getCols().toString());
        }
    };
    @GuardedBy(value="this")
    private final Graph<SQLTable, Link> graph;

    protected BaseGraph(DirectedGraph<SQLTable, Link> g) {
        this.graph = g;
    }

    protected BaseGraph(UndirectedGraph<SQLTable, Link> g) {
        this.graph = g;
    }

    public String toTGF() {
        return this.print(true);
    }

    public String print() {
        return this.print(false);
    }

    private synchronized String print(boolean tgf) {
        StringBuffer sb = new StringBuffer();
        IntegerNameProvider<SQLTable> p = tgf ? new IntegerNameProvider<SQLTable>() : null;
        TreeSet<SQLTable> vertices = new TreeSet<SQLTable>(TABLE_COMP);
        vertices.addAll(this.graph.vertexSet());
        for (SQLTable table : vertices) {
            if (tgf) {
                sb.append(p.getVertexName(table)).append('\t');
            }
            sb.append(table.getSQLName()).append('\n');
        }
        sb.append("#\n");
        TreeSet<Link> edges = new TreeSet<Link>(LINK_COMP);
        edges.addAll(this.graph.edgeSet());
        for (Link l : edges) {
            String dest;
            String src;
            if (tgf) {
                src = p.getVertexName((SQLTable)l.getSource());
                dest = p.getVertexName((SQLTable)l.getTarget());
            } else {
                src = ((SQLTable)l.getSource()).getSQLName().quote();
                dest = l.getContextualName().quote();
            }
            sb.append(src).append('\t').append(dest).append('\t').append(l.getCols()).append('\n');
        }
        return sb.toString();
    }

    public synchronized Set<SQLTable> getConnectedSet(SQLTable table) {
        ConnectivityInspector insp = this.graph instanceof DirectedGraph ? new ConnectivityInspector((DirectedGraph)this.graph) : new ConnectivityInspector((UndirectedGraph)this.graph);
        return insp.connectedSetOf(table);
    }

    public final synchronized Set<SQLTable> getAllTables() {
        return this.graph.vertexSet();
    }

    protected final synchronized Graph<SQLTable, Link> getGraph() {
        return this.graph;
    }
}

