/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class SQLUpdate {
    private List<SQLField> fields = new ArrayList<SQLField>();
    private List<Object> values = new ArrayList<Object>();
    private SQLTable table;
    private Where where;

    public SQLUpdate(Where where) {
        this.where = where;
    }

    public void importValuesFrom(SQLRowAccessor row) {
        SQLField pk = row.getTable().getKey();
        for (String field : row.getFields()) {
            SQLField sqlField = row.getTable().getField(field);
            if (pk.equals(sqlField)) continue;
            if (sqlField.isForeignKey()) {
                this.add(sqlField, row.getForeignIDNumber(field));
                continue;
            }
            this.add(sqlField, row.getObject(field));
        }
    }

    public void add(SQLField field, Object value) {
        if (this.table == null) {
            this.table = field.getTable();
        } else if (!this.table.equals(field.getTable())) {
            throw new IllegalArgumentException(field + " is not in table " + this.table.toString());
        }
        this.fields.add(field);
        this.values.add(value);
    }

    public void set(SQLField field, Object value) {
        if (this.table == null) {
            this.table = field.getTable();
        } else if (!this.table.equals(field.getTable())) {
            throw new IllegalArgumentException(field + " is not in table " + this.table.toString());
        }
        int index = this.fields.indexOf(field);
        if (index < 0) {
            throw new IllegalArgumentException(field + " not in field list");
        }
        this.values.set(index, value);
    }

    public boolean contains(SQLField field) {
        return this.fields.indexOf(field) >= 0;
    }

    public Object getValue(SQLField field) {
        int index = this.fields.indexOf(field);
        if (index < 0) {
            throw new IllegalArgumentException(field + " not in field list");
        }
        return this.values.get(index);
    }

    public String asString() {
        if (this.fields.isEmpty()) {
            throw new IllegalStateException("not fields added");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this.table.getSQLName());
        builder.append(" SET ");
        int stop = this.fields.size();
        int i = 0;
        while (i < stop) {
            SQLField field = this.fields.get(i);
            builder.append(field.getQuotedName());
            builder.append("=");
            Object value = this.values.get(i);
            Class<?> javaType = field.getType().getJavaType();
            Object str = value;
            if (value != null) {
                if (!javaType.isInstance(value)) {
                    str = SQLRowValues.convert(value.getClass(), value, javaType);
                }
                builder.append(field.getType().toString(str));
            } else {
                builder.append("null");
            }
            if (i < stop - 1) {
                builder.append(',');
            }
            ++i;
        }
        builder.append(" WHERE ");
        builder.append(this.where.getClause());
        return builder.toString();
    }

    public static long executeMultipleWithBatch(DBSystemRoot sysRoot, List<SQLUpdate> queries) throws SQLException {
        if (queries.isEmpty()) {
            throw new IllegalArgumentException("no updates");
        }
        ArrayList<String> l = new ArrayList<String>(queries.size());
        for (SQLUpdate i : queries) {
            l.add(i.asString());
        }
        return sysRoot.getDataSource().executeBatch(l, true).get0();
    }
}

