/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.model.SQLResultSet;

@Immutable
public class ListListHandlerGeneric<A>
implements ResultSetHandler {
    private final Class<A> arrayClass;
    private final List<Class<? extends A>> classes;

    public static ListListHandlerGeneric<Object> create(List<Class<?>> classes) {
        return ListListHandlerGeneric.create(Object.class, classes);
    }

    public static <A> ListListHandlerGeneric<A> create(Class<A> arrayClass, int colCount) {
        return ListListHandlerGeneric.create(arrayClass, Collections.nCopies(colCount, arrayClass));
    }

    public static <A> ListListHandlerGeneric<A> create(Class<A> arrayClass, List<Class<? extends A>> classes) {
        return new ListListHandlerGeneric<A>(arrayClass, classes);
    }

    public ListListHandlerGeneric(Class<A> arrayClass, List<Class<? extends A>> classes) {
        if (arrayClass == null) {
            throw new NullPointerException("Missing array component class");
        }
        this.arrayClass = arrayClass;
        this.classes = classes == null ? null : new ArrayList<Class<A>>(classes);
    }

    @Override
    public final List<List<A>> handle(ResultSet rs) throws SQLException {
        int cols = this.classes == null ? rs.getMetaData().getColumnCount() : this.classes.size();
        ArrayList<List<A>> result = new ArrayList<List<A>>();
        while (rs.next()) {
            ArrayList<A> array = new ArrayList<A>();
            int i = 0;
            while (i < cols) {
                if (this.classes == null) {
                    array.add(this.arrayClass.cast(rs.getObject(i + 1)));
                } else {
                    array.add(SQLResultSet.getValue(rs, this.classes.get(i), i + 1));
                }
                ++i;
            }
            result.add(array);
        }
        return result;
    }
}

