/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.convert;

import java.sql.SQLException;
import java.util.List;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.users.rights.UserRightSQLElement;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.SQLCreateTable;

public class AddUserRight
extends Changer<DBRoot> {
    public AddUserRight(DBSystemRoot b) {
        super(b);
    }

    @Override
    protected void changeImpl(DBRoot r) throws SQLException {
        this.getStream().println(r + "... ");
        UserManager userMngr = UserManager.getInstance();
        if (userMngr == null) {
            throw new IllegalStateException("No user manager");
        }
        SQLTable userT = userMngr.getTable();
        List<SQLCreateTable> createTables = UserRightSQLElement.getCreateTables(userT);
        if (createTables.size() == 0) {
            this.getStream().println("Tables already created");
        } else {
            r.createTables(createTables);
            this.getStream().println("Tables created");
        }
        AlterTable alterTable = new AlterTable(userT);
        String[] stringArray = new String[]{"SUPERUSER", "ADMIN"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            if (!userT.contains(f)) {
                alterTable.addColumn(f, "boolean not null default false");
            }
            ++n2;
        }
        if (!alterTable.isEmpty()) {
            this.getDS().execute(alterTable.toString());
            r.getSchema().updateVersion();
            this.getStream().println("Fields created in " + userT);
        }
    }
}

