/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.openconcerto.utils.DecimalUtils;

public class ConvertDevise {
    public static final BigDecimal getTtcFromHt(BigDecimal ht, BigDecimal taxe, int scale) {
        BigDecimal tauxB = taxe.movePointLeft(2).add(BigDecimal.ONE);
        BigDecimal result = ht.multiply(tauxB, DecimalUtils.HIGH_PRECISION).setScale(scale, RoundingMode.HALF_UP);
        return result;
    }

    public static final BigDecimal getHtFromTtc(BigDecimal ttc, BigDecimal taxe, int scale) {
        if (taxe.signum() == 0) {
            return ttc.setScale(scale, RoundingMode.HALF_UP);
        }
        BigDecimal tauxB = taxe.movePointLeft(2).add(BigDecimal.ONE);
        BigDecimal result = ttc.divide(tauxB, DecimalUtils.HIGH_PRECISION).setScale(scale, RoundingMode.HALF_UP);
        return result;
    }

    public static void main(String[] args) {
        BigDecimal ttcFromHt = ConvertDevise.getTtcFromHt(BigDecimal.ONE, new BigDecimal(20), 6);
        System.err.println(ttcFromHt);
        System.err.println(ConvertDevise.getHtFromTtc(ttcFromHt, new BigDecimal(20), 6));
    }
}

