/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.preferences;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.preferences.JavaPrefPreferencePanel;
import org.openconcerto.ui.preferences.PrefView;
import org.openconcerto.utils.Base64;
import org.openconcerto.utils.JImage;
import org.openconcerto.utils.PrefType;

public class PayPalPreferencePanel
extends JavaPrefPreferencePanel {
    public static final String PAYPAL_INVOICE = "paypal.invoice";
    public static final String PAYPAL_CLIENTID = "paypal.clientid";
    public static final String PAYPAL_SECRET = "paypal.secret";
    public static final String PAYPAL_INVOICE_X = "paypal.invoice.x";
    public static final String PAYPAL_INVOICE_Y = "paypal.invoice.y";

    public PayPalPreferencePanel() {
        super("Paypal", null);
        this.setPrefs(new SQLPreferences(((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete()));
        this.removeAll();
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.fill = 0;
        c.anchor = 17;
        JImage img = new JImage(PayPalPreferencePanel.class.getResource("logo_paypal_106x29.png"));
        try {
            img.setHyperLink(new URI("https://www.paypal.fr"));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.add((Component)img, c);
        ++c.gridy;
        c.fill = 2;
        c.gridwidth = 3;
        this.add((Component)new JLabel("Int\u00e9gration du lien de paiement PayPal dans les factures PDF"), c);
        ++c.gridy;
        this.add((Component)new JLabel("Cette fonctionnalit\u00e9 n\u00e9cessite la cr\u00e9ation d'un compte professionnel (gratuit)."), c);
        JButton b = new JButton("Cr\u00e9er votre compte maintenant");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Desktop.isDesktopSupported()) {
                    String url = "https://www.paypal.com/fr/merchantsignup/create";
                    try {
                        Desktop.getDesktop().browse(new URI("https://www.paypal.com/fr/merchantsignup/create"));
                    }
                    catch (IOException | URISyntaxException e1) {
                        JOptionPane.showMessageDialog(PayPalPreferencePanel.this, "https://www.paypal.com/fr/merchantsignup/create", "Erreur d'ouverture du navigateur", 2);
                    }
                }
            }
        });
        ++c.gridy;
        c.fill = 0;
        this.add((Component)b, c);
        ++c.gridy;
        this.add((Component)new JLabel(" "), c);
        ++c.gridy;
        this.add((Component)new JLabelBold("Param\u00e8tres de l'API"), c);
        ++c.gridy;
        this.add((Component)new JLabel("\u00e0 cr\u00e9er depuis https://developer.paypal.com"), c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Client ID", 4), c);
        c.gridwidth = 2;
        ++c.gridx;
        c.weightx = 1.0;
        final PrefView<String> clientIdPrefView = new PrefView<String>(PrefType.STRING_TYPE, "Client ID", PAYPAL_CLIENTID);
        this.addView(clientIdPrefView);
        this.add((Component)clientIdPrefView.getVW().getComp(), c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Secret", 4), c);
        c.gridwidth = 2;
        ++c.gridx;
        c.weightx = 1.0;
        final PrefView<String> secretPrefView = new PrefView<String>(PrefType.STRING_TYPE, "Secret", PAYPAL_SECRET);
        this.addView(secretPrefView);
        this.add((Component)secretPrefView.getVW().getComp(), c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        c.gridwidth = 3;
        c.weightx = 0.0;
        c.anchor = 13;
        JButton bVerify = new JButton("V\u00e9rifier les param\u00e8tres");
        this.add((Component)bVerify, c);
        c.gridx = 1;
        ++c.gridy;
        c.fill = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.anchor = 13;
        PrefView<Boolean> enabledPrefView = new PrefView<Boolean>(PrefType.BOOLEAN_TYPE, "int\u00e9gration", PAYPAL_INVOICE);
        this.addView(enabledPrefView);
        JComponent comp = enabledPrefView.getVW().getComp();
        ((JCheckBox)comp).setText("int\u00e9grer le lien de paiement dans les factures PDF");
        this.add((Component)comp, c);
        ++c.gridy;
        c.fill = 2;
        this.add((Component)new JLabel(" "), c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        this.add((Component)new JLabelBold("Position du logo sur le PDF"), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)new JLabel("X (0 - 440)", 4), c);
        ++c.gridx;
        PrefView<Integer> xPrefView = new PrefView<Integer>(PrefType.INT_TYPE, "X", PAYPAL_INVOICE_X);
        xPrefView.setDefaultValue(10);
        this.addView(xPrefView);
        this.add((Component)xPrefView.getVW().getComp(), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Y (0 - 780)", 4), c);
        ++c.gridx;
        PrefView<Integer> yPrefView = new PrefView<Integer>(PrefType.INT_TYPE, "Y", PAYPAL_INVOICE_Y);
        yPrefView.setDefaultValue(10);
        this.addView(yPrefView);
        this.add((Component)yPrefView.getVW().getComp(), c);
        ++c.gridy;
        c.weighty = 1.0;
        JPanel spacer = new JPanel();
        this.add((Component)spacer, c);
        bVerify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean ok = false;
                try {
                    ok = PayPalPreferencePanel.sendAuth((String)clientIdPrefView.getVW().getValue(), (String)secretPrefView.getVW().getValue());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                if (ok) {
                    JOptionPane.showMessageDialog(PayPalPreferencePanel.this, "Param\u00e8tres OK", "API Paypal", 1);
                } else {
                    JOptionPane.showMessageDialog(PayPalPreferencePanel.this, "Param\u00e8tres incorrects", "API Paypal", 0);
                }
            }
        });
    }

    @Override
    protected void addViews() {
    }

    public static void main(String[] args) throws IOException {
        String id = "Abb2mKqK0TSU6Jgf71CJjFx0u5x6_NmEzHduuvsCXjYCfYxRg9GZ7B6ptx3pijriuq9Apx9Jp-VTFveF";
        String s = "ENR1EyKreAlPbLRI0ofm2NbW6nyk8W5cJUZ7mvaBMgoQ6gB6VBivZpQW6B96toCtLZ3ClCUVutN-Gal2";
        PayPalPreferencePanel.sendAuth(id, String.valueOf(s));
    }

    static boolean sendAuth(String clientId, String secret) throws IOException {
        int numCharsRead;
        URL url = new URL("https://api.paypal.com/v1/oauth2/token");
        URLConnection con = url.openConnection();
        HttpURLConnection http = (HttpURLConnection)con;
        http.setRequestMethod("POST");
        http.setDoOutput(true);
        http.setDefaultUseCaches(false);
        String authString = String.valueOf(clientId) + ":" + secret;
        String authStringEnc = Base64.encodeBytes(authString.getBytes(), 8);
        con.setRequestProperty("Authorization", "Basic " + authStringEnc);
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("grant_type", "client_credentials");
        StringJoiner sj = new StringJoiner("&");
        for (Map.Entry entry : arguments.entrySet()) {
            sj.add(String.valueOf(URLEncoder.encode((String)entry.getKey(), "UTF-8")) + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8"));
        }
        byte[] out = sj.toString().getBytes(StandardCharsets.UTF_8);
        int length = out.length;
        http.setFixedLengthStreamingMode(length);
        http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        http.connect();
        Throwable throwable = null;
        Object var12_14 = null;
        try (OutputStream os = http.getOutputStream();){
            os.write(out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (http.getResponseCode() == 401) {
            return false;
        }
        InputStream is = http.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        char[] charArray = new char[1024];
        StringBuilder sb = new StringBuilder();
        while ((numCharsRead = isr.read(charArray)) > 0) {
            sb.append(charArray, 0, numCharsRead);
        }
        String result = sb.toString();
        return result.contains("access_token");
    }
}

