/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel.compta;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.panel.compta.AbstractExport;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.StringUtils;

public class ExportFEC
extends AbstractExport {
    public static final char ZONE_SEPARATOR = '\t';
    public static final char RECORD_SEPARATOR = '\n';
    public static final List<String> COLS = Arrays.asList("JournalCode", "JournalLib", "EcritureNum", "EcritureDate", "CompteNum", "CompteLib", "CompAuxNum", "CompAuxLib", "PieceRef", "PieceDate", "EcritureLib", "Debit", "Credit", "EcritureLet", "DateLet", "ValidDate", "Montantdevise", "Idevise");
    private final DecimalFormat format = new DecimalFormat("##0.00", DecimalFormatSymbols.getInstance(Locale.FRANCE));
    private List<Object[]> data;
    private final boolean cloture;

    public ExportFEC(DBRoot rootSociete, boolean cloture) {
        super(rootSociete, "FEC", ".csv");
        this.cloture = cloture;
    }

    @Override
    protected int fetchData(Date from, Date to, SQLRow selectedJournal, boolean onlyNew) {
        List l;
        SQLTable tableEcriture = this.getEcritureT();
        SQLTable tableMouvement = tableEcriture.getForeignTable("ID_MOUVEMENT");
        SQLTable tableCompte = tableEcriture.getForeignTable("ID_COMPTE_PCE");
        SQLTable tableJrnl = tableEcriture.getForeignTable("ID_JOURNAL");
        SQLTable tablePiece = tableMouvement.getForeignTable("ID_PIECE");
        SQLSelect sel = this.createSelect(from, to, selectedJournal, onlyNew);
        sel.addSelect(tableJrnl.getField("CODE"));
        sel.addSelect(tableJrnl.getField("NOM"));
        sel.addSelect(tableMouvement.getField("NUMERO"));
        sel.addSelect(tableEcriture.getField("DATE"));
        sel.addSelect(tableCompte.getField("NUMERO"));
        sel.addSelect(tableCompte.getField("NOM"));
        sel.addSelect(tablePiece.getField("NOM"));
        sel.addSelect(tableEcriture.getField("NOM"));
        sel.addSelect(tableEcriture.getField("DEBIT"));
        sel.addSelect(tableEcriture.getField("CREDIT"));
        sel.addSelect(tableEcriture.getField("DATE_LETTRAGE"));
        sel.addSelect(tableEcriture.getField("LETTRAGE"));
        sel.addSelect(tableEcriture.getField("DATE_VALIDE"));
        sel.addFieldOrder(tableEcriture.getField("DATE"));
        sel.addFieldOrder(tableMouvement.getField("NUMERO"));
        Where w = new Where((FieldRef)tableEcriture.getField("DEBIT"), "!=", tableEcriture.getField("CREDIT"));
        Where w2 = new Where((FieldRef)tableEcriture.getField("CLOTURE"), "!=", (Object)Boolean.TRUE);
        sel.setWhere(sel.getWhere().and(w).and(w2));
        this.data = l = (List)this.getRootSociete().getDBSystemRoot().getDataSource().execute(sel.asString(), new ArrayListHandler());
        return l == null ? 0 : l.size();
    }

    private final void addEmptyField(List<String> line) {
        line.add(null);
    }

    private final void addAmountField(List<String> line, Number cents) {
        String formattedAmount = this.format.format(BigDecimal.valueOf(cents.longValue()).movePointLeft(2));
        line.add(formattedAmount);
    }

    private final void addField(List<String> line, String s) {
        if (s == null) {
            throw new NullPointerException("Valeur manquante pour remplir la ligne : " + line);
        }
        String escapedString = this.strongEscape(s).trim();
        line.add(escapedString);
    }

    private final String strongEscape(String str) {
        if (str == null) {
            return "";
        }
        int length = str.length();
        StringBuilder b = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            char c = str.charAt(i);
            int newChar = c > '\u001f' && c < '~' && c != ';' ? (int)c : (c == '\u00e9' || c == '\u00e8' || c == '\u00ea' ? 101 : (c == '\u00e2' || c == '\u00e0' ? 97 : (c == '\u00ee' ? 105 : (c == '\u00f9' || c == '\u00fb' ? 117 : (c == '\u00f4' ? 111 : (c == '\u00e7' ? 99 : 32))))));
            b.append((char)newChar);
            ++i;
        }
        return b.toString();
    }

    @Override
    protected void export(OutputStream out) throws IOException {
        OutputStreamWriter bufOut = new OutputStreamWriter(out, StringUtils.ISO8859_15);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        int fieldsCount = COLS.size();
        for (String colName : COLS) {
            bufOut.write(colName);
            ((Writer)bufOut).write(9);
        }
        ((Writer)bufOut).write(10);
        ArrayList<String> line = new ArrayList<String>(fieldsCount);
        for (Object[] array : this.data) {
            line.clear();
            this.addField(line, (String)array[0]);
            this.addField(line, (String)array[1]);
            this.addField(line, String.valueOf(array[2]));
            String ecritureDate = dateFormat.format(array[3]);
            line.add(ecritureDate);
            if (array[4] == null) {
                ((Writer)bufOut).close();
                JOptionPane.showMessageDialog(new JFrame(), "Une \u00e9criture n'a pas de num\u00e9ro de compte :\n" + line, "Erreur FEC", 0);
                return;
            }
            this.addField(line, (String)array[4]);
            if (array[5] == null) {
                ((Writer)bufOut).close();
                JOptionPane.showMessageDialog(new JFrame(), "Une \u00e9criture n'a pas de libell\u00e9 de compte pour le compte " + array[4].toString() + " :\n" + line, "Erreur FEC", 0);
                return;
            }
            this.addField(line, (String)array[5]);
            this.addEmptyField(line);
            this.addEmptyField(line);
            this.addField(line, (String)array[6]);
            line.add(ecritureDate);
            String s = (String)array[7];
            if (s == null || s.trim().length() == 0) {
                s = "Sans libell\u00e9";
            }
            this.addField(line, s);
            this.addAmountField(line, (Number)array[8]);
            this.addAmountField(line, (Number)array[9]);
            this.addField(line, (String)array[11]);
            if (array[10] != null) {
                String ecritureDateLettrage = dateFormat.format(array[10]);
                line.add(ecritureDateLettrage);
            } else {
                line.add("");
            }
            if (array[12] != null) {
                String ecritureDateValid = dateFormat.format(array[12]);
                line.add(ecritureDateValid);
            } else {
                line.add("");
                if (this.cloture) {
                    ((Writer)bufOut).close();
                    JOptionPane.showMessageDialog(new JFrame(), "Une \u00e9criture n'est pas valid\u00e9e (pas de date):\n" + line, "Erreur FEC", 0);
                    return;
                }
            }
            this.addAmountField(line, ((Number)array[8]).longValue() + ((Number)array[9]).longValue());
            line.add("EUR");
            assert (line.size() == fieldsCount);
            int i = 0;
            while (i < fieldsCount) {
                String zone = (String)line.get(i);
                if (zone != null) {
                    bufOut.write(zone);
                }
                ((Writer)bufOut).write(9);
                ++i;
            }
            ((Writer)bufOut).write(10);
        }
        ((Writer)bufOut).close();
    }
}

