/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.model;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.List;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.generationDoc.A4;
import org.openconcerto.erp.generationDoc.AbstractSheetXml;
import org.openconcerto.erp.generationDoc.ProgressPrintingFrame;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.IListe;

public class PrintDocumentAction
extends AbstractAction {
    private MouseSheetXmlListeListener mouseSheetXmlListeListener;
    private static final double POINTS_PER_INCH = 72.0;

    public PrintDocumentAction(MouseSheetXmlListeListener mouseSheetXmlListeListener) {
        this.mouseSheetXmlListeListener = mouseSheetXmlListeListener;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        IListe ilist = IListe.get(ev);
        SQLRow asRow = IListe.get(ev).getSelectedRow().asRow();
        AbstractSheetXml firstSheet = this.mouseSheetXmlListeListener.createAbstractSheet(asRow);
        String printerName = firstSheet.getPrinter();
        final PrinterJob printJob = PrinterJob.getPrinterJob();
        PrintService myService = null;
        if (printerName != null && printerName.trim().length() > 0) {
            PrintService[] services = PrinterJob.lookupPrintServices();
            int i = 0;
            while (i < services.length) {
                if (services[i].getName().equals(printerName)) {
                    myService = services[i];
                    break;
                }
                ++i;
            }
            if (myService != null) {
                try {
                    System.err.println("MouseSheetXmlListeListener.getRowActions() set printer : " + printerName);
                    printJob.setPrintService(myService);
                }
                catch (PrinterException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Imprimante non compatible");
                    return;
                }
            }
        }
        HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
        MediaSizeName media = MediaSizeName.ISO_A4;
        attributes.add(media);
        A4 paper = new A4(0.0f, 0.0f);
        MediaPrintableArea printableArea = new MediaPrintableArea((float)(paper.getImageableX() / 72.0), (float)(paper.getImageableY() / 72.0), (float)(paper.getImageableWidth() / 72.0), (float)(paper.getImageableHeight() / 72.0), 25400);
        attributes.add(printableArea);
        attributes.add(new Copies(1));
        boolean okToPrint = printJob.printDialog(attributes);
        Attribute attribute = attributes.get(Copies.class);
        if (attribute != null) {
            Copies attributeCopies = (Copies)attribute;
            int value = attributeCopies.getValue();
            printJob.setCopies(value);
        } else {
            printJob.setCopies(1);
        }
        if (okToPrint) {
            Window w = SwingUtilities.getWindowAncestor(ilist);
            final ProgressPrintingFrame pFrame = new ProgressPrintingFrame(w, printJob, "Impression", "Impression en cours", 300);
            final List<SQLRowValues> rows = IListe.get(ev).getSelectedRows();
            Thread thread = new Thread(){

                @Override
                public void run() {
                    final int size = rows.size();
                    int i = 0;
                    while (i < size) {
                        final int index = i;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                pFrame.setMessage("Document " + (index + 1) + "/" + size);
                                pFrame.setProgress(100 * (index + 1) / size);
                            }
                        });
                        if (!pFrame.isCancelled()) {
                            SQLRowValues r = (SQLRowValues)rows.get(i);
                            AbstractSheetXml sheet = PrintDocumentAction.this.mouseSheetXmlListeListener.createAbstractSheet(r.asRow());
                            sheet.printDocument(printJob);
                        }
                        ++i;
                    }
                }
            };
            thread.setPriority(1);
            thread.setDaemon(true);
            pFrame.setLocationRelativeTo(ilist);
            pFrame.setVisible(true);
            thread.start();
        }
    }
}

