/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLField;

public class ImportModel
extends AbstractTableModel {
    private Vector champs = new Vector();
    private Map longueur = new HashMap();
    private String[] titres = new String[2];

    public ImportModel(List l) {
        this.titres[0] = "Champs";
        this.titres[1] = "Longueur";
        this.champs.addAll(l);
    }

    @Override
    public int getRowCount() {
        return this.champs.size();
    }

    @Override
    public int getColumnCount() {
        return this.titres.length;
    }

    public Class getColumnClass(int c) {
        if (c == 0) {
            return String.class;
        }
        return Integer.class;
    }

    @Override
    public String getColumnName(int col) {
        return this.titres[col];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.longueur.put(this.champs.get(rowIndex), aValue);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return Configuration.getInstance().getTranslator().getTitleFor((SQLField)this.champs.get(rowIndex));
        }
        if (columnIndex == 1) {
            return this.longueur.get(this.champs.get(rowIndex));
        }
        return null;
    }

    public int getLongueur(SQLField f) {
        Integer val = (Integer)this.longueur.get(f);
        if (val == null) {
            return 0;
        }
        return val;
    }

    public int upField(int row) {
        if (row > 0) {
            SQLField tmp = (SQLField)this.champs.get(row);
            this.champs.set(row, this.champs.get(row - 1));
            this.champs.set(row - 1, tmp);
            this.fireTableDataChanged();
            return row - 1;
        }
        return row;
    }

    public int downField(int row) {
        if (row < this.getRowCount() - 1) {
            SQLField tmp = (SQLField)this.champs.get(row);
            this.champs.set(row, this.champs.get(row + 1));
            this.champs.set(row + 1, tmp);
            this.fireTableDataChanged();
            return row + 1;
        }
        return row;
    }

    public int getLongueur(int row) {
        Integer val = (Integer)this.getValueAt(row, 1);
        if (val == null) {
            return 0;
        }
        return val;
    }

    public Class getClassForIndex(int row) {
        SQLField f = (SQLField)this.champs.get(row);
        return f.getType().getJavaType();
    }

    public SQLField getFieldForIndex(int row) {
        return (SQLField)this.champs.get(row);
    }

    public String getFieldNameForIndex(int row) {
        SQLField f = (SQLField)this.champs.get(row);
        return f.getName();
    }

    public String getTableNameForIndex(int row) {
        SQLField f = (SQLField)this.champs.get(row);
        return f.getTable().getName();
    }

    public int[] getDelimiteur() {
        int[] delim = new int[this.getRowCount()];
        int i = 0;
        while (i < this.getRowCount()) {
            delim[i] = this.getLongueur(i);
            ++i;
        }
        return delim;
    }
}

