/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.generationEcritures.provider.AccountingRecordsProvider;
import org.openconcerto.erp.generationEcritures.provider.AccountingRecordsProviderManager;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class GenerationMvtSaisieKm
extends GenerationEcritures {
    private int idSaisieKm;
    private static final String source = "SAISIE_KM";
    public static final String ID = "accounting.records.km";

    public GenerationMvtSaisieKm(int idSaisieKm) {
        this.idSaisieKm = idSaisieKm;
    }

    public int genereMouvement() throws SQLException {
        String labelSaisie;
        SQLTable table = base.getTable(source);
        SQLRow saisieRow = table.getRow(this.idSaisieKm);
        this.date = (Date)saisieRow.getObject("DATE");
        this.nom = labelSaisie = saisieRow.getObject("NOM").toString();
        this.putValue("DATE", this.date);
        this.putValue("NOM", this.nom);
        this.putValue("ID_JOURNAL", saisieRow.getObject("ID_JOURNAL"));
        this.putValue("ID_MOUVEMENT", new Integer(1));
        AccountingRecordsProvider provider = AccountingRecordsProviderManager.get(ID);
        SQLRowValues rowValsPiece = new SQLRowValues(pieceTable);
        rowValsPiece.put("NOM", labelSaisie.length() == 0 ? "Saisie au km " : labelSaisie);
        if (provider != null) {
            provider.putPieceLabel(saisieRow, rowValsPiece);
        }
        this.getNewMouvement(source, this.idSaisieKm, 1, rowValsPiece);
        SQLTable tableElt = Configuration.getInstance().getRoot().findTable("SAISIE_KM_ELEMENT");
        Collection set = saisieRow.getReferentRows(tableElt);
        SQLTable tableAssoc = Configuration.getInstance().getRoot().findTable("ASSOCIATION_ANALYTIQUE");
        for (SQLRow rowElement : set) {
            SQLRow rowEcr;
            int idCpt = ComptePCESQLElement.getId(rowElement.getString("NUMERO"), rowElement.getString("NOM"));
            this.putValue("ID_COMPTE_PCE", new Integer(idCpt));
            this.putValue("NOM", rowElement.getString("NOM_ECRITURE"));
            this.putValue("DEBIT", rowElement.getObject("DEBIT"));
            this.putValue("CREDIT", rowElement.getObject("CREDIT"));
            if (tableElt.contains("NOM_PIECE")) {
                this.putValue("NOM_PIECE", rowElement.getObject("NOM_PIECE"));
            }
            if ((rowEcr = this.ajoutEcriture()) == null || rowEcr.isUndefined()) continue;
            SQLRowValues vals = rowElement.createEmptyUpdateRow();
            vals.put("ID_ECRITURE", rowEcr.getID());
            vals.update();
        }
        return this.idMvt;
    }
}

