/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.core.sales.product.model.ProductComponent;
import org.openconcerto.erp.core.sales.product.model.ProductHelper;
import org.openconcerto.erp.core.supplychain.stock.element.ComposedItemStockUpdater;
import org.openconcerto.erp.core.supplychain.stock.element.StockItem;
import org.openconcerto.erp.core.supplychain.stock.element.StockLabel;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.Tuple3;
import org.openconcerto.utils.cc.ITransformer;

public class StockItemsUpdater {
    private final StockLabel label;
    private final List<? extends SQLRowAccessor> items;
    private final TypeStockUpdate type;
    private final boolean createMouvementStock;
    private final SQLRowAccessor rowSource;
    private boolean resetStockTH = false;
    private boolean headless = false;
    List<Tuple3<SQLRowAccessor, Integer, BigDecimal>> reliquat = new ArrayList<Tuple3<SQLRowAccessor, Integer, BigDecimal>>();
    List<String> requests = new ArrayList<String>();

    public StockItemsUpdater(StockLabel label, SQLRowAccessor rowSource, List<? extends SQLRowAccessor> items, TypeStockUpdate t) {
        this(label, rowSource, items, t, true);
    }

    public StockItemsUpdater(StockLabel label, SQLRowAccessor rowSource, List<? extends SQLRowAccessor> items, TypeStockUpdate t, boolean createMouvementStock) {
        this.label = label;
        this.items = items;
        this.type = t;
        this.createMouvementStock = createMouvementStock;
        this.rowSource = rowSource;
        this.headless = GraphicsEnvironment.isHeadless();
    }

    public void setHeadless(boolean headless) {
        this.headless = headless;
    }

    public void addReliquat(SQLRowAccessor article, int qte, BigDecimal qteUnit) {
        this.reliquat.add(Tuple3.create(article, qte, qteUnit));
    }

    public void update() throws SQLException {
        final SQLTable stockTable = this.rowSource.getTable().getTable("STOCK");
        if (this.createMouvementStock) {
            this.clearExistingMvt(this.rowSource);
        }
        List<StockItem> stockItems = this.fetch();
        ListMap<SQLRow, SQLRowValues> cmd = new ListMap<SQLRow, SQLRowValues>();
        for (StockItem stockItem : stockItems) {
            if (stockItem.isStockInit()) {
                this.requests.add(stockItem.getUpdateRequest());
            } else {
                SQLRowValues rowVals = new SQLRowValues(stockTable);
                rowVals.put("QTE_REEL", stockItem.getRealQty());
                rowVals.put("QTE_TH", stockItem.getVirtualQty());
                rowVals.put("QTE_LIV_ATTENTE", stockItem.getDeliverQty());
                rowVals.put("QTE_RECEPT_ATTENTE", stockItem.getReceiptQty());
                rowVals.put("ID_ARTICLE", stockItem.getArticle().getID());
                rowVals.put("ID_DEPOT_STOCK", stockItem.stock.getForeignID("ID_DEPOT_STOCK"));
                rowVals.commit();
                if (stockItem.getArticle().getForeignID("ID_DEPOT_STOCK") == stockItem.stock.getForeignID("ID_DEPOT_STOCK")) {
                    SQLRowValues rowValsArt = stockItem.getArticle().createEmptyUpdateRow();
                    rowValsArt.put("ID_STOCK", (Object)rowVals);
                    rowValsArt.commit();
                }
            }
            if (this.type.isEntry()) continue;
            stockItem.fillCommandeFournisseur(cmd);
        }
        final ArrayList<Object> handlers = new ArrayList<Object>(this.requests.size());
        for (String s : this.requests) {
            handlers.add(null);
        }
        try {
            SQLUtils.executeAtomic(stockTable.getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, IOException>(){

                @Override
                public Object handle(SQLDataSource ds) throws SQLException, IOException {
                    SQLUtils.executeMultiple(stockTable.getDBSystemRoot(), StockItemsUpdater.this.requests, handlers);
                    stockTable.fire(new SQLTableEvent(stockTable, -1, SQLTableEvent.Mode.ROW_UPDATED));
                    return null;
                }
            });
        }
        catch (IOException e) {
            ExceptionHandler.handle("Erreur de la mise \u00e0 jour des stocks!", e);
        }
        DBRoot root = this.rowSource.getTable().getDBRoot();
        if (root.contains("ARTICLE_ELEMENT")) {
            ComposedItemStockUpdater comp = new ComposedItemStockUpdater(root, stockItems);
            comp.update();
        }
        if (!this.headless && cmd.size() > 0) {
            String msg = "Les articles suivants sont inf\u00e9rieurs au stock minimum : \n";
            for (SQLRow row : cmd.keySet()) {
                for (SQLRowValues rowVals : (List)cmd.get(row)) {
                    msg = String.valueOf(msg) + rowVals.getString("CODE") + " " + rowVals.getString("NOM") + "\n";
                }
            }
            final String msgFinal = msg;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, msgFinal, "Alerte de stock minimum", 2);
                }
            });
        }
    }

    private void clearExistingMvt(SQLRowAccessor rowSource) throws RTInterruptedException, SQLException {
        ArrayList<String> multipleRequests = new ArrayList<String>();
        final SQLTable table = this.rowSource.getTable().getTable("MOUVEMENT_STOCK");
        SQLRowValues rowVals = new SQLRowValues(table);
        rowVals.put("QTE", null);
        rowVals.put("REEL", null);
        SQLRowValues rowValsArt = new SQLRowValues(this.rowSource.getTable().getTable("ARTICLE"));
        SQLRowValues rowValsStock = new SQLRowValues(this.rowSource.getTable().getTable("STOCK"));
        rowValsStock.put("QTE_REEL", null);
        rowValsStock.put("QTE_TH", null);
        rowValsStock.put("QTE_RECEPT_ATTENTE", null);
        rowValsStock.put("QTE_LIV_ATTENTE", null);
        rowVals.put("ID_STOCK", (Object)rowValsStock);
        rowVals.put("ID_ARTICLE", (Object)rowValsArt);
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowVals);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                Where w = new Where((FieldRef)table.getField("SOURCE"), "=", (Object)StockItemsUpdater.this.rowSource.getTable().getName());
                w = w.and(new Where((FieldRef)table.getField("IDSOURCE"), "=", StockItemsUpdater.this.rowSource.getID()));
                input.setWhere(w);
                return input;
            }
        });
        HashMap<Number, StockItem> items = new HashMap<Number, StockItem>();
        List<SQLRowValues> result = fetcher.fetch();
        for (SQLRowValues sqlRowValues : result) {
            StockItem item;
            if (!items.containsKey(sqlRowValues.getForeignIDNumber("ID_STOCK"))) {
                item = new StockItem(sqlRowValues.getForeign("ID_ARTICLE"), sqlRowValues.getForeign("ID_STOCK"));
                items.put(sqlRowValues.getForeignIDNumber("ID_STOCK"), item);
            } else {
                item = (StockItem)items.get(sqlRowValues.getForeignIDNumber("ID_STOCK"));
            }
            StockItem.TypeStockMouvement t = sqlRowValues.getBoolean("REEL") != false ? StockItem.TypeStockMouvement.REEL : StockItem.TypeStockMouvement.THEORIQUE;
            item.updateQty(sqlRowValues.getFloat("QTE"), t, true);
            String req = "UPDATE " + sqlRowValues.getTable().getSQLName().quote() + " SET \"ARCHIVE\"=1 WHERE \"ID\"=" + sqlRowValues.getID();
            multipleRequests.add(req);
            multipleRequests.add(item.getUpdateRequest());
        }
        ArrayList<Object> handlers = new ArrayList<Object>(multipleRequests.size());
        for (String s : multipleRequests) {
            handlers.add(null);
        }
        SQLUtils.executeMultiple(table.getDBSystemRoot(), multipleRequests, handlers);
    }

    private List<StockItem> fetch() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<Integer, StockItem> stockItems = new HashMap<Integer, StockItem>();
        String mvtStockTableQuoted = this.rowSource.getTable().getTable("MOUVEMENT_STOCK").getSQLName().quote();
        ProductHelper helper = new ProductHelper(this.rowSource.getTable().getDBRoot());
        ArrayList<ProductComponent> productComponents = new ArrayList<ProductComponent>();
        helper.fillProductComponent(this.items, productComponents, 1, 0, 1);
        List<ProductComponent> boms = helper.getChildWithQtyFrom(productComponents);
        for (ProductComponent productComp : boms) {
            StockItem stockItem;
            if (!productComp.getProduct().getBoolean("GESTION_STOCK").booleanValue() || productComp.getQty().signum() == 0) continue;
            if (!stockItems.containsKey(productComp.getStock().getID())) {
                stockItem = new StockItem(productComp.getProduct(), productComp.getStock());
                stockItems.put(productComp.getStock().getID(), stockItem);
            } else {
                stockItem = (StockItem)stockItems.get(productComp.getStock().getID());
            }
            double qteFinal = productComp.getQty().doubleValue();
            for (Tuple3<SQLRowAccessor, Integer, BigDecimal> t : this.reliquat) {
                if (stockItem.getArticle() == null || !stockItem.getArticle().equalsAsRow((SQLRowAccessor)t.get0())) continue;
                double qteFinalReliquat = t.get2().multiply(new BigDecimal((Integer)t.get1()), DecimalUtils.HIGH_PRECISION).doubleValue();
                qteFinal -= qteFinalReliquat;
            }
            if (!this.type.isEntry()) {
                qteFinal = -qteFinal;
            }
            stockItem.updateQty(qteFinal, this.type.getType());
            if (!this.createMouvementStock) continue;
            Date time = this.rowSource.getDate("DATE").getTime();
            BigDecimal prc = productComp.getPRC(time);
            if (this.type.getType() == StockItem.TypeStockMouvement.REEL || this.type.getType() == StockItem.TypeStockMouvement.REEL_THEORIQUE || this.type.getType() == StockItem.TypeStockMouvement.RETOUR) {
                String mvtStockQuery = "INSERT INTO " + mvtStockTableQuoted + " (\"QTE\",\"DATE\",\"ID_ARTICLE\",\"ID_STOCK\",\"SOURCE\",\"IDSOURCE\",\"NOM\",\"REEL\",\"ORDRE\"";
                if (prc != null) {
                    mvtStockQuery = String.valueOf(mvtStockQuery) + ",\"PRICE\"";
                }
                mvtStockQuery = String.valueOf(mvtStockQuery) + ") VALUES(" + qteFinal + ",'" + dateFormat.format(time) + "'," + productComp.getProduct().getID() + "," + productComp.getStock().getID() + ",'" + this.rowSource.getTable().getName() + "'," + this.rowSource.getID() + ",'" + this.label.getLabel(this.rowSource, productComp.getProduct()) + "',true, (SELECT (MAX(\"ORDRE\")+1) FROM " + mvtStockTableQuoted + ")";
                if (prc != null) {
                    mvtStockQuery = String.valueOf(mvtStockQuery) + "," + prc.setScale(6, RoundingMode.HALF_UP).toString();
                }
                mvtStockQuery = String.valueOf(mvtStockQuery) + ")";
                this.requests.add(mvtStockQuery);
            }
            if (this.type.getType() != StockItem.TypeStockMouvement.THEORIQUE && this.type.getType() != StockItem.TypeStockMouvement.REEL_THEORIQUE && this.type.getType() != StockItem.TypeStockMouvement.RETOUR) continue;
            String mvtStockQuery = "INSERT INTO " + mvtStockTableQuoted + " (\"QTE\",\"DATE\",\"ID_ARTICLE\",\"ID_STOCK\",\"SOURCE\",\"IDSOURCE\",\"NOM\",\"REEL\",\"ORDRE\"";
            if (prc != null) {
                mvtStockQuery = String.valueOf(mvtStockQuery) + ",\"PRICE\"";
            }
            mvtStockQuery = String.valueOf(mvtStockQuery) + ") VALUES(" + qteFinal + ",'" + dateFormat.format(time) + "'," + productComp.getProduct().getID() + "," + productComp.getStock().getID() + ",'" + this.rowSource.getTable().getName() + "'," + this.rowSource.getID() + ",'" + this.label.getLabel(this.rowSource, productComp.getProduct()) + "',false, (SELECT (MAX(\"ORDRE\")+1) FROM " + mvtStockTableQuoted + ")";
            if (prc != null) {
                mvtStockQuery = String.valueOf(mvtStockQuery) + "," + prc.setScale(6, RoundingMode.HALF_UP).toString();
            }
            mvtStockQuery = String.valueOf(mvtStockQuery) + ")";
            this.requests.add(mvtStockQuery);
        }
        return new ArrayList<StockItem>(stockItems.values());
    }

    public void setResetStockTH(boolean resetStockTH) {
        this.resetStockTH = resetStockTH;
    }

    public static enum TypeStockUpdate {
        VIRTUAL_RECEPT(true, StockItem.TypeStockMouvement.THEORIQUE),
        REAL_RECEPT(true, StockItem.TypeStockMouvement.REEL),
        VIRTUAL_DELIVER(false, StockItem.TypeStockMouvement.THEORIQUE),
        REAL_DELIVER(false, StockItem.TypeStockMouvement.REEL),
        REAL_VIRTUAL_RECEPT(true, StockItem.TypeStockMouvement.REEL_THEORIQUE),
        RETOUR_AVOIR_CLIENT(true, StockItem.TypeStockMouvement.RETOUR),
        REAL_VIRTUAL_DELIVER(false, StockItem.TypeStockMouvement.REEL_THEORIQUE);

        private final boolean entry;
        private final StockItem.TypeStockMouvement type;

        private TypeStockUpdate(boolean entry, StockItem.TypeStockMouvement type) {
            this.entry = entry;
            this.type = type;
        }

        public boolean isEntry() {
            return this.entry;
        }

        public StockItem.TypeStockMouvement getType() {
            return this.type;
        }
    }
}

