/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.core.finance.accounting.ui.AnalytiqueItemTable;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.GestionDevise;

public class AssociationAnalytiquePanel
extends JPanel {
    public AssociationAnalytiquePanel(final SQLRowAccessor rowEcr) {
        super(new GridBagLayout());
        long debit = rowEcr.getObject("DEBIT") == null ? 0L : rowEcr.getLong("DEBIT");
        long credit = rowEcr.getObject("CREDIT") == null ? 0L : rowEcr.getLong("CREDIT");
        final long solde = debit - credit;
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        final AnalytiqueItemTable table = new AnalytiqueItemTable(false);
        SQLRequestComboBox box = new SQLRequestComboBox();
        box.uiInit(Configuration.getInstance().getDirectory().getElement("ECRITURE").getComboRequest());
        box.setEnabled(false);
        box.setValue(rowEcr);
        c.weightx = 0.0;
        this.add((Component)new JLabel("Ecriture associ\u00e9e"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.add((Component)box, c);
        c.gridwidth = 2;
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)table, c);
        final JLabelBold labelTotal = new JLabelBold("Total r\u00e9parti : 0/" + solde);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 1;
        c.anchor = 13;
        this.add((Component)labelTotal, c);
        table.insertFrom(rowEcr);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 1;
        c.anchor = 13;
        final JButton buttonApply = new JButton("Enregistrer les modifications");
        JButton buttonClose = new JButton("Annuler");
        JPanel panelButton = new JPanel();
        panelButton.add(buttonApply);
        panelButton.add(buttonClose);
        this.add((Component)panelButton, c);
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(AssociationAnalytiquePanel.this)).dispose();
            }
        });
        buttonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.updateField("ID_ECRITURE", rowEcr.getID());
                ((JFrame)SwingUtilities.getRoot(AssociationAnalytiquePanel.this)).dispose();
            }
        });
        final RowValuesTableModel model = table.getModel();
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int count = model.getRowCount();
                long soldeRows = 0L;
                int i = 0;
                while (i < count) {
                    SQLRowValues rowVals = model.getRowValuesAt(i);
                    soldeRows += rowVals.getLong("MONTANT");
                    ++i;
                }
                long montantRestant = solde - soldeRows;
                if (solde != 0L) {
                    table.getDefaultRowValues().put("MONTANT", montantRestant);
                    BigDecimal pourcent = new BigDecimal(montantRestant).divide(new BigDecimal(solde), DecimalUtils.HIGH_PRECISION).abs().movePointRight(2).setScale(4, RoundingMode.HALF_UP);
                    table.getDefaultRowValues().put("POURCENT", pourcent);
                } else {
                    table.getDefaultRowValues().put("POURCENT", BigDecimal.ZERO);
                }
                buttonApply.setEnabled(soldeRows == solde);
                if (!buttonApply.isEnabled()) {
                    buttonApply.setToolTipText("La r\u00e9partition analytique de l'\u00e9criture n'est pas totale!");
                } else {
                    buttonApply.setToolTipText(null);
                }
                labelTotal.setText("R\u00e9partition totale : " + GestionDevise.currencyToString(soldeRows) + "/" + GestionDevise.currencyToString(solde));
            }
        });
    }
}

