/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.action;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.DefaultMenuConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.config.Log;
import org.openconcerto.erp.config.MainFrame;
import org.openconcerto.erp.config.MenuManager;
import org.openconcerto.erp.config.MinimalMenuConfiguration;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.common.ui.StatusPanel;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.humanresources.payroll.element.CaisseCotisationSQLElement;
import org.openconcerto.erp.element.objet.ClasseCompte;
import org.openconcerto.erp.modules.ModuleFrame;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.erp.panel.ComptaTipsFrame;
import org.openconcerto.erp.preferences.GestionClientPreferencePanel;
import org.openconcerto.erp.rights.DepotStockViewRightEditor;
import org.openconcerto.erp.rights.GroupUIComboRightEditor;
import org.openconcerto.erp.rights.MenuComboRightEditor;
import org.openconcerto.erp.utils.NXDatabaseAccessor;
import org.openconcerto.map.model.Ville;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.preferences.UserProps;
import org.openconcerto.sql.sqlobject.IComboSelectionItem;
import org.openconcerto.sql.ui.ConnexionPanel;
import org.openconcerto.sql.users.User;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.users.rights.SQLTableRightEditor;
import org.openconcerto.sql.users.rights.UserRights;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.task.config.ComptaBasePropsConfiguration;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.component.MutableListComboPopupListener;
import org.openconcerto.ui.preferences.EmailProps;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.JImage;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.i18n.TranslationManager;

public class NouvelleConnexionAction
extends CreateFrameAbstractAction {
    private final ComptaPropsConfiguration conf;
    private ConnexionPanel connexionPanel;

    public NouvelleConnexionAction(ComptaPropsConfiguration conf) {
        this.conf = conf;
        this.putValue("Name", "Changer d'utilisateur");
    }

    @Override
    public JFrame createFrame() {
        assert (SwingUtilities.isEventDispatchThread());
        final ComptaPropsConfiguration comptaPropsConfiguration = this.conf;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    int selectedSociete;
                    Boolean booleanValue = UserProps.getInstance().getBooleanValue("HideTips");
                    if (!booleanValue.booleanValue()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ComptaTipsFrame.getFrame(true).setVisible(true);
                            }
                        });
                    }
                    if (NouvelleConnexionAction.this.connexionPanel != null && !Gestion.isMinimalMode()) {
                        selectedSociete = NouvelleConnexionAction.this.connexionPanel.getSelectedSociete();
                    } else {
                        selectedSociete = UserProps.getInstance().getLastSocieteID();
                        if (selectedSociete < 0) {
                            SQLElement elem = comptaPropsConfiguration.getDirectory().getElement(comptaPropsConfiguration.getRoot().getTable("SOCIETE_COMMON"));
                            List<IComboSelectionItem> comboItems = elem.getComboRequest().getComboItems();
                            if (comboItems.size() > 0) {
                                selectedSociete = comboItems.get(0).getId();
                            } else {
                                throw new IllegalStateException("No " + elem + " found");
                            }
                        }
                    }
                    comptaPropsConfiguration.setUpSocieteDataBaseConnexion(selectedSociete);
                    comptaPropsConfiguration.setupBarCodeIfNeeded();
                    File fMail2 = new File(comptaPropsConfiguration.getConfDir(), "Email" + selectedSociete + ".properties");
                    EmailProps.getInstance().setPropsFileName(fMail2.toString());
                    UserRightsManager.getInstance().addRightForAdmins(new UserRightsManager.RightTuple("moduleDBAdmin", true));
                    UserRightsManager.getInstance().addRightForAdmins(new UserRightsManager.RightTuple("BACKUP", true));
                    final ModuleManager moduleMngr = comptaPropsConfiguration.getModuleManager();
                    try {
                        moduleMngr.init();
                    }
                    catch (Throwable e) {
                        NouvelleConnexionAction.this.openEmergencyModuleManager(moduleMngr, "Impossible de configurer les modules requis", e);
                        return;
                    }
                    MenuManager.setInstance((Gestion.isMinimalMode() ? new MinimalMenuConfiguration(comptaPropsConfiguration) : new DefaultMenuConfiguration(comptaPropsConfiguration)).createMenuAndActions());
                    User user = UserManager.getInstance().getCurrentUser();
                    final UserRights rights = UserRightsManager.getCurrentUserRights();
                    int userId = user.getId();
                    if (!rights.haveRight("ACCES_ALL_SOCIETE")) {
                        boolean accessGranted;
                        SQLTable tableAcces = comptaPropsConfiguration.getRoot().findTable("ACCES_SOCIETE");
                        SQLSelect sel = new SQLSelect();
                        sel.addSelectStar(tableAcces);
                        sel.setWhere(new Where((FieldRef)tableAcces.getField("ID_USER_COMMON"), "=", userId));
                        List<SQLRow> accessRows = SQLRowListRSH.execute(sel);
                        if (accessRows.size() == 0) {
                            accessGranted = true;
                        } else {
                            boolean tmp = false;
                            for (SQLRow r : accessRows) {
                                if (r.getInt("ID_SOCIETE_COMMON") != selectedSociete) continue;
                                tmp = true;
                                break;
                            }
                            accessGranted = tmp;
                        }
                        if (!accessGranted) {
                            JOptionPane.showMessageDialog(null, "Vous n'avez pas les droits suffisants, pour acc\u00e9der \u00e0 cette soci\u00e9t\u00e9!");
                            return;
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MenuComboRightEditor.register();
                            GroupUIComboRightEditor.register();
                            SQLTableRightEditor.register();
                            DepotStockViewRightEditor.register();
                            MutableListComboPopupListener.setLockOverridable(rights.isSuperUser());
                            StatusPanel.getInstance().fireStatusChanged();
                            MainFrame f = new MainFrame(comptaPropsConfiguration);
                            String version = comptaPropsConfiguration.getVersion();
                            String socTitle = comptaPropsConfiguration.getRowSociete() == null ? "" : ", [Soci\u00e9t\u00e9 " + comptaPropsConfiguration.getRowSociete().getString("NOM") + "]";
                            f.setTitle(String.valueOf(comptaPropsConfiguration.getAppName()) + " " + version + socTitle);
                            f.setDefaultCloseOperation(0);
                        }
                    });
                    final FutureTask<Object> showMainFrame = new FutureTask<Object>(new Runnable(){

                        @Override
                        public void run() {
                            if (moduleMngr.isInited()) {
                                MainFrame mainFrame = MainFrame.getInstance();
                                mainFrame.initMenuBar();
                                FrameUtil.show(mainFrame);
                            }
                        }
                    }, null);
                    moduleMngr.invoke(new IClosure<ModuleManager>(){

                        @Override
                        public void executeChecked(ModuleManager input) {
                            try {
                                input.startRequiredModules();
                                try {
                                    input.startPreviouslyRunningModules();
                                }
                                catch (Exception exn) {
                                    try {
                                        ExceptionHandler.handle(NouvelleConnexionAction.this.connexionPanel, "Impossible de d\u00e9marrer les modules", exn).get();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                                SwingUtilities.invokeLater(showMainFrame);
                            }
                            catch (Exception exn) {
                                NouvelleConnexionAction.this.openEmergencyModuleManager(input, "Impossible de d\u00e9marrer les modules requis", exn);
                            }
                        }
                    });
                    NouvelleConnexionAction.initCache(comptaPropsConfiguration);
                    showMainFrame.get();
                }
                catch (Throwable e) {
                    if (e.getMessage() != null && (e.getMessage().contains("table") && e.getMessage().contains("not found") || e.getMessage().contains("unknown field") || e.getMessage().contains("Couldn't add showAs") || e.getMessage().contains("Base de donn\u00e9es non \u00e0 jour"))) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(new JFrame(), "Votre base de donn\u00e9es n'est pas \u00e0 jour.\nUtilisez l'outil de configuration et pensez \u00e0 l'achat du manuel !\n(" + e.getMessage() + ")");
                        return;
                    }
                    ExceptionHandler.handle("Erreur de connexion", e);
                }
            }
        };
        JImage image = new JImage(ComptaBasePropsConfiguration.class.getResource("logo.png"));
        Image customImage = ComptaPropsConfiguration.getInstanceCompta().getCustomLogo();
        if (customImage != null) {
            image.setImage(customImage);
        }
        image.setBackground(Color.WHITE);
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        this.connexionPanel = ConnexionPanel.create(r, image, !Gestion.isMinimalMode());
        List<Locale> langs = Arrays.asList(Locale.FRANCE, Locale.CANADA_FRENCH, new Locale("fr", "CH"), new Locale("fr", "BE"), Locale.UK, Locale.CANADA, Locale.US, Locale.GERMANY, new Locale("de", "CH"), new Locale("es", "ES"), new Locale("pl", "PL"));
        if (this.connexionPanel == null) {
            Locale locale = UserProps.getInstance().getLocale();
            UserProps.getInstance().setLocale(locale);
            ((PropsConfiguration)Configuration.getInstance()).setLocale(locale);
            Locale.setDefault(locale);
            JComponent.setDefaultLocale(locale);
            TranslationManager.createDefaultInstance();
            TM.getInstance();
            return null;
        }
        this.connexionPanel.initLocalization(this.getClass().getName(), langs);
        p.add((Component)this.connexionPanel, c);
        PanelFrame panelFrame = new PanelFrame(p, "Connexion");
        panelFrame.setLocationRelativeTo(null);
        panelFrame.pack();
        panelFrame.setDefaultCloseOperation(2);
        return panelFrame;
    }

    public static void initCache(ComptaPropsConfiguration comptaConf) {
        NouvelleConnexionAction.initCache(comptaConf, 600);
    }

    public static void initCache(final ComptaPropsConfiguration comptaConf, final int timeout) {
        final SQLBase baseSociete = comptaConf.getSQLBaseSociete();
        Thread t = new Thread(){

            @Override
            public void run() {
                ClasseCompte.loadClasseCompte((ComptaPropsConfiguration)comptaConf);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                CaisseCotisationSQLElement.getCaisseCotisation();
                SQLPreferences prefs = SQLPreferences.getMemCached(comptaConf.getRootSociete());
                Ville.init(new NXDatabaseAccessor(comptaConf), prefs.getBoolean(GestionClientPreferencePanel.LOAD_CITIES, true));
                SQLBackgroundTableCache.getInstance().add(baseSociete.getTable("TAXE"), timeout);
                SQLBackgroundTableCache.getInstance().add(baseSociete.getTable("ETAT_DEVIS"), timeout);
                SQLBackgroundTableCache.getInstance().add(baseSociete.getTable("PREFS_COMPTE"), timeout);
                SQLBackgroundTableCache.getInstance().add(baseSociete.getTable("COMPTE_PCE"), timeout);
                SQLBackgroundTableCache.getInstance().add(baseSociete.getTable("JOURNAL"), timeout);
                SQLBackgroundTableCache.getInstance().add(baseSociete.getTable("COMMERCIAL"), timeout);
                SQLBackgroundTableCache.getInstance().add(baseSociete.getTable("PERIODE_VALIDITE"), timeout);
                if (comptaConf.getRootSociete().contains("DEPOT_STOCK")) {
                    SQLBackgroundTableCache.getInstance().add(baseSociete.getTable("DEPOT_STOCK"), timeout);
                }
                SQLBackgroundTableCache.getInstance().add(baseSociete.getTable("TYPE_REGLEMENT"), timeout);
                SQLBackgroundTableCache.getInstance().startCacheWatcher();
                TaxeCache.getCache();
                UndefinedRowValuesCache undefCache = UndefinedRowValuesCache.getInstance();
                ArrayList<SQLTable> tablesToCache = new ArrayList<SQLTable>();
                tablesToCache.add(baseSociete.getTable("DEVIS"));
                tablesToCache.add(baseSociete.getTable("ETAT_DEVIS"));
                tablesToCache.add(baseSociete.getTable("FAMILLE_ARTICLE"));
                tablesToCache.add(baseSociete.getTable("ADRESSE"));
                tablesToCache.add(baseSociete.getTable("DEVIS_ELEMENT"));
                tablesToCache.add(baseSociete.getTable("CONTACT"));
                tablesToCache.add(baseSociete.getTable("SAISIE_VENTE_FACTURE_ELEMENT"));
                tablesToCache.add(baseSociete.getTable("SAISIE_KM_ELEMENT"));
                tablesToCache.add(baseSociete.getTable("BON_DE_LIVRAISON_ELEMENT"));
                tablesToCache.add(baseSociete.getTable("COMMANDE_CLIENT_ELEMENT"));
                tablesToCache.add(baseSociete.getTable("AVOIR_CLIENT_ELEMENT"));
                tablesToCache.add(baseSociete.getTable("BON_RECEPTION_ELEMENT"));
                tablesToCache.add(baseSociete.getTable("ASSOCIATION_ANALYTIQUE"));
                undefCache.preload(tablesToCache);
            }
        };
        t.setName("Cache preload");
        t.setDaemon(true);
        t.setPriority(1);
        t.start();
    }

    private String checkLicense(SwingWorker<String, Object> w) {
        try {
            return w.get();
        }
        catch (Exception e) {
            throw ExceptionHandler.die("Impossible de charger la licence.", e);
        }
    }

    private void openEmergencyModuleManager(final ModuleManager mngr, final String str, final Throwable e) {
        Log.get().log(Level.SEVERE, "Normal startup impossible, opening the module manager in order to resolve the issue.", e);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExceptionHandler.handle(str, e);
                ModuleFrame fMod = new ModuleFrame(mngr, true);
                fMod.setDefaultCloseOperation(3);
                fMod.setTitle(str);
                FrameUtil.show(fMod);
            }
        });
    }
}

