/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.action;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.sql.Configuration;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.state.WindowStateManager;
import org.openconcerto.utils.FileUtils;

public abstract class CreateAndCacheFrameAbstractAction
extends AbstractAction {
    private JFrame frame;
    WindowStateManager stateManager;

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.frame == null) {
            this.frame = this.createFrame();
            this.frame.setLocationRelativeTo(null);
            this.stateManager = new WindowStateManager(this.frame, new File(Configuration.getInstance().getConfDir(), "Configuration" + File.separator + "Frame" + File.separator + FileUtils.sanitize(this.getValue("Name").toString()) + ".xml"));
            this.frame.setIconImages(Gestion.getFrameIcon());
            this.frame.setDefaultCloseOperation(1);
        }
        this.frame.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int w = Math.min(d.width - 100, this.frame.getWidth());
        int h = Math.min(d.height - 100, this.frame.getHeight());
        this.frame.setMinimumSize(new Dimension(w, h));
        FrameUtil.show(this.frame);
        this.stateManager.loadState();
    }

    public abstract JFrame createFrame();
}

