/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.h2.compress.CompressLZF;
import org.h2.compress.Compressor;
import org.h2.mvstore.Chunk;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVMapConcurrent;
import org.h2.mvstore.Page;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.cache.CacheLongKeyLIRS;
import org.h2.mvstore.type.StringDataType;
import org.h2.util.MathUtils;
import org.h2.util.New;

public class MVStore {
    public static final boolean ASSERT = false;
    static final int BLOCK_SIZE = 4096;
    private static final int FORMAT_WRITE = 1;
    private static final int FORMAT_READ = 1;
    volatile BackgroundWriterThread backgroundWriterThread;
    private volatile boolean reuseSpace = true;
    private boolean closed;
    private FileStore fileStore;
    private final int pageSplitSize;
    private long rootChunkStart;
    private CacheLongKeyLIRS<Page> cache;
    private int lastChunkId;
    private final ConcurrentHashMap<Integer, Chunk> chunks = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, HashMap<Integer, Chunk>> freedPageSpace = new ConcurrentHashMap();
    private MVMapConcurrent<String, String> meta;
    private final ConcurrentHashMap<Integer, MVMap<?, ?>> maps = new ConcurrentHashMap();
    private HashMap<String, String> storeHeader = New.hashMap();
    private WriteBuffer writeBuffer;
    private int lastMapId;
    private int versionsToKeep = 5;
    private final boolean compress;
    private final Compressor compressor = new CompressLZF();
    private final Thread.UncaughtExceptionHandler backgroundExceptionHandler;
    private long currentVersion;
    private long lastStoredVersion;
    private int unsavedPageCount;
    private int autoCommitPageCount;
    private boolean saveNeeded;
    private long creationTime;
    private int retentionTime;
    private long lastCommitTime;
    private Chunk retainChunk;
    private volatile long currentStoreVersion = -1L;
    private Thread currentStoreThread;
    private volatile boolean metaChanged;
    private int autoCommitDelay;

    MVStore(HashMap<String, Object> hashMap) {
        int n;
        int n2;
        int n3;
        int n4;
        this.compress = hashMap.containsKey("compress");
        String string = (String)hashMap.get("fileName");
        Object object = hashMap.get("pageSplitSize");
        this.pageSplitSize = object == null ? (string == null ? 4096 : 16384) : (Integer)object;
        object = hashMap.get("backgroundExceptionHandler");
        this.backgroundExceptionHandler = (Thread.UncaughtExceptionHandler)object;
        this.meta = new MVMapConcurrent(StringDataType.INSTANCE, StringDataType.INSTANCE);
        HashMap<String, String> hashMap2 = New.hashMap();
        hashMap2.put("id", "0");
        hashMap2.put("createVersion", Long.toString(this.currentVersion));
        this.meta.init(this, hashMap2);
        this.fileStore = (FileStore)hashMap.get("fileStore");
        if (string == null && this.fileStore == null) {
            this.cache = null;
            return;
        }
        if (this.fileStore == null) {
            this.fileStore = new FileStore();
        }
        this.retentionTime = this.fileStore.getDefaultRetentionTime();
        boolean bl = hashMap.containsKey("readOnly");
        object = hashMap.get("cacheSize");
        int n5 = n4 = object == null ? 16 : (Integer)object;
        if (n4 > 0) {
            n3 = n4 * 1024 * 1024;
            n2 = Math.max(10, this.pageSplitSize / 2);
            n = 16;
            int n6 = n3 / n2 * 2 / 100;
            this.cache = new CacheLongKeyLIRS(n3, n2, n, n6);
        }
        n3 = (object = hashMap.get("autoCommitBufferSize")) == null ? 512 : (Integer)object;
        n2 = n3 * 1024 * 19;
        n = this.pageSplitSize;
        this.autoCommitPageCount = n2 / (n == 0 ? 1 : n);
        char[] cArray = (char[])hashMap.get("encryptionKey");
        try {
            this.fileStore.open(string, bl, cArray);
            if (this.fileStore.size() == 0L) {
                this.creationTime = 0L;
                this.lastCommitTime = this.creationTime = this.getTime();
                this.storeHeader.put("H", "3");
                this.storeHeader.put("blockSize", "4096");
                this.storeHeader.put("format", "1");
                this.storeHeader.put("creationTime", "" + this.creationTime);
                this.writeStoreHeader();
            } else {
                this.readStoreHeader();
                long l = DataUtils.parseLong(this.storeHeader.get("format"), 0L);
                if (l > 1L && !this.fileStore.isReadOnly()) {
                    throw DataUtils.newIllegalStateException(5, "The write format {0} is larger than the supported format {1}, and the file was not opened in read-only mode", l, 1);
                }
                l = DataUtils.parseLong(this.storeHeader.get("formatRead"), l);
                if (l > 1L) {
                    throw DataUtils.newIllegalStateException(5, "The read format {0} is larger than the supported format {1}", l, 1);
                }
                if (this.rootChunkStart > 0L) {
                    this.readMeta();
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            try {
                this.closeStore(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw illegalStateException;
        }
        finally {
            if (cArray != null) {
                Arrays.fill(cArray, '\u0000');
            }
        }
        this.lastCommitTime = this.getTime();
        object = hashMap.get("autoCommitDelay");
        int n7 = object == null ? 1000 : (Integer)object;
        this.setAutoCommitDelay(n7);
    }

    public static MVStore open(String string) {
        HashMap<String, Object> hashMap = New.hashMap();
        hashMap.put("fileName", string);
        return new MVStore(hashMap);
    }

    <T extends MVMap<?, ?>> T openMapVersion(long l, int n, MVMap<?, ?> mVMap) {
        MVMap<String, String> mVMap2 = this.getMetaMap(l);
        String string = mVMap2.get("root." + n);
        long l2 = DataUtils.parseLong(string, 0L);
        MVMap<?, ?> mVMap3 = mVMap.openReadOnly();
        mVMap3.setRootPos(l2, l);
        return (T)mVMap3;
    }

    public <K, V> MVMap<K, V> openMap(String string) {
        return this.openMap(string, new MVMap.Builder());
    }

    public synchronized <M extends MVMap<K, V>, K, V> M openMap(String string, MVMap.MapBuilder<M, K, V> mapBuilder) {
        long l;
        M m;
        int n;
        this.checkOpen();
        String string2 = (String)this.meta.get("name." + string);
        if (string2 != null) {
            n = Integer.parseInt(string2);
            MVMap<?, ?> mVMap = this.maps.get(n);
            if (mVMap != null) {
                return (M)mVMap;
            }
            m = mapBuilder.create();
            String string3 = (String)this.meta.get("map." + string2);
            HashMap<String, String> hashMap = DataUtils.parseMap(string3);
            hashMap.put("id", string2);
            ((MVMap)m).init(this, hashMap);
            String string4 = (String)this.meta.get("root." + n);
            l = string4 == null ? 0L : Long.parseLong(string4);
        } else {
            HashMap<String, String> hashMap = New.hashMap();
            n = ++this.lastMapId;
            hashMap.put("id", Integer.toString(n));
            hashMap.put("createVersion", Long.toString(this.currentVersion));
            m = mapBuilder.create();
            ((MVMap)m).init(this, hashMap);
            this.markMetaChanged();
            this.meta.put("map." + n, ((MVMap)m).asString(string));
            this.meta.put("name." + string, Integer.toString(n));
            l = 0L;
        }
        ((MVMap)m).setRootPos(l, -1L);
        this.maps.put(n, (MVMap<?, ?>)m);
        return m;
    }

    public synchronized Set<String> getMapNames() {
        String string;
        HashSet<String> hashSet = New.hashSet();
        this.checkOpen();
        Iterator<String> iterator = this.meta.keyIterator("name.");
        while (iterator.hasNext() && (string = iterator.next()).startsWith("name.")) {
            hashSet.add(string.substring("name.".length()));
        }
        return hashSet;
    }

    public MVMap<String, String> getMetaMap() {
        this.checkOpen();
        return this.meta;
    }

    private MVMap<String, String> getMetaMap(long l) {
        Chunk chunk = this.getChunkForVersion(l);
        DataUtils.checkArgument(chunk != null, "Unknown version {0}", l);
        chunk = this.readChunkHeader(chunk.start);
        MVMap<String, String> mVMap = this.meta.openReadOnly();
        mVMap.setRootPos(chunk.metaRootPos, l);
        return mVMap;
    }

    private Chunk getChunkForVersion(long l) {
        int n = this.lastChunkId;
        Chunk chunk;
        while ((chunk = this.chunks.get(n)) != null) {
            if (chunk.version <= l) {
                return chunk;
            }
            --n;
        }
        return null;
    }

    public boolean hasMap(String string) {
        return this.meta.containsKey("name." + string);
    }

    private void markMetaChanged() {
        this.metaChanged = true;
    }

    private synchronized void readMeta() {
        this.chunks.clear();
        Chunk chunk = this.readChunkHeader(this.rootChunkStart);
        if (chunk.start == Long.MAX_VALUE) {
            throw DataUtils.newIllegalStateException(6, "Chunk {0} is invalid", chunk.id);
        }
        this.lastChunkId = chunk.id;
        this.chunks.put(chunk.id, chunk);
        this.meta.setRootPos(chunk.metaRootPos, -1L);
        String string = (String)this.meta.get("chunk." + this.lastChunkId);
        Chunk chunk2 = Chunk.fromString(string);
        chunk2.start = chunk.start;
        chunk2.length = chunk.length;
        chunk2.metaRootPos = chunk.metaRootPos;
        chunk2.pageCount = chunk.pageCount;
        chunk2.pageCountLive = chunk.pageCountLive;
        chunk2.maxLength = chunk.maxLength;
        chunk2.maxLengthLive = chunk.maxLengthLive;
        this.chunks.put(chunk.id, chunk2);
        Iterator<Object> iterator = this.meta.keyIterator("chunk.");
        while (iterator.hasNext() && (string = iterator.next()).startsWith("chunk.")) {
            string = (String)this.meta.get(string);
            Chunk chunk3 = Chunk.fromString(string);
            if (this.chunks.containsKey(chunk3.id)) continue;
            if (chunk3.start == Long.MAX_VALUE) {
                throw DataUtils.newIllegalStateException(6, "Chunk {0} is invalid", chunk3.id);
            }
            this.chunks.put(chunk3.id, chunk3);
        }
        for (Chunk chunk3 : this.chunks.values()) {
            if (chunk3.pageCountLive == 0) {
                this.registerFreePage(this.currentVersion, chunk3.id, 0L, 0);
            }
            int n = MathUtils.roundUpInt(chunk3.length, 4096) + 4096;
            this.fileStore.markUsed(chunk3.start, n);
        }
    }

    private void readStoreHeader() {
        this.currentVersion = -1L;
        long l = -1L;
        ByteBuffer byteBuffer = this.fileStore.readFully(this.fileStore.size() - 4096L, 4096);
        ByteBuffer byteBuffer2 = this.fileStore.readFully(0L, 8192);
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(12288);
        byteBuffer3.put(byteBuffer);
        byteBuffer3.put(byteBuffer2);
        for (int i = 0; i < 12288; i += 4096) {
            long l2;
            int n;
            HashMap<String, String> hashMap;
            String string = new String(byteBuffer3.array(), i, 4096, DataUtils.UTF8).trim();
            try {
                hashMap = DataUtils.parseMap(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            String string2 = hashMap.remove("fletcher");
            if (string2 == null) continue;
            try {
                n = (int)Long.parseLong(string2, 16);
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            string = string.substring(0, string.lastIndexOf("fletcher") - 1);
            byte[] byArray = string.getBytes(DataUtils.UTF8);
            int n2 = DataUtils.getFletcher32(byArray, byArray.length / 2 * 2);
            if (n != n2 || (l2 = Long.parseLong(hashMap.get("chunk"))) <= l) continue;
            l = l2;
            this.storeHeader = hashMap;
            this.rootChunkStart = Long.parseLong(hashMap.get("rootChunk"));
            this.creationTime = Long.parseLong(hashMap.get("creationTime"));
            this.lastMapId = Integer.parseInt(hashMap.get("lastMapId"));
            this.currentVersion = Long.parseLong(hashMap.get("version"));
        }
        if (this.currentVersion < 0L) {
            throw DataUtils.newIllegalStateException(6, "Store header is corrupt: {0}", this.fileStore);
        }
        this.setWriteVersion(this.currentVersion);
        this.lastStoredVersion = -1L;
    }

    private byte[] getStoreHeaderBytes() {
        StringBuilder stringBuilder = new StringBuilder();
        this.storeHeader.put("lastMapId", "" + this.lastMapId);
        this.storeHeader.put("chunk", "" + this.lastChunkId);
        this.storeHeader.put("rootChunk", "" + this.rootChunkStart);
        this.storeHeader.put("version", "" + this.currentVersion);
        DataUtils.appendMap(stringBuilder, this.storeHeader);
        byte[] byArray = stringBuilder.toString().getBytes(DataUtils.UTF8);
        int n = DataUtils.getFletcher32(byArray, byArray.length / 2 * 2);
        DataUtils.appendMap(stringBuilder, "fletcher", Integer.toHexString(n));
        byArray = stringBuilder.toString().getBytes(DataUtils.UTF8);
        if (byArray.length > 4096) {
            throw DataUtils.newIllegalStateException(5, "Store header too large: {0}", stringBuilder);
        }
        return byArray;
    }

    private void writeStoreHeader() {
        byte[] byArray = this.getStoreHeaderBytes();
        ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
        byteBuffer.put(byArray);
        byteBuffer.position(4096);
        byteBuffer.put(byArray);
        byteBuffer.rewind();
        this.fileStore.writeFully(0L, byteBuffer);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (this.fileStore != null && !this.fileStore.isReadOnly()) {
            this.stopBackgroundThread();
            if (this.hasUnsavedChanges()) {
                this.commitAndSave();
            }
        }
        this.closeStore(true);
    }

    public void closeImmediately() {
        block2: {
            try {
                this.closeStore(false);
            }
            catch (Exception exception) {
                if (this.backgroundExceptionHandler == null) break block2;
                this.backgroundExceptionHandler.uncaughtException(null, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStore(boolean bl) {
        if (this.closed) {
            return;
        }
        this.stopBackgroundThread();
        this.closed = true;
        if (this.fileStore == null) {
            return;
        }
        MVStore mVStore = this;
        synchronized (mVStore) {
            if (bl) {
                this.shrinkFileIfPossible(0);
            }
            this.cache = null;
            for (MVMap<?, ?> mVMap : New.arrayList(this.maps.values())) {
                mVMap.close();
            }
            this.meta = null;
            this.chunks.clear();
            this.maps.clear();
            try {
                this.fileStore.close();
            }
            finally {
                this.fileStore = null;
            }
        }
    }

    Chunk getChunk(long l) {
        int n = DataUtils.getPageChunkId(l);
        Chunk chunk = this.chunks.get(n);
        if (chunk == null) {
            if (!Thread.holdsLock(this)) {
                throw DataUtils.newIllegalStateException(3, "Unsynchronized metadata read", new Object[0]);
            }
            String string = (String)this.meta.get("chunk." + n);
            if (string == null) {
                throw DataUtils.newIllegalStateException(6, "Chunk {0} not found", n);
            }
            chunk = Chunk.fromString(string);
            if (chunk.start == Long.MAX_VALUE) {
                throw DataUtils.newIllegalStateException(6, "Chunk {0} is invalid", n);
            }
            this.chunks.put(chunk.id, chunk);
        }
        return chunk;
    }

    private void setWriteVersion(long l) {
        for (MVMap<?, ?> mVMap : this.maps.values()) {
            mVMap.setWriteVersion(l);
        }
        this.meta.setWriteVersion(l);
    }

    public long commit() {
        if (this.fileStore != null) {
            return this.commitAndSave();
        }
        long l = ++this.currentVersion;
        this.setWriteVersion(l);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long commitAndSave() {
        if (this.closed) {
            return this.currentVersion;
        }
        if (this.fileStore == null) {
            throw DataUtils.newIllegalStateException(2, "This is an in-memory store", new Object[0]);
        }
        if (this.currentStoreVersion >= 0L) {
            return this.currentVersion;
        }
        if (!this.hasUnsavedChanges()) {
            return this.currentVersion;
        }
        if (this.fileStore.isReadOnly()) {
            throw DataUtils.newIllegalStateException(2, "This store is read-only", new Object[0]);
        }
        try {
            this.currentStoreVersion = this.currentVersion;
            this.currentStoreThread = Thread.currentThread();
            long l = this.storeNow();
            return l;
        }
        finally {
            this.currentStoreVersion = -1L;
            this.currentStoreThread = null;
        }
    }

    private long storeNow() {
        long l;
        Object object;
        long l2;
        int n = this.unsavedPageCount;
        long l3 = this.currentStoreVersion;
        long l4 = ++this.currentVersion;
        this.setWriteVersion(l4);
        this.lastCommitTime = l2 = this.getTime();
        this.retainChunk = null;
        Chunk chunk = this.chunks.get(this.lastChunkId);
        if (chunk != null) {
            this.meta.put("chunk." + chunk.id, chunk.asString());
            l2 = Math.max(chunk.time, l2);
        }
        Chunk chunk2 = new Chunk(++this.lastChunkId);
        chunk2.maxLength = Long.MAX_VALUE;
        chunk2.maxLengthLive = Long.MAX_VALUE;
        chunk2.start = Long.MAX_VALUE;
        chunk2.length = Integer.MAX_VALUE;
        chunk2.time = l2;
        chunk2.version = l4;
        this.chunks.put(chunk2.id, chunk2);
        this.meta.put("chunk." + chunk2.id, chunk2.asString());
        ArrayList<MVMap<?, ?>> arrayList = New.arrayList(this.maps.values());
        ArrayList arrayList2 = New.arrayList();
        for (MVMap<?, ?> mVMap2 : arrayList) {
            mVMap2.setWriteVersion(l4);
            long l5 = mVMap2.getVersion();
            if (mVMap2.getCreateVersion() > l3 || l5 < 0L || l5 < this.lastStoredVersion) continue;
            mVMap2.waitUntilWritten(l3);
            object = mVMap2.openVersion(l3);
            if (((MVMap)object).getRoot().getPos() != 0L) continue;
            arrayList2.add(object);
        }
        for (MVMap<Object, Object> mVMap : arrayList2) {
            Page page = mVMap.getRoot();
            if (page.getTotalCount() == 0L) {
                this.meta.put("root." + mVMap.getId(), "0");
                continue;
            }
            this.meta.put("root." + mVMap.getId(), String.valueOf(Integer.MAX_VALUE));
        }
        Set<Chunk> set = this.applyFreedSpace(l3, l2);
        WriteBuffer writeBuffer = this.getWriteBuffer();
        chunk2.writeHeader(writeBuffer);
        chunk2.maxLength = 0L;
        chunk2.maxLengthLive = 0L;
        for (MVMap mVMap : arrayList2) {
            object = mVMap.getRoot();
            if (((Page)object).getTotalCount() <= 0L) continue;
            ((Page)object).writeUnsavedRecursive(chunk2, writeBuffer);
            long l6 = ((Page)object).getPos();
            this.meta.put("root." + mVMap.getId(), "" + l6);
        }
        this.meta.put("chunk." + chunk2.id, chunk2.asString());
        this.meta.setWriteVersion(l4);
        Page page = this.meta.getRoot();
        page.writeUnsavedRecursive(chunk2, writeBuffer);
        int n2 = writeBuffer.position();
        int n3 = MathUtils.roundUpInt(n2, 4096) + 4096;
        writeBuffer.limit(n3);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Chunk chunk3 = (Chunk)iterator.next();
            int n4 = MathUtils.roundUpInt(chunk3.length, 4096) + 4096;
            this.fileStore.free(chunk3.start, n4);
        }
        long l7 = this.getFileLengthInUse();
        if (this.reuseSpace) {
            l = this.fileStore.allocate(n3);
        } else {
            l = l7;
            this.fileStore.markUsed(l7, n3);
        }
        boolean bl = l + (long)n3 >= this.fileStore.size();
        chunk2.start = l;
        chunk2.length = n2;
        chunk2.metaRootPos = page.getPos();
        writeBuffer.position(0);
        chunk2.writeHeader(writeBuffer);
        this.rootChunkStart = l;
        this.revertTemp(l3);
        writeBuffer.position(writeBuffer.limit() - 4096);
        byte[] byArray = this.getStoreHeaderBytes();
        writeBuffer.put(byArray);
        writeBuffer.put(new byte[4096 - byArray.length]);
        writeBuffer.position(0);
        this.fileStore.writeFully(l, writeBuffer.getBuffer());
        this.releaseWriteBuffer(writeBuffer);
        if (!bl) {
            this.writeStoreHeader();
            this.shrinkFileIfPossible(1);
        }
        for (MVMap mVMap : arrayList2) {
            Page page2 = mVMap.getRoot();
            if (page2.getTotalCount() <= 0L) continue;
            page2.writeEnd();
        }
        page.writeEnd();
        this.unsavedPageCount = Math.max(0, this.unsavedPageCount - n);
        this.metaChanged = false;
        this.lastStoredVersion = l3;
        return l4;
    }

    private WriteBuffer getWriteBuffer() {
        WriteBuffer writeBuffer;
        if (this.writeBuffer != null) {
            writeBuffer = this.writeBuffer;
            writeBuffer.clear();
        } else {
            writeBuffer = new WriteBuffer();
        }
        return writeBuffer;
    }

    private void releaseWriteBuffer(WriteBuffer writeBuffer) {
        if (writeBuffer.capacity() <= 0x400000) {
            this.writeBuffer = writeBuffer;
        }
    }

    private boolean canOverwriteChunk(Chunk chunk, long l) {
        if (chunk.time + (long)this.retentionTime > l) {
            return false;
        }
        Chunk chunk2 = this.retainChunk;
        return chunk2 == null || chunk.version <= chunk2.version;
    }

    private long getTime() {
        return System.currentTimeMillis() - this.creationTime;
    }

    private Set<Chunk> applyFreedSpace(long l, long l2) {
        ArrayList<Chunk> arrayList;
        HashSet<Chunk> hashSet = New.hashSet();
        do {
            arrayList = New.arrayList();
            Iterator<Map.Entry<Long, HashMap<Integer, Chunk>>> iterator = this.freedPageSpace.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, HashMap<Integer, Chunk>> entry = iterator.next();
                long l3 = (Long)entry.getKey();
                if (l3 > l) continue;
                HashMap hashMap = (HashMap)entry.getValue();
                for (Chunk chunk : hashMap.values()) {
                    Chunk chunk2 = this.chunks.get(chunk.id);
                    if (chunk2 == null) continue;
                    chunk2.maxLengthLive += chunk.maxLengthLive;
                    chunk2.pageCountLive += chunk.pageCountLive;
                    if (chunk2.pageCountLive < 0) {
                        throw DataUtils.newIllegalStateException(3, "Corrupt page count {0}", chunk2.pageCountLive);
                    }
                    if (chunk2.maxLengthLive < 0L) {
                        throw DataUtils.newIllegalStateException(3, "Corrupt max length {0}", chunk2.maxLengthLive);
                    }
                    if (chunk2.pageCount == 0 && chunk2.maxLengthLive > 0L) {
                        throw DataUtils.newIllegalStateException(3, "Corrupt max length {0}", chunk2.maxLengthLive);
                    }
                    arrayList.add(chunk2);
                }
                iterator.remove();
            }
            for (Chunk chunk : arrayList) {
                if (chunk.maxLengthLive == 0L) {
                    if (this.canOverwriteChunk(chunk, l2)) {
                        hashSet.add(chunk);
                        this.chunks.remove(chunk.id);
                        this.meta.remove("chunk." + chunk.id);
                        continue;
                    }
                    this.meta.put("chunk." + chunk.id, chunk.asString());
                    this.registerFreePage(l + 1L, chunk.id, 0L, 0);
                    continue;
                }
                this.meta.put("chunk." + chunk.id, chunk.asString());
            }
        } while (arrayList.size() != 0);
        return hashSet;
    }

    private void shrinkFileIfPossible(int n) {
        long l;
        long l2 = this.getFileLengthInUse();
        if (l2 >= (l = this.fileStore.size())) {
            return;
        }
        if (n > 0 && l - l2 < 4096L) {
            return;
        }
        int n2 = (int)(100L - l2 * 100L / l);
        if (n2 < n) {
            return;
        }
        this.fileStore.truncate(l2);
    }

    private long getFileLengthInUse() {
        long l = 8192L;
        for (Chunk chunk : this.chunks.values()) {
            long l2 = chunk.start + (long)chunk.length;
            l = Math.max(l, MathUtils.roundUpLong(l2, 4096L) + 4096L);
        }
        return l;
    }

    public boolean hasUnsavedChanges() {
        this.checkOpen();
        if (this.metaChanged) {
            return true;
        }
        for (MVMap<?, ?> mVMap : this.maps.values()) {
            long l;
            if (mVMap.isClosed() || (l = mVMap.getVersion()) < 0L || l <= this.lastStoredVersion) continue;
            return true;
        }
        return false;
    }

    private Chunk readChunkHeader(long l) {
        ByteBuffer byteBuffer = this.fileStore.readFully(l, 40);
        return Chunk.fromHeader(byteBuffer, l);
    }

    public synchronized boolean compactMoveChunks() {
        this.checkOpen();
        if (this.chunks.size() == 0) {
            return false;
        }
        int n = this.retentionTime;
        this.retentionTime = 0;
        long l = this.getTime();
        ArrayList<Chunk> arrayList = New.arrayList();
        for (Chunk chunk : this.chunks.values()) {
            if (chunk.maxLengthLive != 0L || !this.canOverwriteChunk(chunk, l)) continue;
            arrayList.add(chunk);
        }
        for (Chunk chunk : arrayList) {
            this.chunks.remove(chunk.id);
            this.markMetaChanged();
            this.meta.remove("chunk." + chunk.id);
            int n2 = MathUtils.roundUpInt(chunk.length, 4096) + 4096;
            this.fileStore.free(chunk.start, n2);
        }
        if (this.fileStore.getFillRate() == 100) {
            return false;
        }
        long l2 = this.fileStore.getFirstFree();
        ArrayList<Object> arrayList2 = New.arrayList();
        for (Chunk object : this.chunks.values()) {
            if (object.start <= l2) continue;
            arrayList2.add(object);
        }
        for (Chunk chunk : arrayList2) {
            Object object = this.getWriteBuffer();
            int n2 = MathUtils.roundUpInt(chunk.length, 4096) + 4096;
            ((WriteBuffer)object).limit(n2);
            ByteBuffer byteBuffer = this.fileStore.readFully(chunk.start, n2);
            ((WriteBuffer)object).put(byteBuffer);
            long l3 = this.getFileLengthInUse();
            this.fileStore.markUsed(l3, n2);
            this.fileStore.free(chunk.start, n2);
            chunk.start = l3;
            ((WriteBuffer)object).position(0);
            chunk.writeHeader((WriteBuffer)object);
            ((WriteBuffer)object).position(((WriteBuffer)object).limit() - 4096);
            byte[] byArray = this.getStoreHeaderBytes();
            ((WriteBuffer)object).put(byArray);
            ((WriteBuffer)object).put(new byte[4096 - byArray.length]);
            ((WriteBuffer)object).position(0);
            this.fileStore.writeFully(l3, ((WriteBuffer)object).getBuffer());
            this.releaseWriteBuffer((WriteBuffer)object);
            this.markMetaChanged();
            this.meta.put("chunk." + chunk.id, chunk.asString());
        }
        boolean bl = this.reuseSpace;
        this.reuseSpace = false;
        this.commitAndSave();
        this.sync();
        this.reuseSpace = true;
        for (Object object : arrayList2) {
            if (!this.chunks.containsKey(((Chunk)object).id)) continue;
            WriteBuffer writeBuffer = this.getWriteBuffer();
            int n3 = MathUtils.roundUpInt(((Chunk)object).length, 4096) + 4096;
            writeBuffer.limit(n3);
            ByteBuffer byteBuffer = this.fileStore.readFully(((Chunk)object).start, n3);
            writeBuffer.put(byteBuffer);
            long l4 = this.fileStore.allocate(n3);
            this.fileStore.free(((Chunk)object).start, n3);
            writeBuffer.position(0);
            ((Chunk)object).start = l4;
            ((Chunk)object).writeHeader(writeBuffer);
            writeBuffer.position(writeBuffer.limit() - 4096);
            byte[] byArray = this.getStoreHeaderBytes();
            writeBuffer.put(byArray);
            writeBuffer.put(new byte[4096 - byArray.length]);
            writeBuffer.position(0);
            this.fileStore.writeFully(l4, writeBuffer.getBuffer());
            this.releaseWriteBuffer(writeBuffer);
            this.markMetaChanged();
            this.meta.put("chunk." + ((Chunk)object).id, ((Chunk)object).asString());
        }
        this.commitAndSave();
        this.sync();
        this.shrinkFileIfPossible(0);
        this.reuseSpace = bl;
        this.retentionTime = n;
        return true;
    }

    public void sync() {
        this.fileStore.sync();
    }

    public synchronized boolean compact(int n) {
        int n2;
        this.checkOpen();
        if (this.chunks.size() == 0) {
            return false;
        }
        long l = 0L;
        long l2 = 0L;
        for (Chunk chunk : this.chunks.values()) {
            l += chunk.maxLength;
            l2 += chunk.maxLengthLive;
        }
        if (l <= 0L) {
            l = 1L;
        }
        if ((n2 = (int)(100L * l2 / l)) > n) {
            return false;
        }
        int n3 = (int)(l / (long)this.chunks.size());
        long l3 = this.getTime();
        ArrayList<Chunk> arrayList = New.arrayList();
        for (Chunk chunk : this.chunks.values()) {
            if (!this.canOverwriteChunk(chunk, l3)) continue;
            int n4 = this.lastChunkId - chunk.id + 1;
            chunk.collectPriority = chunk.getFillRate() / n4;
            arrayList.add(chunk);
        }
        if (arrayList.size() == 0) {
            return false;
        }
        Collections.sort(arrayList, new Comparator<Chunk>(){

            @Override
            public int compare(Chunk chunk, Chunk chunk2) {
                return new Integer(chunk.collectPriority).compareTo(chunk2.collectPriority);
            }
        });
        long l4 = 0L;
        Chunk iterator2 = null;
        for (Chunk iterator3 : arrayList) {
            if (iterator2 != null && l4 + iterator3.maxLengthLive > (long)n3) break;
            l4 += iterator3.maxLengthLive;
            iterator2 = iterator3;
        }
        boolean bl = false;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Chunk chunk = (Chunk)iterator.next();
            if (iterator2 == chunk) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            iterator.remove();
        }
        for (Chunk chunk : arrayList) {
            this.copyLive(chunk, arrayList);
        }
        this.commitAndSave();
        return true;
    }

    private void copyLive(Chunk chunk, ArrayList<Chunk> arrayList) {
        ByteBuffer byteBuffer = this.fileStore.readFully(chunk.start, chunk.length);
        Chunk.fromHeader(byteBuffer, chunk.start);
        int n = chunk.length;
        this.markMetaChanged();
        while (byteBuffer.position() < n) {
            int n2 = byteBuffer.position();
            int n3 = byteBuffer.getInt();
            byteBuffer.getShort();
            int n4 = DataUtils.readVarInt(byteBuffer);
            MVMap<?, ?> mVMap = this.getMap(n4);
            if (mVMap == null) {
                byteBuffer.position(n2 + n3);
                continue;
            }
            byteBuffer.position(n2);
            Page page = new Page(mVMap, 0L);
            page.read(byteBuffer, chunk.id, byteBuffer.position(), chunk.length);
            for (int i = 0; i < page.getKeyCount(); ++i) {
                Chunk chunk2;
                Object object = page.getKey(i);
                Page page2 = mVMap.getPage(object);
                if (page2 == null || page2.getPos() == 0L || !arrayList.contains(chunk2 = this.getChunk(page2.getPos()))) continue;
                Object obj = mVMap.remove(object);
                mVMap.put(object, obj);
            }
        }
    }

    private MVMap<?, ?> getMap(int n) {
        if (n == 0) {
            return this.meta;
        }
        return this.maps.get(n);
    }

    Page readPage(MVMap<?, ?> mVMap, long l) {
        Page page;
        if (l == 0L) {
            throw DataUtils.newIllegalStateException(6, "Position 0", new Object[0]);
        }
        Page page2 = page = this.cache == null ? null : this.cache.get(l);
        if (page == null) {
            Chunk chunk = this.getChunk(l);
            long l2 = chunk.start;
            if ((l2 += (long)DataUtils.getPageOffset(l)) < 0L) {
                throw DataUtils.newIllegalStateException(6, "Negative position {0}", l2);
            }
            page = Page.read(this.fileStore, mVMap, l, l2, this.fileStore.size());
            this.cachePage(l, page, page.getMemory());
        }
        return page;
    }

    void removePage(MVMap<?, ?> mVMap, long l) {
        if (l == 0L) {
            this.unsavedPageCount = Math.max(0, this.unsavedPageCount - 1);
            return;
        }
        if (this.cache != null) {
            this.cache.remove(l);
        }
        Chunk chunk = this.getChunk(l);
        long l2 = this.currentVersion;
        if (mVMap == this.meta && this.currentStoreVersion >= 0L && Thread.currentThread() == this.currentStoreThread) {
            l2 = this.currentStoreVersion;
        }
        this.registerFreePage(l2, chunk.id, DataUtils.getPageMaxLength(l), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerFreePage(long l, int n, long l2, int n2) {
        HashMap<Integer, Chunk> hashMap;
        HashMap<Integer, Chunk> hashMap2 = this.freedPageSpace.get(l);
        if (hashMap2 == null) {
            hashMap2 = New.hashMap();
            hashMap = this.freedPageSpace.putIfAbsent(l, hashMap2);
            if (hashMap != null) {
                hashMap2 = hashMap;
            }
        }
        hashMap = hashMap2;
        synchronized (hashMap) {
            Chunk chunk = hashMap2.get(n);
            if (chunk == null) {
                chunk = new Chunk(n);
                hashMap2.put(n, chunk);
            }
            chunk.maxLengthLive -= l2;
            chunk.pageCountLive -= n2;
        }
    }

    Compressor getCompressor() {
        return this.compressor;
    }

    boolean getCompress() {
        return this.compress;
    }

    public int getPageSplitSize() {
        return this.pageSplitSize;
    }

    public boolean getReuseSpace() {
        return this.reuseSpace;
    }

    public void setReuseSpace(boolean bl) {
        this.reuseSpace = bl;
    }

    public int getRetentionTime() {
        return this.retentionTime;
    }

    public void setRetentionTime(int n) {
        this.retentionTime = n;
    }

    public void setVersionsToKeep(int n) {
        this.versionsToKeep = n;
    }

    public long getVersionsToKeep() {
        return this.versionsToKeep;
    }

    long getOldestVersionToKeep() {
        long l = this.currentVersion;
        if (this.fileStore == null) {
            return l - (long)this.versionsToKeep;
        }
        long l2 = this.currentStoreVersion;
        if (l2 > -1L) {
            l = Math.min(l, l2);
        }
        return l;
    }

    private boolean isKnownVersion(long l) {
        String string;
        if (l > this.currentVersion || l < 0L) {
            return false;
        }
        if (l == this.currentVersion || this.chunks.size() == 0) {
            return true;
        }
        Chunk chunk = this.getChunkForVersion(l);
        if (chunk == null) {
            return false;
        }
        MVMap<String, String> mVMap = this.getMetaMap(l);
        if (mVMap == null) {
            return false;
        }
        Iterator<String> iterator = mVMap.keyIterator("chunk.");
        while (iterator.hasNext() && (string = iterator.next()).startsWith("chunk.")) {
            if (this.meta.containsKey(string)) continue;
            return false;
        }
        return true;
    }

    void registerUnsavedPage() {
        int n;
        if ((n = ++this.unsavedPageCount) > this.autoCommitPageCount && this.autoCommitPageCount > 0) {
            this.saveNeeded = true;
        }
    }

    void beforeWrite() {
        if (this.saveNeeded) {
            this.saveNeeded = false;
            this.commitAndSave();
        }
    }

    public int getStoreVersion() {
        this.checkOpen();
        String string = (String)this.meta.get("setting.storeVersion");
        return string == null ? 0 : Integer.parseInt(string);
    }

    public synchronized void setStoreVersion(int n) {
        this.checkOpen();
        this.markMetaChanged();
        this.meta.put("setting.storeVersion", Integer.toString(n));
    }

    public void rollback() {
        this.rollbackTo(this.currentVersion);
    }

    public synchronized void rollbackTo(long l) {
        Chunk object2;
        this.checkOpen();
        if (l == 0L) {
            for (MVMap<?, ?> mVMap : this.maps.values()) {
                mVMap.close();
            }
            this.meta.clear();
            this.chunks.clear();
            if (this.fileStore != null) {
                this.fileStore.clear();
            }
            this.maps.clear();
            this.freedPageSpace.clear();
            this.currentVersion = l;
            this.setWriteVersion(l);
            this.metaChanged = false;
            return;
        }
        DataUtils.checkArgument(this.isKnownVersion(l), "Unknown version {0}", l);
        for (MVMap<?, ?> mVMap : this.maps.values()) {
            mVMap.rollbackTo(l);
        }
        for (long i = this.currentVersion; i >= l && this.freedPageSpace.size() != 0; --i) {
            this.freedPageSpace.remove(i);
        }
        this.meta.rollbackTo(l);
        this.metaChanged = false;
        boolean bl = false;
        int n = -1;
        int n2 = this.lastChunkId;
        while ((object2 = this.chunks.get(n2)) != null) {
            if (object2.version >= l) {
                n = object2.id;
            }
            --n2;
        }
        if (n >= 0 && this.lastChunkId > n) {
            this.revertTemp(l);
            bl = true;
            Chunk chunk = null;
            while ((chunk = this.chunks.get(this.lastChunkId)) != null && chunk.id > n) {
                this.chunks.remove(this.lastChunkId);
                int n3 = MathUtils.roundUpInt(chunk.length, 4096) + 4096;
                this.fileStore.free(chunk.start, n3);
                --this.lastChunkId;
            }
            this.rootChunkStart = chunk.start;
            this.writeStoreHeader();
            byte[] byArray = this.getStoreHeaderBytes();
            ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
            byteBuffer.put(byArray);
            byteBuffer.rewind();
            this.fileStore.writeFully(this.fileStore.size(), byteBuffer);
            this.readStoreHeader();
            this.readMeta();
        }
        for (MVMap<?, ?> mVMap : New.arrayList(this.maps.values())) {
            int n3 = mVMap.getId();
            if (mVMap.getCreateVersion() >= l) {
                mVMap.close();
                this.maps.remove(n3);
                continue;
            }
            if (!bl) continue;
            String string = (String)this.meta.get("root." + n3);
            long l2 = string == null ? 0L : Long.parseLong(string);
            mVMap.setRootPos(l2, -1L);
        }
        Chunk chunk = this.chunks.get(this.lastChunkId - 1);
        if (chunk != null) {
            this.meta.put("chunk." + chunk.id, chunk.asString());
        }
        this.currentVersion = l;
        this.setWriteVersion(l);
    }

    private void revertTemp(long l) {
        Iterator<Object> iterator = this.freedPageSpace.keySet().iterator();
        while (iterator.hasNext()) {
            long l2 = (Long)iterator.next();
            if (l2 > l) continue;
            iterator.remove();
        }
        for (MVMap mVMap : this.maps.values()) {
            mVMap.removeUnusedOldVersions();
        }
    }

    public long getCurrentVersion() {
        return this.currentVersion;
    }

    public FileStore getFileStore() {
        return this.fileStore;
    }

    public Map<String, String> getStoreHeader() {
        return this.storeHeader;
    }

    private void checkOpen() {
        if (this.closed) {
            throw DataUtils.newIllegalStateException(4, "This store is closed", new Object[0]);
        }
    }

    public synchronized void renameMap(MVMap<?, ?> mVMap, String string) {
        this.checkOpen();
        DataUtils.checkArgument(mVMap != this.meta, "Renaming the meta map is not allowed", new Object[0]);
        int n = mVMap.getId();
        String string2 = this.getMapName(n);
        if (string2.equals(string)) {
            return;
        }
        DataUtils.checkArgument(!this.meta.containsKey("name." + string), "A map named {0} already exists", string);
        this.markMetaChanged();
        this.meta.remove("name." + string2);
        this.meta.put("map." + n, mVMap.asString(string));
        this.meta.put("name." + string, Integer.toString(n));
    }

    public synchronized void removeMap(MVMap<?, ?> mVMap) {
        this.checkOpen();
        DataUtils.checkArgument(mVMap != this.meta, "Removing the meta map is not allowed", new Object[0]);
        mVMap.clear();
        int n = mVMap.getId();
        String string = this.getMapName(n);
        this.markMetaChanged();
        this.meta.remove("map." + n);
        this.meta.remove("name." + string);
        this.meta.remove("root." + n);
        this.maps.remove(n);
    }

    public synchronized String getMapName(int n) {
        String string = (String)this.meta.get("map." + n);
        return string == null ? null : DataUtils.parseMap(string).get("name");
    }

    void commitInBackground() {
        block5: {
            if (this.unsavedPageCount == 0 || this.closed) {
                return;
            }
            long l = this.getTime();
            if (l <= this.lastCommitTime + (long)this.autoCommitDelay) {
                return;
            }
            if (!this.hasUnsavedChanges()) {
                return;
            }
            try {
                this.commitAndSave();
            }
            catch (Exception exception) {
                if (this.backgroundExceptionHandler == null) break block5;
                this.backgroundExceptionHandler.uncaughtException(null, exception);
            }
        }
    }

    public void setCacheSize(int n) {
        if (this.cache != null) {
            this.cache.setMaxMemory((long)n * 1024L * 1024L);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBackgroundThread() {
        BackgroundWriterThread backgroundWriterThread = this.backgroundWriterThread;
        if (backgroundWriterThread == null) {
            return;
        }
        this.backgroundWriterThread = null;
        Object object = backgroundWriterThread.sync;
        synchronized (object) {
            backgroundWriterThread.sync.notifyAll();
        }
        try {
            backgroundWriterThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAutoCommitDelay(int n) {
        if (this.autoCommitDelay == n) {
            return;
        }
        this.autoCommitDelay = n;
        if (this.fileStore == null) {
            return;
        }
        this.stopBackgroundThread();
        if (n > 0) {
            int n2 = Math.max(1, n / 10);
            BackgroundWriterThread backgroundWriterThread = new BackgroundWriterThread(this, n2, this.fileStore.toString());
            backgroundWriterThread.start();
            this.backgroundWriterThread = backgroundWriterThread;
        }
    }

    public int getAutoCommitDelay() {
        return this.autoCommitDelay;
    }

    public int getAutoCommitPageCount() {
        return this.autoCommitPageCount;
    }

    public int getUnsavedPageCount() {
        return this.unsavedPageCount;
    }

    void cachePage(long l, Page page, int n) {
        if (this.cache != null) {
            this.cache.put(l, page, n);
        }
    }

    public int getCacheSizeUsed() {
        if (this.cache == null) {
            return 0;
        }
        return (int)(this.cache.getUsedMemory() / 1024L / 1024L);
    }

    public int getCacheSize() {
        if (this.cache == null) {
            return 0;
        }
        return (int)(this.cache.getMaxMemory() / 1024L / 1024L);
    }

    public static class Builder {
        private final HashMap<String, Object> config = New.hashMap();

        private Builder set(String string, Object object) {
            this.config.put(string, object);
            return this;
        }

        public Builder autoCommitDisabled() {
            this.set("autoCommitBufferSize", 0);
            return this.set("autoCommitDelay", 0);
        }

        public Builder autoCommitBufferSize(int n) {
            return this.set("autoCommitBufferSize", n);
        }

        public Builder fileName(String string) {
            return this.set("fileName", string);
        }

        public Builder encryptionKey(char[] cArray) {
            return this.set("encryptionKey", cArray);
        }

        public Builder readOnly() {
            return this.set("readOnly", 1);
        }

        public Builder cacheSize(int n) {
            return this.set("cacheSize", n);
        }

        public Builder compressData() {
            return this.set("compress", 1);
        }

        public Builder pageSplitSize(int n) {
            return this.set("pageSplitSize", n);
        }

        public Builder backgroundExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            return this.set("backgroundExceptionHandler", uncaughtExceptionHandler);
        }

        public Builder fileStore(FileStore fileStore) {
            return this.set("fileStore", fileStore);
        }

        public MVStore open() {
            return new MVStore(this.config);
        }

        public String toString() {
            return DataUtils.appendMap(new StringBuilder(), this.config).toString();
        }

        public static Builder fromString(String string) {
            HashMap<String, String> hashMap = DataUtils.parseMap(string);
            Builder builder = new Builder();
            builder.config.putAll(hashMap);
            return builder;
        }
    }

    private static class BackgroundWriterThread
    extends Thread {
        public final Object sync = new Object();
        private final MVStore store;
        private final int sleep;

        BackgroundWriterThread(MVStore mVStore, int n, String string) {
            super("MVStore background writer " + string);
            this.store = mVStore;
            this.sleep = n;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BackgroundWriterThread backgroundWriterThread;
            while ((backgroundWriterThread = this.store.backgroundWriterThread) != null) {
                Object object = this.sync;
                synchronized (object) {
                    try {
                        this.sync.wait(this.sleep);
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                }
                this.store.commitInBackground();
            }
        }
    }
}

