/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.prog;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SVNUtils {
    private static final Pattern KEYWORD_PATTERN = Pattern.compile("^\\$\\p{Alpha}+:{0,2}\\p{Blank}*(.*?)\\p{Blank}*\\$");

    public static void main(String[] args) throws IOException {
        if (args[0].equals("lastChangedRev")) {
            System.out.println(SVNUtils.lastChangedRev(args[1]));
        } else {
            System.err.println("must choose a method");
        }
    }

    public static Process svn(String[] args) throws IOException {
        String[] cmdNArgs = new String[args.length + 1];
        cmdNArgs[0] = "svn";
        System.arraycopy(args, 0, cmdNArgs, 1, args.length);
        return Runtime.getRuntime().exec(cmdNArgs);
    }

    public static String lastChangedRev(String path) throws IOException {
        String line;
        Process p = SVNUtils.svn(new String[]{"info", String.valueOf(path) + "@HEAD"});
        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String res = null;
        while ((line = reader.readLine()) != null) {
            if (!line.startsWith("Last Changed Rev")) continue;
            res = line.substring(line.indexOf(58) + 1).trim();
        }
        return res;
    }

    public static String getKeywordValue(String substitute) throws IllegalArgumentException {
        Matcher matcher = KEYWORD_PATTERN.matcher(substitute);
        if (!matcher.find()) {
            throw new IllegalArgumentException("SVN format not recognized");
        }
        return matcher.group(1);
    }
}

