/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cc;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openconcerto.utils.cc.ITransformer;

public class TransformedSet<T, TT>
extends AbstractSet<TT> {
    private final Set<T> set;
    private final boolean modifiable;
    private final ITransformer<T, TT> transf;
    private final ITransformer<TT, T> invTransf;

    public TransformedSet(Set<T> set, ITransformer<T, TT> transf, ITransformer<TT, T> invTransf) {
        this(set, transf, invTransf, true);
    }

    public TransformedSet(Set<T> set, ITransformer<T, TT> transf, ITransformer<TT, T> invTransf, boolean modifiable) {
        if (transf == null) {
            throw new NullPointerException("null transformer");
        }
        this.set = set;
        this.modifiable = modifiable;
        this.transf = transf;
        this.invTransf = invTransf;
        if (this.modifiable && this.invTransf == null) {
            throw new IllegalArgumentException("Inverse transformation needed for mutable set");
        }
    }

    private void checkModifiable() {
        if (!this.modifiable) {
            throw new IllegalStateException("Unmodifiable set");
        }
    }

    @Override
    public final boolean add(TT e) {
        this.checkModifiable();
        return this.set.add(this.invTransf.transformChecked(e));
    }

    @Override
    public boolean addAll(Collection<? extends TT> c) {
        this.checkModifiable();
        List<T> toAdd = this.transformCollection(c);
        return this.set.addAll(toAdd);
    }

    private List<T> transformCollection(Collection<? extends TT> c) {
        ArrayList<T> toAdd = new ArrayList<T>(c.size());
        for (TT i : c) {
            toAdd.add(this.invTransf.transformChecked(i));
        }
        return toAdd;
    }

    @Override
    public final void clear() {
        this.checkModifiable();
        this.set.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.invTransf == null ? super.contains(o) : this.set.contains(this.invTransf.transformChecked(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.invTransf == null ? super.containsAll(c) : this.set.containsAll(this.transformCollection(c));
    }

    @Override
    public final boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public final Iterator<TT> iterator() {
        final Iterator<T> iter = this.set.iterator();
        return new Iterator<TT>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public TT next() {
                return TransformedSet.this.transf.transformChecked(iter.next());
            }

            @Override
            public void remove() {
                TransformedSet.this.checkModifiable();
                iter.remove();
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        this.checkModifiable();
        return this.set.remove(this.invTransf.transformChecked(o));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.checkModifiable();
        return this.set.removeAll(this.transformCollection(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.checkModifiable();
        return this.set.retainAll(this.transformCollection(c));
    }

    @Override
    public final int size() {
        return this.set.size();
    }

    @Override
    public Object[] toArray() {
        Object[] res = this.set.toArray();
        int i = 0;
        while (i < res.length) {
            res[i] = this.transf.transformChecked(res[i]);
            ++i;
        }
        return res;
    }
}

