/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.task.config;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.ui.ConnexionPanel;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.utils.Exiter;
import org.openconcerto.task.ModelStateListener;
import org.openconcerto.task.TodoListPanel;
import org.openconcerto.task.config.TaskPropsConfiguration;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.PanelFrame;
import org.openconcerto.ui.state.WindowStateManager;
import org.openconcerto.utils.JImage;

public class TaskNX
extends JFrame
implements ModelStateListener {
    private static TrayIcon trayIcon = null;

    public TaskNX(TaskPropsConfiguration conf) {
        this.setTitle("Task NX");
        TodoListPanel panel = new TodoListPanel(UserManager.getInstance());
        panel.addModelStateListener(this);
        this.setContentPane(panel);
        this.setDefaultCloseOperation(0);
        JMenuBar menuBar2 = new JMenuBar();
        JMenu menu = new JMenu("Fichier");
        AbstractAction min = new AbstractAction("Minimiser"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskNX.this.setState(1);
            }
        };
        final Exiter closeAll = new Exiter(this, false);
        AbstractAction quit = new AbstractAction("Quitter"){

            @Override
            public void actionPerformed(ActionEvent e) {
                closeAll.closeAll();
            }
        };
        menu.add(new JMenuItem(min));
        menu.add(new JMenuItem(quit));
        menuBar2.add(menu);
        this.setJMenuBar(menuBar2);
        WindowStateManager m = new WindowStateManager(this, new File(conf.getConfDir(), String.valueOf(this.getClass().getSimpleName()) + "-window.xml"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TaskNX.this.setState(1);
            }
        });
        this.addTray(quit);
        this.setLocation(10, 10);
        this.pack();
        m.loadState();
    }

    public static void main(String[] args) {
        System.setProperty("org.openconcerto.sql.structure.useXML", "true");
        final TaskPropsConfiguration conf = TaskPropsConfiguration.create();
        Configuration.setInstance(conf);
        final Runnable r = new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TaskNX f = new TaskNX(conf);
                        f.setVisible(true);
                    }
                });
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Toolkit.getDefaultToolkit().setDynamicLayout(true);
                System.setProperty("org.openconcerto.editpanel.noborder", "true");
                System.setProperty("org.openconcerto.editpanel.separator", "true");
                System.setProperty("org.openconcerto.listpanel.simpleui", "true");
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                JImage imageLogo = new JImage(TaskNX.class.getResource("logo.png"));
                boolean sharedSession = "inspecteur".equals(System.getProperty("user.name"));
                PanelFrame f = new PanelFrame(new ConnexionPanel(r, imageLogo, false, !sharedSession), "Connexion");
                f.pack();
                f.setResizable(false);
                f.setDefaultCloseOperation(2);
                f.setLocationRelativeTo(null);
                FrameUtil.show(f);
            }
        });
    }

    private void addTray(Action quit) {
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            Image image = new ImageIcon(TodoListPanel.class.getResource("low.png")).getImage();
            trayIcon = new TrayIcon(image, "TaskNX");
            PopupMenu popup = new PopupMenu();
            popup.add(new MenuItem((String)quit.getValue("Name")));
            popup.addActionListener(quit);
            trayIcon.setPopupMenu(popup);
            try {
                tray.add(trayIcon);
            }
            catch (AWTException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void stateChanged(int state) {
        if (state == 3 && this.getState() == 1 && trayIcon != null) {
            trayIcon.displayMessage("TaskNX", "Votre liste des t\u00e2ches vient d'\u00eatre modifi\u00e9e", TrayIcon.MessageType.INFO);
        }
    }
}

