/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.utils;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class SoundGenerator {
    private int sampleRate = 44100;
    public static final double A4 = 440.0;
    public static final byte FADE_NONE = 0;
    public static final byte FADE_LINEAR = 1;
    public static final byte FADE_QUADRATIC = 2;
    public static final byte WAVE_SIN = 0;
    public static final byte WAVE_SQUARE = 1;
    public static final byte WAVE_TRIANGLE = 2;
    public static final byte WAVE_SAWTOOTH = 3;
    private static final double BYTE_OSCI = 127.0;

    private static double linearFade(double i, int max) {
        return ((float)max - (float)i) / (float)max;
    }

    private static double quadraticFade(double i, int max) {
        return -1.0 / Math.pow(max, 2.0) * Math.pow(i, 2.0) + 1.0;
    }

    private static double sinWave(double i, double period) {
        return Math.sin(Math.PI * 2 * i / period);
    }

    private static double squareWave(double i, double period) {
        return i % period / period < 0.5 ? 1 : -1;
    }

    private static double triangleWave(double i, double period) {
        return Math.asin(Math.sin(Math.PI * 2 * (i / period)));
    }

    private static double sawtoothWave(double i, double period) {
        return -1.0 + 2.0 * (i % period / period);
    }

    public void playGradient(double fstart, double fend, double duration, double volume, byte fadeend, byte wave) {
        byte[] freqdata = new byte[(int)(duration * (double)this.sampleRate)];
        int i = 0;
        while (i < freqdata.length) {
            freqdata[i] = (byte)this.generateValue(i, duration, fstart + (fend - fstart) * ((double)i / (double)freqdata.length), volume, fadeend, wave);
            ++i;
        }
        try {
            AudioFormat af = new AudioFormat(this.sampleRate, 8, 1, true, true);
            SourceDataLine line = AudioSystem.getSourceDataLine(af);
            line.open(af, this.sampleRate);
            line.start();
            line.write(freqdata, 0, freqdata.length);
            line.drain();
            line.close();
        }
        catch (LineUnavailableException e) {
            throw new IllegalStateException(e);
        }
    }

    public void playSounds(double[] freqs, double duration, double volume, byte fade, byte wave) {
        if (freqs.length == 0) {
            throw new IllegalArgumentException("no frequences");
        }
        volume /= (double)freqs.length;
        double[][] soundData = new double[freqs.length][];
        int i = 0;
        while (i < soundData.length) {
            soundData[i] = this.generateSoundData(freqs[i], duration, volume, fade, wave);
            ++i;
        }
        byte[] freqdata = new byte[soundData[0].length];
        int i2 = 0;
        while (i2 < soundData[0].length) {
            int j = 0;
            while (j < soundData.length) {
                int n = i2;
                freqdata[n] = (byte)(freqdata[n] + (byte)soundData[j][i2]);
                ++j;
            }
            ++i2;
        }
        try {
            AudioFormat af = new AudioFormat(this.sampleRate, 8, 1, true, true);
            SourceDataLine line = AudioSystem.getSourceDataLine(af);
            line.open(af, this.sampleRate);
            line.start();
            line.write(freqdata, 0, freqdata.length);
            line.drain();
            line.close();
        }
        catch (LineUnavailableException e) {
            throw new IllegalStateException(e);
        }
    }

    public void playSound(double freq, double duration, double volume, byte fade, byte wave) {
        double[] soundData = this.generateSoundData(freq, duration, volume, fade, wave);
        byte[] freqdata = new byte[soundData.length];
        int i = 0;
        while (i < soundData.length) {
            freqdata[i] = (byte)soundData[i];
            ++i;
        }
        try {
            AudioFormat af = new AudioFormat(this.sampleRate, 8, 1, true, true);
            SourceDataLine line = AudioSystem.getSourceDataLine(af);
            line.open(af, this.sampleRate);
            line.start();
            line.write(freqdata, 0, freqdata.length);
            line.drain();
            line.close();
        }
        catch (LineUnavailableException e) {
            throw new IllegalStateException(e);
        }
    }

    public double generateValue(double i, double duration, double freq, double volume, byte fade, byte wave) {
        double period = (double)this.sampleRate / freq;
        double fadeData = 0.0;
        double waveData = 0.0;
        int length = (int)(duration * (double)this.sampleRate);
        switch (fade) {
            case 0: {
                fadeData = 1.0;
                break;
            }
            case 1: {
                fadeData = SoundGenerator.linearFade(i, length);
                break;
            }
            case 2: {
                fadeData = SoundGenerator.quadraticFade(i, length);
                break;
            }
            default: {
                fadeData = 1.0;
            }
        }
        switch (wave) {
            case 0: {
                waveData = SoundGenerator.sinWave(i, period);
                break;
            }
            case 1: {
                waveData = SoundGenerator.squareWave(i, period);
                break;
            }
            case 2: {
                waveData = SoundGenerator.triangleWave(i, period);
                break;
            }
            case 3: {
                waveData = SoundGenerator.sawtoothWave(i, period);
                break;
            }
            default: {
                waveData = SoundGenerator.sinWave(i, period);
            }
        }
        return waveData * 127.0 * fadeData * volume;
    }

    public double[] generateSoundData(double freq, double duration, double volume, byte fade, byte wave) {
        double[] freqdata = new double[(int)(duration * (double)this.sampleRate)];
        int i = 0;
        while (i < freqdata.length) {
            freqdata[i] = this.generateValue(i, duration, freq, volume, fade, wave);
            ++i;
        }
        return freqdata;
    }

    public void sampleRate(int sr) {
        this.sampleRate = sr;
    }

    public int sampleRate() {
        return this.sampleRate;
    }
}

