/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.supplychain.stock.element.MouvementStockSQLElement;
import org.openconcerto.erp.generationEcritures.GenerationMvtSaisieVenteComptoir;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.erp.preferences.ModeReglementDefautPrefPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.SQLSearchableTextCombo;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.ui.warning.JLabelWarning;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.EmptyObj;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class SaisieVenteComptoirSQLElement
extends ComptaSQLConfElement {
    public SaisieVenteComptoirSQLElement() {
        super("SAISIE_VENTE_COMPTOIR", "une saisie d'une vente comptoir", "saisies de  ventes comptoir");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("NOM");
        l.add("ID_CLIENT");
        l.add("ID_MODE_REGLEMENT");
        l.add("MONTANT_HT");
        l.add("MONTANT_SERVICE");
        l.add("MONTANT_TTC");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("MONTANT_TTC");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            private final JCheckBox checkService;
            private SQLSearchableTextCombo textNom;
            private DeviseField textMontantTTC;
            private DeviseField textMontantService;
            private ElementComboBox comboFournisseur;
            private JTextField textEcheance;
            private ElementComboBox comboTaxe;
            private DeviseField textMontantHT;
            private JCheckBox checkCommande;
            private JDate dateSaisie;
            private ElementComboBox nomArticle;
            private java.util.Date dateEch;
            private JLabel labelEcheancejours;
            private ElementComboBox comboAvoir;
            private ElementComboBox comboClient;
            private final JLabel labelWarning;
            private ValidState validState;
            private Where w;
            private DocumentListener docTTCListen;
            private PropertyChangeListener propertyChangeListener;
            {
                this.checkService = new JCheckBox("dont ");
                this.labelEcheancejours = new JLabel("jours");
                this.labelWarning = new JLabelWarning("le montant du service ne peut pas d\u00e9passer le total HT!");
                this.validState = ValidState.getTrueInstance();
                this.propertyChangeListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (nomArticle.getValidState().isValid() && !nomArticle.isEmpty() && !this.isFilling()) {
                            int idArticle = nomArticle.getValue();
                            SQLTable tableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
                            SQLRow rowArticle = tableArticle.getRow(idArticle);
                            if (rowArticle != null) {
                                comboTaxe.setValue(rowArticle.getInt("ID_TAXE"));
                                textMontantTTC.setText(((BigDecimal)rowArticle.getObject("PV_TTC")).toString());
                            }
                            System.out.println("value article Changed");
                        }
                    }
                };
            }

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                this.docTTCListen = new DocumentListener(){

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.calculMontant();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.calculMontant();
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.calculMontant();
                    }
                };
                c.gridwidth = 0;
                c.gridheight = 1;
                TitledSeparator sep = new TitledSeparator("Renseignements");
                this.add((Component)sep, c);
                c.insets = new Insets(2, 2, 1, 2);
                c.gridwidth = 1;
                JLabel labelNom = new JLabel(this.getLabelFor("NOM"));
                labelNom.setHorizontalAlignment(4);
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                this.add((Component)labelNom, c);
                this.textNom = new SQLSearchableTextCombo();
                ++c.gridx;
                c.weightx = 1.0;
                c.gridwidth = 2;
                this.add((Component)this.textNom, c);
                JLabel labelDate = new JLabel(this.getLabelFor("DATE"));
                this.dateSaisie = new JDate(true);
                c.gridwidth = 1;
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 0.0;
                labelDate.setHorizontalAlignment(4);
                this.add((Component)labelDate, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.dateSaisie, c);
                ++c.gridy;
                c.gridx = 0;
                this.nomArticle = new ElementComboBox();
                JLabel labelNomArticle = new JLabel(this.getLabelFor("ID_ARTICLE"));
                c.weightx = 0.0;
                labelNomArticle.setHorizontalAlignment(4);
                ++c.gridx;
                c.weightx = 0.0;
                c.gridwidth = 0;
                this.nomArticle.addValueListener(this.propertyChangeListener);
                this.comboClient = new ElementComboBox();
                this.comboClient.addValueListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (comboClient.isEmpty()) {
                            w = new Where((FieldRef)this.getTable().getBase().getTable("AVOIR_CLIENT").getField("ID_CLIENT"), "=", -1);
                        } else {
                            w = new Where((FieldRef)this.getTable().getBase().getTable("AVOIR_CLIENT").getField("ID_CLIENT"), "=", comboClient.getSelectedId());
                        }
                    }
                });
                JLabel labelNomClient = new JLabel(this.getLabelFor("ID_CLIENT"));
                ++c.gridy;
                c.gridx = 0;
                c.gridwidth = 1;
                c.weightx = 0.0;
                labelNomClient.setHorizontalAlignment(4);
                this.add((Component)labelNomClient, c);
                ++c.gridx;
                c.gridwidth = 0;
                c.weightx = 0.0;
                this.add((Component)this.comboClient, c);
                this.comboAvoir = new ElementComboBox();
                JLabel labelAvoirClient = new JLabel(this.getLabelFor("ID_AVOIR_CLIENT"));
                ++c.gridy;
                c.gridx = 0;
                c.gridwidth = 1;
                c.weightx = 0.0;
                labelAvoirClient.setHorizontalAlignment(4);
                ++c.gridx;
                c.gridwidth = 0;
                c.weightx = 0.0;
                JLabel labelCptProduit = new JLabel(this.getLabelFor("ID_COMPTE_PCE_PRODUIT"));
                ++c.gridy;
                c.gridx = 0;
                c.gridwidth = 1;
                c.weightx = 0.0;
                labelCptProduit.setHorizontalAlignment(4);
                this.add((Component)labelCptProduit, c);
                ++c.gridx;
                c.gridwidth = 0;
                c.weightx = 0.0;
                ElementComboBox comboCptProduit = new ElementComboBox();
                this.add((Component)comboCptProduit, c);
                this.addView(comboCptProduit, "ID_COMPTE_PCE_PRODUIT");
                JLabel labelCptService = new JLabel(this.getLabelFor("ID_COMPTE_PCE_SERVICE"));
                ++c.gridy;
                c.gridx = 0;
                c.gridwidth = 1;
                c.weightx = 0.0;
                labelCptService.setHorizontalAlignment(4);
                this.add((Component)labelCptService, c);
                ++c.gridx;
                c.gridwidth = 0;
                c.weightx = 0.0;
                ElementComboBox comboCptService = new ElementComboBox();
                this.add((Component)comboCptService, c);
                this.addView(comboCptService, "ID_COMPTE_PCE_SERVICE");
                c.gridwidth = 0;
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 1.0;
                sep = new TitledSeparator("Montant en Euros");
                c.insets = new Insets(10, 2, 1, 2);
                this.add((Component)sep, c);
                c.insets = new Insets(2, 2, 1, 2);
                c.gridwidth = 1;
                JLabel labelMontantHT = new JLabel(this.getLabelFor("MONTANT_HT"));
                labelMontantHT.setHorizontalAlignment(4);
                this.textMontantHT = new DeviseField();
                this.textMontantHT.setEditable(false);
                this.textMontantHT.setEnabled(false);
                this.textMontantHT.setFocusable(false);
                JLabel labelMontantTTC = new JLabel(this.getLabelFor("MONTANT_TTC"));
                labelMontantTTC.setHorizontalAlignment(4);
                this.textMontantTTC = new DeviseField();
                this.textMontantTTC.getDocument().addDocumentListener(this.docTTCListen);
                c.fill = 2;
                c.weightx = 0.0;
                ++c.gridy;
                c.gridx = 0;
                c.gridwidth = 1;
                this.add((Component)labelMontantHT, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textMontantHT, c);
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)this.checkService, c);
                this.checkService.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (this.isFilling()) {
                            return;
                        }
                        boolean b = checkService.isSelected();
                        textMontantService.setEditable(b);
                        textMontantService.setEnabled(b);
                        textMontantService.setFocusable(b);
                        if (!b) {
                            textMontantService.setText("");
                        } else {
                            textMontantService.setText(textMontantHT.getText());
                        }
                    }
                });
                this.textMontantService = new DeviseField();
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textMontantService, c);
                JLabel labelMontantService = new JLabel("de service HT");
                c.weightx = 0.0;
                ++c.gridx;
                this.add((Component)labelMontantService, c);
                ++c.gridx;
                c.gridwidth = 0;
                this.add((Component)this.labelWarning, c);
                this.labelWarning.setVisible(false);
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                c.gridwidth = 1;
                JLabel labelTaxe = new JLabel(this.getLabelFor("ID_TAXE"));
                labelTaxe.setHorizontalAlignment(4);
                this.add((Component)labelTaxe, c);
                ++c.gridx;
                this.comboTaxe = new ElementComboBox(false);
                c.fill = 0;
                this.add((Component)this.comboTaxe, c);
                c.fill = 2;
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                this.add((Component)labelMontantTTC, c);
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)this.textMontantTTC, c);
                c.gridwidth = 0;
                c.gridx = 0;
                ++c.gridy;
                sep = new TitledSeparator("Mode de r\u00e8glement");
                c.insets = new Insets(10, 2, 1, 2);
                this.add((Component)sep, c);
                c.insets = new Insets(2, 2, 1, 2);
                c.gridx = 0;
                ++c.gridy;
                c.gridwidth = 0;
                this.addView("ID_MODE_REGLEMENT", "required;notdecorated;noseparator");
                ElementSQLObject eltModeRegl = (ElementSQLObject)this.getView("ID_MODE_REGLEMENT");
                this.add((Component)eltModeRegl, c);
                c.gridwidth = 0;
                c.gridx = 0;
                ++c.gridy;
                sep = new TitledSeparator("Commande");
                c.insets = new Insets(10, 2, 1, 2);
                this.add((Component)sep, c);
                c.insets = new Insets(2, 2, 1, 2);
                this.checkCommande = new JCheckBox("Produit \u00e0 commander");
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 0.0;
                c.gridwidth = 2;
                this.checkCommande.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        boolean b = checkCommande.isSelected();
                        comboFournisseur.setEnabled(b);
                        comboFournisseur.setInteractionMode(b ? InteractionMode.READ_WRITE : InteractionMode.DISABLED);
                        textEcheance.setEditable(b);
                        textEcheance.setEnabled(b);
                        this.updateValidState();
                    }
                });
                JLabel labelFournisseur = new JLabel(this.getLabelFor("ID_FOURNISSEUR"));
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 0.0;
                c.gridwidth = 1;
                labelFournisseur.setHorizontalAlignment(4);
                this.comboFournisseur = new ElementComboBox();
                ++c.gridx;
                c.weightx = 1.0;
                c.gridwidth = 4;
                JLabel labelEcheance = new JLabel("Echeance");
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 0.0;
                c.gridwidth = 1;
                labelEcheance.setHorizontalAlignment(4);
                ++c.gridx;
                c.weightx = 1.0;
                this.textEcheance = new JTextField();
                this.textEcheance.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyReleased(KeyEvent e) {
                        this.calculDate();
                    }
                });
                ++c.gridx;
                c.weightx = 0.0;
                c.gridwidth = 0;
                c.gridx = 0;
                ++c.gridy;
                sep = new TitledSeparator("Informations compl\u00e9mentaires");
                c.insets = new Insets(10, 2, 1, 2);
                c.insets = new Insets(2, 2, 1, 2);
                ITextArea textInfos = new ITextArea();
                c.gridx = 0;
                ++c.gridy;
                c.gridheight = 0;
                c.gridwidth = 0;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.fill = 1;
                this.addSQLObject(this.textNom, "NOM");
                this.addRequiredSQLObject(this.comboClient, "ID_CLIENT");
                this.addSQLObject(this.nomArticle, "ID_ARTICLE");
                this.addRequiredSQLObject(this.textMontantTTC, "MONTANT_TTC");
                this.addRequiredSQLObject(this.textMontantHT, "MONTANT_HT");
                this.addSQLObject(this.textMontantService, "MONTANT_SERVICE");
                this.addRequiredSQLObject(this.dateSaisie, "DATE");
                this.addSQLObject(textInfos, "INFOS");
                this.addSQLObject(this.comboFournisseur, "ID_FOURNISSEUR");
                this.addSQLObject(this.textEcheance, "ECHEANCE");
                this.addRequiredSQLObject(this.comboTaxe, "ID_TAXE");
                this.addSQLObject(this.comboAvoir, "ID_AVOIR_CLIENT");
                this.comboTaxe.setButtonsVisible(false);
                this.comboTaxe.setValue(2);
                this.checkService.setSelected(false);
                this.textMontantService.setEditable(false);
                this.textMontantService.setEnabled(false);
                this.checkCommande.setSelected(false);
                this.comboFournisseur.setInteractionMode(InteractionMode.DISABLED);
                this.comboFournisseur.setEnabled(false);
                this.textEcheance.setEditable(false);
                this.textEcheance.setEnabled(false);
                this.comboTaxe.addValueListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        this.calculMontant();
                    }
                });
                SimpleDocumentListener docL = new SimpleDocumentListener(){

                    @Override
                    public void update(DocumentEvent e) {
                        this.updateValidState();
                    }
                };
                this.textMontantService.getDocument().addDocumentListener(docL);
                this.textMontantHT.getDocument().addDocumentListener(docL);
                this.comboFournisseur.addEmptyListener(new EmptyListener(){

                    @Override
                    public void emptyChange(EmptyObj src, boolean newValue) {
                        this.updateValidState();
                    }
                });
            }

            @Override
            public Set<String> getPartialResetNames() {
                HashSet<String> s = new HashSet<String>();
                s.addAll(super.getPartialResetNames());
                s.add("MONTANT_TTC");
                s.add("MONTANT_SERVICE");
                s.add("MONTANT_HT");
                s.add("NOM");
                s.add("ID_AVOIR_CLIENT");
                s.add("ID_ARTICLE");
                s.add("INFOS");
                return s;
            }

            private void calculMontant() {
                SQLRow ligneTaxe;
                int idTaxe;
                if (!this.isFilling() && (idTaxe = this.comboTaxe.getSelectedId()) > 1 && (ligneTaxe = this.getTable().getBase().getTable("TAXE").getRow(idTaxe)) != null) {
                    float taux = ligneTaxe.getFloat("TAUX") / 100.0f;
                    if (this.textMontantTTC.getText().trim().length() > 0) {
                        PrixTTC pTTC = this.textMontantTTC.getText().trim().equals("-") ? new PrixTTC(0L) : new PrixTTC(GestionDevise.parseLongCurrency(this.textMontantTTC.getText()));
                        this.updateTextHT(GestionDevise.currencyToString(pTTC.calculLongHT(taux)));
                    } else {
                        this.updateTextHT("");
                    }
                }
            }

            private boolean isMontantServiceValid() {
                String montant = this.textMontantService.getText().trim();
                String montantHT = this.textMontantHT.getText().trim();
                boolean b = montant.length() == 0 ? true : (montantHT.length() == 0 ? false : GestionDevise.parseLongCurrency(montantHT) >= GestionDevise.parseLongCurrency(montant));
                this.labelWarning.setVisible(!b);
                System.err.println("Montant service is valid ? " + b + " --> HT val " + montantHT + " --> service val " + montant);
                return b;
            }

            private void updateTextHT(final String prixHT) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        textMontantHT.setText(prixHT);
                    }
                });
            }

            @Override
            protected SQLRowValues createDefaults() {
                SQLRowValues vals = new SQLRowValues(this.getTable());
                try {
                    SQLRow r = ModeReglementDefautPrefPanel.getDefaultRow(true);
                    SQLElement eltModeReglement = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
                    if (((SQLRowAccessor)r).getID() > 1) {
                        SQLRowValues rowVals = eltModeReglement.createCopy(((SQLRowAccessor)r).getID());
                        System.err.println(rowVals.getInt("ID_TYPE_REGLEMENT"));
                        vals.put("ID_MODE_REGLEMENT", (Object)rowVals);
                    }
                }
                catch (SQLException e) {
                    System.err.println("Impossible de s\u00e9lectionner le mode de r\u00e8glement par d\u00e9faut du client.");
                    e.printStackTrace();
                }
                return vals;
            }

            private void calculDate() {
                int aJ = 0;
                if (this.textEcheance.getText().trim().length() != 0) {
                    try {
                        aJ = Integer.parseInt(this.textEcheance.getText());
                    }
                    catch (Exception e) {
                        System.out.println("Erreur de format sur TextField Ajour " + this.textEcheance.getText());
                    }
                }
                Calendar cal = Calendar.getInstance();
                cal.setTime(new java.util.Date());
                long tempsMil = (long)aJ * 86400000L;
                cal.setTimeInMillis(cal.getTimeInMillis() + tempsMil);
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
                this.dateEch = cal.getTime();
                this.labelEcheancejours.setText("jours, soit le " + dateFormat.format(this.dateEch));
            }

            private void updateValidState() {
                this.setValidState(this.computeValidState());
            }

            private ValidState computeValidState() {
                ValidState res = ValidState.getTrueInstance();
                if (!this.isMontantServiceValid()) {
                    res = res.and(ValidState.createCached(false, this.labelWarning.getText()));
                }
                if (this.checkCommande.isSelected()) {
                    res = res.and(ValidState.createCached(!this.comboFournisseur.isEmpty(), "Fournisseur non renseign\u00e9"));
                }
                return res;
            }

            private final void setValidState(ValidState validState) {
                if (!validState.equals(this.validState)) {
                    this.validState = validState;
                    this.fireValidChange();
                }
            }

            @Override
            public synchronized ValidState getValidState() {
                return super.getValidState().and(this.validState);
            }

            @Override
            public int insert(SQLRow order) {
                SQLRow rowArt;
                if (this.nomArticle.isEmpty()) {
                    this.createArticle();
                }
                if (this.textNom.getValue() == null || ((String)this.textNom.getValue()).trim().length() <= 0) {
                    this.textNom.setValue(this.nomArticle.getTextComp().getText());
                }
                final int id = super.insert(order);
                if (this.checkCommande.isSelected()) {
                    this.createCommande(id);
                }
                if ((rowArt = this.getTable().getRow(id).getForeignRow("ID_ARTICLE")) != null && !rowArt.isUndefined() && rowArt.getBoolean("GESTION_STOCK").booleanValue()) {
                    Configuration.getInstance().getNonInteractiveSQLExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            SQLRow rowVC = this.getTable().getRow(id);
                            SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
                            SQLRowValues rowVals = new SQLRowValues(eltMvtStock.getTable());
                            rowVals.put("QTE", -1);
                            rowVals.put("NOM", "Saisie vente comptoir");
                            rowVals.put("IDSOURCE", id);
                            rowVals.put("SOURCE", this.getTable().getName());
                            rowVals.put("ID_ARTICLE", rowVC.getInt("ID_ARTICLE"));
                            rowVals.put("ID_STOCK", rowVC.getForeign("ID_ARTICLE").getForeignID("ID_STOCK"));
                            rowVals.put("DATE", rowVC.getObject("DATE"));
                            try {
                                SQLRow row = rowVals.insert();
                                ListMap<SQLRow, SQLRowValues> map = ((MouvementStockSQLElement)Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK")).updateStock(Arrays.asList(row), false);
                                MouvementStockSQLElement.createCommandeF(map, null);
                            }
                            catch (SQLException e) {
                                ExceptionHandler.handle("Erreur lors de la cr\u00e9ation des mouvements de stock", e);
                            }
                        }
                    });
                }
                new GenerationMvtSaisieVenteComptoir(id);
                return id;
            }

            private void createCommande(int id) {
                System.out.println("Ajout d'une commande");
                SQLRow rowSaisie = SaisieVenteComptoirSQLElement.this.getTable().getRow(id);
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("NOM", rowSaisie.getObject("NOM"));
                m.put("DATE", rowSaisie.getObject("DATE"));
                m.put("DATE_ECHEANCE", new Date(this.dateEch.getTime()));
                m.put("IDSOURCE", new Integer(id));
                m.put("SOURCE", "SAISIE_VENTE_COMPTOIR");
                m.put("ID_CLIENT", rowSaisie.getObject("ID_CLIENT"));
                m.put("ID_FOURNISSEUR", rowSaisie.getObject("ID_FOURNISSEUR"));
                m.put("ID_ARTICLE", rowSaisie.getObject("ID_ARTICLE"));
                SQLTable tableCmd = this.getTable().getBase().getTable("COMMANDE_CLIENT");
                SQLRowValues valCmd = new SQLRowValues(tableCmd, m);
                try {
                    if (valCmd.getInvalid() == null) {
                        valCmd.insert();
                    }
                }
                catch (Exception e) {
                    System.err.println("Erreur \u00e0 l'insertion dans la table " + valCmd.getTable().getName());
                    e.printStackTrace();
                }
            }

            private void createArticle() {
                System.out.println("Cr\u00e9ation de l'article");
                String tNomArticle = this.nomArticle.getTextComp().getText();
                String codeArticle = "";
                if (tNomArticle.trim().length() == 0 && codeArticle.trim().length() == 0) {
                    return;
                }
                SQLTable articleTable = this.getTable().getBase().getTable("ARTICLE");
                int idTaxe = this.comboTaxe.getSelectedId();
                BigDecimal prix = StringUtils.getBigDecimalFromUserText(this.textMontantHT.getText());
                BigDecimal prixTTC = StringUtils.getBigDecimalFromUserText(this.textMontantTTC.getText());
                if (tNomArticle.trim().length() == 0) {
                    tNomArticle = "Nom Indefini";
                }
                if (codeArticle.trim().length() == 0) {
                    codeArticle = "Indefini";
                }
                SQLRowValues vals = new SQLRowValues(articleTable);
                vals.put("NOM", tNomArticle);
                vals.put("CODE", codeArticle);
                vals.put("PA_HT", prix);
                vals.put("PV_HT", prix);
                vals.put("PRIX_METRIQUE_VT_1", prix);
                vals.put("PRIX_METRIQUE_HA_1", prix);
                vals.put("PV_TTC", prixTTC);
                vals.put("ID_UNITE_VENTE", 2);
                vals.put("ID_TAXE", new Integer(idTaxe));
                vals.put("CREATION_AUTO", Boolean.TRUE);
                vals.put("GESTION_STOCK", Boolean.FALSE);
                try {
                    SQLRow row = vals.insert();
                    this.nomArticle.setValue(row);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void update() {
                if (JOptionPane.showConfirmDialog(this, "Attention en modifiant cette vente comptoir, vous supprimerez les ch\u00e9ques et les \u00e9ch\u00e9ances associ\u00e9s. Continuer?", "Modification de vente comptoir", 0) == 0) {
                    SQLRow row = this.getTable().getRow(this.getSelectedID());
                    SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
                    SQLSelect sel = new SQLSelect();
                    sel.addSelect(eltMvtStock.getTable().getField("ID"));
                    Where w = new Where((FieldRef)eltMvtStock.getTable().getField("IDSOURCE"), "=", row.getID());
                    Where w2 = new Where((FieldRef)eltMvtStock.getTable().getField("SOURCE"), "=", (Object)this.getTable().getName());
                    sel.setWhere(w.and(w2));
                    List l = (List)eltMvtStock.getTable().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
                    if (l != null) {
                        int i = 0;
                        while (i < l.size()) {
                            Object[] tmp = (Object[])l.get(i);
                            try {
                                eltMvtStock.archive(((Number)tmp[0]).intValue());
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                            ++i;
                        }
                    }
                    if (this.textNom.getValue() != null && ((String)this.textNom.getValue()).trim().length() <= 0) {
                        this.textNom.setValue(this.nomArticle.getTextComp().getText());
                    }
                    if (this.nomArticle.getValue() == null || Integer.parseInt(this.nomArticle.getValue().toString()) == -1) {
                        this.createArticle();
                    }
                    super.update();
                    row = this.getTable().getRow(this.getSelectedID());
                    int idMvt = row.getInt("ID_MOUVEMENT");
                    System.out.println(String.valueOf(row.getID()) + "__________***************** UPDATE " + idMvt);
                    EcritureSQLElement eltEcr = (EcritureSQLElement)Configuration.getInstance().getDirectory().getElement("ECRITURE");
                    eltEcr.archiveMouvementProfondeur(idMvt, false);
                    SQLRow rowArt = row.getForeignRow("ID_ARTICLE");
                    if (rowArt != null && !rowArt.isUndefined() && rowArt.getBoolean("GESTION_STOCK").booleanValue()) {
                        SQLRowValues rowVals = new SQLRowValues(eltMvtStock.getTable());
                        rowVals.put("QTE", -1);
                        rowVals.put("NOM", "Saisie vente comptoir");
                        rowVals.put("IDSOURCE", this.getSelectedID());
                        rowVals.put("SOURCE", this.getTable().getName());
                        rowVals.put("ID_ARTICLE", row.getInt("ID_ARTICLE"));
                        rowVals.put("ID_STOCK", row.getForeign("ID_ARTICLE").getForeignID("ID_STOCK"));
                        rowVals.put("DATE", row.getObject("DATE"));
                        try {
                            SQLRow rowNew = rowVals.insert();
                            final ListMap<SQLRow, SQLRowValues> map = ((MouvementStockSQLElement)Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK")).updateStock(Arrays.asList(rowNew), false);
                            ComptaPropsConfiguration.getInstanceCompta().getNonInteractiveSQLExecutor().execute(new Runnable(){

                                @Override
                                public void run() {
                                    MouvementStockSQLElement.createCommandeF(map, null);
                                }
                            });
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    if (idMvt > 1) {
                        new GenerationMvtSaisieVenteComptoir(this.getSelectedID(), idMvt);
                    } else {
                        new GenerationMvtSaisieVenteComptoir(this.getSelectedID());
                    }
                }
            }

            @Override
            public void select(SQLRowAccessor r) {
                this.textMontantTTC.getDocument().removeDocumentListener(this.docTTCListen);
                this.nomArticle.rmValueListener(this.propertyChangeListener);
                super.select(r);
                this.checkService.setSelected(r != null && r.getObject("MONTANT_SERVICE") != null && r.getLong("MONTANT_SERVICE") > 0L);
                this.textMontantTTC.getDocument().addDocumentListener(this.docTTCListen);
                this.nomArticle.addValueListener(this.propertyChangeListener);
            }

            @Override
            public void select(SQLRowAccessor r, Set<String> views) {
                super.select(r, views);
                this.checkService.setSelected(r != null && r.getObject("MONTANT_SERVICE") != null && r.getLong("MONTANT_SERVICE") > 0L);
            }
        };
    }

    @Override
    protected void archive(TreesOfSQLRows trees, boolean cutLinks) throws SQLException {
        super.archive(trees, cutLinks);
        for (SQLRow row : trees.getRows()) {
            SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
            SQLSelect sel = new SQLSelect(eltMvtStock.getTable().getBase());
            sel.addSelect(eltMvtStock.getTable().getField("ID"));
            Where w = new Where((FieldRef)eltMvtStock.getTable().getField("IDSOURCE"), "=", row.getID());
            Where w2 = new Where((FieldRef)eltMvtStock.getTable().getField("SOURCE"), "=", (Object)this.getTable().getName());
            sel.setWhere(w.and(w2));
            List l = (List)eltMvtStock.getTable().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
            if (l == null) continue;
            int i = 0;
            while (i < l.size()) {
                Object[] tmp = (Object[])l.get(i);
                eltMvtStock.archive(((Number)tmp[0]).intValue());
                ++i;
            }
        }
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".sale";
    }
}

