/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.openconcerto.erp.action.AboutAction;
import org.openconcerto.erp.action.AstuceAction;
import org.openconcerto.erp.action.GestionDroitsAction;
import org.openconcerto.erp.action.ListeBanqueAction;
import org.openconcerto.erp.action.NouvelleSocieteAction;
import org.openconcerto.erp.action.PreferencesAction;
import org.openconcerto.erp.action.SauvegardeBaseAction;
import org.openconcerto.erp.action.TaskAdminAction;
import org.openconcerto.erp.action.list.ListeDesSocietesCommonsAction;
import org.openconcerto.erp.action.list.ListeDesUsersCommonAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.MainFrame;
import org.openconcerto.erp.config.MenuAndActions;
import org.openconcerto.erp.config.MenuConfiguration;
import org.openconcerto.erp.core.customerrelationship.customer.action.ListeDesClientsAction;
import org.openconcerto.erp.core.customerrelationship.customer.action.ListeDesContactsAction;
import org.openconcerto.erp.core.customerrelationship.customer.action.ListeDesDepartementsClientsAction;
import org.openconcerto.erp.core.customerrelationship.customer.action.NouvelHistoriqueListeClientAction;
import org.openconcerto.erp.core.customerrelationship.mail.action.ListeDesModelesEmailAction;
import org.openconcerto.erp.core.finance.accounting.action.BalanceAgeeAction;
import org.openconcerto.erp.core.finance.accounting.action.CompteResultatBilanAction;
import org.openconcerto.erp.core.finance.accounting.action.EtatBalanceAction;
import org.openconcerto.erp.core.finance.accounting.action.EtatChargeAction;
import org.openconcerto.erp.core.finance.accounting.action.EtatGrandLivreAction;
import org.openconcerto.erp.core.finance.accounting.action.EtatJournauxAction;
import org.openconcerto.erp.core.finance.accounting.action.ExportRelationExpertAction;
import org.openconcerto.erp.core.finance.accounting.action.GestionPlanComptableEAction;
import org.openconcerto.erp.core.finance.accounting.action.ImportEcritureAction;
import org.openconcerto.erp.core.finance.accounting.action.ImportEcritureFECAction;
import org.openconcerto.erp.core.finance.accounting.action.ImpressionJournauxAnalytiqueAction;
import org.openconcerto.erp.core.finance.accounting.action.ImpressionLivrePayeAction;
import org.openconcerto.erp.core.finance.accounting.action.ImpressionRepartitionAnalytiqueAction;
import org.openconcerto.erp.core.finance.accounting.action.ListeDesCategorieComptableAction;
import org.openconcerto.erp.core.finance.accounting.action.ListeDesComptesAction;
import org.openconcerto.erp.core.finance.accounting.action.ListeDesDevisesAction;
import org.openconcerto.erp.core.finance.accounting.action.ListeDesEcrituresAction;
import org.openconcerto.erp.core.finance.accounting.action.ListeDesEcrituresAnalytiquesAction;
import org.openconcerto.erp.core.finance.accounting.action.ListeDesJournauxAction;
import org.openconcerto.erp.core.finance.accounting.action.ListeDesPostesAnalytiquesAction;
import org.openconcerto.erp.core.finance.accounting.action.ListeDesTauxDeChangeAction;
import org.openconcerto.erp.core.finance.accounting.action.ListeEcritureParClasseAction;
import org.openconcerto.erp.core.finance.accounting.action.NouveauClotureAction;
import org.openconcerto.erp.core.finance.accounting.action.NouveauClotureSansAnouveauxAction;
import org.openconcerto.erp.core.finance.accounting.action.NouveauLettrageAction;
import org.openconcerto.erp.core.finance.accounting.action.NouveauPointageAction;
import org.openconcerto.erp.core.finance.accounting.action.NouvelleValidationAction;
import org.openconcerto.erp.core.finance.accounting.ui.SaisieJournalAction;
import org.openconcerto.erp.core.finance.payment.action.ListeDesChequesAEncaisserAction;
import org.openconcerto.erp.core.finance.payment.action.ListeDesChequesAvoirAction;
import org.openconcerto.erp.core.finance.payment.action.ListeDesChequesFournisseursAction;
import org.openconcerto.erp.core.finance.payment.action.ListeDesDepostChequesAction;
import org.openconcerto.erp.core.finance.payment.action.ListeDesEncaissementsAction;
import org.openconcerto.erp.core.finance.payment.action.ListeDesRelancesAction;
import org.openconcerto.erp.core.finance.payment.action.ListeDesTraitesFournisseursAction;
import org.openconcerto.erp.core.finance.payment.action.NouveauDecaissementChequeAvoirAction;
import org.openconcerto.erp.core.finance.payment.action.NouveauListeDesChequesADecaisserAction;
import org.openconcerto.erp.core.finance.payment.action.NouveauListeDesChequesAEncaisserAction;
import org.openconcerto.erp.core.finance.payment.element.EncaisserMontantSQLElement;
import org.openconcerto.erp.core.finance.tax.action.ReportingEcoContributionPanel;
import org.openconcerto.erp.core.finance.tax.action.ReportingTaxeComplementairePanel;
import org.openconcerto.erp.core.humanresources.ListeDesContactsAdministratif;
import org.openconcerto.erp.core.humanresources.employe.action.ListeDesAyantsDroitsAction;
import org.openconcerto.erp.core.humanresources.employe.action.ListeDesCaissesCotisationsAction;
import org.openconcerto.erp.core.humanresources.employe.action.ListeDesCommerciauxAction;
import org.openconcerto.erp.core.humanresources.employe.action.ListeDesContratsPrevoyanceAction;
import org.openconcerto.erp.core.humanresources.employe.action.ListeDesSalariesAction;
import org.openconcerto.erp.core.humanresources.payroll.action.ClotureMensuellePayeAction;
import org.openconcerto.erp.core.humanresources.payroll.action.EditionFichePayeAction;
import org.openconcerto.erp.core.humanresources.payroll.action.ListeDesInfosSalariePayeAction;
import org.openconcerto.erp.core.humanresources.payroll.action.ListeDesProfilsPayeAction;
import org.openconcerto.erp.core.humanresources.payroll.action.ListeDesRubriquesDePayeAction;
import org.openconcerto.erp.core.humanresources.payroll.action.ListeDesVariablesPayes;
import org.openconcerto.erp.core.humanresources.payroll.action.NouvelAcompteAction;
import org.openconcerto.erp.core.humanresources.payroll.action.NouvelHistoriqueFichePayeAction;
import org.openconcerto.erp.core.humanresources.payroll.action.NouvelleSaisieKmAction;
import org.openconcerto.erp.core.reports.stat.action.EvolutionCAAction;
import org.openconcerto.erp.core.reports.stat.action.EvolutionCACumulAction;
import org.openconcerto.erp.core.reports.stat.action.EvolutionCmdAction;
import org.openconcerto.erp.core.reports.stat.action.EvolutionCmdCumulAction;
import org.openconcerto.erp.core.reports.stat.action.EvolutionMargeAction;
import org.openconcerto.erp.core.reports.stat.action.ReportingCommercialAction;
import org.openconcerto.erp.core.reports.stat.action.ReportingCommercialFournisseurAction;
import org.openconcerto.erp.core.reports.stat.action.VenteArticleFamilleGraphAction;
import org.openconcerto.erp.core.reports.stat.action.VenteArticleGraphAction;
import org.openconcerto.erp.core.reports.stat.action.VenteArticleMargeGraphAction;
import org.openconcerto.erp.core.sales.credit.action.ListeDesAvoirsClientsAction;
import org.openconcerto.erp.core.sales.credit.action.NouveauAvoirClientAction;
import org.openconcerto.erp.core.sales.invoice.action.EtatVenteAction;
import org.openconcerto.erp.core.sales.invoice.action.GenEtatStockAction;
import org.openconcerto.erp.core.sales.invoice.action.GenListeVenteAction;
import org.openconcerto.erp.core.sales.invoice.action.GenReportingVenteAction;
import org.openconcerto.erp.core.sales.invoice.action.ImportReglementSageAction;
import org.openconcerto.erp.core.sales.invoice.action.ListeDebiteursAction;
import org.openconcerto.erp.core.sales.invoice.action.ListeDesFactureItemsAction;
import org.openconcerto.erp.core.sales.invoice.action.ListeDesVentesAction;
import org.openconcerto.erp.core.sales.invoice.action.ListeEcheancePrelevementAction;
import org.openconcerto.erp.core.sales.invoice.action.ListeSDDMessageAction;
import org.openconcerto.erp.core.sales.invoice.action.ListeSaisieVenteFactureAction;
import org.openconcerto.erp.core.sales.invoice.action.ListesFacturesClientsImpayeesAction;
import org.openconcerto.erp.core.sales.invoice.action.NouveauSaisieVenteComptoirAction;
import org.openconcerto.erp.core.sales.invoice.action.NouveauSaisieVenteFactureAction;
import org.openconcerto.erp.core.sales.invoice.report.ReportingClientPanel;
import org.openconcerto.erp.core.sales.invoice.report.SituationCompteClientPanel;
import org.openconcerto.erp.core.sales.order.action.ListeDesCommandesClientAction;
import org.openconcerto.erp.core.sales.order.action.ListeDesCommandesClientItemsAction;
import org.openconcerto.erp.core.sales.order.action.ListeDesElementsACommanderClientAction;
import org.openconcerto.erp.core.sales.order.action.ListeDesFacturationCommandesClientAction;
import org.openconcerto.erp.core.sales.order.action.NouvelleCommandeClientAction;
import org.openconcerto.erp.core.sales.pos.action.ListeDesCaissesTicketAction;
import org.openconcerto.erp.core.sales.product.action.ListeDesArticlesAction;
import org.openconcerto.erp.core.sales.product.action.ListeEcoContributionAction;
import org.openconcerto.erp.core.sales.product.action.ListeHistoCodeClientArticleAction;
import org.openconcerto.erp.core.sales.product.action.TransfertStockAction;
import org.openconcerto.erp.core.sales.quote.action.ListeDesDevisAction;
import org.openconcerto.erp.core.sales.quote.action.NouveauDevisAction;
import org.openconcerto.erp.core.sales.shipment.action.ListeDesBonsDeLivraisonAction;
import org.openconcerto.erp.core.sales.shipment.action.ListeDesReliquatsBonsLivraisonsAction;
import org.openconcerto.erp.core.sales.shipment.action.NouveauBonLivraisonAction;
import org.openconcerto.erp.core.supplychain.credit.action.ListeDesAvoirsFournisseurAction;
import org.openconcerto.erp.core.supplychain.credit.action.NouvelAvoirFournisseurAction;
import org.openconcerto.erp.core.supplychain.order.action.ListeDesCommandesAction;
import org.openconcerto.erp.core.supplychain.order.action.ListeDesDemandesAchatsAction;
import org.openconcerto.erp.core.supplychain.order.action.ListeDesDemandesPrixAction;
import org.openconcerto.erp.core.supplychain.order.action.ListeDesElementsACommanderAction;
import org.openconcerto.erp.core.supplychain.order.action.ListeDesFacturesFournisseurAction;
import org.openconcerto.erp.core.supplychain.order.action.ListeSaisieAchatAction;
import org.openconcerto.erp.core.supplychain.order.action.NouveauSaisieAchatAction;
import org.openconcerto.erp.core.supplychain.order.action.NouvelleCommandeAction;
import org.openconcerto.erp.core.supplychain.order.action.NouvelleDemandePrixAction;
import org.openconcerto.erp.core.supplychain.order.action.NouvelleFactureFournisseurAction;
import org.openconcerto.erp.core.supplychain.product.action.ListeDesArticlesFournisseurAction;
import org.openconcerto.erp.core.supplychain.receipt.action.ListeDesBonsReceptionsAction;
import org.openconcerto.erp.core.supplychain.receipt.action.ListeDesReliquatsBonsReceptionsAction;
import org.openconcerto.erp.core.supplychain.receipt.action.NouveauBonReceptionAction;
import org.openconcerto.erp.core.supplychain.stock.action.ListeDesDepotsStocksAction;
import org.openconcerto.erp.core.supplychain.stock.action.ListeDesEtatsStocksAction;
import org.openconcerto.erp.core.supplychain.stock.action.ListeDesMouvementsStockAction;
import org.openconcerto.erp.core.supplychain.stock.action.ListeDesStocksAction;
import org.openconcerto.erp.core.supplychain.stock.action.NouvelleSaisieMouvementStockAction;
import org.openconcerto.erp.core.supplychain.supplier.action.ListeDesContactsFournisseursAction;
import org.openconcerto.erp.core.supplychain.supplier.action.ListeDesFournisseursAction;
import org.openconcerto.erp.core.supplychain.supplier.action.ListesFacturesFournImpayeesAction;
import org.openconcerto.erp.core.supplychain.supplier.action.NouvelHistoriqueListeFournAction;
import org.openconcerto.erp.modules.ModuleFrame;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.erp.preferences.GestionClientPreferencePanel;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.erp.rights.NXRights;
import org.openconcerto.erp.utils.correct.CorrectMouvement;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.users.rights.UserRights;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.PanelFrame;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.LayoutHints;

public class DefaultMenuConfiguration
implements MenuConfiguration {
    private ComptaPropsConfiguration configuration;

    public DefaultMenuConfiguration(ComptaPropsConfiguration configuration) {
        this.configuration = configuration;
    }

    public ComptaPropsConfiguration getConfiguration() {
        return this.configuration;
    }

    public void registerMenuTranslations() {
    }

    @Override
    public MenuAndActions createMenuAndActions() {
        MenuAndActions res = new MenuAndActions();
        this.createMenuGroup(res.getGroup());
        this.registerMenuActions(res);
        return res;
    }

    public void createMenuGroup(Group mGroup) {
        UserRights rights = UserRightsManager.getCurrentUserRights();
        mGroup.add(this.createFilesMenuGroup());
        mGroup.add(this.createCreationMenuGroup());
        mGroup.add(this.createListMenuGroup());
        if (rights.haveRight(ComptaUserRight.MENU)) {
            mGroup.add(this.createAccountingMenuGroup());
            mGroup.add(this.createStatsDocumentsGroup());
        }
        if (rights.haveRight(NXRights.ACCES_MENU_STAT.getCode())) {
            mGroup.add(this.createStatsMenuGroup());
        }
        mGroup.add(this.createPaymentMenuGroup());
        if (rights.haveRight(NXRights.LOCK_MENU_PAYE.getCode())) {
            mGroup.add(this.createPayrollMenuGroup());
        }
        if (rights.haveRight(NXRights.ACCES_MENU_STRUCTURE.getCode())) {
            mGroup.add(this.createOrganizationMenuGroup());
        }
        mGroup.add(this.createHelpMenuGroup());
        if (rights.haveRight(NXRights.LOCK_MENU_TEST.getCode())) {
            mGroup.add(this.createTestMenuGroup());
        }
    }

    public void registerMenuActions(MenuAndActions ma) {
        this.registerFilesMenuActions(ma);
        this.registerCreationMenuActions(ma);
        this.registerListMenuActions(ma);
        this.registerAccountingMenuActions(ma);
        this.registerStatsDocumentsActions(ma);
        this.registerStatsMenuActions(ma);
        this.registerPaymentMenuActions(ma);
        this.registerPayrollMenuActions(ma);
        this.registerOrganizationMenuActions(ma);
        this.registerHelpMenuActions(ma);
        this.registerHelpTestActions(ma);
    }

    public Group createFilesMenuGroup() {
        Group group = new Group("menu.file");
        if (UserRightsManager.getCurrentUserRights().haveRight("BACKUP")) {
            group.addItem("backup");
        }
        group.addItem("modules");
        group.addItem("preferences");
        group.addItem("quit");
        return group;
    }

    public Group createCreationMenuGroup() {
        Group group = new Group("menu.create");
        Boolean bModeVenteComptoir = DefaultNXProps.getInstance().getBooleanValue("ArticleVenteComptoir", true);
        UserRights rights = UserRightsManager.getCurrentUserRights();
        Group accountingGroup = new Group("accounting");
        if (rights.haveRight(ComptaUserRight.MENU)) {
            accountingGroup.addItem("accounting.entry.create");
            accountingGroup.addItem("accounting.entry.ledger.create");
        }
        group.add(accountingGroup);
        Group customerGroup = new Group("customer", LayoutHints.DEFAULT_NOLABEL_SEPARATED_GROUP_HINTS);
        customerGroup.addItem("customer.quote.create");
        customerGroup.addItem("customer.delivery.create");
        customerGroup.addItem("customer.order.create");
        if (bModeVenteComptoir.booleanValue() && rights.haveRight("VENTE_COMPTOIR")) {
            customerGroup.addItem("pos.sale.create");
        }
        customerGroup.addItem("customer.invoice.create");
        customerGroup.addItem("customer.credit.create");
        group.add(customerGroup);
        Group supplierGroup = new Group("supplier", LayoutHints.DEFAULT_NOLABEL_SEPARATED_GROUP_HINTS);
        group.add(supplierGroup);
        if (rights.haveRight(NXRights.LOCK_MENU_ACHAT.getCode())) {
            supplierGroup.addItem("supplier.order.create");
            supplierGroup.addItem("supplier.receipt.create");
            supplierGroup.addItem("supplier.purchase.create");
            supplierGroup.addItem("supplier.invoice.purchase.create");
            supplierGroup.addItem("supplier.credit.create");
            group.addItem("stock.io.create");
        }
        group.addItem("product.stock.transfert");
        return group;
    }

    public Group createHelpMenuGroup() {
        Group group = new Group("menu.help");
        group.addItem("information");
        group.addItem("tips");
        return group;
    }

    public Group createOrganizationMenuGroup() {
        Group group = new Group("menu.organization");
        UserRights rights = UserRightsManager.getCurrentUserRights();
        if (rights.haveRight(ComptaUserRight.MENU)) {
            Group gAccounting = new Group("menu.organization.accounting", LayoutHints.DEFAULT_NOLABEL_SEPARATED_GROUP_HINTS);
            gAccounting.addItem("accounting.chart");
            gAccounting.addItem("accounting.list");
            gAccounting.addItem("accounting.journal");
            gAccounting.addItem("accounting.category.list");
            gAccounting.addItem("accounting.checkDB");
            gAccounting.addItem("accounting.currency");
            gAccounting.addItem("accounting.currency.rates");
            group.add(gAccounting);
        }
        if (rights.haveRight("LOCK_MENU_ADMIN")) {
            Group gUser = new Group("menu.organization.user", LayoutHints.DEFAULT_NOLABEL_SEPARATED_GROUP_HINTS);
            gUser.addItem("user.list");
            gUser.addItem("user.right.list");
            gUser.addItem("user.task.right");
            group.add(gUser);
        }
        group.addItem("email.template.list");
        group.addItem("product.ecotax");
        group.addItem("office.contact.list");
        group.addItem("salesman.list");
        Group gPos = new Group("menu.organization.pos", LayoutHints.DEFAULT_NOLABEL_SEPARATED_GROUP_HINTS);
        gPos.addItem("pos.list");
        group.add(gPos);
        group.addItem("enterprise.list");
        group.addItem("divison.bank.list");
        group.addItem("enterprise.create");
        return group;
    }

    public Group createPayrollMenuGroup() {
        Group group = new Group("menu.payroll");
        group.addItem("payroll.list.report.print");
        group.addItem("payroll.profile.list");
        group.addItem("payroll.history");
        group.addItem("payroll.infos.history");
        group.addItem("payroll.create");
        group.addItem("payroll.deposit.create");
        group.addItem("employee.list");
        Group groupConfig = new Group("menu.payroll.config", LayoutHints.DEFAULT_NOLABEL_SEPARATED_GROUP_HINTS);
        groupConfig.addItem("payroll.section");
        groupConfig.addItem("payroll.variable");
        groupConfig.addItem("payroll.caisse");
        groupConfig.addItem("employee.contrat.prev.list");
        group.add(groupConfig);
        group.addItem("payroll.closing");
        return group;
    }

    public Group createPaymentMenuGroup() {
        Group group = new Group("menu.payment");
        UserRights rights = UserRightsManager.getCurrentUserRights();
        if (rights.haveRight(ComptaUserRight.MENU) || rights.haveRight(ComptaUserRight.POINTAGE_LETTRAGE)) {
            group.addItem("payment.checking.create");
            group.addItem("payment.reconciliation.create");
        }
        if (rights.haveRight(NXRights.GESTION_ENCAISSEMENT.getCode())) {
            Group gCustomer = new Group("menu.payment.customer");
            gCustomer.addItem("customer.invoice.unpaid.list");
            gCustomer.addItem("customer.payment.prelevement.list");
            gCustomer.addItem("customer.payment.report");
            gCustomer.addItem("customer.dept.list");
            gCustomer.addItem("customer.payment.list");
            gCustomer.addItem("customer.payment.followup.list");
            gCustomer.addItem("customer.payment.check.pending.list");
            gCustomer.addItem("customer.payment.check.pending.create");
            gCustomer.addItem("customer.payment.check.deposit.list");
            gCustomer.addItem("customer.credit.check.list");
            gCustomer.addItem("customer.credit.check.create");
            group.add(gCustomer);
        }
        if (rights.haveRight(NXRights.LOCK_MENU_ACHAT.getCode())) {
            Group gSupplier = new Group("menu.payment.supplier");
            gSupplier.addItem("supplier.invoice.unpaid.list");
            gSupplier.addItem("supplier.bill.list");
            gSupplier.addItem("supplier.payment.check.list");
            gSupplier.addItem("supplier.payment.check.pending.list");
            group.add(gSupplier);
        }
        return group;
    }

    public Group createStatsMenuGroup() {
        Group group = new Group("menu.stats");
        group.addItem("sales.graph");
        group.addItem("sales.graph.cumulate");
        group.addItem("sales.graph.cmd");
        group.addItem("sales.graph.cmd.cumulate");
        group.addItem("sales.margin.graph");
        group.addItem("sales.list.stock.report");
        group.addItem("sales.list.reporting");
        group.addItem("order.list.reporting");
        group.addItem("sales.list.report");
        group.addItem("sales.list.salesman.report");
        group.addItem("sales.list.salesman.supplier.report");
        group.addItem("sales.product.graph");
        group.addItem("sales.product.margin.graph");
        group.addItem("sales.product.family.graph");
        group.addItem("sales.list.graph");
        group.addItem("sales.report.ecocontribution");
        group.addItem("sales.report.taxesupp");
        return group;
    }

    public Group createStatsDocumentsGroup() {
        Group group = new Group("menu.report");
        group.addItem("accounting.costs.report");
        group.addItem("accounting.balance.report");
        return group;
    }

    public Group createAccountingMenuGroup() {
        Group group = new Group("menu.accounting");
        group.addItem("accounting.balance");
        group.addItem("accounting.client.balance");
        group.addItem("accounting.ledger");
        Group analytic = new Group("accounting.analytical");
        analytic.addItem("accounting.analytical.ledger");
        analytic.addItem("accounting.analytical.entries.ledger");
        analytic.addItem("accounting.analytical.ledger.global");
        analytic.addItem("accounting.analytical.dpt");
        group.add(analytic);
        group.addItem("accounting.general.ledger");
        group.addItem("accounting.entries.ledger");
        group.addItem("accounting.entries.list");
        Group gIO = new Group("menu.accounting.io", LayoutHints.DEFAULT_NOLABEL_SEPARATED_GROUP_HINTS);
        gIO.addItem("accounting.import");
        gIO.addItem("accounting.import.fec");
        gIO.addItem("accounting.export");
        group.add(gIO);
        Group gClosing = new Group("menu.accounting.closing", LayoutHints.DEFAULT_NOLABEL_SEPARATED_GROUP_HINTS);
        gClosing.addItem("accounting.validating");
        gClosing.addItem("accounting.closing");
        group.add(gClosing);
        return group;
    }

    public Group createListMenuGroup() {
        Group group = new Group("menu.list");
        Boolean bModeVenteComptoir = DefaultNXProps.getInstance().getBooleanValue("ArticleVenteComptoir", true);
        UserRights rights = UserRightsManager.getCurrentUserRights();
        Group gCustomer = new Group("menu.list.customer", LayoutHints.DEFAULT_NOLABEL_SEPARATED_GROUP_HINTS);
        gCustomer.addItem("customer.list");
        SQLPreferences prefs = SQLPreferences.getMemCached(this.configuration.getRootSociete());
        if (prefs.getBoolean(GestionClientPreferencePanel.DISPLAY_CLIENT_DPT, false)) {
            gCustomer.addItem("customer.department.list");
        }
        gCustomer.addItem("contact.list");
        if (rights.haveRight(NXRights.ACCES_HISTORIQUE.getCode())) {
            gCustomer.addItem("customer.history");
        }
        gCustomer.addItem("customer.quote.list");
        gCustomer.addItem("customer.order.list");
        gCustomer.addItem("customer.order.invoice.list");
        gCustomer.addItem("customer.order.list.details");
        gCustomer.addItem("customer.delivery.list");
        if (this.configuration.getRootSociete().contains("RELIQUAT_BR")) {
            gCustomer.addItem("customer.delivery.reliquat.list");
        }
        group.add(gCustomer);
        boolean useListDesVentesAction = bModeVenteComptoir;
        if (useListDesVentesAction) {
            gCustomer.addItem("sales.list");
        } else {
            gCustomer.addItem("customer.invoice.list");
        }
        gCustomer.addItem("customer.credit.list");
        gCustomer.addItem("sales.quote.element.list");
        gCustomer.addItem("customer.invoice.details.list");
        Group gSupplier = new Group("menu.list.supplier", LayoutHints.DEFAULT_NOLABEL_SEPARATED_GROUP_HINTS);
        gSupplier.addItem("supplier.list");
        gSupplier.addItem("supplier.contact.list");
        gSupplier.addItem("supplier.history");
        if (rights.haveRight(NXRights.LOCK_MENU_ACHAT.getCode())) {
            gSupplier.addItem("supplier.order.preview");
            gSupplier.addItem("supplier.order.ask");
            gSupplier.addItem("supplier.order.list");
            gSupplier.addItem("supplier.receipt.list");
            if (this.configuration.getRootSociete().contains("RELIQUAT_BR")) {
                gSupplier.addItem("supplier.receipt.reliquat.list");
            }
            gSupplier.addItem("supplier.purchase.list");
            gSupplier.addItem("supplier.invoice.purchase.list");
            gSupplier.addItem("supplier.credit.list");
        }
        group.add(gSupplier);
        Group gProduct = new Group("menu.list.product", LayoutHints.DEFAULT_NOLABEL_SEPARATED_GROUP_HINTS);
        gProduct.addItem("product.list");
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.STOCK_MULTI_DEPOT, false)) {
            gProduct.addItem("stock.depot.list");
            gProduct.addItem("stock.item.list");
        }
        gProduct.addItem("stock.io.list");
        gProduct.addItem("stock.io.state");
        gProduct.addItem("customer.order.waiting");
        gProduct.addItem("supplier.order.waiting");
        group.add(gProduct);
        return group;
    }

    public Group createTestMenuGroup() {
        Group group = new Group("menu.test");
        group.addItem("test.checkReplannedCmd");
        group.addItem("test.checkReplannedMultiCmd");
        group.addItem("test.lettrage.fact");
        group.addItem("test.lettrage.compt");
        group.addItem("test.lettrage.achat");
        return group;
    }

    public void registerFilesMenuActions(MenuAndActions mManager) {
        mManager.putAction(new SauvegardeBaseAction(), "backup");
        mManager.putAction(new AbstractAction(){
            private ModuleFrame frame = null;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.frame == null) {
                    this.frame = new ModuleFrame(DefaultMenuConfiguration.this.getConfiguration().getModuleManager());
                }
                this.frame.setLocationRelativeTo(null);
                FrameUtil.show(this.frame);
            }
        }, "modules");
        mManager.putAction(new PreferencesAction(this.getConfiguration().getModuleManager()), "preferences");
        mManager.putAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.getInstance().quit();
            }
        }, "quit");
    }

    public void registerCreationMenuActions(MenuAndActions mManager) {
        Boolean bModeVenteComptoir = DefaultNXProps.getInstance().getBooleanValue("ArticleVenteComptoir", true);
        UserRights rights = UserRightsManager.getCurrentUserRights();
        ComptaPropsConfiguration conf = this.getConfiguration();
        if (rights.haveRight(ComptaUserRight.MENU)) {
            mManager.putAction(new NouvelleSaisieKmAction(conf), "accounting.entry.create");
            mManager.putAction(new SaisieJournalAction(), "accounting.entry.ledger.create");
        }
        mManager.putAction(new NouveauDevisAction(conf), "customer.quote.create");
        mManager.putAction(new NouveauBonLivraisonAction(conf), "customer.delivery.create");
        mManager.putAction(new NouvelleCommandeClientAction(conf), "customer.order.create");
        if (bModeVenteComptoir.booleanValue() && rights.haveRight("VENTE_COMPTOIR")) {
            mManager.putAction(new NouveauSaisieVenteComptoirAction(conf), "pos.sale.create");
        }
        mManager.putAction(new NouveauSaisieVenteFactureAction(conf), "customer.invoice.create");
        mManager.putAction(new NouveauAvoirClientAction(conf), "customer.credit.create");
        mManager.putAction(new TransfertStockAction(conf), "product.stock.transfert");
        if (rights.haveRight(NXRights.LOCK_MENU_ACHAT.getCode())) {
            mManager.putAction(new NouvelleDemandePrixAction(conf), "supplier.order.ask.create");
            mManager.putAction(new NouvelleCommandeAction(conf), "supplier.order.create");
            mManager.putAction(new NouveauBonReceptionAction(conf), "supplier.receipt.create");
            mManager.putAction(new NouveauSaisieAchatAction(conf), "supplier.purchase.create");
            mManager.putAction(new NouvelleFactureFournisseurAction(conf), "supplier.invoice.purchase.create");
            mManager.putAction(new NouvelAvoirFournisseurAction(conf), "supplier.credit.create");
            mManager.putAction(new NouvelleSaisieMouvementStockAction(conf), "stock.io.create");
        }
    }

    public void registerListMenuActions(MenuAndActions mManager) {
        boolean useListDesVentesAction;
        ComptaPropsConfiguration conf = this.configuration;
        Boolean bModeVenteComptoir = DefaultNXProps.getInstance().getBooleanValue("ArticleVenteComptoir", true);
        UserRights rights = UserRightsManager.getCurrentUserRights();
        mManager.putAction(new ListeDesClientsAction(conf), "customer.list");
        SQLPreferences prefs = SQLPreferences.getMemCached(conf.getRootSociete());
        if (prefs.getBoolean(GestionClientPreferencePanel.DISPLAY_CLIENT_DPT, false)) {
            mManager.putAction(new ListeDesDepartementsClientsAction(conf), "customer.department.list");
        }
        mManager.putAction(new ListeDesContactsAction(conf), "contact.list");
        if (rights.haveRight(NXRights.ACCES_HISTORIQUE.getCode())) {
            mManager.putAction(new NouvelHistoriqueListeClientAction(), "customer.history");
        }
        mManager.putAction(new ListeDesDevisAction(conf), "customer.quote.list");
        mManager.putAction(new ListeDesCommandesClientAction(), "customer.order.list");
        mManager.putAction(new ListeDesFacturationCommandesClientAction(conf), "customer.order.invoice.list");
        mManager.putAction(new ListeDesCommandesClientItemsAction(conf), "customer.order.list.details");
        mManager.putAction(new ListeDesBonsDeLivraisonAction(conf), "customer.delivery.list");
        if (conf.getRootSociete().contains("RELIQUAT_BL")) {
            mManager.putAction(new ListeDesReliquatsBonsLivraisonsAction(), "customer.delivery.reliquat.list");
        }
        if (useListDesVentesAction = bModeVenteComptoir.booleanValue()) {
            mManager.putAction(new ListeDesVentesAction(conf), "sales.list");
        } else {
            mManager.putAction(new ListeSaisieVenteFactureAction(), "customer.invoice.list");
        }
        mManager.putAction(new ListeDesAvoirsClientsAction(conf), "customer.credit.list");
        mManager.putAction(new ListeDesFactureItemsAction(conf), "customer.invoice.details.list");
        mManager.putAction(new ListeDesFournisseursAction(), "supplier.list");
        mManager.putAction(new ListeDesContactsFournisseursAction(), "supplier.contact.list");
        mManager.putAction(new NouvelHistoriqueListeFournAction(), "supplier.history");
        if (rights.haveRight(NXRights.LOCK_MENU_ACHAT.getCode())) {
            mManager.putAction(new ListeDesCommandesAction(), "supplier.order.list");
            mManager.putAction(new ListeDesDemandesPrixAction(conf), "supplier.order.ask");
            mManager.putAction(new ListeDesDemandesAchatsAction(conf), "supplier.order.preview");
            mManager.putAction(new ListeDesReliquatsBonsReceptionsAction(), "supplier.receipt.reliquat.list");
            mManager.putAction(new ListeDesBonsReceptionsAction(), "supplier.receipt.list");
            mManager.putAction(new ListeSaisieAchatAction(), "supplier.purchase.list");
            mManager.putAction(new ListeDesFacturesFournisseurAction(), "supplier.invoice.purchase.list");
            mManager.putAction(new ListeDesAvoirsFournisseurAction(), "supplier.credit.list");
        }
        mManager.putAction(new ListeDesArticlesAction(), "product.list");
        mManager.putAction(new ListeHistoCodeClientArticleAction(), "product.customer.list");
        mManager.putAction(new ListeDesArticlesFournisseurAction(), "product.supplychain.list");
        mManager.putAction(new ListeDesDepotsStocksAction(), "stock.depot.list");
        mManager.putAction(new ListeDesStocksAction(), "stock.item.list");
        mManager.putAction(new ListeDesMouvementsStockAction(conf), "stock.io.list");
        mManager.putAction(new ListeDesEtatsStocksAction(conf), "stock.io.state");
        mManager.putAction(new ListeDesElementsACommanderClientAction(conf), "customer.order.waiting");
        mManager.putAction(new ListeDesElementsACommanderAction(conf), "supplier.order.waiting");
    }

    public void registerAccountingMenuActions(MenuAndActions mManager) {
        mManager.putAction(new EtatBalanceAction(), "accounting.balance");
        mManager.putAction(new BalanceAgeeAction(), "accounting.client.balance");
        mManager.putAction(new ImpressionJournauxAnalytiqueAction(), "accounting.analytical.ledger");
        mManager.putAction(new EtatJournauxAction(), "accounting.ledger");
        mManager.putAction(new EtatGrandLivreAction(), "accounting.general.ledger");
        mManager.putAction(new ListeDesEcrituresAction(), "accounting.entries.ledger");
        mManager.putAction(new ListeDesEcrituresAnalytiquesAction(), "accounting.analytical.entries.ledger");
        mManager.putAction(new ListeDesPostesAnalytiquesAction(), "accounting.analytical.dpt");
        mManager.putAction(new ImpressionRepartitionAnalytiqueAction(), "accounting.analytical.ledger.global");
        mManager.putAction(new ListeEcritureParClasseAction(), "accounting.entries.list");
        mManager.putAction(new NouvelleValidationAction(), "accounting.validating");
        mManager.putAction(new NouveauClotureAction(), "accounting.closing");
        mManager.putAction(new ImportEcritureAction(), "accounting.import");
        mManager.putAction(new ExportRelationExpertAction(), "accounting.export");
        mManager.putAction(new ImportEcritureFECAction(), "accounting.import.fec");
    }

    public void registerStatsDocumentsActions(MenuAndActions mManager) {
        mManager.putAction(new EtatChargeAction(), "accounting.costs.report");
        mManager.putAction(new CompteResultatBilanAction(), "accounting.balance.report");
    }

    public void registerStatsMenuActions(MenuAndActions mManager) {
        ComptaPropsConfiguration conf = this.getConfiguration();
        mManager.putAction(new EvolutionCAAction(), "sales.graph");
        mManager.putAction(new EvolutionCACumulAction(), "sales.graph.cumulate");
        mManager.putAction(new EvolutionCmdAction(), "sales.graph.cmd");
        mManager.putAction(new EvolutionCmdCumulAction(), "sales.graph.cmd.cumulate");
        mManager.putAction(new ReportingCommercialAction(conf.getRootSociete()), "sales.list.salesman.report");
        mManager.putAction(new ReportingCommercialFournisseurAction(conf), "sales.list.salesman.supplier.report");
        mManager.putAction(new EvolutionMargeAction(), "sales.margin.graph");
        mManager.putAction(new GenReportingVenteAction(false), "sales.list.reporting");
        mManager.putAction(new GenReportingVenteAction(true), "order.list.reporting");
        mManager.putAction(new GenListeVenteAction(), "sales.list.report");
        mManager.putAction(new GenEtatStockAction(), "sales.list.stock.report");
        mManager.putAction(new VenteArticleGraphAction(), "sales.product.graph");
        mManager.putAction(new VenteArticleMargeGraphAction(), "sales.product.margin.graph");
        mManager.putAction(new VenteArticleFamilleGraphAction(), "sales.product.family.graph");
        mManager.putAction(new EtatVenteAction(), "sales.list.graph");
        mManager.putAction(new AbstractAction("Reporting Eco Contribution"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelFrame frame = new PanelFrame(new ReportingEcoContributionPanel(), "Reporting  Eco Contribution");
                frame.setVisible(true);
            }
        }, "sales.report.ecocontribution");
        mManager.putAction(new AbstractAction("Reporting Taxes compl\u00e9mentaires"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelFrame frame = new PanelFrame(new ReportingTaxeComplementairePanel(), "Reporting Taxes compl\u00e9mentaires");
                frame.setVisible(true);
            }
        }, "sales.report.taxesupp");
    }

    public void registerPaymentMenuActions(MenuAndActions mManager) {
        UserRights rights = UserRightsManager.getCurrentUserRights();
        final ComptaPropsConfiguration conf = this.getConfiguration();
        if (rights.haveRight(ComptaUserRight.MENU) || rights.haveRight(ComptaUserRight.POINTAGE_LETTRAGE)) {
            mManager.putAction(new NouveauPointageAction(), "payment.checking.create");
            mManager.putAction(new NouveauLettrageAction(), "payment.reconciliation.create");
        }
        if (rights.haveRight(NXRights.GESTION_ENCAISSEMENT.getCode())) {
            mManager.putAction(new ListesFacturesClientsImpayeesAction(), "customer.invoice.unpaid.list");
            mManager.putAction(new ImportReglementSageAction(conf.getDirectory().getElement(EncaisserMontantSQLElement.class)), "customer.invoice.payment.xml.sage.import");
            mManager.putAction(new ListeDebiteursAction(), "customer.dept.list");
            mManager.putAction(new AbstractAction("Relev\u00e9 client"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PanelFrame frame = new PanelFrame(new ReportingClientPanel(), "Reporting client");
                    frame.setVisible(true);
                }
            }, "customer.payment.report");
            mManager.putAction(new AbstractAction("Situation Client"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PanelFrame frame = new PanelFrame(new SituationCompteClientPanel(conf), "Situation client");
                    frame.setVisible(true);
                }
            }, "customer.payment.details");
            mManager.putAction(new ListeDesEncaissementsAction(), "customer.payment.list");
            mManager.putAction(new ListeDesRelancesAction(), "customer.payment.followup.list");
            mManager.putAction(new ListeDesChequesAEncaisserAction(), "customer.payment.check.pending.list");
            mManager.putAction(new ListeDesDepostChequesAction(), "customer.payment.check.deposit.list");
            mManager.putAction(new NouveauListeDesChequesAEncaisserAction(conf), "customer.payment.check.pending.create");
            mManager.putAction(new ListeSDDMessageAction(conf.getDirectory()), "customer.payment.sddMessage.list");
            mManager.putAction(new ListeEcheancePrelevementAction(conf), "customer.payment.prelevement.list");
            mManager.putAction(new ListeDesChequesAvoirAction(), "customer.credit.check.list");
            mManager.putAction(new NouveauDecaissementChequeAvoirAction(conf), "customer.credit.check.create");
        }
        if (rights.haveRight(NXRights.LOCK_MENU_ACHAT.getCode())) {
            mManager.putAction(new ListesFacturesFournImpayeesAction(), "supplier.invoice.unpaid.list");
            mManager.putAction(new ListeDesTraitesFournisseursAction(), "supplier.bill.list");
            mManager.putAction(new ListeDesChequesFournisseursAction(), "supplier.payment.check.list");
            mManager.putAction(new NouveauListeDesChequesADecaisserAction(conf), "supplier.payment.check.pending.list");
        }
    }

    public void registerPayrollMenuActions(MenuAndActions mManager) {
        ComptaPropsConfiguration conf = this.getConfiguration();
        mManager.putAction(new ImpressionLivrePayeAction(), "payroll.list.report.print");
        mManager.putAction(new ListeDesProfilsPayeAction(), "payroll.profile.list");
        mManager.putAction(new NouvelHistoriqueFichePayeAction(), "payroll.history");
        mManager.putAction(new EditionFichePayeAction(), "payroll.create");
        mManager.putAction(new NouvelAcompteAction(conf), "payroll.deposit.create");
        mManager.putAction(new ListeDesSalariesAction(), "employee.list");
        mManager.putAction(new ListeDesContratsPrevoyanceAction(), "employee.contrat.prev.list");
        mManager.putAction(new ListeDesCaissesCotisationsAction(), "payroll.caisse");
        mManager.putAction(new ListeDesAyantsDroitsAction(), "employee.contrat.prev.ayantdroit.list");
        mManager.putAction(new ListeDesRubriquesDePayeAction(), "payroll.section");
        mManager.putAction(new ListeDesVariablesPayes(), "payroll.variable");
        mManager.putAction(new ListeDesInfosSalariePayeAction(), "payroll.infos.history");
        mManager.putAction(new ClotureMensuellePayeAction(), "payroll.closing");
    }

    public void registerOrganizationMenuActions(MenuAndActions mManager) {
        UserRights rights = UserRightsManager.getCurrentUserRights();
        if (rights.haveRight(ComptaUserRight.MENU)) {
            mManager.putAction(new GestionPlanComptableEAction(), "accounting.chart");
            mManager.putAction(new ListeDesComptesAction(), "accounting.list");
            mManager.putAction(new ListeDesJournauxAction(), "accounting.journal");
            mManager.putAction(new ListeDesDevisesAction(), "accounting.currency");
            mManager.putAction(new ListeDesCategorieComptableAction(), "accounting.category.list");
            mManager.putAction(new ListeDesTauxDeChangeAction(), "accounting.currency.rates");
            mManager.putAction(new AbstractAction("Check DB"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DBRoot rootSociete = DefaultMenuConfiguration.this.configuration.getRootSociete();
                    SQLSelect sel = CorrectMouvement.createUnbalancedSelect(rootSociete);
                    List ids = rootSociete.getDBSystemRoot().getDataSource().executeCol(sel.asString());
                    JOptionPane.showMessageDialog((Component)e.getSource(), "Il y a " + ids.size() + " mouvement(s) non \u00e9quilibr\u00e9(s).", "R\u00e9sultat", ids.size() == 0 ? 1 : 2);
                }
            }, "accounting.checkDB");
        }
        mManager.putAction(new ListeEcoContributionAction(), "product.ecotax");
        if (rights.haveRight("LOCK_MENU_ADMIN")) {
            mManager.putAction(new ListeDesUsersCommonAction(), "user.list");
            mManager.putAction(new GestionDroitsAction(), "user.right.list");
            mManager.putAction(new TaskAdminAction(), "user.task.right");
        }
        mManager.putAction(new ListeDesModelesEmailAction(), "email.template.list");
        mManager.putAction(new ListeDesContactsAdministratif(), "office.contact.list");
        mManager.putAction(new ListeDesCommerciauxAction(), "salesman.list");
        mManager.putAction(new ListeDesCaissesTicketAction(), "pos.list");
        mManager.putAction(new ListeDesSocietesCommonsAction(), "enterprise.list");
        mManager.putAction(new ListeBanqueAction(), "divison.bank.list");
        mManager.putAction(new NouvelleSocieteAction(this.getConfiguration()), "enterprise.create");
    }

    public void registerHelpMenuActions(MenuAndActions mManager) {
        mManager.putAction(new AboutAction(this.getConfiguration()), "information");
        mManager.putAction(new AstuceAction(), "tips");
    }

    public void registerHelpTestActions(MenuAndActions mManager) {
        mManager.putAction(new NouveauClotureSansAnouveauxAction(), "accounting.closing.sansanouveaux");
    }
}

