/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental;

import java.util.Arrays;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.experimental.RandomGraphHelper;
import org.jgrapht.generate.GraphGenerator;

public class PartiteRandomGraphGenerator<V, E>
implements GraphGenerator<V, E, Object[]> {
    private final int[] numVertices;
    private final int numEdges;

    public PartiteRandomGraphGenerator(int numVertices1, int numVertices2, int numEdges) {
        if (numVertices1 < 0 || numVertices2 < 0) {
            throw new IllegalArgumentException("must be non-negative");
        }
        if (numEdges < 0 || numEdges > numVertices1 * numVertices2) {
            throw new IllegalArgumentException("illegal number of edges");
        }
        int[] numVertices = new int[]{numVertices1, numVertices2};
        this.numVertices = numVertices;
        this.numEdges = numEdges;
    }

    public PartiteRandomGraphGenerator(int[] numVertices, int numEdges) {
        if (numEdges < 0) {
            throw new IllegalArgumentException("illegal number of edges");
        }
        int i = 0;
        while (i < numVertices.length) {
            if (numVertices[i] < 0) {
                throw new IllegalArgumentException("must be non-negative");
            }
            int j = 0;
            while (j < i) {
                if (numEdges > numVertices[i] * numVertices[j]) {
                    throw new IllegalArgumentException("illegal number of edges");
                }
                ++j;
            }
            ++i;
        }
        this.numVertices = numVertices;
        this.numEdges = numEdges;
    }

    @Override
    public void generateGraph(Graph<V, E> target, VertexFactory<V> vertexFactory, Map<String, Object[]> resultMap) {
        Object[][] vertices = new Object[this.numVertices.length][];
        int i = 0;
        while (i < this.numVertices.length) {
            vertices[i] = RandomGraphHelper.addVertices(target, vertexFactory, this.numVertices[i]);
            if (resultMap != null) {
                resultMap.put(Integer.toString(i), vertices[i]);
            }
            int j = 0;
            while (j < i) {
                RandomGraphHelper.addEdges(target, Arrays.asList(vertices[i]), Arrays.asList(vertices[j]), this.numEdges);
                ++j;
            }
            ++i;
        }
    }
}

