/*
 * Decompiled with CFR 0.152.
 */
package de.rototor.pdfbox.graphics2d;

import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DFontTextDrawer;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2D;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2DFontTextDrawerDefaultFonts;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.fontbox.ttf.TrueTypeCollection;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.util.Matrix;

public class PdfBoxGraphics2DFontTextDrawer
implements IPdfBoxGraphics2DFontTextDrawer,
Closeable {
    private static final String NOTO_SANS_SEMI_BOLD_ITALIC = "Noto Sans SemiBold Italic";
    private static final String NOTO_SANS_SEMI_BOLD = "Noto Sans SemiBold";
    private static final String NOTO_SANS_BOLD_ITALIC = "Noto Sans Bold Italic";
    private static final String NOTO_SANS_BOLD = "Noto Sans Bold";
    private static final String NOTO_SANS_ITALIC = "Noto Sans Italic";
    private static final String NOTO_SANS_REGULAR = "Noto Sans Regular";
    private final List<FontEntry> fontFiles = new ArrayList<FontEntry>();
    private final List<File> tempFiles = new ArrayList<File>();
    private final Map<String, PDFont> fontMap = new HashMap<String, PDFont>();
    private static final boolean ENABLE_EXPERIMENTAL_TEXT_DECORATION = true;
    private PDFont fallbackFontUnknownEncodings;
    private static final boolean DEBUG_BOX = false;
    String[] notoTTFs = new String[]{"NotoSans-Regular.ttf", "NotoSans-Italic.ttf", "NotoSans-SemiBold.ttf", "NotoSans-SemiBoldItalic.ttf", "NotoSans-Bold.ttf", "NotoSans-BoldItalic.ttf"};
    String[] notoNames = new String[]{"Noto Sans Regular", "Noto Sans Italic", "Noto Sans SemiBold", "Noto Sans SemiBold Italic", "Noto Sans Bold", "Noto Sans Bold Italic"};
    private Set<String> fontWarning = new HashSet<String>();

    @Override
    public void close() {
        for (File tempFile : this.tempFiles) {
            tempFile.delete();
        }
        this.tempFiles.clear();
        this.fontFiles.clear();
        this.fontMap.clear();
    }

    public void registerFont(String fontName, InputStream fontStream) throws IOException {
        File fontFile = File.createTempFile("pdfboxgfx2dfont", ".ttf");
        try (FileOutputStream out = new FileOutputStream(fontFile);){
            IOUtils.copy(fontStream, out);
        }
        fontFile.deleteOnExit();
        this.tempFiles.add(fontFile);
        this.registerFont(fontName, fontFile);
    }

    public void registerFont(String fontName, File fontFile) {
        if (!fontFile.exists()) {
            throw new IllegalArgumentException("Font " + fontFile + " does not exist!");
        }
        FontEntry entry = new FontEntry();
        entry.overrideName = fontName;
        entry.file = fontFile;
        this.fontFiles.add(entry);
    }

    public void registerFont(File fontFile) {
        this.registerFont(null, fontFile);
    }

    public void registerFont(InputStream fontStream) throws IOException {
        this.registerFont(null, fontStream);
    }

    public void registerFont(String name, PDFont font) {
        this.fontMap.put(name, font);
    }

    protected boolean hasDynamicFontMapping() {
        return this.getClass() != PdfBoxGraphics2DFontTextDrawer.class;
    }

    @Override
    public boolean canDrawText(AttributedCharacterIterator iterator, IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env) throws IOException, FontFormatException {
        if (this.fontMap.size() == 0 && this.fontFiles.size() == 0 && !this.hasDynamicFontMapping()) {
            return false;
        }
        boolean run = true;
        StringBuilder sb = new StringBuilder();
        while (run) {
            Font attributeFont = (Font)iterator.getAttribute(TextAttribute.FONT);
            if (attributeFont == null) {
                attributeFont = env.getFont();
            }
            if (iterator.getAttribute(TextAttribute.BACKGROUND) != null) {
                return false;
            }
            boolean isStrikeThrough = TextAttribute.STRIKETHROUGH_ON.equals(iterator.getAttribute(TextAttribute.STRIKETHROUGH));
            boolean isUnderline = TextAttribute.UNDERLINE_ON.equals(iterator.getAttribute(TextAttribute.UNDERLINE));
            boolean isLigatures = TextAttribute.LIGATURES_ON.equals(iterator.getAttribute(TextAttribute.LIGATURES));
            if (isStrikeThrough || isUnderline) {
                // empty if block
            }
            if (isLigatures) {
                return false;
            }
            run = this.iterateRun(iterator, sb);
            String s = sb.toString();
            int l = s.length();
            int i = 0;
            while (i < l) {
                int codePoint = s.codePointAt(i);
                switch (Character.getDirectionality(codePoint)) {
                    case 0: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 16: 
                    case 17: 
                    case 18: {
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
                if (!attributeFont.canDisplay(codePoint)) {
                    return false;
                }
                i += Character.charCount(codePoint);
            }
        }
        return true;
    }

    @Override
    public void drawText(AttributedCharacterIterator iterator, IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env) throws IOException, FontFormatException {
        PDPageContentStream contentStream = env.getContentStream();
        DrawTextDecorationState drawState = new DrawTextDecorationState();
        contentStream.saveGraphicsState();
        contentStream.beginText();
        Matrix textMatrix = new Matrix();
        textMatrix.scale(1.0f, -1.0f);
        contentStream.setTextMatrix(textMatrix);
        StringBuilder sb = new StringBuilder();
        boolean run = true;
        while (run) {
            Number fontSize;
            Font attributeFont = (Font)iterator.getAttribute(TextAttribute.FONT);
            if (attributeFont == null) {
                attributeFont = env.getFont();
            }
            if ((fontSize = (Number)iterator.getAttribute(TextAttribute.SIZE)) != null) {
                attributeFont = attributeFont.deriveFont(fontSize.floatValue());
            }
            PDFont font = this.applyFont(attributeFont, env);
            Paint paint = (Paint)iterator.getAttribute(TextAttribute.FOREGROUND);
            if (paint == null) {
                paint = env.getPaint();
            }
            boolean isStrikeThrough = TextAttribute.STRIKETHROUGH_ON.equals(iterator.getAttribute(TextAttribute.STRIKETHROUGH));
            boolean isUnderline = TextAttribute.UNDERLINE_ON.equals(iterator.getAttribute(TextAttribute.UNDERLINE));
            boolean isLigatures = TextAttribute.LIGATURES_ON.equals(iterator.getAttribute(TextAttribute.LIGATURES));
            run = this.iterateRun(iterator, sb);
            String text = sb.toString();
            env.applyPaint(paint, null);
            try {
                this.showTextOnStream(env, contentStream, attributeFont, font, isStrikeThrough, isUnderline, isLigatures, drawState, paint, text);
            }
            catch (IllegalArgumentException e) {
                System.err.println("PDFBoxGraphics: Can not map text " + text + " with font " + attributeFont.getFontName() + ": " + e.getMessage());
                if (font instanceof PDType1Font && !font.isEmbedded()) {
                    try {
                        if (this.fallbackFontUnknownEncodings == null) {
                            this.fallbackFontUnknownEncodings = this.findFallbackFont(env);
                        }
                        if (this.fallbackFontUnknownEncodings != null) {
                            env.getContentStream().setFont(this.fallbackFontUnknownEncodings, attributeFont.getSize2D());
                            this.showTextOnStream(env, contentStream, attributeFont, this.fallbackFontUnknownEncodings, isStrikeThrough, isUnderline, isLigatures, drawState, paint, text);
                            e = null;
                        }
                    }
                    catch (IllegalArgumentException e1) {
                        e = e1;
                    }
                }
                if (e == null) continue;
                System.err.println("PDFBoxGraphics: Can not map text " + text + " with font " + attributeFont.getFontName() + ": " + e.getMessage());
            }
        }
        contentStream.endText();
        contentStream.restoreGraphicsState();
        if (!drawState.drawers.isEmpty()) {
            contentStream.saveGraphicsState();
            contentStream.transform(textMatrix);
            for (ITextDecorationDrawer drawer : drawState.drawers) {
                drawer.draw(contentStream);
            }
            contentStream.restoreGraphicsState();
        }
    }

    @Override
    public FontMetrics getFontMetrics(final Font f, IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env) throws IOException, FontFormatException {
        final FontMetrics defaultMetrics = env.getCalculationGraphics().getFontMetrics(f);
        final PDFont pdFont = this.mapFont(f, env);
        if (pdFont == null) {
            return defaultMetrics;
        }
        return new FontMetrics(f){

            @Override
            public int getDescent() {
                return defaultMetrics.getDescent();
            }

            @Override
            public int getHeight() {
                return defaultMetrics.getHeight();
            }

            @Override
            public int getMaxAscent() {
                return defaultMetrics.getMaxAscent();
            }

            @Override
            public int getMaxDescent() {
                return defaultMetrics.getMaxDescent();
            }

            @Override
            public boolean hasUniformLineMetrics() {
                return defaultMetrics.hasUniformLineMetrics();
            }

            @Override
            public LineMetrics getLineMetrics(String str, Graphics context) {
                return defaultMetrics.getLineMetrics(str, context);
            }

            @Override
            public LineMetrics getLineMetrics(String str, int beginIndex, int limit, Graphics context) {
                return defaultMetrics.getLineMetrics(str, beginIndex, limit, context);
            }

            @Override
            public LineMetrics getLineMetrics(char[] chars, int beginIndex, int limit, Graphics context) {
                return defaultMetrics.getLineMetrics(chars, beginIndex, limit, context);
            }

            @Override
            public LineMetrics getLineMetrics(CharacterIterator ci, int beginIndex, int limit, Graphics context) {
                return defaultMetrics.getLineMetrics(ci, beginIndex, limit, context);
            }

            @Override
            public Rectangle2D getStringBounds(String str, Graphics context) {
                return defaultMetrics.getStringBounds(str, context);
            }

            @Override
            public Rectangle2D getStringBounds(String str, int beginIndex, int limit, Graphics context) {
                return defaultMetrics.getStringBounds(str, beginIndex, limit, context);
            }

            @Override
            public Rectangle2D getStringBounds(char[] chars, int beginIndex, int limit, Graphics context) {
                return defaultMetrics.getStringBounds(chars, beginIndex, limit, context);
            }

            @Override
            public Rectangle2D getStringBounds(CharacterIterator ci, int beginIndex, int limit, Graphics context) {
                return defaultMetrics.getStringBounds(ci, beginIndex, limit, context);
            }

            @Override
            public Rectangle2D getMaxCharBounds(Graphics context) {
                return defaultMetrics.getMaxCharBounds(context);
            }

            @Override
            public int getAscent() {
                return defaultMetrics.getAscent();
            }

            @Override
            public int getMaxAdvance() {
                return defaultMetrics.getMaxAdvance();
            }

            @Override
            public int getLeading() {
                return defaultMetrics.getLeading();
            }

            @Override
            public FontRenderContext getFontRenderContext() {
                return defaultMetrics.getFontRenderContext();
            }

            @Override
            public int charWidth(char ch) {
                char[] chars = new char[]{ch};
                return this.charsWidth(chars, 0, chars.length);
            }

            @Override
            public int charWidth(int codePoint) {
                char[] data = Character.toChars(codePoint);
                return this.charsWidth(data, 0, data.length);
            }

            @Override
            public int charsWidth(char[] data, int off, int len) {
                return this.stringWidth(new String(data, off, len));
            }

            @Override
            public int stringWidth(String str) {
                try {
                    return (int)(pdFont.getStringWidth(str) / 1000.0f * f.getSize2D());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalArgumentException e) {
                    return defaultMetrics.stringWidth(str);
                }
            }

            @Override
            public int[] getWidths() {
                try {
                    int[] first256Widths = new int[256];
                    int i = 0;
                    while (i < first256Widths.length) {
                        first256Widths[i] = (int)(pdFont.getWidth(i) / 1000.0f * (float)f.getSize());
                        ++i;
                    }
                    return first256Widths;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private PDFont findFallbackFont(IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env) throws IOException {
        String javaHome = System.getProperty("java.home", ".");
        String javaFontDir = String.valueOf(javaHome) + "/lib/fonts";
        String windir = System.getenv("WINDIR");
        if (windir == null) {
            windir = javaFontDir;
        }
        File[] paths = new File[]{new File(new File(windir), "fonts"), new File("/Library/Fonts"), new File("/System/Library/Fonts/Supplemental/"), new File("/usr/share/fonts/truetype"), new File("/usr/share/fonts/truetype/dejavu"), new File("/usr/share/fonts/truetype/liberation"), new File("/usr/share/fonts/truetype/noto"), new File(javaFontDir), new File("/usr/share/fonts/truetype/msttcorefonts")};
        String[] stringArray = new String[]{"LucidaSansRegular.ttf", "arial.ttf", "Arial.ttf", "DejaVuSans.ttf", "LiberationMono-Regular.ttf", "NotoSerif-Regular.ttf", "Arial Unicode.ttf", "Tahoma.ttf", "Verdana.ttf"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fontFileName = stringArray[n2];
            File[] fileArray = paths;
            int n3 = paths.length;
            int n4 = 0;
            while (n4 < n3) {
                PDType0Font pdType0Font;
                File path = fileArray[n4];
                File arialFile = new File(path, fontFileName);
                if (arialFile.exists() && (pdType0Font = this.tryToLoadFont(env, arialFile)) != null) {
                    return pdType0Font;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    private PDType0Font tryToLoadFont(IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env, File foundFontFile) throws IOException {
        try {
            return PDType0Font.load(env.getDocument(), foundFontFile);
        }
        catch (IOException e) {
            return null;
        }
    }

    private void showTextOnStream(final IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env, final PDPageContentStream contentStream, final Font attributeFont, final PDFont font, final boolean isStrikeThrough, final boolean isUnderline, boolean isLigatures, DrawTextDecorationState drawState, final Paint paint, String text) throws IOException {
        contentStream.showText(text);
        final float stringWidth = font.getStringWidth(text) / 1000.0f * attributeFont.getSize2D();
        if (isStrikeThrough || isUnderline) {
            final LineMetrics lineMetrics = attributeFont.getLineMetrics(text, env.getFontRenderContext());
            final float ourX = drawState.x;
            drawState.drawers.add(new ITextDecorationDrawer(){

                @Override
                public void draw(PDPageContentStream stream) throws IOException {
                    float height = lineMetrics.getHeight();
                    float pdFontHeight = font.getBoundingBox().getHeight() / 1000.0f * attributeFont.getSize2D();
                    float scale = pdFontHeight / height;
                    float decent = lineMetrics.getDescent();
                    env.applyPaint(paint, new Rectangle2D.Float(ourX, -decent * scale, stringWidth, height * scale));
                    float baseline = lineMetrics.getBaselineOffsets()[lineMetrics.getBaselineIndex()];
                    if (isStrikeThrough) {
                        env.applyStroke(new BasicStroke(PdfBoxGraphics2DFontTextDrawer.this.getSensibleThickness(lineMetrics.getStrikethroughThickness(), attributeFont)));
                        float strikethroughOffset = scale * (baseline + lineMetrics.getStrikethroughOffset());
                        contentStream.moveTo(ourX, -strikethroughOffset);
                        contentStream.lineTo(ourX + stringWidth, -strikethroughOffset);
                        contentStream.stroke();
                    }
                    if (isUnderline) {
                        env.applyStroke(new BasicStroke(PdfBoxGraphics2DFontTextDrawer.this.getSensibleThickness(lineMetrics.getUnderlineThickness(), attributeFont)));
                        float underlineOffset = scale * (baseline + lineMetrics.getUnderlineOffset());
                        contentStream.moveTo(ourX, -underlineOffset);
                        contentStream.lineTo(ourX + stringWidth, -underlineOffset);
                        contentStream.stroke();
                    }
                }
            });
        }
        drawState.x += stringWidth;
    }

    private float getSensibleThickness(float thickness, Font font) {
        if (thickness < 1.0E-5f) {
            return 0.04f * font.getSize2D();
        }
        return thickness;
    }

    private PDFont applyFont(Font font, IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env) throws IOException, FontFormatException {
        PDFont fontToUse = this.mapFont(font, env);
        env.getContentStream().setFont(fontToUse, font.getSize2D());
        return fontToUse;
    }

    protected PDFont mapFont(Font font, final IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env) throws IOException, FontFormatException {
        for (final FontEntry fontEntry : this.fontFiles) {
            if (fontEntry.overrideName == null) {
                Font javaFont = Font.createFont(0, fontEntry.file);
                fontEntry.overrideName = javaFont.getFontName();
            }
            if (fontEntry.file.getName().toLowerCase(Locale.US).endsWith(".ttc")) {
                TrueTypeCollection collection = new TrueTypeCollection(fontEntry.file);
                collection.processAllFonts(new TrueTypeCollection.TrueTypeFontProcessor(){

                    @Override
                    public void process(TrueTypeFont ttf) throws IOException {
                        PDType0Font pdFont = PDType0Font.load(env.getDocument(), ttf, true);
                        PdfBoxGraphics2DFontTextDrawer.this.fontMap.put(fontEntry.overrideName, pdFont);
                        PdfBoxGraphics2DFontTextDrawer.this.fontMap.put(pdFont.getName(), pdFont);
                    }
                });
                continue;
            }
            PDType0Font pdFont = PDType0Font.load(env.getDocument(), fontEntry.file);
            this.fontMap.put(fontEntry.overrideName, pdFont);
        }
        this.fontFiles.clear();
        PDFont fontToUse = this.fontMap.get(font.getFontName());
        if (fontToUse == null) {
            fontToUse = (font.getStyle() & 3) == 3 ? this.fontMap.get(NOTO_SANS_BOLD_ITALIC) : ((font.getStyle() & 2) == 2 ? this.fontMap.get(NOTO_SANS_ITALIC) : ((font.getStyle() & 1) == 1 ? this.fontMap.get(NOTO_SANS_BOLD) : this.fontMap.get(NOTO_SANS_REGULAR)));
            if (!this.fontWarning.contains(font.getName())) {
                System.err.println("WARNING : PdfBoxGraphics2DFontTextDrawer mapping \"" + font.getFontName() + "\" to embedded " + fontToUse.getName());
                this.fontWarning.add(font.getName());
            }
        }
        return fontToUse;
    }

    @Override
    public void init(IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env) {
        try {
            this.registerNotoFonts(env);
        }
        catch (FontFormatException | IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void registerNotoFonts(IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env) throws FontFormatException, IOException {
        int i = 0;
        while (i < this.notoTTFs.length) {
            PDType0Font pdFont = PDType0Font.load(env.getDocument(), this.getClass().getResourceAsStream(this.notoTTFs[i]));
            this.fontMap.put(this.notoNames[i], pdFont);
            ++i;
        }
    }

    private boolean iterateRun(AttributedCharacterIterator iterator, StringBuilder sb) {
        sb.setLength(0);
        int charCount = iterator.getRunLimit() - iterator.getRunStart();
        while (charCount-- > 0) {
            char c = iterator.current();
            iterator.next();
            if (c == '\uffff') {
                return false;
            }
            sb.append(c);
        }
        return iterator.getIndex() < iterator.getRunLimit();
    }

    public static void main(String[] args) throws FontFormatException, IOException {
        System.out.println("System fonts :");
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int i = 0;
        while (i < fonts.length) {
            System.out.println(fonts[i]);
            ++i;
        }
        System.out.println();
        PDDocument document = new PDDocument();
        PDDocumentInformation info = new PDDocumentInformation();
        info.setCreator("Creator");
        info.setProducer("Producer");
        info.setCreationDate(Calendar.getInstance());
        info.setModificationDate(Calendar.getInstance());
        document.setDocumentInformation(info);
        PDRectangle pageSize = PDRectangle.A4;
        PdfBoxGraphics2DFontTextDrawerDefaultFonts fontTextDrawer = new PdfBoxGraphics2DFontTextDrawerDefaultFonts();
        PDPage page = new PDPage(pageSize);
        document.addPage(page);
        PdfBoxGraphics2D g2 = new PdfBoxGraphics2D(document, pageSize.getWidth(), pageSize.getHeight());
        g2.setFontTextDrawer(fontTextDrawer);
        Font f = new Font("Arial", 0, 12);
        g2.setFont(f);
        System.out.println("Creating test file with font : " + f.getName());
        g2.setColor(Color.BLACK);
        g2.drawString("Test " + f.getName(), 100, 100);
        g2.dispose();
        PDFormXObject xform = g2.getXFormObject();
        Matrix matrix = new Matrix();
        matrix.translate(0.0f, 0.0f);
        PDPageContentStream contentStream = new PDPageContentStream(document, page);
        contentStream.transform(matrix);
        contentStream.drawForm(xform);
        contentStream.close();
        document.save(new File("test.pdf"));
        document.close();
        Desktop.getDesktop().open(new File("test.pdf"));
    }

    private static class DrawTextDecorationState {
        public float x;
        final List<ITextDecorationDrawer> drawers = new ArrayList<ITextDecorationDrawer>();

        private DrawTextDecorationState() {
        }
    }

    private static class FontEntry {
        String overrideName;
        File file;

        private FontEntry() {
        }
    }

    private static interface ITextDecorationDrawer {
        public void draw(PDPageContentStream var1) throws IOException;
    }
}

