/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view;

import java.awt.GridLayout;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.navigator.SQLBrowser;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.EditPanelListener;
import org.openconcerto.sql.view.IListPanel;
import org.openconcerto.sql.view.TabbedIListPanel;
import org.openconcerto.sql.view.list.IListe;

public class TabbedListeModifyPanel
extends JPanel {
    private final SQLElement element;
    private final IListe liste;
    private IListPanel listPanel;
    protected JTabbedPane tabbedPane = new JTabbedPane();
    protected EditPanel editorModifyComp;
    protected EditPanel editorAddComp;
    private int selectedId = -1;
    private JPanel emptyPanelModify = new JPanel();
    private JPanel emptyPanelAdd = new JPanel();
    private SQLBrowser browser;

    public TabbedListeModifyPanel(SQLElement elem, SQLBrowser browser) {
        this(elem, null, browser);
    }

    public TabbedListeModifyPanel(SQLElement elem, IListe list, SQLBrowser browser) {
        this.element = elem;
        this.liste = list;
        this.browser = browser;
        this.tabbedPane.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                System.out.println(".canImport()");
                return true;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                System.out.println(".createTransferable()");
                Transferable tr = new Transferable(){

                    @Override
                    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                        System.out.println(".getTransferData()");
                        return new JLabel("salut");
                    }

                    @Override
                    public DataFlavor[] getTransferDataFlavors() {
                        System.out.println(".getTransferDataFlavors()");
                        DataFlavor[] array = new DataFlavor[]{};
                        return array;
                    }

                    @Override
                    public boolean isDataFlavorSupported(DataFlavor flavor) {
                        System.out.println(".isDataFlavorSupported()");
                        return true;
                    }
                };
                return tr;
            }

            @Override
            public void exportAsDrag(JComponent comp, InputEvent e, int action) {
                System.out.println(".exportAsDrag()");
                super.exportAsDrag(comp, e, action);
            }

            @Override
            protected void exportDone(JComponent source, Transferable data, int action) {
                System.out.println(".exportDone()");
                super.exportDone(source, data, action);
            }

            @Override
            public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
                System.out.println(".exportToClipboard()");
                super.exportToClipboard(comp, clip, action);
            }

            @Override
            public int getSourceActions(JComponent c) {
                System.out.println(".getSourceActions()");
                return 1;
            }

            @Override
            public Icon getVisualRepresentation(Transferable t) {
                System.out.println(".getVisualRepresentation()");
                return super.getVisualRepresentation(t);
            }

            @Override
            public boolean importData(JComponent comp, Transferable t) {
                System.out.println(".importData()");
                return super.importData(comp, t);
            }
        });
        MouseAdapter listener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                System.out.println(".mousePressed()");
                JComponent c = (JComponent)e.getSource();
                TransferHandler handler = c.getTransferHandler();
                handler.exportAsDrag(c, e, 1);
            }
        };
        this.tabbedPane.addMouseListener(listener);
    }

    public final SQLElement getElement() {
        return this.element;
    }

    public final IListe getListe() {
        return this.liste;
    }

    public SQLComponent getModifComp() {
        return this.editorModifyComp.getSQLComponent();
    }

    private void initEditor() {
        if (this.editorModifyComp == null) {
            List hiddenFields = this.getHiddenFields();
            this.editorModifyComp = new EditPanel(this.element, EditPanel.MODIFICATION, (List<SQLField>)hiddenFields);
            this.editorModifyComp.setModifyLabel("Valider les modifications [F12]");
            this.editorModifyComp.disableCancel();
            this.editorModifyComp.disableDelete();
            this.editorModifyComp.addEditPanelListener(new EditPanelListener(){

                @Override
                public void cancelled() {
                }

                @Override
                public void deleted() {
                }

                @Override
                public void inserted(int id) {
                }

                @Override
                public void modified() {
                    TabbedListeModifyPanel.this.hideEditTab();
                }
            });
        }
    }

    private List getHiddenFields() {
        SQLField parentField = this.element.getParentForeignField();
        Vector<SQLField> hiddenFields = new Vector<SQLField>();
        if (parentField != null) {
            hiddenFields.add(parentField);
        }
        return hiddenFields;
    }

    public void initTab() {
        this.setOpaque(false);
        this.setLayout(new GridLayout(1, 1));
        TabbedListeModifyPanel me = this;
        this.listPanel = new TabbedIListPanel(this.element, this.liste, this);
        this.tabbedPane.addTab("Liste des " + this.element.getPluralName() + " [F8]", this.listPanel);
        this.add(this.tabbedPane);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (TabbedListeModifyPanel.this.tabbedPane.getSelectedComponent() == TabbedListeModifyPanel.this.emptyPanelModify) {
                    int indexOfComponent = TabbedListeModifyPanel.this.tabbedPane.indexOfComponent(TabbedListeModifyPanel.this.emptyPanelModify);
                    TabbedListeModifyPanel.this.tabbedPane.removeTabAt(indexOfComponent);
                    TabbedListeModifyPanel.this.initEditor();
                    String desc = TabbedListeModifyPanel.this.getEditorTitle();
                    TabbedListeModifyPanel.this.tabbedPane.insertTab(desc, null, TabbedListeModifyPanel.this.editorModifyComp, null, indexOfComponent);
                    TabbedListeModifyPanel.this.tabbedPane.setSelectedComponent(TabbedListeModifyPanel.this.editorModifyComp);
                    TabbedListeModifyPanel.this.editorModifyComp.selectionId(TabbedListeModifyPanel.this.selectedId, -1);
                }
                if (TabbedListeModifyPanel.this.tabbedPane.getSelectedComponent() == TabbedListeModifyPanel.this.editorModifyComp) {
                    TabbedListeModifyPanel.this.editorModifyComp.selectionId(TabbedListeModifyPanel.this.selectedId, -1);
                }
            }
        });
    }

    public void activateList() {
        this.tabbedPane.setSelectedComponent(this.listPanel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TabbedListeModifyPanel.this.listPanel.grabFocus();
            }
        });
    }

    public void showEditTab() {
        int index = this.tabbedPane.indexOfComponent(this.editorModifyComp);
        if (index != -1) {
            this.tabbedPane.setSelectedComponent(this.editorModifyComp);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TabbedListeModifyPanel.this.editorModifyComp.grabFocus();
                }
            });
        } else {
            index = this.tabbedPane.indexOfComponent(this.emptyPanelModify);
            if (index != -1) {
                this.tabbedPane.setSelectedComponent(this.emptyPanelModify);
            }
        }
    }

    public void showAddTab(List<SQLRow> sqlRows) {
        int index = this.tabbedPane.indexOfComponent(this.editorAddComp);
        if (index != -1) {
            this.tabbedPane.setSelectedComponent(this.editorAddComp);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TabbedListeModifyPanel.this.editorAddComp.grabFocus();
                }
            });
        } else {
            List hiddenFields = this.getHiddenFields();
            this.editorAddComp = new EditPanel(this.element, EditPanel.CREATION, (List<SQLField>)hiddenFields);
            this.editorAddComp.setValues(sqlRows);
            int insertIndex = this.tabbedPane.indexOfComponent(this.editorModifyComp);
            insertIndex = insertIndex < 0 ? 1 : ++insertIndex;
            this.tabbedPane.insertTab("Ajouter " + this.element.getSingularName() + " [F10]", null, this.editorAddComp, "", insertIndex);
            this.tabbedPane.setSelectedComponent(this.editorAddComp);
            this.editorAddComp.addEditPanelListener(new EditPanelListener(){

                @Override
                public void cancelled() {
                    TabbedListeModifyPanel.this.hideAddTab();
                }

                @Override
                public void deleted() {
                }

                @Override
                public void inserted(int id) {
                    if (!TabbedListeModifyPanel.this.editorAddComp.alwaysVisible()) {
                        TabbedListeModifyPanel.this.hideAddTab();
                    }
                }

                @Override
                public void modified() {
                }
            });
        }
    }

    public void validateEdition() {
        this.editorModifyComp.modifier();
    }

    public void setSelectedId(int id) {
        this.selectedId = id;
        if (this.selectedId > 0) {
            this.createEditTab();
        } else {
            this.hideEditTab();
        }
    }

    private void hideEditTab() {
        if (this.editorModifyComp == null) {
            this.tabbedPane.remove(this.emptyPanelModify);
        } else {
            this.tabbedPane.remove(this.editorModifyComp);
        }
    }

    private void hideAddTab() {
        if (this.editorAddComp != null) {
            this.tabbedPane.remove(this.editorAddComp);
        }
    }

    private void createEditTab() {
        String desc = this.getEditorTitle();
        if (this.editorModifyComp == null) {
            this.tabbedPane.insertTab(desc, null, this.emptyPanelModify, null, 1);
        } else {
            this.tabbedPane.insertTab(desc, null, this.editorModifyComp, null, 1);
        }
    }

    private String getEditorTitle() {
        SQLRow row = this.element.getTable().getRow(this.selectedId);
        return "Edition:" + this.element.getDescription(row) + " [F9]";
    }

    public SQLBrowser getBrowser() {
        return this.browser;
    }
}

