/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.text.JTextComponent;
import org.openconcerto.erp.modules.ElementContext;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.sql.view.DropManager;
import org.openconcerto.sql.view.FileDropHandler;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.utils.ListMap;

public final class ComponentsContext
extends ElementContext {
    private final Set<String> createdTables;
    private final ListMap<String, String> createdFields;
    private final ListMap<SQLElement, String> fields;
    private final ListMap<SQLElement, IListeAction> rowActions;

    ComponentsContext(SQLElementDirectory dir, DBRoot root, Set<String> tables, Set<SQLName> fields) {
        super(dir, root);
        this.createdTables = tables;
        this.createdFields = new ListMap();
        for (SQLName f : fields) {
            assert (f.getItemCount() == 2);
            String tableName = f.getFirst();
            if (this.createdTables.contains(tableName)) continue;
            this.createdFields.add(tableName, f.getItem(1));
        }
        this.fields = new ListMap();
        this.rowActions = new ListMap();
    }

    private final SQLElement checkField(String tableName, String name) {
        if (this.createdTables.contains(tableName)) {
            throw new IllegalArgumentException("The table " + tableName + " was created by this module");
        }
        if (!((List)this.createdFields.getNonNull(tableName)).contains(name)) {
            throw new IllegalArgumentException("The field " + new SQLName(tableName, name).quote() + " wasn't created by this module");
        }
        return this.getElement(tableName);
    }

    public final void putAdditionalField(String tableName, String name) {
        SQLElement elem = this.checkField(tableName, name);
        if (!elem.putAdditionalField(name)) {
            throw new IllegalStateException("Already added " + name + " in " + elem);
        }
        this.fields.add(elem, name);
    }

    public final void putAdditionalTextField(String tableName, String name, Supplier<? extends JTextComponent> comp) {
        SQLElement elem = this.checkField(tableName, name);
        if (!elem.putAdditionalTextField(name, comp)) {
            throw new IllegalStateException("Already added " + name + " in " + elem);
        }
        this.fields.add(elem, name);
    }

    public final void putAdditionalTextCombo(String tableName, String name, Supplier<? extends SQLTextCombo> comp) {
        SQLElement elem = this.checkField(tableName, name);
        if (!elem.putAdditionalTextCombo(name, comp)) {
            throw new IllegalStateException("Already added " + name + " in " + elem);
        }
        this.fields.add(elem, name);
    }

    public final void putAdditionalCombo(String tableName, String name, Supplier<? extends SQLRequestComboBox> comp) {
        SQLElement elem = this.checkField(tableName, name);
        if (!elem.putAdditionalCombo(name, comp)) {
            throw new IllegalStateException("Already added " + name + " in " + elem);
        }
        this.fields.add(elem, name);
    }

    final ListMap<SQLElement, String> getFields() {
        return this.fields;
    }

    public final void addListAction(String tableName, IListeAction action) {
        SQLElement elem = this.getElement(tableName);
        this.rowActions.add(elem, action);
        elem.getRowActions().add(action);
    }

    final ListMap<SQLElement, IListeAction> getRowActions() {
        return this.rowActions;
    }

    public final void addFileDropHandler(String tableName, FileDropHandler handler) {
        DropManager.getInstance().add(this.getRoot().getTable(tableName), handler);
    }
}

