/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.customerrelationship.customer.element.ContactItemTable;
import org.openconcerto.erp.core.edm.AttachmentAction;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.EditPanelListener;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.warning.JLabelWarning;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class SalarieSQLElement
extends ComptaSQLConfElement {
    public SalarieSQLElement() {
        super("SALARIE", "un salari\u00e9", "salari\u00e9s");
        RowAction.PredicateRowAction actionAttachment = new RowAction.PredicateRowAction(new AttachmentAction().getAction(), true);
        actionAttachment.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(actionAttachment);
        RowAction.PredicateRowAction actionNewContrat = new RowAction.PredicateRowAction(new AbstractAction("Cr\u00e9er un nouveau contrat"){

            @Override
            public void actionPerformed(ActionEvent e) {
                final SQLRowValues rowSelected = IListe.get(e).getSelectedRow();
                JOptionPane.showMessageDialog(null, "Attention la cr\u00e9ation d'un nouveau contrat n'est pas r\u00e9versible.\nCr\u00e9er tous les bulletins de salaire de l'ancien contrat avant la cr\u00e9ation du nouveau.");
                final SQLElement infosPayeElement = SalarieSQLElement.this.getDirectory().getElement("INFOS_SALARIE_PAYE");
                EditFrame f = new EditFrame(infosPayeElement, EditPanel.EditMode.CREATION);
                final SQLRow rowInfosAncien = rowSelected.asRow().getForeign("ID_INFOS_SALARIE_PAYE");
                SQLRowValues cloneInfos = infosPayeElement.createCopy(rowInfosAncien.getID());
                ((SQLRowValues)cloneInfos.getForeign("ID_CONTRAT_SALARIE")).put("DATE_DEBUT", null);
                f.getSQLComponent().select(cloneInfos);
                f.addEditPanelListener(new EditPanelListener(){

                    @Override
                    public void modified() {
                    }

                    @Override
                    public void inserted(int id) {
                        try {
                            rowInfosAncien.createEmptyUpdateRow().put("ID_SALARIE", rowSelected.getID()).commit();
                            rowSelected.createEmptyUpdateRow().put("ID_INFOS_SALARIE_PAYE", id).commit();
                            infosPayeElement.getTable().getRow(id).createEmptyUpdateRow().put("ID_SALARIE", rowSelected.getID()).commit();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void deleted() {
                    }

                    @Override
                    public void cancelled() {
                    }
                });
                FrameUtil.show(f);
            }
        }, true);
        actionNewContrat.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(actionNewContrat);
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("NOM");
        l.add("PRENOM");
        l.add("ID_FICHE_PAYE");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("NOM");
        l.add("PRENOM");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            private final JLabel warningCodeSalLabel;
            private final JTextField textCode;
            ContactItemTable tableContact;
            private JTabbedPane tabbedPane;
            private final SQLTable tableNum;
            {
                this.warningCodeSalLabel = new JLabelWarning();
                this.textCode = new JTextField();
                this.tableContact = new ContactItemTable(UndefinedRowValuesCache.getInstance().getDefaultRowValues(this.getTable().getTable("CONTACT_SALARIE")));
                this.tableNum = this.getTable().getBase().getTable("NUMEROTATION_AUTO");
            }

            @Override
            public void addViews() {
                this.warningCodeSalLabel.setText("Ce code est d\u00e9j\u00e0 affect\u00e9 \u00e0 un autre salari\u00e9!");
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                JLabel labelTitrePersonnel = new JLabel(this.getLabelFor("ID_TITRE_PERSONNEL"));
                ElementComboBox comboTitre = new ElementComboBox(false, 5);
                this.add((Component)labelTitrePersonnel, c);
                ++c.gridx;
                c.weightx = 0.0;
                c.fill = 0;
                this.add((Component)comboTitre, c);
                JLabel labelNom = new JLabel(this.getLabelFor("NOM"));
                JTextField textNom = new JTextField();
                c.fill = 2;
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)labelNom, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)textNom, c);
                JLabel labelPrenom = new JLabel(this.getLabelFor("PRENOM"));
                JTextField textPrenom = new JTextField();
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)labelPrenom, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)textPrenom, c);
                JLabel labelCode = new JLabel(this.getLabelFor("CODE"));
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)labelCode, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.textCode, c);
                c.weightx = 0.0;
                ++c.gridx;
                this.add((Component)this.warningCodeSalLabel, c);
                this.warningCodeSalLabel.setVisible(false);
                this.textCode.getDocument().addDocumentListener(new SimpleDocumentListener(){

                    @Override
                    public void update(DocumentEvent e) {
                        this.checkCode();
                    }
                });
                JLabel labelUser = new JLabel(this.getLabelFor("ID_USER_COMMON"));
                ElementComboBox comboUser = new ElementComboBox(false, 50);
                c.gridx = 0;
                ++c.gridy;
                this.add((Component)labelUser, c);
                ++c.gridx;
                c.weightx = 1.0;
                c.fill = 0;
                this.add((Component)comboUser, c);
                this.addView(comboUser, "ID_USER_COMMON");
                this.tabbedPane = new JTabbedPane();
                this.addView("ID_ETAT_CIVIL", "required;notdecorated;noseparator");
                ElementSQLObject eltEtatCivil = (ElementSQLObject)this.getView("ID_ETAT_CIVIL");
                JScrollPane scrollEtatCivil = new JScrollPane(eltEtatCivil);
                scrollEtatCivil.setBorder(null);
                this.tabbedPane.add("Etat Civil", scrollEtatCivil);
                JPanel panelContact = new JPanel(new GridBagLayout());
                DefaultGridBagConstraints cContact = new DefaultGridBagConstraints();
                cContact.weighty = 1.0;
                cContact.weightx = 1.0;
                cContact.fill = 1;
                panelContact.add((Component)this.tableContact, cContact);
                JScrollPane scrollContact = new JScrollPane(panelContact);
                scrollContact.setBorder(null);
                this.tabbedPane.add("Contacts", scrollContact);
                this.addView("ID_REGLEMENT_PAYE", "required;notdecorated;noseparator");
                ElementSQLObject eltReglPaye = (ElementSQLObject)this.getView("ID_REGLEMENT_PAYE");
                JScrollPane scrollReglPaye = new JScrollPane(eltReglPaye);
                scrollReglPaye.setBorder(null);
                this.tabbedPane.add("R\u00e8glement", scrollReglPaye);
                this.addView("ID_PAS", "required;notdecorated;noseparator");
                ElementSQLObject eltPas = (ElementSQLObject)this.getView("ID_PAS");
                JScrollPane scrollPas = new JScrollPane(eltPas);
                scrollPas.setBorder(null);
                this.tabbedPane.add("PAS", scrollPas);
                this.addView("ID_INFOS_SALARIE_PAYE", "required;notdecorated;noseparator");
                ElementSQLObject eltInfosPaye = (ElementSQLObject)this.getView("ID_INFOS_SALARIE_PAYE");
                JScrollPane scrollInfosPaye = new JScrollPane(eltInfosPaye);
                scrollInfosPaye.setBorder(null);
                this.tabbedPane.add("Informations salari\u00e9-paye", scrollInfosPaye);
                this.addView("ID_FICHE_PAYE", "required;notdecorated;noseparator");
                ElementSQLObject eltFichePaye = (ElementSQLObject)this.getView("ID_FICHE_PAYE");
                JScrollPane scrollFichePaye = new JScrollPane(eltFichePaye);
                scrollFichePaye.setBorder(null);
                this.tabbedPane.add("Fiche de paye en cours", scrollFichePaye);
                this.addView("ID_CUMULS_CONGES", "required;notdecorated;noseparator");
                ElementSQLObject eltCumulsConges = (ElementSQLObject)this.getView("ID_CUMULS_CONGES");
                JPanel panelCumulsConges = new JPanel();
                panelCumulsConges.setBorder(BorderFactory.createTitledBorder("Cumuls cong\u00e9s"));
                panelCumulsConges.add(eltCumulsConges);
                this.addView("ID_CUMULS_PAYE", "required;notdecorated;noseparator");
                ElementSQLObject eltCumulPaye = (ElementSQLObject)this.getView("ID_CUMULS_PAYE");
                JPanel panelCumulsPaye = new JPanel();
                panelCumulsPaye.setBorder(BorderFactory.createTitledBorder("Cumuls paye"));
                panelCumulsPaye.add(eltCumulPaye);
                this.addView("ID_VARIABLE_SALARIE", "required;notdecorated;noseparator");
                ElementSQLObject eltVarSalarie = (ElementSQLObject)this.getView("ID_VARIABLE_SALARIE");
                JPanel panelVarSalarie = new JPanel();
                panelVarSalarie.setBorder(BorderFactory.createTitledBorder("Variables de la p\u00e9riode"));
                panelVarSalarie.add(eltVarSalarie);
                JPanel panelAllCumul = new JPanel();
                DefaultGridBagConstraints cPanel = new DefaultGridBagConstraints();
                panelAllCumul.setLayout(new GridBagLayout());
                cPanel.fill = 0;
                panelAllCumul.add((Component)panelCumulsConges, cPanel);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelAllCumul.add((Component)panelCumulsPaye, cPanel);
                cPanel.gridwidth = 0;
                ++cPanel.gridy;
                cPanel.gridx = 0;
                cPanel.weighty = 1.0;
                cPanel.weightx = 1.0;
                cPanel.anchor = 18;
                panelAllCumul.add((Component)panelVarSalarie, cPanel);
                this.tabbedPane.add("Cumuls et variables de la p\u00e9riode", new JScrollPane(panelAllCumul));
                if (!this.getElement().getAdditionalFields().isEmpty()) {
                    c.gridx = 0;
                    ++c.gridy;
                    c.gridwidth = 0;
                    JPanel addP = ComptaSQLConfElement.createAdditionalPanel();
                    this.setAdditionalFieldsPanel(new FormLayouter(addP, 2));
                    this.tabbedPane.add("Compl\u00e9ments", new JScrollPane(addP));
                }
                ++c.gridy;
                c.gridx = 0;
                c.weighty = 1.0;
                c.gridwidth = 0;
                c.fill = 1;
                c.weighty = 1.0;
                c.weightx = 1.0;
                c.anchor = 18;
                this.add((Component)this.tabbedPane, c);
                this.addRequiredSQLObject(textNom, "NOM");
                this.addRequiredSQLObject(textPrenom, "PRENOM");
                this.addRequiredSQLObject(this.textCode, "CODE");
                this.addRequiredSQLObject(comboTitre, "ID_TITRE_PERSONNEL");
                comboTitre.setButtonsVisible(false);
                DefaultGridBagConstraints.lockMinimumSize(comboTitre);
                this.textCode.setText(NumerotationAutoSQLElement.getNextNumero(SalarieSQLElement.class, new Date()));
            }

            @Override
            public synchronized ValidState getValidState() {
                return super.getValidState().and(ValidState.createCached(!this.warningCodeSalLabel.isVisible(), this.warningCodeSalLabel.getText()));
            }

            private void checkCode() {
                boolean currentValid;
                SQLSelect selNum = new SQLSelect(this.getTable().getBase());
                selNum.addSelectFunctionStar("count");
                selNum.setWhere(new Where((FieldRef)this.getTable().getField("CODE"), "=", (Object)this.textCode.getText().trim()));
                selNum.andWhere(new Where((FieldRef)this.getTable().getField("ID"), "!=", this.getSelectedID()));
                Number count = (Number)this.getTable().getBase().getDataSource().executeScalar(selNum.asString());
                boolean isValid = count.intValue() == 0;
                boolean bl = currentValid = !this.warningCodeSalLabel.isVisible();
                if (currentValid != isValid) {
                    this.warningCodeSalLabel.setVisible(!isValid);
                    this.fireValidChange();
                }
            }

            @Override
            public void select(SQLRowAccessor r) {
                super.select(r);
                this.checkCode();
                if (r != null) {
                    this.tableContact.insertFrom("ID_SALARIE", r.asRowValues());
                }
            }

            @Override
            public void update() {
                super.update();
                SQLTable tableFichePaye = this.getTable().getBase().getTable("FICHE_PAYE");
                SQLRowValues rowVals = new SQLRowValues(tableFichePaye);
                rowVals.put("ID_SALARIE", this.getSelectedID());
                SQLRow row = this.getTable().getRow(this.getSelectedID());
                try {
                    rowVals.update(row.getInt("ID_FICHE_PAYE"));
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                this.tableContact.updateField("ID_SALARIE", this.getSelectedID());
            }

            @Override
            public int insert(SQLRow order) {
                int id = super.insert(order);
                SQLTable tableFichePaye = this.getTable().getBase().getTable("FICHE_PAYE");
                SQLTable tableInfosPaye = this.getTable().getBase().getTable("INFOS_SALARIE_PAYE");
                SQLRow row = this.getTable().getRow(id);
                SQLRow rowInfosPaye = tableInfosPaye.getRow(row.getInt("ID_INFOS_SALARIE_PAYE"));
                try {
                    rowInfosPaye.createEmptyUpdateRow().put("ID_SALARIE", id).commit();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                SQLRowValues rowVals = new SQLRowValues(tableFichePaye);
                rowVals.put("ID_SALARIE", id);
                rowVals.put("CONGES_ACQUIS", rowInfosPaye.getObject("CONGES_PAYES"));
                try {
                    rowVals.update(row.getInt("ID_FICHE_PAYE"));
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                if (NumerotationAutoSQLElement.getNextNumero(SalarieSQLElement.class, new Date()).equalsIgnoreCase(this.textCode.getText().trim())) {
                    SQLRowValues rowValsNum = new SQLRowValues(this.tableNum);
                    int val = this.tableNum.getRow(2).getInt("SALARIE_START");
                    rowValsNum.put("SALARIE_START", new Integer(++val));
                    try {
                        rowValsNum.update(2);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                this.tableContact.updateField("ID_SALARIE", id);
                return id;
            }
        };
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".employe";
    }
}

