/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DocumentFilter;
import javax.swing.text.MaskFormatter;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.DeviseNiceTableCellRenderer;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.accounting.model.LettrageModel;
import org.openconcerto.erp.core.finance.accounting.ui.ListPanelEcritures;
import org.openconcerto.erp.core.finance.accounting.ui.PointageRenderer;
import org.openconcerto.erp.model.ISQLCompteSelector;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.erp.utils.LowerCaseFormatFilter;
import org.openconcerto.erp.utils.UpperCaseFormatFilter;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.EditPanelListener;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FontUtils;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.warning.JLabelWarning;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.text.DocumentFilterList;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class LettragePanel
extends JPanel {
    private ListPanelEcritures ecriturePanel;
    private JTextField codeLettrage;
    private JTextField codeLettragePartiel;
    private ISQLCompteSelector selCompte;
    private JCheckBox boxValidEcriture;
    private JCheckBox boxAddSousCompte;
    private JPanel warningPanel;
    private JPanel warningSolde;
    private final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
    private final SQLTable tableEcr = this.base.getTable("ECRITURE");
    private final SQLTable tableComptePCE = this.base.getTable("COMPTE_PCE");
    private static final int allEcriture = 0;
    private static final int ecritureLettree = 1;
    private static final int ecritureNonLettree = 2;
    private int modeSelect;
    private LettrageModel model;
    private JButton buttonLettrer;
    private final JButton buttonRegler = new JButton("R\u00e9gler");
    private JDate dateDeb;
    private JDate dateFin;
    private JDate dateLettrage;

    public LettragePanel() {
        this(ComptePCESQLElement.getId("4"));
    }

    public LettragePanel(int idCompte) {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        SQLElementDirectory directory = Configuration.getInstance().getDirectory();
        this.modeSelect = 0;
        JLabel labelPointageCompte = new JLabel("Lettrage du compte");
        labelPointageCompte.setHorizontalAlignment(4);
        this.add((Component)labelPointageCompte, c);
        this.selCompte = new ISQLCompteSelector();
        SQLElement eltCpt = directory.getElement("COMPTE_PCE");
        ComboSQLRequest createComboRequest = eltCpt.createComboRequest();
        String function = "REGEXP";
        if (Configuration.getInstance().getBase().getServer().getSQLSystem() == SQLSystem.POSTGRESQL) {
            function = "~";
        }
        createComboRequest.setWhere(new Where((FieldRef)eltCpt.getTable().getField("NUMERO"), function, (Object)"^4.*$"));
        this.selCompte.init(eltCpt, createComboRequest);
        this.selCompte.setValue(idCompte);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.add((Component)this.selCompte, c);
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 1, 2);
        TitledSeparator sepGestionLettrage = new TitledSeparator("Gestion du lettrage");
        c.fill = 2;
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 0;
        this.add((Component)sepGestionLettrage, c);
        JLabel labelCode = new JLabel("Code lettrage");
        labelCode.setHorizontalAlignment(4);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)labelCode, c);
        this.codeLettrage = new JTextField(10);
        DocumentFilterList.add((AbstractDocument)this.codeLettrage.getDocument(), (DocumentFilter)new UpperCaseFormatFilter(), DocumentFilterList.FilterType.SIMPLE_FILTER);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.codeLettrage, c);
        this.codeLettrage.setText(NumerotationAutoSQLElement.getNextCodeLettrage());
        JLabel labelCodepartiel = new JLabel("Code lettrage partiel");
        labelCodepartiel.setHorizontalAlignment(4);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)labelCodepartiel, c);
        this.codeLettragePartiel = new JTextField(10);
        DocumentFilterList.add((AbstractDocument)this.codeLettragePartiel.getDocument(), (DocumentFilter)new LowerCaseFormatFilter(), DocumentFilterList.FilterType.SIMPLE_FILTER);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.codeLettragePartiel, c);
        this.codeLettragePartiel.setText(this.getNextCodeLettragePartiel());
        this.createPanelWarning();
        c.gridwidth = 0;
        c.weightx = 0.0;
        ++c.gridx;
        this.add((Component)this.warningPanel, c);
        JLabel labelDate = new JLabel("Date");
        labelDate.setHorizontalAlignment(4);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.add((Component)labelDate, c);
        this.dateLettrage = new JDate(true);
        ++c.gridx;
        this.add((Component)this.dateLettrage, c);
        ++c.gridx;
        this.createPanelWarningSolde();
        c.gridwidth = 0;
        c.weightx = 0.0;
        this.add((Component)this.warningSolde, c);
        c.gridwidth = 1;
        TitledSeparator sepPeriode = new TitledSeparator("Filtre ");
        ++c.gridy;
        c.gridx = 0;
        c.anchor = 17;
        c.gridwidth = 0;
        c.fill = 2;
        this.add((Component)sepPeriode, c);
        JPanel panelSelectEcritures = this.createPanelSelectionEcritures();
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        JLabel labelEcr = new JLabel("Ecritures");
        labelEcr.setHorizontalAlignment(4);
        this.add((Component)labelEcr, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.fill = 0;
        this.add((Component)panelSelectEcritures, c);
        JPanel panelPeriode = new JPanel();
        this.dateDeb = new JDate();
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        JLabel labelPerio = new JLabel("P\u00e9riode du ");
        labelPerio.setHorizontalAlignment(4);
        c.fill = 2;
        this.add((Component)labelPerio, c);
        panelPeriode.add(this.dateDeb);
        this.dateDeb.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LettragePanel.this.changeListRequest();
            }
        });
        this.dateFin = new JDate(true);
        panelPeriode.add(new JLabel("au"));
        this.dateFin.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LettragePanel.this.changeListRequest();
            }
        });
        panelPeriode.add(this.dateFin);
        ++c.gridx;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.fill = 0;
        this.add((Component)panelPeriode, c);
        c.gridx = 0;
        ++c.gridy;
        this.boxAddSousCompte = new JCheckBox("Ajouter les sous comptes");
        this.boxAddSousCompte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LettragePanel.this.changeListRequest();
            }
        });
        this.add((Component)this.boxAddSousCompte, c);
        TitledSeparator sepEcriture = new TitledSeparator("Ecritures ");
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.fill = 2;
        this.add((Component)sepEcriture, c);
        EcritureSQLElement ecritureElem = directory.getElement(EcritureSQLElement.class);
        this.ecriturePanel = new ListPanelEcritures((SQLElement)ecritureElem, new IListe(ecritureElem.createLettrageTableSource()));
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        c.gridwidth = 0;
        this.ecriturePanel.getListe().setPreferredSize(new Dimension(this.ecriturePanel.getListe().getPreferredSize().width, 200));
        this.add((Component)this.ecriturePanel, c);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 1;
        c.gridwidth = 3;
        c.gridheight = 3;
        this.model = new LettrageModel(this.selCompte.getSelectedId());
        JTable table = new JTable(this.model);
        table.setRowHeight(FontUtils.getPreferredRowHeight(table));
        int i = 0;
        while (i < table.getColumnCount()) {
            table.getColumnModel().getColumn(i).setCellRenderer(new DeviseNiceTableCellRenderer());
            ++i;
        }
        JScrollPane sPane = new JScrollPane(table);
        Dimension d = new Dimension(table.getPreferredSize().width, table.getPreferredSize().height + table.getTableHeader().getPreferredSize().height + 4);
        sPane.setPreferredSize(d);
        this.add((Component)sPane, c);
        c.gridx = 4;
        c.gridwidth = 1;
        c.anchor = 13;
        c.fill = 0;
        c.weightx = 0.0;
        this.add((Component)this.createPanelLegende(), c);
        c.gridheight = 1;
        final JButton buttonDelettrer = new JButton("D\u00e9lettrer");
        this.buttonLettrer = new JButton("Lettrer");
        this.boxValidEcriture = new JCheckBox("Valider les \u00e9critures lettr\u00e9es");
        ++c.gridx;
        c.gridwidth = 0;
        this.add((Component)this.boxValidEcriture, c);
        JPanel panelButton = new JPanel();
        panelButton.add((Component)this.buttonRegler, c);
        panelButton.add((Component)this.buttonLettrer, c);
        panelButton.add((Component)buttonDelettrer, c);
        ++c.gridy;
        c.gridx = 5;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.fill = 0;
        c.anchor = 13;
        this.add((Component)panelButton, c);
        ++c.gridy;
        c.anchor = 14;
        JButton buttonClose = new JButton("Fermer");
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Window)SwingUtilities.getRoot((Component)e.getSource())).dispose();
            }
        });
        this.add((Component)buttonClose, c);
        this.buttonLettrer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int[] rowIndex = LettragePanel.this.ecriturePanel.getListe().getJTable().getSelectedRows();
                    LettragePanel.this.actionLettrage(rowIndex, false);
                }
                catch (SQLException e1) {
                    ExceptionHandler.handle("Erreur de lettrage", e1);
                }
            }
        });
        this.buttonRegler.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final List<SQLRowValues> res = LettragePanel.this.ecriturePanel.getListe().getSelectedRows();
                final SQLTable tableKm = LettragePanel.this.ecriturePanel.getListe().getSource().getPrimaryTable().getTable("SAISIE_KM");
                SQLRowValues rowValsKm = new SQLRowValues(tableKm);
                rowValsKm.put("DATE", new Date());
                rowValsKm.put("ID_JOURNAL", 4);
                long solde = LettragePanel.this.model.getSoldeSelection();
                final SQLTable tableKmItem = tableKm.getTable("SAISIE_KM_ELEMENT");
                ArrayList<String> pieces = new ArrayList<String>();
                for (SQLRowValues sqlRowValues : res) {
                    SQLRowValues rowValsKmItemTiers = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(tableKmItem));
                    rowValsKmItemTiers.put("NUMERO", sqlRowValues.getForeign("ID_COMPTE_PCE").getString("NUMERO"));
                    rowValsKmItemTiers.put("NOM", sqlRowValues.getForeign("ID_COMPTE_PCE").getString("NOM"));
                    String pieceNom = sqlRowValues.getString("NOM_PIECE").trim().length() > 0 ? sqlRowValues.getString("NOM_PIECE") : sqlRowValues.getForeign("ID_MOUVEMENT").getForeign("ID_PIECE").getString("NOM");
                    rowValsKmItemTiers.put("NOM_PIECE", pieceNom);
                    if (pieceNom != null && pieceNom.trim().length() > 0) {
                        pieces.add(pieceNom);
                    }
                    rowValsKmItemTiers.put("CREDIT", sqlRowValues.getLong("DEBIT"));
                    rowValsKmItemTiers.put("DEBIT", sqlRowValues.getLong("CREDIT"));
                    if (rowValsKmItemTiers.getTable().contains("MONTANT_ECHEANCE")) {
                        rowValsKmItemTiers.put("MONTANT_ECHEANCE", sqlRowValues.getLong("CREDIT"));
                    }
                    rowValsKmItemTiers.put("ID_SAISIE_KM", (Object)rowValsKm);
                }
                SQLRowValues rowValsKmItemBq = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(tableKmItem));
                boolean achat = solde < 0L;
                int idPce = tableKm.getTable("TYPE_REGLEMENT").getRow(2).getInt("ID_COMPTE_PCE_" + (achat ? "FOURN" : "CLIENT"));
                if (idPce <= 1) {
                    try {
                        idPce = ComptePCESQLElement.getIdComptePceDefault("VenteCB");
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
                SQLTable tableAccount = tableKmItem.getTable("COMPTE_PCE");
                SQLRow rowCptBq = tableAccount.getRow(idPce);
                rowValsKmItemBq.put("NUMERO", rowCptBq.getString("NUMERO"));
                rowValsKmItemBq.put("NOM", rowCptBq.getString("NOM"));
                if (!pieces.isEmpty()) {
                    StringBuilder build = new StringBuilder();
                    int nbPieces = pieces.size();
                    int i = 0;
                    for (String string : pieces) {
                        build.append(string);
                        if (++i >= nbPieces) continue;
                        build.append(", ");
                    }
                    rowValsKmItemBq.put("NOM_PIECE", build.toString());
                }
                if (solde > 0L) {
                    rowValsKmItemBq.put("CREDIT", solde);
                    rowValsKmItemBq.put("DEBIT", 0L);
                } else {
                    rowValsKmItemBq.put("DEBIT", -solde);
                    rowValsKmItemBq.put("CREDIT", 0L);
                }
                rowValsKmItemBq.put("ID_SAISIE_KM", (Object)rowValsKm);
                EditFrame frame = new EditFrame(Configuration.getInstance().getDirectory().getElement("SAISIE_KM"), EditPanel.EditMode.CREATION);
                frame.getSQLComponent().select(rowValsKm);
                frame.setVisible(true);
                frame.addEditPanelListener(new EditPanelListener(){

                    @Override
                    public void modified() {
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void inserted(int id) {
                        Collection rowsInserted = tableKm.getRow(id).getReferentRows(tableKmItem);
                        ArrayList<String> piece = new ArrayList<String>();
                        ArrayList<Object> rowsToLettre = new ArrayList<Object>();
                        long solde = 0L;
                        for (SQLRowValues sqlRowValues : res) {
                            rowsToLettre.add(sqlRowValues);
                            String nomPiece = sqlRowValues.getString("NOM_PIECE");
                            if (sqlRowValues.getForeign("ID_COMPTE_PCE").getString("NUMERO").startsWith("4") && nomPiece.trim().length() > 0) {
                                piece.add(nomPiece);
                            }
                            solde += sqlRowValues.getLong("DEBIT");
                            solde -= sqlRowValues.getLong("CREDIT");
                        }
                        for (SQLRow sqlRow : rowsInserted) {
                            SQLRow rowEcr = sqlRow.getForeign("ID_ECRITURE");
                            String nomPiece = sqlRow.getString("NOM_PIECE");
                            if (!rowEcr.getString("COMPTE_NUMERO").startsWith("4")) continue;
                            solde += rowEcr.getLong("DEBIT");
                            solde -= rowEcr.getLong("CREDIT");
                            if (nomPiece.trim().length() > 0) {
                                piece.add(nomPiece);
                            }
                            rowsToLettre.add(rowEcr);
                        }
                        if (solde == 0L) {
                            String codeLettre = LettragePanel.this.codeLettrage.getText().trim();
                            for (SQLRowAccessor sQLRowAccessor : rowsToLettre) {
                                SQLRowValues rowVals = new SQLRowValues(sQLRowAccessor.getTable());
                                if (codeLettre.length() <= 0) continue;
                                rowVals.put("LETTRAGE_PARTIEL", "");
                                rowVals.put("LETTRAGE", codeLettre);
                                rowVals.put("DATE_LETTRAGE", LettragePanel.this.dateLettrage.getDate());
                                try {
                                    rowVals.update(sQLRowAccessor.getID());
                                }
                                catch (SQLException e1) {
                                    e1.printStackTrace();
                                }
                            }
                            SQLElement sQLElement = Configuration.getInstance().getDirectory().getElement("NUMEROTATION_AUTO");
                            SQLRowValues rowVals = sQLElement.getTable().getRow(2).createEmptyUpdateRow();
                            rowVals.put("CODE_LETTRAGE", codeLettre);
                            try {
                                rowVals.update();
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                            LettragePanel.this.codeLettrage.setText(LettragePanel.this.getNextCodeLettrage());
                            LettragePanel.this.model.updateTotauxCompte();
                        } else {
                            String codeLettreP = LettragePanel.this.codeLettragePartiel.getText().trim();
                            String string = LettragePanel.this.codeLettrage.getText().trim();
                            SQLSelect selEcr = new SQLSelect();
                            SQLTable tableEcr = tableKm.getTable("ECRITURE");
                            selEcr.addSelect(tableEcr.getKey());
                            selEcr.addSelect(tableEcr.getField("NOM_PIECE"));
                            selEcr.addSelect(tableEcr.getField("DEBIT"));
                            selEcr.addSelect(tableEcr.getField("CREDIT"));
                            selEcr.addSelect(tableEcr.getField("LETTRAGE"));
                            selEcr.addSelect(tableEcr.getField("LETTRAGE_PARTIEL"));
                            Where w2 = new Where(tableEcr.getField("NOM_PIECE"), piece);
                            w2 = w2.and(new Where((FieldRef)tableEcr.getField("COMPTE_NUMERO"), "LIKE", (Object)"40%").or(new Where((FieldRef)tableEcr.getField("COMPTE_NUMERO"), "LIKE", (Object)"41%")));
                            w2 = w2.and(new Where((FieldRef)tableEcr.getField("DATE_LETTRAGE"), "=", (Object)null));
                            selEcr.setWhere(w2);
                            List<SQLRow> rows = SQLRowListRSH.execute(selEcr);
                            ListMap<String, SQLRow> mapPiece = new ListMap<String, SQLRow>();
                            HashMap<String, Long> soldePiece = new HashMap<String, Long>();
                            for (SQLRow sQLRow : rows) {
                                String pieceName = sQLRow.getString("NOM_PIECE");
                                mapPiece.add(pieceName, sQLRow);
                                long soldeRow = sQLRow.getLong("DEBIT") - sQLRow.getLong("CREDIT");
                                if (soldePiece.containsKey(pieceName)) {
                                    soldePiece.put(pieceName, (Long)soldePiece.get(pieceName) + soldeRow);
                                    continue;
                                }
                                soldePiece.put(pieceName, soldeRow);
                            }
                            for (Map.Entry entry : mapPiece.entrySet()) {
                                SQLElement elt;
                                SQLRowValues rowVals;
                                if ((Long)soldePiece.get(entry.getKey()) == 0L) {
                                    try {
                                        void var8_12;
                                        for (SQLRow rowEcr : (List)entry.getValue()) {
                                            rowVals = rowEcr.createEmptyUpdateRow();
                                            if (var8_12.length() <= 0) continue;
                                            rowVals.put("LETTRAGE_PARTIEL", "");
                                            rowVals.put("LETTRAGE", var8_12);
                                            rowVals.put("DATE_LETTRAGE", LettragePanel.this.dateLettrage.getDate());
                                            rowVals.update();
                                        }
                                        elt = Configuration.getInstance().getDirectory().getElement("NUMEROTATION_AUTO");
                                        SQLRowValues rowVals2 = elt.getTable().getRow(2).createEmptyUpdateRow();
                                        rowVals2.put("CODE_LETTRAGE", var8_12);
                                        rowVals2.update();
                                        String string2 = LettragePanel.this.getNextCodeLettrage();
                                    }
                                    catch (SQLException e) {
                                        e.printStackTrace();
                                    }
                                    continue;
                                }
                                try {
                                    for (SQLRow rowEcr : (List)entry.getValue()) {
                                        rowVals = rowEcr.createEmptyUpdateRow();
                                        if (codeLettreP.length() <= 0) continue;
                                        rowVals.put("LETTRAGE_PARTIEL", codeLettreP);
                                        rowVals.update();
                                    }
                                    elt = Configuration.getInstance().getDirectory().getElement("NUMEROTATION_AUTO");
                                    SQLRowValues rowVals2 = elt.getTable().getRow(2).createEmptyUpdateRow();
                                    rowVals2.put("CODE_LETTRAGE_PARTIEL", codeLettreP);
                                    rowVals2.update();
                                    codeLettreP = LettragePanel.this.getNextCodeLettragePartiel();
                                }
                                catch (SQLException e) {
                                    e.printStackTrace();
                                }
                            }
                            LettragePanel.this.codeLettrage.setText(LettragePanel.this.getNextCodeLettrage());
                            LettragePanel.this.codeLettragePartiel.setText(LettragePanel.this.getNextCodeLettragePartiel());
                            LettragePanel.this.model.updateTotauxCompte();
                        }
                    }

                    @Override
                    public void deleted() {
                    }

                    @Override
                    public void cancelled() {
                    }
                });
            }
        });
        buttonDelettrer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rowIndex = LettragePanel.this.ecriturePanel.getListe().getJTable().getSelectedRows();
                LettragePanel.this.actionDelettrage(rowIndex, false);
            }
        });
        this.selCompte.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LettragePanel.this.changeListRequest();
            }
        });
        this.addActionMenuDroit();
        this.ecriturePanel.getListe().getJTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                System.err.println("Mouse released");
                int[] selectedRows = LettragePanel.this.ecriturePanel.getListe().getJTable().getSelectedRows();
                int[] idRows = new int[selectedRows.length];
                int i = 0;
                while (i < idRows.length) {
                    idRows[i] = LettragePanel.this.ecriturePanel.getListe().idFromIndex(selectedRows[i]);
                    ++i;
                }
                LettragePanel.this.model.updateSelection(idRows);
                LettragePanel.this.warningSolde.setVisible(LettragePanel.this.model.getSoldeSelection() != 0L);
                buttonDelettrer.setEnabled(LettragePanel.this.model.getSoldeSelection() == 0L);
                LettragePanel.this.buttonLettrer.setEnabled(LettragePanel.this.model.getSoldeSelection() == 0L);
                LettragePanel.this.buttonRegler.setEnabled(!LettragePanel.this.ecriturePanel.getListe().getSelectedRows().isEmpty());
            }
        });
        this.ecriturePanel.getListe().getJTable().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                System.err.println("Key released");
                int[] selectedRows = LettragePanel.this.ecriturePanel.getListe().getJTable().getSelectedRows();
                int[] idRows = new int[selectedRows.length];
                int i = 0;
                while (i < idRows.length) {
                    idRows[i] = LettragePanel.this.ecriturePanel.getListe().idFromIndex(selectedRows[i]);
                    ++i;
                }
                LettragePanel.this.model.updateSelection(idRows);
                LettragePanel.this.warningPanel.setVisible(LettragePanel.this.codeLettrage.getText().trim().length() == 0);
                LettragePanel.this.warningSolde.setVisible(LettragePanel.this.model.getSoldeSelection() != 0L);
            }
        });
        this.codeLettrage.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                LettragePanel.this.warningPanel.setVisible(LettragePanel.this.codeLettrage.getText().trim().length() == 0);
                LettragePanel.this.buttonLettrer.setEnabled(LettragePanel.this.codeLettrage.getText().trim().length() != 0);
            }
        });
        this.changeListRequest();
        this.warningPanel.setVisible(this.codeLettrage.getText().trim().length() == 0);
        this.buttonLettrer.setEnabled(this.codeLettrage.getText().trim().length() != 0);
    }

    private String getNextCodeLettragePartiel() {
        return Configuration.getInstance().getDirectory().getElement(NumerotationAutoSQLElement.class).getNextCodeLettragePartiel();
    }

    private String getNextCodeLettrage() {
        Configuration.getInstance().getDirectory().getElement(NumerotationAutoSQLElement.class);
        return NumerotationAutoSQLElement.getNextCodeLettrage();
    }

    private void addActionMenuDroit() {
        RowAction.PredicateRowAction action = new RowAction.PredicateRowAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow rowEcr = LettragePanel.this.ecriturePanel.getListe().fetchSelectedRow();
                MouvementSQLElement.showSource(rowEcr.getInt("ID_MOUVEMENT"));
            }
        }, false, "financing.accouning.entries.source.show");
        action.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.ecriturePanel.getListe().addIListeAction(action);
        final AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int[] rowIndex = LettragePanel.this.ecriturePanel.getListe().getJTable().getSelectedRows();
                    LettragePanel.this.actionLettrage(rowIndex, false);
                }
                catch (SQLException e1) {
                    ExceptionHandler.handle("erreur de lettrage", e1);
                }
            }
        };
        RowAction.PredicateRowAction actionLettre = new RowAction.PredicateRowAction((Action)abstractAction, false, "financing.accouning.entries.match");
        actionLettre.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        this.ecriturePanel.getListe().addIListeAction(actionLettre);
        AbstractAction abstractActionPartiel = new AbstractAction("Lettrage Partiel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int[] rowIndex = LettragePanel.this.ecriturePanel.getListe().getJTable().getSelectedRows();
                    LettragePanel.this.actionLettrage(rowIndex, true);
                }
                catch (SQLException e1) {
                    ExceptionHandler.handle("erreur de lettrage", e1);
                }
            }
        };
        RowAction.PredicateRowAction actionLettreP = new RowAction.PredicateRowAction((Action)abstractActionPartiel, false, "financing.accouning.entries.match.partial");
        actionLettreP.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        this.ecriturePanel.getListe().addIListeAction(actionLettreP);
        this.codeLettrage.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                abstractAction.setEnabled(LettragePanel.this.codeLettrage.getText().trim().length() > 0);
            }
        });
        this.ecriturePanel.getListe().addRowAction(new AbstractAction("D\u00e9lettrer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rowIndex = LettragePanel.this.ecriturePanel.getListe().getJTable().getSelectedRows();
                LettragePanel.this.actionDelettrage(rowIndex, false);
            }
        }, "financing.accouning.entries.unmatch");
        this.ecriturePanel.getListe().addRowAction(new AbstractAction("D\u00e9lettrer partiel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rowIndex = LettragePanel.this.ecriturePanel.getListe().getJTable().getSelectedRows();
                LettragePanel.this.actionDelettrage(rowIndex, true);
            }
        }, "financing.accouning.entries.unmatch.partial");
    }

    private void createPanelWarning() {
        this.warningPanel = new JPanel();
        this.warningPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        JLabelWarning warningNoCodeImg = new JLabelWarning();
        warningNoCodeImg.setHorizontalAlignment(4);
        this.warningPanel.add((Component)warningNoCodeImg, c);
        JLabel warningNoCodeText = new JLabel("Impossible de lettrer tant que le code de lettrage n'est pas saisi!");
        ++c.gridx;
        this.warningPanel.add((Component)warningNoCodeText, c);
    }

    private void createPanelWarningSolde() {
        this.warningSolde = new JPanel();
        this.warningSolde.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        JLabelWarning warningNoCodeImg = new JLabelWarning();
        warningNoCodeImg.setHorizontalAlignment(4);
        this.warningSolde.add((Component)warningNoCodeImg, c);
        JLabel warningNoCodeText = new JLabel("Impossible de lettrer tant que le solde s\u00e9lectionn\u00e9 n'est pas nul!");
        ++c.gridx;
        this.warningSolde.add((Component)warningNoCodeText, c);
    }

    private void actionLettrage(int[] rowIndex, boolean partiel) throws SQLException {
        String codeLettre = partiel ? this.codeLettragePartiel.getText().trim() : this.codeLettrage.getText().trim();
        ArrayList<SQLRow> rowsSelected = new ArrayList<SQLRow>(rowIndex.length);
        long solde = 0L;
        int i = 0;
        while (i < rowIndex.length) {
            int id = this.ecriturePanel.getListe().idFromIndex(rowIndex[i]);
            SQLRow row = this.tableEcr.getRow(id);
            rowsSelected.add(row);
            solde += ((Long)row.getObject("DEBIT")).longValue();
            solde -= ((Long)row.getObject("CREDIT")).longValue();
            ++i;
        }
        if (partiel || solde == 0L) {
            for (SQLRow row2 : rowsSelected) {
                SQLRowValues rowVals = new SQLRowValues(this.tableEcr);
                if (codeLettre.length() <= 0) continue;
                if (this.boxValidEcriture.isSelected() && !row2.getBoolean("VALIDE").booleanValue()) {
                    EcritureSQLElement.validationEcritures(row2.getInt("ID_MOUVEMENT"));
                }
                if (partiel) {
                    rowVals.put("LETTRAGE_PARTIEL", codeLettre);
                } else {
                    rowVals.put("LETTRAGE", codeLettre);
                    rowVals.put("DATE_LETTRAGE", this.dateLettrage.getDate());
                }
                try {
                    rowVals.update(row2.getID());
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
            SQLElement elt = Configuration.getInstance().getDirectory().getElement("NUMEROTATION_AUTO");
            SQLRowValues rowVals = elt.getTable().getRow(2).createEmptyUpdateRow();
            if (partiel) {
                rowVals.put("CODE_LETTRAGE_PARTIEL", codeLettre);
            } else {
                rowVals.put("CODE_LETTRAGE", codeLettre);
            }
            try {
                rowVals.update();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.codeLettrage.setText(NumerotationAutoSQLElement.getNextCodeLettrage());
            if (partiel) {
                this.codeLettragePartiel.setText(this.getNextCodeLettragePartiel());
            } else {
                this.codeLettrage.setText(this.getNextCodeLettrage());
            }
            this.model.updateTotauxCompte();
        }
    }

    protected MaskFormatter createFormatter() {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter("UUU");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return formatter;
    }

    private void actionDelettrage(int[] rowIndex, boolean partiel) {
        ArrayList<SQLRow> rowsSelected = new ArrayList<SQLRow>(rowIndex.length);
        long solde = 0L;
        int i = 0;
        while (i < rowIndex.length) {
            int id = this.ecriturePanel.getListe().idFromIndex(rowIndex[i]);
            SQLRow row = this.tableEcr.getRow(id);
            rowsSelected.add(row);
            solde += ((Long)row.getObject("DEBIT")).longValue();
            solde -= ((Long)row.getObject("CREDIT")).longValue();
            ++i;
        }
        if (partiel || solde == 0L) {
            for (SQLRow row : rowsSelected) {
                SQLRowValues rowVals = new SQLRowValues(this.tableEcr);
                if (partiel) {
                    if (row.getString("LETTRAGE_PARTIEL").trim().length() == 0) continue;
                    rowVals.put("LETTRAGE_PARTIEL", "");
                    try {
                        rowVals.update(row.getID());
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (row.getString("LETTRAGE").trim().length() == 0) continue;
                rowVals.put("LETTRAGE", "");
                rowVals.put("DATE_LETTRAGE", null);
                try {
                    rowVals.update(row.getID());
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }
        this.model.updateTotauxCompte();
    }

    private void changeListRequest() {
        Integer idCpt = this.selCompte.getWantedID();
        SQLRow row = this.tableComptePCE.getRow(Integer.valueOf(((Object)idCpt).toString()));
        Where w = new Where((FieldRef)this.tableEcr.getField("ID_COMPTE_PCE"), "=", this.tableComptePCE.getKey());
        if (!UserRightsManager.getCurrentUserRights().haveRight(ComptaUserRight.ACCES_NOT_RESCTRICTED_TO_411)) {
            w = w.and(new Where((FieldRef)this.tableEcr.getField("COMPTE_NUMERO"), "LIKE", (Object)"411%"));
        }
        if (row != null) {
            String num = row.getString("NUMERO");
            Where w2 = this.boxAddSousCompte.isSelected() ? new Where((FieldRef)this.tableComptePCE.getField("NUMERO"), "LIKE", (Object)(String.valueOf(num) + "%")) : new Where((FieldRef)this.tableComptePCE.getField("NUMERO"), "=", (Object)num);
            w = w.and(w2);
        } else {
            w = w.and(new Where((FieldRef)this.tableComptePCE.getKey(), "=", (Object)idCpt));
        }
        if (this.tableEcr.getFields().contains("HIDE_LETTRAGE")) {
            w = w.and(new Where((FieldRef)this.tableEcr.getField("HIDE_LETTRAGE"), "=", (Object)Boolean.FALSE));
        }
        Date d1 = this.dateDeb.getValue();
        Date d2 = this.dateFin.getValue();
        if (d1 == null && d2 != null) {
            w = w.and(new Where((FieldRef)this.tableEcr.getField("DATE"), "<=", (Object)d2));
        } else if (d1 != null && d2 == null) {
            w = w.and(new Where((FieldRef)this.tableEcr.getField("DATE"), ">=", (Object)d1));
        } else if (d1 != null && d2 != null) {
            w = w.and(new Where((FieldRef)this.tableEcr.getField("DATE"), d1, (Object)d2));
        }
        if (this.modeSelect == 1) {
            w = w.and(new Where((FieldRef)this.tableEcr.getField("LETTRAGE"), "!=", (Object)""));
        } else if (this.modeSelect == 2) {
            Where wLettre = new Where((FieldRef)this.tableEcr.getField("LETTRAGE"), "=", (Object)"");
            Object s = null;
            wLettre = wLettre.or(new Where((FieldRef)this.tableEcr.getField("LETTRAGE"), "=", (Object)s));
            w = w.and(wLettre);
        }
        this.ecriturePanel.getListe().getRequest().setWhere(w);
        this.ecriturePanel.getListe().setModificationAllowed(false);
        this.model.setIdCompte(Integer.parseInt(((Object)idCpt).toString()));
    }

    private JPanel createPanelSelectionEcritures() {
        JPanel panelSelectEcritures = new JPanel();
        GridBagConstraints cPanel = new GridBagConstraints();
        cPanel.anchor = 18;
        cPanel.fill = 2;
        cPanel.gridheight = 1;
        cPanel.gridwidth = 1;
        cPanel.gridx = 0;
        cPanel.gridy = 0;
        cPanel.weightx = 0.0;
        cPanel.weighty = 0.0;
        panelSelectEcritures.setLayout(new GridBagLayout());
        final JRadioButton buttonBoth = new JRadioButton("Toutes");
        panelSelectEcritures.add((Component)buttonBoth, cPanel);
        ++cPanel.gridx;
        final JRadioButton buttonNonLettre = new JRadioButton("Non lettr\u00e9es");
        panelSelectEcritures.add((Component)buttonNonLettre, cPanel);
        ++cPanel.gridx;
        final JRadioButton buttonLettre = new JRadioButton("Lettr\u00e9es");
        panelSelectEcritures.add((Component)buttonLettre, cPanel);
        ButtonGroup group = new ButtonGroup();
        group.add(buttonBoth);
        group.add(buttonNonLettre);
        group.add(buttonLettre);
        buttonBoth.setSelected(true);
        buttonLettre.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (buttonLettre.isSelected()) {
                    LettragePanel.this.modeSelect = 1;
                    LettragePanel.this.changeListRequest();
                }
            }
        });
        buttonNonLettre.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (buttonNonLettre.isSelected()) {
                    LettragePanel.this.modeSelect = 2;
                    LettragePanel.this.changeListRequest();
                }
            }
        });
        buttonBoth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (buttonBoth.isSelected()) {
                    LettragePanel.this.modeSelect = 0;
                    LettragePanel.this.changeListRequest();
                }
            }
        });
        return panelSelectEcritures;
    }

    private JPanel createPanelLegende() {
        JPanel panelLegende = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = -1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 0, 0, 0);
        GridBagConstraints cPanel = new GridBagConstraints();
        cPanel.anchor = 18;
        cPanel.fill = 2;
        cPanel.gridheight = 1;
        cPanel.gridwidth = 1;
        cPanel.gridx = 0;
        cPanel.gridy = -1;
        cPanel.weightx = 0.0;
        cPanel.weighty = 0.0;
        cPanel.insets = new Insets(0, 0, 0, 0);
        panelLegende.setLayout(new GridBagLayout());
        panelLegende.setBorder(BorderFactory.createTitledBorder("L\u00e9gendes"));
        JPanel ecritureValidPanel = new JPanel();
        ecritureValidPanel.setLayout(new GridBagLayout());
        ecritureValidPanel.setBackground(Color.WHITE);
        ecritureValidPanel.add((Component)new JLabel("Ecritures valid\u00e9es"), cPanel);
        panelLegende.add((Component)ecritureValidPanel, c);
        JPanel ecritureNonValidPanel = new JPanel();
        ecritureNonValidPanel.setLayout(new GridBagLayout());
        ecritureNonValidPanel.setBackground(PointageRenderer.getCouleurEcritureNonValide());
        ecritureNonValidPanel.add((Component)new JLabel("Ecritures non valid\u00e9es"), cPanel);
        panelLegende.add((Component)ecritureNonValidPanel, c);
        JPanel ecritureNonValidTodayPanel = new JPanel();
        ecritureNonValidTodayPanel.setLayout(new GridBagLayout());
        ecritureNonValidTodayPanel.setBackground(PointageRenderer.getCouleurEcritureToDay());
        ecritureNonValidTodayPanel.add((Component)new JLabel("Ecritures non valid\u00e9es du jour"), cPanel);
        panelLegende.add((Component)ecritureNonValidTodayPanel, c);
        JPanel ecriturePointePanel = new JPanel();
        ecriturePointePanel.setLayout(new GridBagLayout());
        ecriturePointePanel.setBackground(PointageRenderer.getCouleurEcriturePointee());
        ecriturePointePanel.add((Component)new JLabel("Ecritures lettr\u00e9es"), cPanel);
        panelLegende.add((Component)ecriturePointePanel, c);
        return panelLegende;
    }
}

