/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.ntp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openconcerto.utils.ntp.Timestamp;

public final class Message {
    public static final int MAXIMUM_LENGTH = 384;
    private byte byLeapIndicator;
    private byte byVersionNumber = (byte)4;
    private byte byMode = (byte)3;
    private byte byStratum;
    private byte byPollInterval;
    private byte byPrecision;
    private double dRootDelay;
    private double dRootDispersion;
    private byte[] sReferenceIdentifier = "LOCL".getBytes();
    private Timestamp tReferenceTimestamp = Timestamp.ZERO;
    private Timestamp tOriginateTimestamp = Timestamp.ZERO;
    private Timestamp tReceiveTimestamp = Timestamp.ZERO;
    private Timestamp tTransmitTimestamp = Timestamp.ZERO;

    public byte getLeapIndicator() {
        return this.byLeapIndicator;
    }

    public void setLeapIndicator(byte byLeapIndicator) {
        this.byLeapIndicator = byLeapIndicator;
    }

    public byte getVersionNumber() {
        return this.byVersionNumber;
    }

    public void setVersionNumber(byte byVersionNumber) {
        this.byVersionNumber = byVersionNumber;
    }

    public byte getMode() {
        return this.byMode;
    }

    public void setMode(byte byMode) {
        this.byMode = byMode;
    }

    public byte getStratum() {
        return this.byStratum;
    }

    public void setStratum(byte byStratum) {
        this.byStratum = byStratum;
    }

    public byte getPollInterval() {
        return this.byPollInterval;
    }

    public void setPollInterval(byte byPollInterval) {
        this.byPollInterval = byPollInterval;
    }

    public byte getPrecision() {
        return this.byPrecision;
    }

    public void setPrecision(byte byPrecision) {
        this.byPrecision = byPrecision;
    }

    public double getRootDelay() {
        return this.dRootDelay;
    }

    public void setRootDelay(double dRootDelay) {
        this.dRootDelay = dRootDelay;
    }

    public double getRootDispersion() {
        return this.dRootDispersion;
    }

    public void setRootDispersion(double dRootDispersion) {
        this.dRootDispersion = dRootDispersion;
    }

    public byte[] getReferenceIdentifier() {
        return this.sReferenceIdentifier;
    }

    public void setReferenceIdentifier(byte[] sReferenceIdentifier) {
        this.sReferenceIdentifier = sReferenceIdentifier;
    }

    public Timestamp getReferenceTimestamp() {
        return this.tReferenceTimestamp;
    }

    public void setReferenceTimestamp(Timestamp tReferenceTimestamp) {
        this.tReferenceTimestamp = tReferenceTimestamp;
    }

    public Timestamp getOriginateTimestamp() {
        return this.tOriginateTimestamp;
    }

    public void setOriginateTimestamp(Timestamp tOriginateTimestamp) {
        this.tOriginateTimestamp = tOriginateTimestamp;
    }

    public Timestamp getReceiveTimestamp() {
        return this.tReceiveTimestamp;
    }

    public void setReceiveTimestamp(Timestamp tReceiveTimestamp) {
        this.tReceiveTimestamp = tReceiveTimestamp;
    }

    public Timestamp getTransmitTimestamp() {
        return this.tTransmitTimestamp;
    }

    public void setTransmitTimestamp(Timestamp tTransmitTimestamp) {
        this.tTransmitTimestamp = tTransmitTimestamp;
    }

    public void encodeMessage(OutputStream output) throws IOException {
        byte flags = (byte)(this.getLeapIndicator() << 6);
        flags = (byte)(flags + (byte)(this.getVersionNumber() << 3));
        flags = (byte)(flags + this.getMode());
        output.write(flags);
        output.write(this.getStratum());
        output.write(this.getPollInterval());
        output.write(this.getPrecision());
        Message.encodeFixedPoint(this.getRootDelay(), output);
        Message.encodeFixedPoint(this.getRootDispersion(), output);
        Message.encodeBitstring(this.getReferenceIdentifier(), output);
        Message.encodeTimestamp(this.getReferenceTimestamp(), output);
        Message.encodeTimestamp(this.getOriginateTimestamp(), output);
        Message.encodeTimestamp(this.getReceiveTimestamp(), output);
        Message.encodeTimestamp(this.getTransmitTimestamp(), output);
    }

    public static Message decodeMessage(InputStream input) throws IOException {
        Message message = new Message();
        byte flags = (byte)input.read();
        message.setLeapIndicator((byte)(flags >> 6));
        message.setVersionNumber((byte)(flags >> 3 & 7));
        message.setMode((byte)(flags & 7));
        message.setStratum((byte)input.read());
        message.setPollInterval((byte)input.read());
        message.setPrecision((byte)input.read());
        message.setRootDelay(Message.decodeFixedPoint(input));
        message.setRootDispersion(Message.decodeFixedPoint(input));
        message.setReferenceIdentifier(Message.decodeBitstring(input));
        message.setReferenceTimestamp(Message.decodeTimestamp(input));
        message.setOriginateTimestamp(Message.decodeTimestamp(input));
        message.setReceiveTimestamp(Message.decodeTimestamp(input));
        message.setTransmitTimestamp(Message.decodeTimestamp(input));
        return message;
    }

    private static void encode32(long number, OutputStream output) throws IOException {
        int i = 3;
        while (i >= 0) {
            output.write((int)(number >> 8 * i & 0xFFL));
            --i;
        }
    }

    private static long decode32(InputStream input) throws IOException {
        long number = 0L;
        int i = 0;
        while (i < 4) {
            number = (number << 8) + (long)input.read();
            ++i;
        }
        return number;
    }

    private static void encodeBitstring(byte[] bitstring, OutputStream output) throws IOException {
        byte[] temp = new byte[4];
        System.arraycopy(bitstring, 0, temp, 0, bitstring.length);
        output.write(temp);
    }

    private static byte[] decodeBitstring(InputStream input) throws IOException {
        byte[] bitstring = new byte[4];
        input.read(bitstring, 0, 4);
        return bitstring;
    }

    private static void encodeFixedPoint(double number, OutputStream output) throws IOException {
        Message.encode32((long)(number * 65536.0), output);
    }

    private static double decodeFixedPoint(InputStream input) throws IOException {
        return (double)Message.decode32(input) / 65536.0;
    }

    private static void encodeTimestamp(Timestamp timestamp, OutputStream output) throws IOException {
        Message.encode32(timestamp.getInteger(), output);
        Message.encode32(timestamp.getFraction(), output);
    }

    private static Timestamp decodeTimestamp(InputStream input) throws IOException {
        long integer = Message.decode32(input);
        long fraction = Message.decode32(input);
        return new Timestamp(integer, fraction);
    }
}

