/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Toolkit;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.function.Supplier;
import org.openconcerto.utils.Platform;

public class WindowUtils {
    private WindowUtils() {
    }

    public static void setWMClass(Supplier<String> nameSupplier, boolean pidSuffix) {
        Class<?> xtoolkit = Toolkit.getDefaultToolkit().getClass();
        if (xtoolkit.getName().equals("sun.awt.X11.XToolkit")) {
            try {
                String suppliedName;
                Field awtAppClassName = xtoolkit.getDeclaredField("awtAppClassName");
                awtAppClassName.setAccessible(true);
                String pid = null;
                if (pidSuffix) {
                    try {
                        Platform p = Platform.getInstance();
                        if (p.supportsPID()) {
                            pid = p.getPID();
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
                if ((suppliedName = Objects.requireNonNull(nameSupplier.get(), "Null name").trim()).isEmpty()) {
                    throw new IllegalArgumentException("Empty name");
                }
                String name = String.valueOf(suppliedName) + (pid == null ? "" : " [" + pid + "]");
                awtAppClassName.set(null, name);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }
}

