/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.credit.component;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.element.SocieteCommonSQLElement;
import org.openconcerto.erp.core.common.ui.AbstractArticleItemTable;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.common.ui.TotalPanel;
import org.openconcerto.erp.core.customerrelationship.customer.ui.AddressChoiceUI;
import org.openconcerto.erp.core.customerrelationship.customer.ui.AdresseType;
import org.openconcerto.erp.core.customerrelationship.customer.ui.CategorieComptableChoiceUI;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.sales.credit.ui.AvoirItemTable;
import org.openconcerto.erp.core.supplychain.stock.element.StockItemsUpdater;
import org.openconcerto.erp.core.supplychain.stock.element.StockLabel;
import org.openconcerto.erp.generationDoc.gestcomm.AvoirClientXmlSheet;
import org.openconcerto.erp.generationEcritures.GenerationMvtAvoirClient;
import org.openconcerto.erp.model.ISQLCompteSelector;
import org.openconcerto.erp.panel.PanelOOSQLComponent;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionClientPreferencePanel;
import org.openconcerto.erp.preferences.GestionCommercialeGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.cc.IFactory;
import org.openconcerto.utils.checks.ValidState;

public class AvoirClientSQLComponent
extends TransfertBaseSQLComponent
implements ActionListener {
    protected PanelOOSQLComponent panelGestDoc;
    private TotalPanel totalTTC;
    private JTextField textNom;
    private JDate date;
    private JUniqueTextField textNumero;
    private AbstractArticleItemTable table;
    private JCheckBox boxAdeduire = new JCheckBox(this.getLabelFor("A_DEDUIRE"));
    private ElementSQLObject eltModeRegl;
    private final SQLTable tableClient = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("CLIENT");
    private final SQLElement clientElt = Configuration.getInstance().getDirectory().getElement(this.tableClient);
    private final ElementComboBox comboClient = new ElementComboBox();
    private ElementComboBox comboPole = new ElementComboBox();
    private ElementComboBox comboCommercial = new ElementComboBox();
    private ElementComboBox comboVerificateur = new ElementComboBox();
    private final ElementComboBox comboBanque = new ElementComboBox();
    private ElementComboBox selectContact;
    private JLabel labelCompteServ;
    private ISQLCompteSelector compteSelService;
    private final boolean displayDpt;
    private final ElementComboBox comboDpt = new ElementComboBox();
    private JCheckBox checkCompteServiceAuto;
    private PropertyChangeListener listenerModeReglDefaut = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            int idCli = AvoirClientSQLComponent.this.comboClient.getWantedID();
            if (idCli > 1) {
                SQLRow rowCli = AvoirClientSQLComponent.this.tableClient.getRow(idCli);
                if (!AvoirClientSQLComponent.this.isFilling() && !rowCli.isForeignEmpty("ID_COMMERCIAL")) {
                    AvoirClientSQLComponent.this.comboCommercial.setValue(rowCli.getForeignID("ID_COMMERCIAL"));
                }
                if (rowCli.getObject("ID_CATEGORIE_COMPTABLE") != null && !rowCli.isForeignEmpty("ID_CATEGORIE_COMPTABLE")) {
                    AvoirClientSQLComponent.this.totalTTC.setCategorieComptable(rowCli.getForeign("ID_CATEGORIE_COMPTABLE"));
                } else {
                    AvoirClientSQLComponent.this.totalTTC.setCategorieComptable(null);
                }
                SQLElement sqleltModeRegl = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
                int idModeRegl = rowCli.getInt("ID_MODE_REGLEMENT");
                if (!AvoirClientSQLComponent.this.isFilling() && idModeRegl > 1 && AvoirClientSQLComponent.this.eltModeRegl.isCreated()) {
                    SQLRow rowModeRegl = sqleltModeRegl.getTable().getRow(idModeRegl);
                    SQLRowValues rowValsModeRegl = rowModeRegl.createUpdateRow();
                    rowValsModeRegl.clearPrimaryKeys();
                    AvoirClientSQLComponent.this.eltModeRegl.setValue(rowValsModeRegl);
                }
            } else {
                AvoirClientSQLComponent.this.totalTTC.setCategorieComptable(null);
            }
        }
    };
    private final ElementComboBox boxTarif = new ElementComboBox();
    private PropertyChangeListener changeClientListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Integer id = AvoirClientSQLComponent.this.comboClient.getWantedID();
            if (id > 1) {
                SQLRow row = AvoirClientSQLComponent.this.clientElt.getTable().getRow(id);
                SQLField fieldForeignClient = AvoirClientSQLComponent.this.getTable().getDBRoot().findTable("CONTACT").getField("ID_CLIENT");
                Where wC = new Where((FieldRef)fieldForeignClient, "=", -1);
                wC = wC.or(new Where((FieldRef)AvoirClientSQLComponent.this.getTable().getDBRoot().findTable("CONTACT").getField("ID_CLIENT"), "=", (Object)id));
                AvoirClientSQLComponent.this.selectContact.getRequest().setWhere(wC);
                if (row.getObject("ID_CATEGORIE_COMPTABLE") != null && !row.isForeignEmpty("ID_CATEGORIE_COMPTABLE")) {
                    AvoirClientSQLComponent.this.table.setRowCatComptable(row.getForeign("ID_CATEGORIE_COMPTABLE"));
                } else {
                    AvoirClientSQLComponent.this.table.setRowCatComptable(null);
                }
                if (!AvoirClientSQLComponent.this.isFilling() && AvoirClientSQLComponent.this.comboClient.getElement().getTable().getFieldsName().contains("ID_TARIF")) {
                    SQLRow foreignRow = row.getForeignRow("ID_TARIF");
                    if (!(foreignRow.isUndefined() || AvoirClientSQLComponent.this.boxTarif.getSelectedRow() != null && AvoirClientSQLComponent.this.boxTarif.getSelectedId() == ((SQLRowAccessor)foreignRow).getID() || JOptionPane.showConfirmDialog(null, "Appliquer les tarifs associ\u00e9s au client?") != 0)) {
                        AvoirClientSQLComponent.this.boxTarif.setValue(((SQLRowAccessor)foreignRow).getID());
                    } else {
                        AvoirClientSQLComponent.this.boxTarif.setValue(((SQLRowAccessor)foreignRow).getID());
                    }
                }
                AvoirClientSQLComponent.this.table.setClient(row, !AvoirClientSQLComponent.this.isFilling());
            } else {
                AvoirClientSQLComponent.this.table.setRowCatComptable(null);
                AvoirClientSQLComponent.this.selectContact.getRequest().setWhere(Where.FALSE);
            }
        }
    };

    @Override
    protected RowValuesTable getRowValuesTable() {
        return this.table.getRowValuesTable();
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRowValues vals = new SQLRowValues(this.getTable());
        vals.put("A_DEDUIRE", Boolean.TRUE);
        this.eltModeRegl.setEditable(InteractionMode.DISABLED);
        this.eltModeRegl.setCreated(false);
        SQLRow prefs = this.getTable().getDBRoot().getTable("PREFS_COMPTE").getTable().getRow(2);
        int idCompteVenteService = prefs.getInt("ID_COMPTE_PCE_VENTE_SERVICE");
        if (idCompteVenteService <= 1) {
            try {
                idCompteVenteService = ComptePCESQLElement.getIdComptePceDefault("VentesServices");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        vals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), new Date()));
        vals.put("MONTANT_TTC", 0L);
        vals.put("MONTANT_SERVICE", 0L);
        vals.put("MONTANT_HT", 0L);
        vals.put("MONTANT_TVA", 0L);
        vals.put("ID_COMPTE_PCE_SERVICE", idCompteVenteService);
        return vals;
    }

    public AvoirClientSQLComponent() {
        super(Configuration.getInstance().getDirectory().getElement("AVOIR_CLIENT"));
        SQLPreferences prefs = SQLPreferences.getMemCached(this.getTable().getDBRoot());
        this.displayDpt = prefs.getBoolean(GestionClientPreferencePanel.DISPLAY_CLIENT_DPT, false);
    }

    @Override
    public void addViews() {
        SQLPreferences prefs;
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.textNumero = new JUniqueTextField(16);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = ComptaSQLConfElement.createAdditionalPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 1));
        this.add((Component)addP, c);
        ++c.gridy;
        c.gridwidth = 1;
        this.textNom = new JTextField();
        this.date = new JDate(true);
        this.date.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AvoirClientSQLComponent.this.fireValidChange();
                if (!AvoirClientSQLComponent.this.isFilling() && AvoirClientSQLComponent.this.date.getValue() != null) {
                    AvoirClientSQLComponent.this.table.setDateDevise(AvoirClientSQLComponent.this.date.getValue());
                }
            }
        });
        this.add((Component)new JLabel(this.getLabelFor("NUMERO"), 4), c);
        c.weightx = 1.0;
        c.fill = 0;
        ++c.gridx;
        DefaultGridBagConstraints.lockMinimumSize(this.textNumero);
        this.add((Component)this.textNumero, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Date", 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        this.add((Component)this.date, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel(this.getLabelFor("NOM"), 4), c);
        ++c.gridx;
        this.add((Component)this.textNom, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 0.0;
        this.comboCommercial = new ElementComboBox();
        this.comboCommercial.setMinimumSize(this.comboCommercial.getPreferredSize());
        this.add((Component)new JLabel(this.getLabelFor("ID_COMMERCIAL"), 4), c);
        ++c.gridx;
        c.fill = 0;
        this.add((Component)this.comboCommercial, c);
        this.addSQLObject(this.comboCommercial, "ID_COMMERCIAL");
        c.fill = 2;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new JLabel(this.getLabelFor("MOTIF"), 4), c);
        ++c.gridx;
        c.gridwidth = 1;
        JTextField textMotif = new JTextField();
        this.add((Component)textMotif, c);
        if (this.getTable().contains("DATE_LIVRAISON")) {
            JLabel labelDateLiv = new JLabel("Livraison le");
            ++c.gridx;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.fill = 2;
            labelDateLiv.setHorizontalAlignment(4);
            this.add((Component)labelDateLiv, c);
            ++c.gridx;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.fill = 0;
            JDate dateLiv = new JDate();
            this.add((Component)dateLiv, c);
            c.fill = 2;
            this.addSQLObject(dateLiv, "DATE_LIVRAISON");
        }
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.add((Component)new JLabel(this.getLabelFor("ID_CLIENT"), 4), c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 0;
        this.add((Component)this.comboClient, c);
        this.addRequiredSQLObject(this.comboClient, "ID_CLIENT");
        if (this.displayDpt) {
            ++c.gridx;
            c.gridwidth = 1;
            c.weightx = 0.0;
            JLabel labelDpt = new JLabel(this.getLabelFor("ID_CLIENT_DEPARTEMENT"));
            labelDpt.setHorizontalAlignment(4);
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.fill = 2;
            this.add((Component)labelDpt, c);
            ++c.gridx;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            this.add((Component)this.comboDpt, c);
            DefaultGridBagConstraints.lockMinimumSize(this.comboDpt);
            this.addSQLObject(this.comboDpt, "ID_CLIENT_DEPARTEMENT");
            this.comboClient.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    int wantedID = AvoirClientSQLComponent.this.comboClient.getWantedID();
                    if (wantedID != -1 && wantedID >= 0) {
                        SQLRow rowClient = AvoirClientSQLComponent.this.getTable().getForeignTable("ID_CLIENT").getRow(wantedID);
                        AvoirClientSQLComponent.this.comboDpt.getRequest().setWhere(new Where((FieldRef)AvoirClientSQLComponent.this.comboDpt.getRequest().getPrimaryTable().getField("ID_CLIENT"), "=", rowClient.getID()));
                    } else {
                        AvoirClientSQLComponent.this.comboDpt.getRequest().setWhere(null);
                    }
                }
            });
        }
        if ((prefs = SQLPreferences.getMemCached(this.getTable().getDBRoot())).getBoolean(GestionCommercialeGlobalPreferencePanel.ADDRESS_SPEC, true)) {
            final SQLElement adrElement = this.getElement().getForeignElement("ID_ADRESSE");
            final AddressChoiceUI addressUI = new AddressChoiceUI();
            addressUI.addToUI(this, c);
            this.comboClient.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    int wantedID = AvoirClientSQLComponent.this.comboClient.getWantedID();
                    System.err.println("SET WHERE ID_CLIENT = " + wantedID);
                    if (wantedID != -1 && wantedID >= 0) {
                        addressUI.getComboAdrF().getRequest().setWhere(new Where((FieldRef)adrElement.getTable().getField("ID_CLIENT"), "=", wantedID).and(new Where((FieldRef)adrElement.getTable().getField("TYPE"), "=", (Object)AdresseType.Invoice.getId())));
                        addressUI.getComboAdrL().getRequest().setWhere(new Where((FieldRef)adrElement.getTable().getField("ID_CLIENT"), "=", wantedID).and(new Where((FieldRef)adrElement.getTable().getField("TYPE"), "=", (Object)AdresseType.Delivery.getId())));
                    } else {
                        addressUI.getComboAdrF().getRequest().setWhere(Where.FALSE);
                        addressUI.getComboAdrL().getRequest().setWhere(Where.FALSE);
                    }
                }
            });
        }
        if (prefs.getBoolean(GestionCommercialeGlobalPreferencePanel.CATEGORIE_COMPTABLE_SPEC, false)) {
            final CategorieComptableChoiceUI catUI = new CategorieComptableChoiceUI();
            catUI.addToUI(this, c);
            catUI.getCombo().addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    int wantedID = catUI.getCombo().getWantedID();
                    if (wantedID != -1 && wantedID >= 0) {
                        AvoirClientSQLComponent.this.table.setRowCatComptable(catUI.getCombo().getElement().getTable().getRow(wantedID));
                    } else {
                        AvoirClientSQLComponent.this.table.setRowCatComptable(null);
                    }
                }
            });
        }
        ComptaPropsConfiguration comptaPropsConfiguration = (ComptaPropsConfiguration)Configuration.getInstance();
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 2;
        JLabel labelContact = new JLabel(this.getLabelFor("ID_CONTACT"), 4);
        this.add((Component)labelContact, c);
        this.selectContact = new ElementComboBox(){

            @Override
            protected SQLComponent createSQLComponent(EditPanel.EditMode mode) {
                SQLComponent c = super.createSQLComponent(mode);
                if (mode.equals((Object)EditPanel.EditMode.CREATION)) {
                    c.setDefaultsFactory(new IFactory<SQLRowValues>(){

                        @Override
                        public SQLRowValues createChecked() {
                            SQLRowValues defaultContactRowValues = new SQLRowValues(AvoirClientSQLComponent.this.selectContact.getRequest().getPrimaryTable());
                            Integer id = AvoirClientSQLComponent.this.comboClient.getWantedID();
                            defaultContactRowValues.put("ID_CLIENT", id);
                            return defaultContactRowValues;
                        }
                    });
                }
                return c;
            }
        };
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.add((Component)this.selectContact, c);
        SQLElement contactElement = this.getElement().getForeignElement("ID_CONTACT");
        this.selectContact.init(contactElement, contactElement.getComboRequest(true));
        this.selectContact.getRequest().setWhere(Where.FALSE);
        this.addView(this.selectContact, "ID_CONTACT");
        this.checkCompteServiceAuto = new JCheckBox(this.getLabelFor("COMPTE_SERVICE_AUTO"));
        this.addSQLObject(this.checkCompteServiceAuto, "COMPTE_SERVICE_AUTO");
        this.compteSelService = new ISQLCompteSelector();
        this.labelCompteServ = new JLabel("Compte Service");
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.labelCompteServ.setHorizontalAlignment(4);
        this.add((Component)this.labelCompteServ, c);
        ++c.gridx;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.add((Component)this.compteSelService, c);
        this.addRequiredSQLObject(this.compteSelService, "ID_COMPTE_PCE_SERVICE");
        String valServ = DefaultNXProps.getInstance().getStringProperty("ArticleService");
        Boolean bServ = Boolean.valueOf(valServ);
        if (!bServ.booleanValue()) {
            this.labelCompteServ.setVisible(false);
            this.compteSelService.setVisible(false);
        }
        this.checkCompteServiceAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AvoirClientSQLComponent.this.setCompteServiceVisible(!AvoirClientSQLComponent.this.checkCompteServiceAuto.isSelected());
            }
        });
        if (this.getTable().getFieldsName().contains("ID_TARIF")) {
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            this.add((Component)new JLabel("Tarif \u00e0 appliquer", 4), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.weightx = 1.0;
            this.add((Component)this.boxTarif, c);
            this.addView(this.boxTarif, "ID_TARIF");
            this.boxTarif.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    AvoirClientSQLComponent.this.table.setTarif(AvoirClientSQLComponent.this.boxTarif.getSelectedRow(), false);
                }
            });
        }
        this.table = new AvoirItemTable();
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.weighty = 1.0;
        this.add((Component)this.table, c);
        this.addView(this.table.getRowValuesTable(), "");
        JPanel panelBottom = this.getBottomPanel();
        ++c.gridy;
        c.weighty = 0.0;
        this.add((Component)panelBottom, c);
        c.gridheight = 1;
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel(this.getLabelFor("INFOS")), c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 0.0;
        c.gridwidth = 4;
        ITextArea infos = new ITextArea(4, 4);
        infos.setBorder(null);
        JScrollPane scrollPane = new JScrollPane(infos);
        DefaultGridBagConstraints.lockMinimumSize(scrollPane);
        this.add((Component)scrollPane, c);
        this.panelGestDoc = new PanelOOSQLComponent(this);
        c.fill = 0;
        ++c.gridy;
        c.anchor = 13;
        this.add((Component)this.panelGestDoc, c);
        this.addSQLObject(this.textNom, "NOM");
        if (this.getTable().contains("INFOS")) {
            this.addSQLObject(infos, "INFOS");
        }
        this.addSQLObject(this.boxAdeduire, "A_DEDUIRE");
        this.addSQLObject(textMotif, "MOTIF");
        this.addRequiredSQLObject(this.textNumero, "NUMERO");
        this.addRequiredSQLObject(this.date, "DATE");
        this.boxAdeduire.addActionListener(this);
        this.comboClient.addModelListener("wantedID", this.listenerModeReglDefaut);
        this.comboClient.addModelListener("wantedID", this.changeClientListener);
        DefaultGridBagConstraints.lockMinimumSize(this.comboClient);
        DefaultGridBagConstraints.lockMinimumSize(this.comboBanque);
        DefaultGridBagConstraints.lockMinimumSize(this.comboCommercial);
    }

    private JPanel getBottomPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.anchor = 18;
        c.weightx = 1.0;
        this.boxAdeduire.setOpaque(false);
        this.boxAdeduire.setMinimumSize(new Dimension(430, this.boxAdeduire.getPreferredSize().height));
        this.boxAdeduire.setPreferredSize(new Dimension(430, this.boxAdeduire.getPreferredSize().height));
        panel.add((Component)this.boxAdeduire, c);
        this.addView("ID_MODE_REGLEMENT", "notdecorated;noseparator");
        this.eltModeRegl = (ElementSQLObject)this.getView("ID_MODE_REGLEMENT");
        ++c.gridy;
        c.fill = 0;
        c.weighty = 1.0;
        this.eltModeRegl.setOpaque(false);
        panel.add((Component)this.eltModeRegl, c);
        JPanel panelPortEtRemise = new JPanel();
        panelPortEtRemise.setOpaque(false);
        panelPortEtRemise.setLayout(new GridBagLayout());
        DefaultGridBagConstraints cFrais = new DefaultGridBagConstraints();
        DeviseField textPortHT = new DeviseField(5);
        DeviseField textRemiseHT = new DeviseField(5);
        cFrais.gridheight = 1;
        cFrais.fill = 3;
        cFrais.weighty = 1.0;
        cFrais.gridx = 1;
        JLabel labelPortHT = new JLabel(this.getLabelFor("PORT_HT"));
        labelPortHT.setHorizontalAlignment(4);
        ++cFrais.gridy;
        panelPortEtRemise.add((Component)labelPortHT, cFrais);
        ++cFrais.gridx;
        DefaultGridBagConstraints.lockMinimumSize(textPortHT);
        panelPortEtRemise.add((Component)textPortHT, cFrais);
        JLabel labelTaxeHT = new JLabel(this.getLabelFor("ID_TAXE_PORT"));
        labelTaxeHT.setHorizontalAlignment(4);
        cFrais.gridx = 1;
        ++cFrais.gridy;
        panelPortEtRemise.add((Component)labelTaxeHT, cFrais);
        ++cFrais.gridx;
        SQLRequestComboBox boxTaxePort = new SQLRequestComboBox(false, 8);
        panelPortEtRemise.add((Component)boxTaxePort, cFrais);
        this.addView(boxTaxePort, "ID_TAXE_PORT", (Object)"required");
        boxTaxePort.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AvoirClientSQLComponent.this.totalTTC.updateTotal();
            }
        });
        JLabel labelRemiseHT = new JLabel(this.getLabelFor("REMISE_HT"));
        labelRemiseHT.setHorizontalAlignment(4);
        ++cFrais.gridy;
        cFrais.gridx = 1;
        panelPortEtRemise.add((Component)labelRemiseHT, cFrais);
        ++cFrais.gridx;
        DefaultGridBagConstraints.lockMinimumSize(textRemiseHT);
        panelPortEtRemise.add((Component)textRemiseHT, cFrais);
        ++cFrais.gridy;
        ++c.gridx;
        c.gridy = 0;
        c.gridheight = 2;
        c.weightx = 0.0;
        c.fill = 2;
        c.anchor = 18;
        panel.add((Component)panelPortEtRemise, c);
        DeviseField fieldHT = new DeviseField();
        DeviseField fieldEco = new DeviseField();
        DeviseField fieldTVA = new DeviseField();
        DeviseField fieldService = new DeviseField();
        DeviseField fieldTTC = new DeviseField();
        this.addSQLObject(textPortHT, "PORT_HT");
        DeviseField fieldDevise = new DeviseField();
        if (this.getTable().getFieldsName().contains("T_DEVISE")) {
            this.addSQLObject(fieldDevise, "T_DEVISE");
        }
        this.addSQLObject(textRemiseHT, "REMISE_HT");
        this.addSQLObject(fieldEco, "T_ECO_CONTRIBUTION");
        this.addRequiredSQLObject(fieldHT, "MONTANT_HT");
        this.addRequiredSQLObject(fieldTVA, "MONTANT_TVA");
        this.addRequiredSQLObject(fieldTTC, "MONTANT_TTC");
        this.addRequiredSQLObject(fieldService, "MONTANT_SERVICE");
        JTextField poids = new JTextField();
        if (this.getTable().getFieldsName().contains("T_POIDS")) {
            this.addSQLObject(poids, "T_POIDS");
        }
        this.totalTTC = new TotalPanel(this.table, fieldEco, fieldHT, fieldTVA, fieldTTC, textPortHT, textRemiseHT, fieldService, null, fieldDevise, poids, null, boxTaxePort, null);
        this.totalTTC.setOpaque(false);
        ++c.gridx;
        c.gridy = 0;
        c.gridheight = 2;
        c.fill = 1;
        panel.add((Component)this.totalTTC, c);
        textPortHT.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AvoirClientSQLComponent.this.totalTTC.updateTotal();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AvoirClientSQLComponent.this.totalTTC.updateTotal();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AvoirClientSQLComponent.this.totalTTC.updateTotal();
            }
        });
        textRemiseHT.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AvoirClientSQLComponent.this.totalTTC.updateTotal();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AvoirClientSQLComponent.this.totalTTC.updateTotal();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AvoirClientSQLComponent.this.totalTTC.updateTotal();
            }
        });
        return panel;
    }

    @Override
    public synchronized ValidState getValidState() {
        Date value = this.date.getValue();
        ValidState selfState = value != null && value.after(SocieteCommonSQLElement.getDateDebutExercice()) ? ValidState.getTrueInstance() : ValidState.createCached(false, "La date est incorrecte, cette p\u00e9riode est clotur\u00e9e.");
        return super.getValidState().and(selfState);
    }

    private void setCompteServiceVisible(boolean b) {
        this.compteSelService.setVisible(b);
        this.labelCompteServ.setVisible(b);
    }

    private String getInitialesFromVerif(SQLRow row) {
        String s = "";
        if (row != null) {
            String nom;
            String prenom = row.getString("PRENOM");
            if (prenom != null && prenom.length() > 0) {
                s = String.valueOf(s) + prenom.toUpperCase().charAt(0);
            }
            if ((nom = row.getString("NOM")) != null && nom.length() > 0) {
                s = String.valueOf(s) + nom.toUpperCase().charAt(0);
            }
        }
        return s;
    }

    private void createCompteServiceAuto(int id) {
        SQLRow rowPole = this.comboPole.getSelectedRow();
        SQLRow rowVerif = this.comboVerificateur.getSelectedRow();
        String verifInitiale = this.getInitialesFromVerif(rowVerif);
        int idCpt = ComptePCESQLElement.getId("706" + rowPole.getString("CODE") + verifInitiale, "Service " + rowPole.getString("NOM") + " " + rowVerif.getString("NOM"));
        SQLRowValues rowVals = this.getTable().getRow(id).createEmptyUpdateRow();
        rowVals.put("ID_COMPTE_PCE_SERVICE", idCpt);
        try {
            rowVals.update();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int insert(SQLRow order) {
        int id = this.getSelectedID();
        SQLTable tableNum = this.getTable().getBase().getTable("NUMEROTATION_AUTO");
        if (this.textNumero.checkValidation()) {
            id = super.insert(order);
            try {
                this.table.updateField("ID_AVOIR_CLIENT", id);
                SQLRow row = this.getTable().getRow(id);
                if (NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), row.getDate("DATE").getTime()).equalsIgnoreCase(this.textNumero.getText().trim())) {
                    SQLRowValues rowVals = new SQLRowValues(tableNum);
                    String label = NumerotationAutoSQLElement.getLabelNumberFor(this.getElement().getClass());
                    int val = tableNum.getRow(2).getInt(label);
                    rowVals.put(label, (Object)(++val));
                    try {
                        rowVals.update(2);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                SQLRowValues rowVals2 = row.createUpdateRow();
                Long l = rowVals2.getLong("MONTANT_SOLDE");
                Long l2 = rowVals2.getLong("MONTANT_TTC");
                rowVals2.put("MONTANT_RESTANT", l2 - l);
                rowVals2.update();
                final int idFinal = id;
                ComptaPropsConfiguration.getInstanceCompta().getNonInteractiveSQLExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AvoirClientSQLComponent.this.updateStock(idFinal);
                        }
                        catch (Exception e) {
                            ExceptionHandler.handle("Update error", e);
                        }
                    }
                });
                GenerationMvtAvoirClient gen = new GenerationMvtAvoirClient(row);
                gen.genereMouvement();
                this.createAvoirClient(row);
                this.useAvoir(row);
            }
            catch (Exception e) {
                ExceptionHandler.handle("Erreur lors de la cr\u00e9ation de l'avoir", e);
            }
        } else {
            ExceptionHandler.handle("Impossible de modifier, num\u00e9ro d'avoir existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
        }
        return id;
    }

    protected void createAvoirClient(SQLRow row) {
        AvoirClientXmlSheet bSheet = new AvoirClientXmlSheet(row);
        try {
            bSheet.createDocumentAsynchronous();
            bSheet.showPrintAndExportAsynchronous(this.panelGestDoc.isVisualisationSelected(), this.panelGestDoc.isImpressionSelected(), true, this.getElement(), row);
        }
        catch (Exception e) {
            ExceptionHandler.handle("Impossible de cr\u00e9er l'avoir", e);
        }
    }

    public void useAvoir(final SQLRowAccessor r) {
        if (r.getBoolean("A_DEDUIRE").booleanValue() && r.getReferentRows(this.getTable().getTable("SAISIE_VENTE_FACTURE")).size() == 0) {
            JPanel p = new JPanel(new GridBagLayout());
            DefaultGridBagConstraints c = new DefaultGridBagConstraints();
            c.gridwidth = 0;
            p.add((Component)new JLabel("Voulez appliquer cet avoir sur une facture existante?"), c);
            ++c.gridy;
            c.gridwidth = 1;
            p.add((Component)new JLabel("Appliquer l'avoir sur la facture : "), c);
            ++c.gridx;
            final SQLRequestComboBox box = new SQLRequestComboBox();
            ComboSQLRequest comboRequest = this.getElement().getDirectory().getElement("SAISIE_VENTE_FACTURE").getComboRequest(true);
            Where w = new Where((FieldRef)comboRequest.getPrimaryTable().getField("ID_AVOIR_CLIENT"), "=", this.getTable().getUndefinedID());
            w = w.and(new Where((FieldRef)comboRequest.getPrimaryTable().getField("ID_CLIENT"), "=", r.getForeignID("ID_CLIENT")));
            comboRequest.setWhere(w);
            box.uiInit(comboRequest);
            p.add((Component)box, c);
            ++c.gridy;
            c.gridx = 0;
            final JButton buttonApply = new JButton("Appliquer");
            JButton buttonAnnuler = new JButton("Fermer");
            p.add((Component)buttonApply, c);
            buttonApply.setEnabled(false);
            box.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    buttonApply.setEnabled(box.getSelectedRow() != null);
                }
            });
            ++c.gridx;
            p.add((Component)buttonAnnuler, c);
            final PanelFrame f = new PanelFrame(p, "Affection d'un avoir client");
            buttonAnnuler.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    f.dispose();
                }
            });
            buttonApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SQLRow rowFacture = box.getSelectedRow();
                    long ttc = rowFacture.getLong("T_TTC");
                    long totalAvoirTTC = r.getLong("MONTANT_TTC");
                    long totalSolde = r.getLong("MONTANT_SOLDE");
                    long totalAvoir = totalAvoirTTC - totalSolde;
                    long totalAvoirApplique = 0L;
                    long netAPayer = ttc - totalAvoir;
                    if (netAPayer < 0L) {
                        netAPayer = 0L;
                        totalAvoirApplique = ttc;
                    } else {
                        totalAvoirApplique = totalAvoir;
                    }
                    SQLRowValues createEmptyUpdateRow = rowFacture.createEmptyUpdateRow();
                    createEmptyUpdateRow.put("ID_AVOIR_CLIENT", r.getID());
                    createEmptyUpdateRow.put("NET_A_PAYER", netAPayer);
                    createEmptyUpdateRow.put("T_AVOIR_TTC", totalAvoirApplique);
                    try {
                        try {
                            rowFacture = createEmptyUpdateRow.commit();
                            long restant = totalAvoirTTC - totalAvoirApplique;
                            SQLRowValues rowVals = r.createEmptyUpdateRow();
                            long l2 = ttc - restant;
                            if (l2 >= 0L) {
                                rowVals.put("SOLDE", Boolean.TRUE);
                                rowVals.put("MONTANT_SOLDE", totalAvoirTTC);
                                rowVals.put("MONTANT_RESTANT", 0);
                            } else {
                                long m = totalSolde + ttc;
                                rowVals.put("MONTANT_SOLDE", m);
                                rowVals.put("MONTANT_RESTANT", totalAvoirTTC - m);
                            }
                            rowVals.update();
                            Collection rowEch = rowFacture.getReferentRows(rowFacture.getTable().getTable("ECHEANCE_CLIENT"));
                            for (SQLRow sqlRow : rowEch) {
                                if (sqlRow.getBoolean("REG_COMPTA").booleanValue() || sqlRow.getBoolean("REGLE").booleanValue()) continue;
                                SQLRowValues createEmptyUpdateRow2 = sqlRow.createEmptyUpdateRow();
                                long max = Math.max(0L, sqlRow.getLong("MONTANT") - totalAvoir);
                                createEmptyUpdateRow2.put("MONTANT", max);
                                createEmptyUpdateRow2.put("REGLE", max == 0L);
                                createEmptyUpdateRow2.commit();
                                break;
                            }
                        }
                        catch (SQLException e1) {
                            ExceptionHandler.handle("Erreur lors de l'affection de l'avoir sur la facture!", e1);
                            f.dispose();
                        }
                    }
                    finally {
                        f.dispose();
                    }
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FrameUtil.showPacked(f);
                }
            });
        }
    }

    @Override
    public void select(SQLRowAccessor r) {
        if (r != null) {
            SQLRowValues rVals = r.asRowValues().deepCopy();
            SQLRowValues vals = new SQLRowValues(r.getTable());
            vals.load(rVals, CollectionUtils.createSet("ID_CLIENT"));
            vals.setID(rVals.getID());
            super.select(vals);
            rVals.remove("ID_CLIENT");
            super.select(rVals);
        } else {
            super.select(r);
        }
    }

    @Override
    public void update() {
        if (this.textNumero.checkValidation()) {
            super.update();
            try {
                this.table.updateField("ID_AVOIR_CLIENT", this.getSelectedID());
                SQLRow row = this.getTable().getRow(this.getSelectedID());
                SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
                SQLSelect sel = new SQLSelect(eltMvtStock.getTable().getBase());
                sel.addSelect(eltMvtStock.getTable().getField("ID"));
                Where w = new Where((FieldRef)eltMvtStock.getTable().getField("IDSOURCE"), "=", row.getID());
                Where w2 = new Where((FieldRef)eltMvtStock.getTable().getField("SOURCE"), "=", (Object)this.getTable().getName());
                sel.setWhere(w.and(w2));
                List l = (List)eltMvtStock.getTable().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
                if (l != null) {
                    int i = 0;
                    while (i < l.size()) {
                        Object[] tmp = (Object[])l.get(i);
                        eltMvtStock.archive(((Number)tmp[0]).intValue());
                        ++i;
                    }
                }
                SQLRowValues rowVals2 = this.getTable().getRow(this.getSelectedID()).createUpdateRow();
                Long l2 = rowVals2.getLong("MONTANT_SOLDE");
                Long l3 = rowVals2.getLong("MONTANT_TTC");
                rowVals2.put("MONTANT_RESTANT", l3 - l2);
                rowVals2.update();
                final int idFinal = this.getSelectedID();
                ComptaPropsConfiguration.getInstanceCompta().getNonInteractiveSQLExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AvoirClientSQLComponent.this.updateStock(idFinal);
                        }
                        catch (Exception e) {
                            ExceptionHandler.handle("Update error", e);
                        }
                    }
                });
                int idMvt = row.getInt("ID_MOUVEMENT");
                System.err.println("Archivage des fils");
                EcritureSQLElement eltEcr = (EcritureSQLElement)Configuration.getInstance().getDirectory().getElement("ECRITURE");
                eltEcr.archiveMouvementProfondeur(idMvt, false);
                GenerationMvtAvoirClient gen = new GenerationMvtAvoirClient(row, idMvt);
                gen.genereMouvement();
                this.createAvoirClient(row);
                this.useAvoir(row);
            }
            catch (Exception e) {
                ExceptionHandler.handle("Erreur de mise \u00e0 jour de l'avoir", e);
            }
        } else {
            ExceptionHandler.handle("Impossible de modifier, num\u00e9ro d'avoir existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
            return;
        }
    }

    protected String getLibelleStock(SQLRowAccessor row, SQLRowAccessor rowElt) {
        return "Avoir client N\u00b0" + row.getString("NUMERO");
    }

    private void updateStock(int id) throws SQLException {
        SQLRow row = this.getTable().getRow(id);
        Collection referentRows = row.getReferentRows(this.getTable().getTable("AVOIR_CLIENT_ELEMENT"));
        ArrayList<SQLRow> effectiveRows = new ArrayList<SQLRow>();
        for (SQLRow sqlRow : referentRows) {
            if (!sqlRow.getBoolean("RETOUR_STOCK").booleanValue()) continue;
            effectiveRows.add(sqlRow);
        }
        if (effectiveRows.size() > 0) {
            StockItemsUpdater stockUpdater = new StockItemsUpdater(new StockLabel(){

                @Override
                public String getLabel(SQLRowAccessor rowOrigin, SQLRowAccessor rowElt) {
                    return AvoirClientSQLComponent.this.getLibelleStock(rowOrigin, rowElt);
                }
            }, row, effectiveRows, StockItemsUpdater.TypeStockUpdate.RETOUR_AVOIR_CLIENT);
            stockUpdater.update();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.boxAdeduire && this.eltModeRegl != null) {
            boolean b = this.boxAdeduire.isSelected();
            this.eltModeRegl.setEditable(!b ? InteractionMode.READ_WRITE : InteractionMode.DISABLED);
            this.eltModeRegl.setCreated(!b);
        }
    }

    @Override
    protected void refreshAfterSelect(SQLRowAccessor rSource) {
        this.table.setDateDevise(this.date.getValue());
    }
}

