/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.MoisSQLElement;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;

public abstract class ImpressionPayePanel
extends JPanel
implements ActionListener {
    private JButton valid;
    private JButton annul;
    protected JCheckBox checkImpr;
    protected JCheckBox checkVisu;
    protected ElementComboBox selMoisDeb;
    protected ElementComboBox selMoisEnd;
    protected JTextField textAnnee;
    DateFormat format = new SimpleDateFormat("yyyy");

    public ImpressionPayePanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        Calendar cal = Calendar.getInstance();
        MoisSQLElement moisElt = ComptaPropsConfiguration.getInstanceCompta().getDirectory().getElement(MoisSQLElement.class);
        this.selMoisDeb = new ElementComboBox(true, 12);
        this.selMoisDeb.init(moisElt);
        this.selMoisDeb.setButtonsVisible(false);
        this.selMoisDeb.setAddIconVisible(false);
        this.selMoisEnd = new ElementComboBox(true, 12);
        this.selMoisEnd.init(moisElt);
        this.selMoisEnd.setButtonsVisible(false);
        this.selMoisEnd.setAddIconVisible(false);
        this.add((Component)new JLabel("P\u00e9riode de"), c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)this.selMoisDeb, c);
        this.selMoisDeb.setValue(2);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)new JLabel("\u00e0"), c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)this.selMoisEnd, c);
        this.selMoisEnd.setValue(cal.get(2) + 2);
        this.textAnnee = new JTextField(5);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)new JLabel("de l'ann\u00e9e"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.textAnnee.setText(this.format.format(cal.getTime()));
        this.add((Component)this.textAnnee, c);
        this.valid = new JButton("Valider");
        this.annul = new JButton("Fermer");
        this.checkImpr = new JCheckBox("Impression");
        this.checkVisu = new JCheckBox("Visualisation");
        c.gridwidth = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.fill = 0;
        c.anchor = 13;
        JPanel panelCheck = new JPanel();
        panelCheck.add(this.checkImpr);
        panelCheck.add(this.checkVisu);
        this.checkVisu.setSelected(true);
        this.add((Component)panelCheck, c);
        ++c.gridy;
        c.gridx = 0;
        JPanel panelButton = new JPanel();
        panelButton.add(this.valid);
        panelButton.add(this.annul);
        this.add((Component)panelButton, c);
        this.valid.addActionListener(this);
        this.annul.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(ImpressionPayePanel.this)).dispose();
            }
        });
        this.selMoisDeb.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ImpressionPayePanel.this.checkValidity();
            }
        });
        this.selMoisEnd.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ImpressionPayePanel.this.checkValidity();
            }
        });
        this.textAnnee.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ImpressionPayePanel.this.checkValidity();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ImpressionPayePanel.this.checkValidity();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ImpressionPayePanel.this.checkValidity();
            }
        });
    }

    private void checkValidity() {
        if (this.selMoisDeb.getSelectedId() > 1 && this.selMoisEnd.getSelectedId() > 1 && this.textAnnee.getText().trim().length() > 0 && this.selMoisDeb.getSelectedId() <= this.selMoisEnd.getSelectedId()) {
            this.valid.setEnabled(this.checkImpr.isSelected() || this.checkVisu.isSelected());
            return;
        }
        this.valid.setEnabled(false);
    }
}

