/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openconcerto.ui.EnhancedTable;
import org.openconcerto.ui.FormatEditor;
import org.openconcerto.ui.Log;
import org.openconcerto.ui.TimestampEditorPanel;
import org.openconcerto.ui.table.FocusAwareEditor;

public class TimestampTableCellEditor
extends FormatEditor
implements ActionListener,
FocusAwareEditor {
    private Calendar calendar;
    private JPopupMenu aPopup;
    private boolean popupOpen = false;
    private final TimestampEditorPanel content = new TimestampEditorPanel(false, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TimestampTableCellEditor.this.stopCellEditing();
        }
    });
    private boolean allowNull = false;

    public TimestampTableCellEditor(boolean showHour) {
        this();
        this.content.setHourVisible(showHour);
    }

    public TimestampTableCellEditor() {
        super(DateFormat.getDateTimeInstance(3, 3));
        this.calendar = Calendar.getInstance();
        this.content.setBorder(null);
    }

    public void setAllowNull(boolean b) {
        this.allowNull = b;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        final Component c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
        Date time = (Date)value;
        if (time == null) {
            time = new Timestamp(System.currentTimeMillis());
        }
        this.content.setTime(time);
        this.calendar.setTime(time);
        final Point p = new Point(0, 0 + table.getRowHeight(row));
        if (this.aPopup != null) {
            this.content.removeActionListener(this);
            this.aPopup.setVisible(false);
            this.aPopup = null;
        }
        JTextField t = (JTextField)c;
        this.aPopup = new JPopupMenu();
        this.aPopup.add(this.content);
        this.aPopup.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!TimestampTableCellEditor.this.allowNull && evt.getPropertyName().equals("visible") && Boolean.FALSE.equals(evt.getNewValue())) {
                    TimestampTableCellEditor.this.stopCellEditing();
                }
            }
        });
        this.popupOpen = true;
        t.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TimestampTableCellEditor.this.showPopup(c, p);
                    }
                });
            }
        });
        t.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 40) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TimestampTableCellEditor.this.showPopup(c, p);
                        }
                    });
                }
            }
        });
        this.content.addActionListener(this);
        return c;
    }

    @Override
    public boolean stopCellEditing() {
        this.hidePopup();
        return super.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        super.cancelCellEditing();
        this.hidePopup();
    }

    public void hidePopup() {
        this.popupOpen = false;
        this.content.removeActionListener(this);
        if (this.aPopup != null) {
            this.aPopup.setVisible(false);
        }
    }

    public void showPopup(Component c, Point p) {
        this.popupOpen = true;
        if (this.aPopup != null) {
            try {
                this.aPopup.show(c, p.x, p.y);
                String cancelName = "cancel";
                if (this.aPopup.getRootPane().getActionMap().get("cancel") == null) {
                    Log.get().warning("missing cancel action, value won't be reverted");
                }
                this.aPopup.getRootPane().getActionMap().put("cancel", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TimestampTableCellEditor.this.cancelCellEditing();
                    }
                });
            }
            catch (Exception e) {
                System.err.println("cannot show popup : " + e.getMessage());
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TimestampTableCellEditor.this.content.requestFocus();
            }
        });
    }

    public boolean isPopupOpen() {
        return this.popupOpen;
    }

    @Override
    public Object getCellEditorValue() {
        Date v = (Date)super.getCellEditorValue();
        long t = System.currentTimeMillis();
        if (v != null) {
            t = v.getTime();
        } else if (this.allowNull) {
            return null;
        }
        return new Timestamp(t);
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.delegate.setValue(this.content.getTimestamp());
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                JFrame f = new JFrame(TimestampTableCellEditor.class.getName());
                Object[][] rowData = new Timestamp[2][2];
                rowData[0][0] = new Timestamp(5000000L);
                rowData[0][1] = new Timestamp(5050000L);
                rowData[1][0] = new Timestamp(5100000L);
                final EnhancedTable table = new EnhancedTable(rowData, new String[]{"a", "b"});
                table.getColumnModel().getColumn(0).setCellEditor(new TimestampTableCellEditor(true));
                table.getColumnModel().getColumn(1).setCellEditor(new TimestampTableCellEditor(true));
                JPanel p = new JPanel();
                p.setLayout(new BorderLayout());
                p.add((Component)table, "Center");
                JButton b = new JButton("Dump values");
                p.add((Component)b, "South");
                b.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int i = 0;
                        while (i < 2) {
                            int j = 0;
                            while (j < 2) {
                                System.err.println(table.getModel().getValueAt(i, j));
                                ++j;
                            }
                            ++i;
                        }
                    }
                });
                f.setContentPane(p);
                f.setSize(new Dimension(400, 300));
                f.setDefaultCloseOperation(3);
                f.setLocationRelativeTo(null);
                f.setVisible(true);
            }
        });
    }
}

