/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.preferences;

import java.io.File;
import java.util.Locale;
import org.openconcerto.sql.Configuration;
import org.openconcerto.ui.preferences.AbstractProps;
import org.openconcerto.utils.i18n.I18nUtils;

public class UserProps
extends AbstractProps {
    private static final String PASSWORD = "Password";
    private static final String LAST_LOGIN = "LastLogin";
    private static final String LAST_SOCIETE = "LastSociete";
    public static final String LOCALE = "Language";
    private static UserProps instance;

    public void setLastLoginName(String login) {
        this.setProperty(LAST_LOGIN, login);
    }

    public void setEncryptedStoredPassword(String password) {
        this.setProperty(PASSWORD, password);
    }

    public String getStoredPassword() {
        return this.getProperty(PASSWORD);
    }

    public String getLastLoginName() {
        return this.getStringProperty(LAST_LOGIN);
    }

    public int getLastSocieteID() {
        return this.getIntProperty(LAST_SOCIETE, -1);
    }

    public void setLastSocieteID(int id) {
        this.setProperty(LAST_SOCIETE, String.valueOf(id));
    }

    @Override
    protected String getPropsFileName() {
        Configuration conf = Configuration.getInstance();
        return conf.getConfDirForRoot() + File.separator + "User.properties";
    }

    public static synchronized UserProps getInstance() {
        if (instance == null) {
            instance = new UserProps();
        }
        return instance;
    }

    public Locale getLocale() {
        String p = this.getProperty(LOCALE);
        if (p == null) {
            return Locale.getDefault();
        }
        return I18nUtils.createLocaleFromString(p);
    }

    public void setLocale(Locale locale) {
        this.setProperty(LOCALE, locale.toString());
    }
}

