/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.ui;

import java.math.BigDecimal;
import java.util.Vector;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.view.list.CellDynamicModifier;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.RowValuesTablePanel;
import org.openconcerto.sql.view.list.SQLTableElement;

public class ProductItemListTable
extends RowValuesTablePanel {
    public ProductItemListTable() {
        this.init();
        this.uiInit();
    }

    @Override
    protected void init() {
        SQLElement eProductItem = this.getSQLElement();
        SQLTable productItemTable = eProductItem.getTable();
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        final SQLTableElement product = new SQLTableElement(productItemTable.getField("ID_ARTICLE"));
        list.add(product);
        SQLTableElement q = new SQLTableElement(productItemTable.getField("QTE"), Integer.class);
        list.add(q);
        SQLTableElement quantity = new SQLTableElement(productItemTable.getField("QTE_UNITAIRE"), BigDecimal.class);
        list.add(quantity);
        SQLTableElement unit = new SQLTableElement(productItemTable.getField("ID_UNITE_VENTE"));
        unit.setEditable(true);
        unit.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                if (source.equals(product)) {
                    Object object = row.getObject("ID_ARTICLE");
                    if (object == null) {
                        return null;
                    }
                    SQLRowAccessor r = row.getForeign("ID_ARTICLE");
                    SQLRow rArticle = r.asRow();
                    rArticle.fetchValues();
                    return rArticle.getForeignIDNumber("ID_UNITE_VENTE");
                }
                return row.getObject("ID_UNITE_VENTE");
            }
        });
        product.addModificationListener(unit);
        list.add(unit);
        this.defaultRowVals = new SQLRowValues(this.getSQLElement().getTable());
        this.defaultRowVals.put("ID_ARTICLE", null);
        this.defaultRowVals.put("QTE", (Object)1);
        this.defaultRowVals.put("QTE_UNITAIRE", BigDecimal.valueOf(1L));
        this.model = new RowValuesTableModel(eProductItem, list, productItemTable.getField("ID_ARTICLE"), false, this.defaultRowVals);
        this.table = new RowValuesTable(this.model, null);
    }

    @Override
    public SQLElement getSQLElement() {
        return Configuration.getInstance().getDirectory().getElement("ARTICLE_ELEMENT");
    }
}

